/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.replication;

import java.nio.ByteBuffer;
import kd.bos.olapServer2.common.CommandTypes;
import kd.bos.olapServer2.dataSources.MetadataCommandInfo;
import kd.bos.olapServer2.metadata.CubeCreateMetadataCommand;
import kd.bos.olapServer2.metadata.MetadataCommandExecutor;
import kd.bos.olapServer2.metadata.MetadataTypes;
import kd.bos.olapServer2.replication.IDDLRecord;
import kd.bos.olapServer2.replication.IRedoRecordHead;
import kd.bos.olapServer2.replication.RedoType;
import kd.bos.olapServer2.storages.CubeWorkspace;
import kd.bos.olapServer2.storages.OlapWorkspace;
import kd.bos.olapServer2.tools.JsonHelper;
import kd.bos.olapServer2.tools.Res;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b \u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\f\u0010\u001d\u001a\u00060\nj\u0002`\u000bH\u0016J\f\u0010\u001e\u001a\u00060\u0011j\u0002`\u0012H\u0016J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010%\u001a\u00020 2\u0006\u0010&\u001a\u00020\"H\u0016J\u001c\u0010'\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\n\u0010(\u001a\u00060\nj\u0002`\u000bH\u0002J\b\u0010)\u001a\u00020*H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0018\u0010\t\u001a\u00060\nj\u0002`\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0018\u0010\u0010\u001a\u00060\u0011j\u0002`\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0018\u0010\u0018\u001a\u00060\u0019j\u0002`\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006+"}, d2={"Lkd/bos/olapServer2/replication/AbstractDDLRecord;", "Lkd/bos/olapServer2/replication/IDDLRecord;", "head", "Lkd/bos/olapServer2/replication/IRedoRecordHead;", "body", "Ljava/nio/ByteBuffer;", "(Lkd/bos/olapServer2/replication/IRedoRecordHead;Ljava/nio/ByteBuffer;)V", "getBody", "()Ljava/nio/ByteBuffer;", "cubeId", "", "Lkd/bos/olapServer2/common/int;", "getCubeId", "()I", "getHead", "()Lkd/bos/olapServer2/replication/IRedoRecordHead;", "isOlapLevel", "", "Lkd/bos/olapServer2/common/bool;", "()Z", "redoType", "Lkd/bos/olapServer2/replication/RedoType;", "getRedoType", "()Lkd/bos/olapServer2/replication/RedoType;", "tid", "", "Lkd/bos/olapServer2/common/long;", "getTid", "()J", "parseCubeId", "parseDDlOlapLevel", "replayCubeDDL", "", "olap", "Lkd/bos/olapServer2/storages/OlapWorkspace;", "cube", "Lkd/bos/olapServer2/storages/CubeWorkspace;", "replayDDL", "olapWorkspace", "replayOlapDDL", "createCubeId", "toString", "", "bos-olap-core2"})
public abstract class AbstractDDLRecord
implements IDDLRecord {
    @NotNull
    private final IRedoRecordHead head;
    @NotNull
    private final ByteBuffer body;

    public AbstractDDLRecord(@NotNull IRedoRecordHead head, @NotNull ByteBuffer body) {
        Intrinsics.checkNotNullParameter((Object)head, (String)"head");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        this.head = head;
        this.body = body;
    }

    @NotNull
    public final IRedoRecordHead getHead() {
        return this.head;
    }

    @NotNull
    public final ByteBuffer getBody() {
        return this.body;
    }

    @Override
    @NotNull
    public RedoType getRedoType() {
        return this.head.getType();
    }

    @Override
    public int getCubeId() {
        return this.parseCubeId();
    }

    public int parseCubeId() {
        int cId = this.head.getCubeId();
        if (!(cId != 0)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        return cId < 0 ? ~cId : cId;
    }

    public boolean parseDDlOlapLevel() {
        boolean bl;
        if (this.head.getCubeId() < 0) {
            bl = true;
        } else {
            String commandStr = this.getDDLCommand();
            MetadataCommandInfo command = (MetadataCommandInfo)JsonHelper.INSTANCE.getMapper().readValue(commandStr, MetadataCommandInfo.class);
            bl = command.getMetadataType() == MetadataTypes.Cube && (command.getAction() == CommandTypes.create || command.getAction() == CommandTypes.drop);
        }
        return bl;
    }

    @Override
    public long getTid() {
        return this.head.getTid();
    }

    @Override
    public boolean isOlapLevel() {
        return this.parseDDlOlapLevel();
    }

    @Override
    public void replayDDL(@NotNull OlapWorkspace olapWorkspace) {
        Intrinsics.checkNotNullParameter((Object)olapWorkspace, (String)"olapWorkspace");
        if (this.head.getCubeId() < 0) {
            this.replayOlapDDL(olapWorkspace, this.getCubeId());
        } else {
            CubeWorkspace cubeWorkspace = olapWorkspace.getCubeWorkspaceByCubeId(this.getCubeId());
            this.replayCubeDDL(olapWorkspace, cubeWorkspace);
        }
    }

    private final void replayCubeDDL(OlapWorkspace olap, CubeWorkspace cube) {
        String cmd = this.getDDLCommand();
        try {
            MetadataCommandInfo command = (MetadataCommandInfo)JsonHelper.INSTANCE.getMapper().readValue(cmd, MetadataCommandInfo.class);
            Intrinsics.checkNotNull((Object)command);
            new MetadataCommandExecutor(command, olap, cube).run();
        }
        catch (Exception e) {
            throw Res.INSTANCE.getRuntimeException("cube: " + cube.getMetadata().getName() + '(' + cube.getCubeId() + "): \u91cd\u505aDDL redo\u65e5\u5fd7\u51fa\u9519, \u547d\u4ee4\u4e3a: " + cmd, e, new Object[0]);
        }
    }

    private final void replayOlapDDL(OlapWorkspace olap, int createCubeId) {
        String cmd = this.getDDLCommand();
        try {
            MetadataCommandInfo command = (MetadataCommandInfo)JsonHelper.INSTANCE.getMapper().readValue(cmd, MetadataCommandInfo.class);
            Intrinsics.checkNotNull((Object)command);
            new CubeCreateMetadataCommand(command, olap, createCubeId).execute();
        }
        catch (Exception e) {
            throw Res.INSTANCE.getRuntimeException("olap \u91cd\u505aDDL redo\u65e5\u5fd7\u51fa\u9519, \u547d\u4ee4\u4e3a: " + cmd, e, new Object[0]);
        }
    }

    @NotNull
    public String toString() {
        return "cubeID: " + this.getCubeId() + ", tid: " + this.getTid() + ", " + this.getDDLCommand() + '\n';
    }
}

