/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.replication;

import java.nio.ByteBuffer;
import kd.bos.olapServer2.common.CommonTypesKt;
import kd.bos.olapServer2.common.NotSupportedException;
import kd.bos.olapServer2.dataEntities.InputRow;
import kd.bos.olapServer2.replication.IDMLRecord;
import kd.bos.olapServer2.replication.IRedoRecordHead;
import kd.bos.olapServer2.replication.RedoType;
import kd.bos.olapServer2.storages.CubeWorkspace;
import kd.bos.olapServer2.storages.IInputRowWriter;
import kd.bos.olapServer2.storages.IInputRowWriter4Redo;
import kd.bos.olapServer2.storages.StaticMeasureValueCollection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b \u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0004J\f\u0010!\u001a\u00060\"j\u0002`#H\u0016J\f\u0010$\u001a\u00060\u0011j\u0002`\u0012H\u0016J\f\u0010%\u001a\u00060\u0011j\u0002`\u0012H\u0016J8\u0010&\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010\u001f\u001a\u00020 2\n\u0010+\u001a\u00060\u0011j\u0002`\u00122\n\u0010,\u001a\u00060\u0011j\u0002`\u0012H\u0016J\b\u0010-\u001a\u00020\"H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0018\u0010\t\u001a\u00060\nj\u0002`\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0018\u0010\u0010\u001a\u00060\u0011j\u0002`\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0018\u0010\u0018\u001a\u00060\u0019j\u0002`\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006."}, d2={"Lkd/bos/olapServer2/replication/AbstractDMLRecord;", "Lkd/bos/olapServer2/replication/IDMLRecord;", "head", "Lkd/bos/olapServer2/replication/IRedoRecordHead;", "body", "Ljava/nio/ByteBuffer;", "(Lkd/bos/olapServer2/replication/IRedoRecordHead;Ljava/nio/ByteBuffer;)V", "getBody", "()Ljava/nio/ByteBuffer;", "cubeId", "", "Lkd/bos/olapServer2/common/int;", "getCubeId", "()I", "getHead", "()Lkd/bos/olapServer2/replication/IRedoRecordHead;", "isOlapLevel", "", "Lkd/bos/olapServer2/common/bool;", "()Z", "redoType", "Lkd/bos/olapServer2/replication/RedoType;", "getRedoType", "()Lkd/bos/olapServer2/replication/RedoType;", "tid", "", "Lkd/bos/olapServer2/common/long;", "getTid", "()J", "clearMeasures", "", "row", "Lkd/bos/olapServer2/dataEntities/InputRow;", "dmlRecordToString", "", "Lkd/bos/olapServer2/common/string;", "isBofDML", "isEofDML", "replayDML", "cube", "Lkd/bos/olapServer2/storages/CubeWorkspace;", "writer", "Lkd/bos/olapServer2/storages/IInputRowWriter;", "isSkip", "is4BackupReplay", "toString", "bos-olap-core2"})
public abstract class AbstractDMLRecord
implements IDMLRecord {
    @NotNull
    private final IRedoRecordHead head;
    @NotNull
    private final ByteBuffer body;

    public AbstractDMLRecord(@NotNull IRedoRecordHead head, @NotNull ByteBuffer body) {
        Intrinsics.checkNotNullParameter((Object)head, (String)"head");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        this.head = head;
        this.body = body;
    }

    @NotNull
    public final IRedoRecordHead getHead() {
        return this.head;
    }

    @NotNull
    public final ByteBuffer getBody() {
        return this.body;
    }

    @Override
    @NotNull
    public RedoType getRedoType() {
        return this.head.getType();
    }

    @Override
    public int getCubeId() {
        return this.head.getCubeId();
    }

    @Override
    public boolean isOlapLevel() {
        return false;
    }

    @Override
    public long getTid() {
        return this.head.getTid();
    }

    @Override
    public void replayDML(@NotNull CubeWorkspace cube, @NotNull IInputRowWriter writer, @NotNull InputRow row, boolean isSkip, boolean is4BackupReplay) {
        Intrinsics.checkNotNullParameter((Object)cube, (String)"cube");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Intrinsics.checkNotNullParameter((Object)row, (String)"row");
        row.reset();
        switch (WhenMappings.$EnumSwitchMapping$0[this.getRedoType().ordinal()]) {
            case 1: {
                int partitionId = this.getPartitionId();
                int markDimensionCount = partitionId >= 0 ? cube.getMetadata().getPartitionItems().get(partitionId).getMarkDimensionsAndMembers().size() : 0;
                this.getRow(row, row.getKeys().getCount() - markDimensionCount);
                if (isSkip) {
                    this.clearMeasures(row);
                }
                if (is4BackupReplay) {
                    writer.addOrUpdate4Redo(partitionId, row.getKeys(), row.getValues());
                    break;
                }
                writer.add4Redo(partitionId, row.getKeys(), row.getValues(), this.getRowIndex());
                break;
            }
            case 2: {
                if (isSkip) {
                    return;
                }
                if (is4BackupReplay) {
                    this.getMeasures(row);
                    IInputRowWriter4Redo.DefaultImpls.update4Redo$default(writer, this.getPartitionId(), this.getRowIndex(), row.getValues(), null, 8, null);
                    break;
                }
                this.getUndoValues(row);
                StaticMeasureValueCollection undoValue = new StaticMeasureValueCollection(row.getValues().getCount());
                int n = row.getValues().getCount();
                for (int i = 0; i < n; ++i) {
                    undoValue.set(i, row.getValues().getMeasureValue(i));
                }
                row.reset();
                this.getMeasures(row);
                writer.update4Redo(this.getPartitionId(), this.getRowIndex(), row.getValues(), undoValue);
                break;
            }
            case 3: {
                if (isSkip) {
                    return;
                }
                this.getMeasures(row);
                writer.update4Redo(this.getPartitionId(), this.getRowIndex(), row.getValues(), null);
                break;
            }
            default: {
                throw new NotSupportedException("not supported type: " + (Object)((Object)this.getRedoType()));
            }
        }
    }

    protected final void clearMeasures(@NotNull InputRow row) {
        Intrinsics.checkNotNullParameter((Object)row, (String)"row");
        int n = row.getValues().getCount();
        for (int i = 0; i < n; ++i) {
            if (Intrinsics.areEqual((Object)row.getValues().getMeasureValue(i), (Object)CommonTypesKt.getIgnoreValue())) continue;
            row.setMeasureValue(i, CommonTypesKt.getUndefined());
        }
    }

    @Override
    public boolean isEofDML() {
        return true;
    }

    @Override
    public boolean isBofDML() {
        return true;
    }

    @NotNull
    public String dmlRecordToString() {
        String string2;
        switch (WhenMappings.$EnumSwitchMapping$0[this.getRedoType().ordinal()]) {
            case 1: {
                string2 = "cubeID: " + this.head.getCubeId() + ", tid: " + this.head.getTid() + ", insert, index: " + this.getRowIndex() + '\n';
                break;
            }
            case 2: {
                string2 = "cubeID: " + this.head.getCubeId() + ", tid: " + this.head.getTid() + ", update, partitionID: " + this.getPartitionId() + ", rowIndex: " + this.getRowIndex() + ", undoTid : " + this.getUndoTid() + '\n';
                break;
            }
            case 3: {
                string2 = "partitionID: " + this.getPartitionId() + ", compensation, rowIndex: " + this.getRowIndex() + ", rollbackTid: " + this.getUndoTid() + '\n';
                break;
            }
            default: {
                throw new NotSupportedException("not support such type: " + this.head.getType().name());
            }
        }
        return string2;
    }

    @NotNull
    public String toString() {
        return this.dmlRecordToString();
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RedoType.values().length];
            try {
                nArray[RedoType.INSERT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RedoType.UPDATE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RedoType.Compensation.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

