/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.replication;

import java.io.Closeable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import kd.bos.olapServer2.collections.IReferenceIterator;
import kd.bos.olapServer2.replication.DDLRecord;
import kd.bos.olapServer2.replication.DDLRecordV0;
import kd.bos.olapServer2.replication.DDLRecordV3;
import kd.bos.olapServer2.replication.IDDLRecord;
import kd.bos.olapServer2.replication.IDMLRecord;
import kd.bos.olapServer2.replication.IRedoRecord;
import kd.bos.olapServer2.replication.LSNUtil;
import kd.bos.olapServer2.replication.ReadedRedoPage;
import kd.bos.olapServer2.replication.RedoPageInfo;
import kd.bos.olapServer2.replication.RedoRecordWithPage;
import kd.bos.olapServer2.replication.SlaveLSNContext;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010(\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0005\b \u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u000278B-\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0010\b\u0002\u0010\u0006\u001a\n\u0018\u00010\u0007j\u0004\u0018\u0001`\b\u0012\f\b\u0002\u0010\t\u001a\u00060\nj\u0002`\u000b\u00a2\u0006\u0002\u0010\fJ\u001c\u0010&\u001a\u00060\nj\u0002`\u000b2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u000fH\u0002J\u001c\u0010*\u001a\u00060\nj\u0002`\u000b2\u0006\u0010'\u001a\u00020+2\u0006\u0010)\u001a\u00020\u000fH\u0002J\u0012\u0010,\u001a\u0004\u0018\u00010\u00022\u0006\u0010)\u001a\u00020\u0002H\u0002J\u0012\u0010-\u001a\u0004\u0018\u00010\u00022\u0006\u0010)\u001a\u00020\u0002H\u0002J\f\u0010.\u001a\u00060\nj\u0002`\u000bH\u0016J\u001a\u0010/\u001a\u00060\nj\u0002`\u000b2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001fH\u0002J\u001a\u00101\u001a\u00060\nj\u0002`\u000b2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001fH\u0002J\u0014\u00102\u001a\u00060\nj\u0002`\u000b2\u0006\u0010)\u001a\u00020\u000fH\u0002J\b\u00103\u001a\u000204H\u0002J\f\u00105\u001a\u00060\nj\u0002`\u000bH\u0002J\f\u00106\u001a\u00060\nj\u0002`\u000bH\u0002R\u0010\u0010\r\u001a\u0004\u0018\u00010\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u0010\u001a\u0016\u0012\b\u0012\u00060\u0007j\u0002`\b\u0012\b\u0012\u00060\u0012R\u00020\u00000\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0013\u001a&\u0012\b\u0012\u00060\u0007j\u0002`\b\u0012\u0018\u0012\u0016\u0012\b\u0012\u00060\u0007j\u0002`\b\u0012\b\u0012\u00060\u0014R\u00020\u00000\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\n\u0018\u00010\u0007j\u0004\u0018\u0001`\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u001b\u001a\u00060\nj\u0002`\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0012\u0010\t\u001a\u00060\nj\u0002`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0010\u0010\"\u001a\u0004\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lkd/bos/olapServer2/replication/AbstractRedoReader;", "Lkd/bos/olapServer2/collections/IReferenceIterator;", "Lkd/bos/olapServer2/replication/RedoRecordWithPage;", "Ljava/io/Closeable;", "lsnContext", "Lkd/bos/olapServer2/replication/SlaveLSNContext;", "cubeId", "", "Lkd/bos/olapServer2/common/int;", "isRedoReader", "", "Lkd/bos/olapServer2/common/bool;", "(Lkd/bos/olapServer2/replication/SlaveLSNContext;Ljava/lang/Integer;Z)V", "_current", "_lastPage", "Lkd/bos/olapServer2/replication/ReadedRedoPage;", "cacheDDLRecords", "Ljava/util/HashMap;", "Lkd/bos/olapServer2/replication/AbstractRedoReader$PageDDLRecord;", "cacheDMLRecords", "Lkd/bos/olapServer2/replication/AbstractRedoReader$PageDMLRecord;", "Ljava/lang/Integer;", "current", "getCurrent", "()Lkd/bos/olapServer2/replication/RedoRecordWithPage;", "currentRecord", "Lkd/bos/olapServer2/replication/IRedoRecord;", "existUnCompleteRecord", "getExistUnCompleteRecord", "()Z", "redoPageItr", "", "getRedoPageItr", "()Ljava/util/Iterator;", "startPage", "Lkd/bos/olapServer2/replication/RedoPageInfo;", "undoRecords", "Ljava/util/Stack;", "mergeRedoDDLRecord", "record", "Lkd/bos/olapServer2/replication/IDDLRecord;", "page", "mergeRedoDMLRecord", "Lkd/bos/olapServer2/replication/IDMLRecord;", "mergeUndoDDLRecord", "mergeUndoDMLRecord", "next", "nextEndRecord", "redoFileItr", "nextEndRecordInNextPage", "nextEndRecordInPage", "pushPageRecord", "", "redoNext", "undoNext", "PageDDLRecord", "PageDMLRecord", "bos-olap-core2"})
@SourceDebugExtension(value={"SMAP\nAbstractRedoReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractRedoReader.kt\nkd/bos/olapServer2/replication/AbstractRedoReader\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,343:1\n187#2,3:344\n*S KotlinDebug\n*F\n+ 1 AbstractRedoReader.kt\nkd/bos/olapServer2/replication/AbstractRedoReader\n*L\n192#1:344,3\n*E\n"})
public abstract class AbstractRedoReader
implements IReferenceIterator<RedoRecordWithPage>,
Closeable {
    @NotNull
    private final SlaveLSNContext lsnContext;
    @Nullable
    private final Integer cubeId;
    private final boolean isRedoReader;
    @Nullable
    private RedoRecordWithPage _current;
    @Nullable
    private RedoPageInfo startPage;
    @Nullable
    private IRedoRecord currentRecord;
    @NotNull
    private Stack<RedoRecordWithPage> undoRecords;
    @Nullable
    private ReadedRedoPage _lastPage;
    @NotNull
    private final HashMap<Integer, PageDDLRecord> cacheDDLRecords;
    @NotNull
    private final HashMap<Integer, HashMap<Integer, PageDMLRecord>> cacheDMLRecords;

    public AbstractRedoReader(@NotNull SlaveLSNContext lsnContext, @Nullable Integer cubeId, boolean isRedoReader) {
        Intrinsics.checkNotNullParameter((Object)lsnContext, (String)"lsnContext");
        this.lsnContext = lsnContext;
        this.cubeId = cubeId;
        this.isRedoReader = isRedoReader;
        this.undoRecords = new Stack();
        this.cacheDDLRecords = new HashMap();
        this.cacheDMLRecords = new HashMap();
    }

    public /* synthetic */ AbstractRedoReader(SlaveLSNContext slaveLSNContext, Integer n, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = null;
        }
        if ((n2 & 4) != 0) {
            bl = true;
        }
        this(slaveLSNContext, n, bl);
    }

    @NotNull
    public abstract Iterator<ReadedRedoPage> getRedoPageItr();

    @Override
    @NotNull
    public RedoRecordWithPage getCurrent() {
        RedoRecordWithPage redoRecordWithPage = this._current;
        if (redoRecordWithPage == null) {
            throw new NullPointerException("error,current is null");
        }
        return redoRecordWithPage;
    }

    @Override
    public boolean next() {
        if (!this.isRedoReader) {
            return this.undoNext();
        }
        return this.redoNext();
    }

    private final boolean undoNext() {
        this.pushPageRecord();
        while (!((Collection)this.undoRecords).isEmpty()) {
            RedoRecordWithPage redoRecordWithPage = this.undoRecords.pop();
            this.pushPageRecord();
            IRedoRecord record = redoRecordWithPage.getRecord();
            if (record instanceof IDDLRecord) {
                if (record instanceof DDLRecordV0 || record instanceof DDLRecord) {
                    this._current = redoRecordWithPage;
                    return true;
                }
                Intrinsics.checkNotNull((Object)redoRecordWithPage);
                this._current = this.mergeUndoDDLRecord(redoRecordWithPage);
                if (this._current == null) continue;
                return true;
            }
            if (record instanceof IDMLRecord) {
                Intrinsics.checkNotNull((Object)redoRecordWithPage);
                this._current = this.mergeUndoDMLRecord(redoRecordWithPage);
                if (this._current == null) continue;
                return true;
            }
            this._current = redoRecordWithPage;
            return true;
        }
        return false;
    }

    private final boolean redoNext() {
        boolean bl;
        if (this.nextEndRecord(this.getRedoPageItr())) {
            RedoPageInfo page = this.startPage;
            IRedoRecord record = this.currentRecord;
            if (!(page != null && record != null)) {
                String string2 = "Failed requirement.";
                throw new IllegalArgumentException(string2.toString());
            }
            this._current = new RedoRecordWithPage(page, record);
            bl = true;
        } else {
            this.startPage = null;
            this.currentRecord = null;
            this._current = null;
            bl = false;
        }
        return bl;
    }

    private final void pushPageRecord() {
        while (this.undoRecords.empty() && this.getRedoPageItr().hasNext()) {
            ReadedRedoPage page = this.getRedoPageItr().next();
            while (page.hasNext()) {
                IRedoRecord record = page.next();
                RedoRecordWithPage redoRecord = new RedoRecordWithPage(new RedoPageInfo(page), record);
                if (this.cubeId != null) {
                    Integer n = this.cubeId;
                    if (n == null || record.getCubeId() != n.intValue()) continue;
                    this.undoRecords.push(redoRecord);
                    continue;
                }
                this.undoRecords.push(redoRecord);
            }
        }
    }

    private final boolean nextEndRecord(Iterator<ReadedRedoPage> redoFileItr) {
        boolean bl;
        ReadedRedoPage lastPage = this._lastPage;
        if (lastPage == null) {
            bl = this.nextEndRecordInNextPage(redoFileItr);
        } else {
            boolean hasNext = this.nextEndRecordInPage(lastPage);
            if (hasNext) {
                bl = true;
            } else {
                this._lastPage = null;
                bl = this.nextEndRecordInNextPage(redoFileItr);
            }
        }
        return bl;
    }

    private final boolean nextEndRecordInPage(ReadedRedoPage page) {
        if (page.hasNext()) {
            boolean bl;
            IRedoRecord record = page.next();
            if (record instanceof IDDLRecord) {
                bl = this.mergeRedoDDLRecord((IDDLRecord)record, page);
            } else if (record instanceof IDMLRecord) {
                bl = this.mergeRedoDMLRecord((IDMLRecord)record, page);
            } else {
                this.startPage = new RedoPageInfo(page);
                this.currentRecord = record;
                bl = true;
            }
            return bl;
        }
        return false;
    }

    private final boolean nextEndRecordInNextPage(Iterator<ReadedRedoPage> redoFileItr) {
        while (redoFileItr.hasNext()) {
            ReadedRedoPage currentPage;
            this._lastPage = currentPage = redoFileItr.next();
            this.lsnContext.setNextReadPage(LSNUtil.INSTANCE.nextPageLSN(this.lsnContext.getNextReadPage()));
            boolean hasNext = this.nextEndRecordInPage(currentPage);
            if (!hasNext) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean getExistUnCompleteRecord() {
        boolean bl;
        if (this.cacheDDLRecords.size() > 0) return true;
        Map $this$any$iv = this.cacheDMLRecords;
        boolean $i$f$any = false;
        if ($this$any$iv.isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.entrySet().iterator();
        do {
            Map.Entry element$iv;
            if (!iterator2.hasNext()) return false;
            Map.Entry entry = element$iv = iterator2.next();
            boolean bl2 = false;
            if (((HashMap)entry.getValue()).size() > 0) {
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    private final boolean mergeRedoDMLRecord(IDMLRecord record, ReadedRedoPage page) {
        PageDMLRecord prePartitionPageRecord;
        HashMap<Integer, PageDMLRecord> prePageRecord = this.cacheDMLRecords.get(record.getCubeId());
        int partitionId = record.getPartitionId();
        HashMap<Integer, PageDMLRecord> hashMap = prePageRecord;
        PageDMLRecord pageDMLRecord = prePartitionPageRecord = hashMap != null ? hashMap.get(partitionId) : null;
        if (prePageRecord == null || prePartitionPageRecord == null) {
            if (record.isEofDML()) {
                this.startPage = new RedoPageInfo(page);
                this.currentRecord = record;
                return true;
            }
            if (prePageRecord == null) {
                Map map2 = this.cacheDMLRecords;
                Integer n = record.getCubeId();
                Object object2 = new Pair[]{TuplesKt.to((Object)partitionId, (Object)new PageDMLRecord(this, new RedoPageInfo(page), record))};
                object2 = MapsKt.hashMapOf((Pair[])object2);
                map2.put(n, object2);
            } else {
                Integer n = partitionId;
                ((Map)prePageRecord).put(n, new PageDMLRecord(this, new RedoPageInfo(page), record));
            }
        } else {
            IDMLRecord mergeRecord = record.consolidate(prePartitionPageRecord.getRecord());
            if (record.isEofDML()) {
                prePageRecord.remove(partitionId);
                this.startPage = prePartitionPageRecord.getStartPage();
                this.currentRecord = mergeRecord;
                return true;
            }
            prePartitionPageRecord.setRecord(mergeRecord);
        }
        return false;
    }

    private final boolean mergeRedoDDLRecord(IDDLRecord record, ReadedRedoPage page) {
        PageDDLRecord prePageRecord = this.cacheDDLRecords.get(record.getCubeId());
        if (prePageRecord == null) {
            if (record.isEofDDL()) {
                this.startPage = new RedoPageInfo(page);
                this.currentRecord = record;
                return true;
            }
            if (!(record.getCubeId() != 0)) {
                String string2 = "Failed requirement.";
                throw new IllegalArgumentException(string2.toString());
            }
            ((Map)this.cacheDDLRecords).put(record.getCubeId(), new PageDDLRecord(this, new RedoPageInfo(page), record));
        } else {
            IDDLRecord mergeRecord = record.consolidate(prePageRecord.getRecord());
            if (record.isEofDDL()) {
                if (!(record.getCubeId() != 0)) {
                    String string3 = "Failed requirement.";
                    throw new IllegalArgumentException(string3.toString());
                }
                this.cacheDDLRecords.remove(record.getCubeId());
                this.startPage = prePageRecord.getStartPage();
                this.currentRecord = mergeRecord;
                return true;
            }
            prePageRecord.setRecord(mergeRecord);
        }
        return false;
    }

    private final RedoRecordWithPage mergeUndoDMLRecord(RedoRecordWithPage page) {
        PageDMLRecord prePartitionPageRecord;
        IRedoRecord iRedoRecord = page.getRecord();
        Intrinsics.checkNotNull((Object)iRedoRecord, (String)"null cannot be cast to non-null type kd.bos.olapServer2.replication.IDMLRecord");
        IDMLRecord record = (IDMLRecord)iRedoRecord;
        HashMap<Integer, PageDMLRecord> prePageRecord = this.cacheDMLRecords.get(record.getCubeId());
        int partitionId = record.getPartitionId();
        HashMap<Integer, PageDMLRecord> hashMap = prePageRecord;
        PageDMLRecord pageDMLRecord = prePartitionPageRecord = hashMap != null ? hashMap.get(partitionId) : null;
        if (prePageRecord == null || prePartitionPageRecord == null) {
            if (record.isBofDML()) {
                return page;
            }
            if (prePageRecord == null) {
                Map map2 = this.cacheDMLRecords;
                Integer n = record.getCubeId();
                Object object2 = new Pair[]{TuplesKt.to((Object)partitionId, (Object)new PageDMLRecord(this, page.getStartPage(), record))};
                object2 = MapsKt.hashMapOf((Pair[])object2);
                map2.put(n, object2);
            } else {
                Integer n = partitionId;
                ((Map)prePageRecord).put(n, new PageDMLRecord(this, page.getStartPage(), record));
            }
        } else {
            IDMLRecord mergeRecord = prePartitionPageRecord.getRecord().consolidate(record);
            if (record.isBofDML()) {
                prePageRecord.remove(partitionId);
                return new RedoRecordWithPage(page.getStartPage(), prePartitionPageRecord.getEndPageInfo(), mergeRecord);
            }
            Integer n = partitionId;
            ((Map)prePageRecord).put(n, new PageDMLRecord(this, page.getStartPage(), prePartitionPageRecord.getEndPageInfo(), mergeRecord));
        }
        return null;
    }

    private final RedoRecordWithPage mergeUndoDDLRecord(RedoRecordWithPage page) {
        IRedoRecord record = page.getRecord();
        if (!(record instanceof IDDLRecord)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        PageDDLRecord prePageRecord = this.cacheDDLRecords.get(record.getCubeId());
        if (prePageRecord == null) {
            if (((IDDLRecord)record).isBofDDL()) {
                return page;
            }
            if (!(record.getCubeId() != 0)) {
                String string3 = "Failed requirement.";
                throw new IllegalArgumentException(string3.toString());
            }
            ((Map)this.cacheDDLRecords).put(record.getCubeId(), new PageDDLRecord(this, page.getStartPage(), (IDDLRecord)record));
        } else {
            IDDLRecord iDDLRecord = prePageRecord.getRecord();
            Intrinsics.checkNotNull((Object)iDDLRecord, (String)"null cannot be cast to non-null type kd.bos.olapServer2.replication.DDLRecordV3");
            IDDLRecord mergeRecord = ((DDLRecordV3)iDDLRecord).consolidate(record);
            if (((IDDLRecord)record).isBofDDL()) {
                if (!(record.getCubeId() != 0)) {
                    String string4 = "Failed requirement.";
                    throw new IllegalArgumentException(string4.toString());
                }
                this.cacheDDLRecords.remove(record.getCubeId());
                return new RedoRecordWithPage(page.getStartPage(), prePageRecord.getEndPageInfo(), mergeRecord);
            }
            ((Map)this.cacheDDLRecords).put(record.getCubeId(), new PageDDLRecord(this, page.getStartPage(), prePageRecord.getEndPageInfo(), mergeRecord));
        }
        return null;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\n\u00a8\u0006\u0010"}, d2={"Lkd/bos/olapServer2/replication/AbstractRedoReader$PageDDLRecord;", "", "startPage", "Lkd/bos/olapServer2/replication/RedoPageInfo;", "record", "Lkd/bos/olapServer2/replication/IDDLRecord;", "(Lkd/bos/olapServer2/replication/AbstractRedoReader;Lkd/bos/olapServer2/replication/RedoPageInfo;Lkd/bos/olapServer2/replication/IDDLRecord;)V", "endPageInfo", "(Lkd/bos/olapServer2/replication/AbstractRedoReader;Lkd/bos/olapServer2/replication/RedoPageInfo;Lkd/bos/olapServer2/replication/RedoPageInfo;Lkd/bos/olapServer2/replication/IDDLRecord;)V", "getEndPageInfo", "()Lkd/bos/olapServer2/replication/RedoPageInfo;", "getRecord", "()Lkd/bos/olapServer2/replication/IDDLRecord;", "setRecord", "(Lkd/bos/olapServer2/replication/IDDLRecord;)V", "getStartPage", "bos-olap-core2"})
    private final class PageDDLRecord {
        @NotNull
        private final RedoPageInfo startPage;
        @NotNull
        private final RedoPageInfo endPageInfo;
        @NotNull
        private IDDLRecord record;
        final /* synthetic */ AbstractRedoReader this$0;

        public PageDDLRecord(@NotNull AbstractRedoReader this$0, @NotNull RedoPageInfo startPage, @NotNull RedoPageInfo endPageInfo, IDDLRecord record) {
            Intrinsics.checkNotNullParameter((Object)startPage, (String)"startPage");
            Intrinsics.checkNotNullParameter((Object)endPageInfo, (String)"endPageInfo");
            Intrinsics.checkNotNullParameter((Object)record, (String)"record");
            this.this$0 = this$0;
            this.startPage = startPage;
            this.endPageInfo = endPageInfo;
            this.record = record;
        }

        @NotNull
        public final RedoPageInfo getStartPage() {
            return this.startPage;
        }

        @NotNull
        public final RedoPageInfo getEndPageInfo() {
            return this.endPageInfo;
        }

        @NotNull
        public final IDDLRecord getRecord() {
            return this.record;
        }

        public final void setRecord(@NotNull IDDLRecord iDDLRecord) {
            Intrinsics.checkNotNullParameter((Object)iDDLRecord, (String)"<set-?>");
            this.record = iDDLRecord;
        }

        public PageDDLRecord(@NotNull AbstractRedoReader this$0, @NotNull RedoPageInfo startPage, IDDLRecord record) {
            Intrinsics.checkNotNullParameter((Object)startPage, (String)"startPage");
            Intrinsics.checkNotNullParameter((Object)record, (String)"record");
            this(this$0, startPage, startPage, record);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\n\u00a8\u0006\u0010"}, d2={"Lkd/bos/olapServer2/replication/AbstractRedoReader$PageDMLRecord;", "", "startPage", "Lkd/bos/olapServer2/replication/RedoPageInfo;", "record", "Lkd/bos/olapServer2/replication/IDMLRecord;", "(Lkd/bos/olapServer2/replication/AbstractRedoReader;Lkd/bos/olapServer2/replication/RedoPageInfo;Lkd/bos/olapServer2/replication/IDMLRecord;)V", "endPageInfo", "(Lkd/bos/olapServer2/replication/AbstractRedoReader;Lkd/bos/olapServer2/replication/RedoPageInfo;Lkd/bos/olapServer2/replication/RedoPageInfo;Lkd/bos/olapServer2/replication/IDMLRecord;)V", "getEndPageInfo", "()Lkd/bos/olapServer2/replication/RedoPageInfo;", "getRecord", "()Lkd/bos/olapServer2/replication/IDMLRecord;", "setRecord", "(Lkd/bos/olapServer2/replication/IDMLRecord;)V", "getStartPage", "bos-olap-core2"})
    private final class PageDMLRecord {
        @NotNull
        private final RedoPageInfo startPage;
        @NotNull
        private final RedoPageInfo endPageInfo;
        @NotNull
        private IDMLRecord record;
        final /* synthetic */ AbstractRedoReader this$0;

        public PageDMLRecord(@NotNull AbstractRedoReader this$0, @NotNull RedoPageInfo startPage, @NotNull RedoPageInfo endPageInfo, IDMLRecord record) {
            Intrinsics.checkNotNullParameter((Object)startPage, (String)"startPage");
            Intrinsics.checkNotNullParameter((Object)endPageInfo, (String)"endPageInfo");
            Intrinsics.checkNotNullParameter((Object)record, (String)"record");
            this.this$0 = this$0;
            this.startPage = startPage;
            this.endPageInfo = endPageInfo;
            this.record = record;
        }

        @NotNull
        public final RedoPageInfo getStartPage() {
            return this.startPage;
        }

        @NotNull
        public final RedoPageInfo getEndPageInfo() {
            return this.endPageInfo;
        }

        @NotNull
        public final IDMLRecord getRecord() {
            return this.record;
        }

        public final void setRecord(@NotNull IDMLRecord iDMLRecord) {
            Intrinsics.checkNotNullParameter((Object)iDMLRecord, (String)"<set-?>");
            this.record = iDMLRecord;
        }

        public PageDMLRecord(@NotNull AbstractRedoReader this$0, @NotNull RedoPageInfo startPage, IDMLRecord record) {
            Intrinsics.checkNotNullParameter((Object)startPage, (String)"startPage");
            Intrinsics.checkNotNullParameter((Object)record, (String)"record");
            this(this$0, startPage, startPage, record);
        }
    }
}

