/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.replication;

import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.ObjectReader;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import kd.bos.olapServer2.backup.sequenceLog.SeqRedoLogger;
import kd.bos.olapServer2.common.ITempFolder;
import kd.bos.olapServer2.common.Paths;
import kd.bos.olapServer2.common.PathsKt;
import kd.bos.olapServer2.replication.BackupRecordMetadata;
import kd.bos.olapServer2.replication.BackupRecordMetadataBuilder;
import kd.bos.olapServer2.replication.BackupRecordMetadataBuilderV2;
import kd.bos.olapServer2.replication.BackupRecordMetadataBuilderV3;
import kd.bos.olapServer2.replication.BackupRecordMetadataBuilderV4;
import kd.bos.olapServer2.replication.BackupRecordType;
import kd.bos.olapServer2.replication.BackupRecordV3;
import kd.bos.olapServer2.replication.BackupRecordWorkspace;
import kd.bos.olapServer2.replication.CubeMapFileContainer;
import kd.bos.olapServer2.replication.CubeMapValue;
import kd.bos.olapServer2.replication.LSNUtil;
import kd.bos.olapServer2.replication.RedoUtil;
import kd.bos.olapServer2.replication.TotalBackupBuilderV1;
import kd.bos.olapServer2.tools.FileTools;
import kd.bos.olapServer2.tools.JsonHelper;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\n\b\u0000\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0019\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J,\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J \u0010\u0010\u001a\u00020\t2\n\u0010\u0011\u001a\u00060\u0012j\u0002`\u00132\n\u0010\u0014\u001a\u00060\u0003j\u0002`\u0004H\u0002J\u0006\u0010\u0015\u001a\u00020\tJ \u0010\u0016\u001a\u00020\t2\n\u0010\u0017\u001a\u00060\u0003j\u0002`\u00042\n\u0010\u0018\u001a\u00060\u0003j\u0002`\u0004H\u0002J(\u0010\u0019\u001a\u00020\t2\n\u0010\u001a\u001a\u00060\u0003j\u0002`\u00042\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u00042\u0006\u0010\u001b\u001a\u00020\fH\u0002R\u0012\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lkd/bos/olapServer2/replication/BackupRecordUpgrade;", "", "backupPath", "", "Lkd/bos/olapServer2/common/string;", "incrementLogger", "Lkd/bos/olapServer2/backup/sequenceLog/SeqRedoLogger;", "(Ljava/lang/String;Lkd/bos/olapServer2/backup/sequenceLog/SeqRedoLogger;)V", "delOldFiles", "", "totalRecords", "", "Lkd/bos/olapServer2/replication/BackupRecordV3;", "targetDir", "Ljava/io/File;", "incrementRecords", "deleteRecoveryFiles", "lastLsn", "", "Lkd/bos/olapServer2/common/LSN;", "recoveryBackupPath", "tryUpgrade", "upgradeIncrement", "sourcePath", "targetPath", "upgradeTotal", "sourceTotalPath", "backupRecord", "Companion", "bos-olap-core2"})
@SourceDebugExtension(value={"SMAP\nBackupRecordUpgrade.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackupRecordUpgrade.kt\nkd/bos/olapServer2/replication/BackupRecordUpgrade\n+ 2 Timing.kt\nkotlin/system/TimingKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,260:1\n17#2,5:261\n22#2:268\n13309#3,2:266\n13309#3,2:269\n13309#3,2:275\n13309#3,2:277\n13309#3,2:279\n13309#3,2:281\n1855#4,2:271\n1855#4,2:273\n*S KotlinDebug\n*F\n+ 1 BackupRecordUpgrade.kt\nkd/bos/olapServer2/replication/BackupRecordUpgrade\n*L\n75#1:261,5\n75#1:268\n80#1:266,2\n131#1:269,2\n162#1:275,2\n180#1:277,2\n190#1:279,2\n207#1:281,2\n149#1:271,2\n152#1:273,2\n*E\n"})
public final class BackupRecordUpgrade {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String backupPath;
    @NotNull
    private final SeqRedoLogger incrementLogger;

    public BackupRecordUpgrade(@NotNull String backupPath, @NotNull SeqRedoLogger incrementLogger) {
        Intrinsics.checkNotNullParameter((Object)backupPath, (String)"backupPath");
        Intrinsics.checkNotNullParameter((Object)incrementLogger, (String)"incrementLogger");
        this.backupPath = backupPath;
        this.incrementLogger = incrementLogger;
    }

    public final void tryUpgrade() {
        boolean onlyNeedUpdateVersion = false;
        int realVersion = Companion.tryGetVersion$bos_olap_core2(this.backupPath);
        switch (realVersion) {
            case -1: {
                return;
            }
            case 1: 
            case 2: {
                onlyNeedUpdateVersion = false;
                break;
            }
            case 3: {
                onlyNeedUpdateVersion = true;
                break;
            }
            case 4: {
                return;
            }
        }
        if (onlyNeedUpdateVersion) {
            BackupRecordMetadataBuilder.Companion.readFrom(this.backupPath).upgrade(true);
        } else {
            System.out.println((Object)"The service is upgrading backup data,please waiting...");
            BackupRecordMetadata metadata = BackupRecordMetadataBuilder.Companion.readFrom(this.backupPath).upgrade(true).build();
            File tempDir = ITempFolder.Companion.createTempDirectory("BackupRecordWorkspace_Upgrade");
            String string2 = tempDir.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
            String incrementBase = RedoUtil.INSTANCE.getOrCreateIncrementPath(string2);
            try {
                boolean $i$f$measureTimeMillis = false;
                long start$iv = System.currentTimeMillis();
                boolean bl = false;
                String string3 = tempDir.getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getAbsolutePath(...)");
                BackupRecordMetadataBuilderV4 builder = new BackupRecordMetadataBuilderV4(string3);
                List totalRecords = new ArrayList();
                List incrementRecords = new ArrayList();
                BackupRecordV3[] $this$forEach$iv = metadata.getBackRecords();
                boolean $i$f$forEach = false;
                int n = $this$forEach$iv.length;
                for (int i = 0; i < n; ++i) {
                    BackupRecordV3 element$iv;
                    BackupRecordV3 backupRecord = element$iv = $this$forEach$iv[i];
                    boolean bl2 = false;
                    switch (WhenMappings.$EnumSwitchMapping$0[backupRecord.getType().ordinal()]) {
                        case 1: 
                        case 2: {
                            String[] stringArray = new String[]{backupRecord.getName()};
                            File totalDir = Paths.INSTANCE.get(this.backupPath, stringArray).toFile();
                            if (!totalDir.exists()) break;
                            String string4 = totalDir.getPath();
                            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getPath(...)");
                            String string5 = tempDir.getPath();
                            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getPath(...)");
                            this.upgradeTotal(string4, string5, backupRecord);
                            builder.getBackupRecords().add(backupRecord);
                            totalRecords.add(backupRecord);
                            break;
                        }
                        case 3: {
                            String[] stringArray = new String[]{backupRecord.getName()};
                            File incrementDir = Paths.INSTANCE.get(this.backupPath, stringArray).toFile();
                            if (!incrementDir.exists()) break;
                            String string6 = incrementDir.getPath();
                            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getPath(...)");
                            this.upgradeIncrement(string6, incrementBase);
                            incrementRecords.add(backupRecord);
                        }
                    }
                }
                builder.save();
                File targetDir = new File(this.backupPath);
                String string7 = targetDir.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"getPath(...)");
                String[] stringArray = new String[]{"backup.record"};
                File backupRecordFile = Paths.INSTANCE.get(string7, stringArray).toFile();
                if (backupRecordFile.exists()) {
                    String string8 = targetDir.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"getPath(...)");
                    backupRecordFile.renameTo(Paths.INSTANCE.toFile(string8, "backupOld.record"));
                }
                FileTools.moveDir$default(FileTools.INSTANCE, tempDir, targetDir, SetsKt.emptySet(), false, false, 24, null);
                String[] stringArray2 = new String[]{"recoveryFiles"};
                File recoveryFilesSource = Paths.INSTANCE.get(this.backupPath, stringArray2).toFile();
                if (recoveryFilesSource.exists()) {
                    BackupRecordMetadata newMetadata = builder.build();
                    BackupRecordV3 firstRecord = (BackupRecordV3)ArraysKt.firstOrNull((Object[])newMetadata.getBackRecords());
                    if (firstRecord != null) {
                        long l = firstRecord.getStart();
                        String string9 = recoveryFilesSource.getPath();
                        Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"getPath(...)");
                        this.deleteRecoveryFiles(l, string9);
                    }
                    String[] stringArray3 = new String[]{"recoveryFiles"};
                    File recoveryFilesTarget = Paths.INSTANCE.get(RedoUtil.INSTANCE.getOrCreateIncrementPath(this.backupPath), stringArray3).toFile();
                    Intrinsics.checkNotNull((Object)recoveryFilesSource);
                    Intrinsics.checkNotNull((Object)recoveryFilesTarget);
                    FileTools.moveDir$default(FileTools.INSTANCE, recoveryFilesSource, recoveryFilesTarget, SetsKt.emptySet(), false, false, 24, null);
                }
                this.delOldFiles(totalRecords, targetDir, incrementRecords);
                long upgradeTime = System.currentTimeMillis() - start$iv;
                File[] fileArray = Paths.INSTANCE.toFile(RedoUtil.INSTANCE.getOrCreateIncrementPath(this.backupPath)).listFiles();
                if (fileArray != null) {
                    File[] $this$forEach$iv2 = fileArray;
                    boolean $i$f$forEach2 = false;
                    int n2 = $this$forEach$iv2.length;
                    for (int i = 0; i < n2; ++i) {
                        File element$iv;
                        File it = element$iv = $this$forEach$iv2[i];
                        boolean bl3 = false;
                        Intrinsics.checkNotNull((Object)it);
                        if (!Intrinsics.areEqual((Object)FilesKt.getExtension((File)it), (Object)"redo")) continue;
                        this.incrementLogger.addFile(it);
                    }
                }
                System.out.println((Object)("Successfully upgraded backup data,spend time " + (double)upgradeTime / 1000.0 + 's'));
            }
            catch (Throwable t2) {
                StringBuilder stringBuilder = new StringBuilder().append("Upgraded backup data failed,error message:");
                String string10 = t2.getMessage();
                if (string10 == null) {
                    string10 = "";
                }
                System.out.println((Object)stringBuilder.append(string10).toString());
                FileTools.INSTANCE.deleteDir(tempDir);
                throw t2;
            }
        }
    }

    private final void delOldFiles(List<BackupRecordV3> totalRecords, File targetDir, List<BackupRecordV3> incrementRecords) {
        String[] stringArray;
        Iterable $this$forEach$iv = totalRecords;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BackupRecordV3 totalRecord = (BackupRecordV3)element$iv;
            boolean bl = false;
            String string2 = targetDir.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
            stringArray = new String[]{totalRecord.getName()};
            File file = Paths.INSTANCE.get(string2, stringArray).toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
            FileTools.INSTANCE.deleteDir(file);
        }
        $this$forEach$iv = incrementRecords;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BackupRecordV3 incrementRecord = (BackupRecordV3)element$iv;
            boolean bl = false;
            String string3 = targetDir.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getPath(...)");
            stringArray = new String[]{incrementRecord.getName()};
            File file = Paths.INSTANCE.get(string3, stringArray).toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
            FileTools.INSTANCE.deleteDir(file);
        }
    }

    private final void deleteRecoveryFiles(long lastLsn, String recoveryBackupPath) {
        block1: {
            File[] files;
            if (files == null) break block1;
            File[] $this$forEach$iv = files = PathsKt.fileSafeConstructor(recoveryBackupPath).listFiles(BackupRecordUpgrade::deleteRecoveryFiles$lambda$5);
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                File element$iv;
                File file = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                Intrinsics.checkNotNull((Object)file);
                long fileLsn = LSNUtil.INSTANCE.getLsnByBackupFileName(FilesKt.getNameWithoutExtension((File)file));
                if (fileLsn >= lastLsn) continue;
                file.delete();
            }
        }
    }

    private final void upgradeTotal(String sourceTotalPath, String backupPath, BackupRecordV3 backupRecord) {
        String[] copyFiles;
        String sourceTotalName = backupRecord.getName();
        String[] stringArray = new String[]{"-"};
        String timeStr = (String)StringsKt.split$default((CharSequence)sourceTotalName, (String[])stringArray, (boolean)false, (int)2, (int)2, null).get(0);
        String targetTotalPath = RedoUtil.INSTANCE.getTotalRecordFolder(backupPath, sourceTotalName, true).getAbsolutePath();
        String[] stringArray2 = new String[]{"index.json", "olap.control", "lsn.control"};
        String[] $this$forEach$iv = copyFiles = stringArray2;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            String element$iv;
            String name2 = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            String[] stringArray3 = new String[]{name2};
            Path sourceFile = Paths.INSTANCE.get(sourceTotalPath, stringArray3);
            Intrinsics.checkNotNull((Object)targetTotalPath);
            String[] stringArray4 = new String[]{name2};
            Path targetFile = Paths.INSTANCE.get(targetTotalPath, stringArray4);
            if (!sourceFile.toFile().exists()) continue;
            Files.copy(sourceFile, targetFile, new CopyOption[0]);
        }
        TotalBackupBuilderV1 collection = new TotalBackupBuilderV1();
        File[] fileArray = new File(sourceTotalPath).listFiles(BackupRecordUpgrade::upgradeTotal$lambda$8);
        if (fileArray != null) {
            File[] $this$forEach$iv2 = fileArray;
            boolean $i$f$forEach2 = false;
            int n2 = $this$forEach$iv2.length;
            for (int i = 0; i < n2; ++i) {
                File element$iv;
                File backupFile = element$iv = $this$forEach$iv2[i];
                boolean bl = false;
                Intrinsics.checkNotNull((Object)backupFile);
                String cubeName = FilesKt.getNameWithoutExtension((File)backupFile);
                String fileName = cubeName + '-' + timeStr + ".backup";
                String targetCubeDir = FileTools.INSTANCE.getOrCreateDir(backupPath, cubeName);
                String[] stringArray5 = new String[]{fileName};
                Path targetCubePath = Paths.INSTANCE.get(targetCubeDir, stringArray5);
                Files.copy(backupFile.toPath(), targetCubePath, new CopyOption[0]);
                long tid = BackupRecordWorkspace.Companion.getBackupFileTransactionVersion(backupFile);
                collection.set(cubeName, new CubeMapValue(tid, fileName));
            }
        }
        Intrinsics.checkNotNull((Object)targetTotalPath);
        new CubeMapFileContainer(targetTotalPath).save(collection);
    }

    private final void upgradeIncrement(String sourcePath, String targetPath) {
        block1: {
            File[] fileArray = new File(sourcePath).listFiles(BackupRecordUpgrade::upgradeIncrement$lambda$10);
            if (fileArray == null) break block1;
            File[] $this$forEach$iv = fileArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                File element$iv;
                File backupFile = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                Object[] objectArray = new String[1];
                Intrinsics.checkNotNullExpressionValue((Object)backupFile.getName(), (String)"getName(...)");
                Path targetFilePath = Paths.INSTANCE.get(targetPath, (String[])objectArray);
                objectArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                Files.copy(backupFile.toPath(), targetFilePath, (CopyOption[])objectArray);
            }
        }
    }

    private static final boolean deleteRecoveryFiles$lambda$5(File file, String fileName) {
        Intrinsics.checkNotNull((Object)fileName);
        return StringsKt.endsWith$default((String)fileName, (String)".backup", (boolean)false, (int)2, null);
    }

    private static final boolean upgradeTotal$lambda$8(File f) {
        String string2 = f.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        return StringsKt.endsWith$default((String)string2, (String)".backup", (boolean)false, (int)2, null);
    }

    private static final boolean upgradeIncrement$lambda$10(File f) {
        String string2 = f.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        return StringsKt.endsWith$default((String)string2, (String)".redo", (boolean)false, (int)2, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00060\u0004j\u0002`\u00052\n\u0010\u0006\u001a\u00060\u0007j\u0002`\bH\u0000\u00a2\u0006\u0002\b\t\u00a8\u0006\n"}, d2={"Lkd/bos/olapServer2/replication/BackupRecordUpgrade$Companion;", "", "()V", "tryGetVersion", "", "Lkd/bos/olapServer2/common/int;", "backupPath", "", "Lkd/bos/olapServer2/common/string;", "tryGetVersion$bos_olap_core2", "bos-olap-core2"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final int tryGetVersion$bos_olap_core2(@NotNull String backupPath) {
            int n;
            Intrinsics.checkNotNullParameter((Object)backupPath, (String)"backupPath");
            String[] stringArray = new String[]{"backup.record"};
            String filePath = ((Object)Paths.INSTANCE.get(backupPath, stringArray)).toString();
            if (FileTools.INSTANCE.isExist(filePath)) {
                Object object2 = Paths.INSTANCE.createInputStream(filePath);
                Object object3 = Charsets.UTF_8;
                Reader reader = new InputStreamReader((InputStream)object2, (Charset)object3);
                int n2 = 8192;
                object2 = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n2);
                object3 = null;
                try {
                    Object it = (BufferedReader)object2;
                    boolean bl = false;
                    it = ((BufferedReader)it).readLine();
                }
                catch (Throwable it) {
                    object3 = it;
                    throw it;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object2, (Throwable)object3);
                }
                Object firstLine = it;
                object2 = (CharSequence)firstLine;
                if (object2 == null || object2.length() == 0) {
                    n = -1;
                } else if (((String)firstLine).charAt(0) == '{') {
                    int version = -1;
                    try {
                        InjectableValues.Std inject = new InjectableValues.Std().addValue("path", (Object)backupPath);
                        ObjectReader objectReader = JsonHelper.INSTANCE.getMapper().readerFor(BackupRecordMetadataBuilder.class).with((InjectableValues)inject);
                        BackupRecordMetadataBuilder backupRecordMetadataBuilder = (BackupRecordMetadataBuilder)objectReader.readValue(PathsKt.fileSafeConstructor(filePath));
                        if (backupRecordMetadataBuilder instanceof BackupRecordMetadataBuilderV2) {
                            version = 2;
                        } else if (backupRecordMetadataBuilder instanceof BackupRecordMetadataBuilderV3) {
                            version = 3;
                        } else if (backupRecordMetadataBuilder instanceof BackupRecordMetadataBuilderV4) {
                            version = 4;
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    n = version;
                } else {
                    n = 1;
                }
            } else {
                n = -1;
            }
            return n;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BackupRecordType.values().length];
            try {
                nArray[BackupRecordType.Total.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BackupRecordType.HotTotal.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BackupRecordType.Increment.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

