/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.replication;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.olapServer2.backup.BackupConstant;
import kd.bos.olapServer2.common.CommonTypesKt;
import kd.bos.olapServer2.common.OlapConfigItems;
import kd.bos.olapServer2.common.Paths;
import kd.bos.olapServer2.replication.BackupRecord;
import kd.bos.olapServer2.replication.BackupRecordMetadata;
import kd.bos.olapServer2.replication.BackupRecordMetadataBuilder;
import kd.bos.olapServer2.replication.BackupRecordType;
import kd.bos.olapServer2.replication.BackupRecordV3;
import kd.bos.olapServer2.replication.BackupRecordWorkspace;
import kd.bos.olapServer2.replication.BackupType;
import kd.bos.olapServer2.replication.CubeMapFileContainer;
import kd.bos.olapServer2.replication.CubeMapValue;
import kd.bos.olapServer2.replication.LSNUtil;
import kd.bos.olapServer2.replication.RecoveryFiles;
import kd.bos.olapServer2.replication.RedoUtil;
import kd.bos.olapServer2.replication.TimeUtil;
import kd.bos.olapServer2.server.IOlapLogger;
import kd.bos.olapServer2.tools.FileTools;
import kd.bos.olapServer2.tools.Res;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0010\b\u0000\u0018\u0000 M2\u00020\u0001:\u0002LMB\u0019\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001c\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\n\u0010\u0015\u001a\u00060\u0016j\u0002`\u0017H\u0002J\u001c\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\b\u0002\u0010\u0015\u001a\u00060\u0016j\u0002`\u0017J&\u0010\u0019\u001a\u00020\u00122\u001c\u0010\u001a\u001a\u0018\u0012\b\u0012\u00060\u0003j\u0002`\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u001c0\u001bH\u0002J2\u0010\u001e\u001a\u00020\u00122\u001c\u0010\u001a\u001a\u0018\u0012\b\u0012\u00060\u0003j\u0002`\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u001c0\u001b2\n\u0010\u0015\u001a\u00060\u0016j\u0002`\u0017H\u0002J\u0010\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J*\u0010 \u001a\u00020\u00122\n\u0010!\u001a\u00060\u0003j\u0002`\u00042\n\u0010\"\u001a\u00060\u0016j\u0002`#2\n\u0010$\u001a\u00060\u0016j\u0002`#J\f\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u001cJ?\u0010'\u001a\u0004\u0018\u00010&2%\u0010(\u001a!\u0012\u0013\u0012\u00110&\u00a2\u0006\f\b*\u0012\b\b+\u0012\u0004\b\b(,\u0012\b\u0012\u00060-j\u0002`.0)2\f\b\u0002\u0010/\u001a\u00060-j\u0002`.H\u0002J+\u00100\u001a\b\u0012\u0004\u0012\u00020&012\n\u00102\u001a\u000603j\u0002`42\n\u0010/\u001a\u00060-j\u0002`.H\u0002\u00a2\u0006\u0002\u00105J=\u00106\u001a\u0004\u0018\u00010&2%\u0010(\u001a!\u0012\u0013\u0012\u00110&\u00a2\u0006\f\b*\u0012\b\b+\u0012\u0004\b\b(,\u0012\b\u0012\u00060-j\u0002`.0)2\n\u0010/\u001a\u00060-j\u0002`.H\u0002J\u000e\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:J,\u0010;\u001a\f\u0012\b\u0012\u00060\u0003j\u0002`\u00040\u001c2\f\b\u0002\u0010<\u001a\u000603j\u0002`42\f\b\u0002\u0010/\u001a\u00060-j\u0002`.J\"\u0010=\u001a\u001c\u0012\b\u0012\u00060\u0003j\u0002`\u0004\u0012\u000e\u0012\f\u0012\b\u0012\u00060\u0003j\u0002`\u00040>0\u001bH\u0002J\u0014\u0010?\u001a\u0004\u0018\u00010&2\n\u0010@\u001a\u00060\u0016j\u0002`\u0017J\b\u0010A\u001a\u0004\u0018\u00010&J\u0014\u0010B\u001a\u0004\u0018\u00010&2\n\u0010@\u001a\u00060\u0016j\u0002`\u0017J\b\u0010C\u001a\u0004\u0018\u00010&J\b\u0010D\u001a\u0004\u0018\u00010&J\u001e\u0010E\u001a\u0018\u0012\b\u0012\u00060\u0003j\u0002`\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u001c0\u001bH\u0002J\u0014\u0010F\u001a\u00060-j\u0002`.2\u0006\u0010G\u001a\u00020&H\u0002J*\u0010H\u001a\u00020\u00122\n\u0010I\u001a\u00060\u0003j\u0002`\u00042\n\u0010J\u001a\u00060\u0016j\u0002`#2\n\u0010K\u001a\u00060\u0016j\u0002`#R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006N"}, d2={"Lkd/bos/olapServer2/replication/BackupRecordWorkspace;", "", "backupPath", "", "Lkd/bos/olapServer2/common/string;", "_metadata", "Lkd/bos/olapServer2/replication/BackupRecordMetadata;", "(Ljava/lang/String;Lkd/bos/olapServer2/replication/BackupRecordMetadata;)V", "_cleaning", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getBackupPath", "()Ljava/lang/String;", "dateFormat", "Ljava/text/SimpleDateFormat;", "metadata", "getMetadata", "()Lkd/bos/olapServer2/replication/BackupRecordMetadata;", "cleanBackupFiles", "", "logger", "Lkd/bos/olapServer2/server/IOlapLogger;", "nowTime", "", "Lkd/bos/olapServer2/common/long;", "cleanBackupRecords", "cleanRuleByNumberAndTotalBackup", "realBackupFiles", "", "", "Lkd/bos/olapServer2/replication/BackupRecordWorkspace$BackupFileInfo;", "cleanRuleByTime", "cleanTotalBackup", "copyRecoveryFilesToBackup", "sourcePath", "startLsn", "Lkd/bos/olapServer2/common/LSN;", "endLsn", "findAllTotalRecordsWithSort", "Lkd/bos/olapServer2/replication/BackupRecord;", "findFirstRecord", "condition", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "record", "", "Lkd/bos/olapServer2/common/bool;", "includeZero", "findLastCountRecord", "", "count", "", "Lkd/bos/olapServer2/common/int;", "(IZ)[Lkd/bos/olapServer2/replication/BackupRecord;", "findLastRecord", "getBackupDir", "Ljava/io/File;", "type", "Lkd/bos/olapServer2/replication/BackupType;", "getBackupRecords", "lastCount", "getCubeTotalBackupFiles", "", "getFirstRecordAfterWithZero", "time", "getLastPointWithoutZero", "getLastTotalBackupBefore", "getLastTotalBackupWithZero", "getLastTotalBackupWithoutZero", "getRealBackupFiles", "isZeroEmptyTotalRecord", "backupRecord", "writeBackupRecord", "dirName", "start", "end", "BackupFileInfo", "Companion", "bos-olap-core2"})
@SourceDebugExtension(value={"SMAP\nBackupRecordWorkspace.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackupRecordWorkspace.kt\nkd/bos/olapServer2/replication/BackupRecordWorkspace\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 6 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,472:1\n1#2:473\n13309#3,2:474\n11065#3:476\n11400#3,3:477\n3792#3:480\n4307#3,2:481\n3792#3:488\n4307#3,2:489\n13309#3,2:506\n6143#3,2:514\n11065#3:516\n11400#3,3:517\n13309#3,2:522\n3792#3:524\n4307#3,2:525\n1045#4:483\n1855#4:484\n1855#4,2:485\n1856#4:487\n1855#4:491\n1855#4:492\n1856#4:500\n1856#4:501\n1855#4:502\n1002#4,2:503\n1856#4:505\n1549#4:508\n1620#4,3:509\n1045#4:527\n372#5,7:493\n37#6,2:512\n37#6,2:520\n*S KotlinDebug\n*F\n+ 1 BackupRecordWorkspace.kt\nkd/bos/olapServer2/replication/BackupRecordWorkspace\n*L\n76#1:474,2\n129#1:476\n129#1:477,3\n167#1:480\n167#1:481,2\n227#1:488\n227#1:489,2\n303#1:506,2\n319#1:514,2\n321#1:516\n321#1:517,3\n329#1:522,2\n347#1:524\n347#1:525,2\n167#1:483\n192#1:484\n193#1:485,2\n192#1:487\n227#1:491\n228#1:492\n228#1:500\n227#1:501\n292#1:502\n292#1:503,2\n292#1:505\n316#1:508\n316#1:509,3\n349#1:527\n229#1:493,7\n316#1:512,2\n321#1:520,2\n*E\n"})
public final class BackupRecordWorkspace {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String backupPath;
    @NotNull
    private volatile BackupRecordMetadata _metadata;
    @NotNull
    private final SimpleDateFormat dateFormat;
    @NotNull
    private final AtomicBoolean _cleaning;
    @NotNull
    public static final String TOTAL_NAME = "total";
    @NotNull
    public static final String INCREMENT_NAME = "increment";
    @NotNull
    public static final String RECOVERY_FILES_NAME = "recoveryFiles";

    public BackupRecordWorkspace(@NotNull String backupPath, @NotNull BackupRecordMetadata _metadata) {
        Intrinsics.checkNotNullParameter((Object)backupPath, (String)"backupPath");
        Intrinsics.checkNotNullParameter((Object)_metadata, (String)"_metadata");
        this.backupPath = backupPath;
        this._metadata = _metadata;
        this.dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        this._cleaning = new AtomicBoolean(false);
    }

    @NotNull
    public final String getBackupPath() {
        return this.backupPath;
    }

    @NotNull
    public final BackupRecordMetadata getMetadata() {
        return this._metadata;
    }

    @NotNull
    public final File getBackupDir(@NotNull BackupType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        String backupFolderName = null;
        switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: 
            case 2: {
                backupFolderName = TOTAL_NAME;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        String suffix = "-total";
        String dirName = this.dateFormat.format(new Date()) + suffix;
        String[] stringArray = new String[]{backupFolderName, dirName};
        File backupDir = Paths.INSTANCE.joinToFile(this.backupPath, stringArray);
        if (!(!backupDir.exists())) {
            boolean bl = false;
            String string2 = "backup directory " + backupDir + "\u5df2\u5b58\u5728";
            throw new IllegalArgumentException(string2.toString());
        }
        return backupDir;
    }

    @Nullable
    public final BackupRecord getLastTotalBackupWithoutZero() {
        return this.findLastRecord((Function1<? super BackupRecord, Boolean>)((Function1)getLastTotalBackupWithoutZero.1.INSTANCE), false);
    }

    @Nullable
    public final BackupRecord getLastPointWithoutZero() {
        return this.findLastRecord((Function1<? super BackupRecord, Boolean>)((Function1)getLastPointWithoutZero.1.INSTANCE), false);
    }

    @Nullable
    public final BackupRecord getLastTotalBackupWithZero() {
        return this.findLastRecord((Function1<? super BackupRecord, Boolean>)((Function1)getLastTotalBackupWithZero.1.INSTANCE), true);
    }

    private final BackupRecord findLastRecord(Function1<? super BackupRecord, Boolean> condition, boolean includeZero) {
        BackupRecordV3 lastRecord = null;
        BackupRecordV3[] $this$forEach$iv = this.getMetadata().getBackRecords();
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            BackupRecordV3 element$iv;
            BackupRecordV3 backupRecord = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            if (includeZero) {
                if (!((Boolean)condition.invoke((Object)backupRecord)).booleanValue()) continue;
                lastRecord = backupRecord;
                continue;
            }
            if (!((Boolean)condition.invoke((Object)backupRecord)).booleanValue() || this.isZeroEmptyTotalRecord(backupRecord)) continue;
            lastRecord = backupRecord;
        }
        return lastRecord;
    }

    public final void copyRecoveryFilesToBackup(@NotNull String sourcePath, long startLsn, long endLsn) {
        Intrinsics.checkNotNullParameter((Object)sourcePath, (String)"sourcePath");
        Companion.copyRecoveryFiles(sourcePath, startLsn, endLsn, this.backupPath);
    }

    private final boolean isZeroEmptyTotalRecord(BackupRecord backupRecord) {
        File totalBackupDir = RedoUtil.getTotalRecordFolder$default(RedoUtil.INSTANCE, this.backupPath, backupRecord.getName(), false, 4, null);
        return backupRecord.getStart() == 0L && backupRecord.getEnd() == 0L && !totalBackupDir.exists();
    }

    @Nullable
    public final BackupRecord getLastTotalBackupBefore(long time2) {
        return this.findLastRecord((Function1<? super BackupRecord, Boolean>)((Function1)new Function1<BackupRecord, Boolean>(time2){
            final /* synthetic */ long $time;
            {
                this.$time = $time;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull BackupRecord it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return kd.bos.olapServer2.replication.BackupRecordWorkspace$Companion.access$parseTotalBackupTime(BackupRecordWorkspace.Companion, it.getName()) <= this.$time && it.getStart() == it.getEnd();
            }
        }), false);
    }

    @Nullable
    public final BackupRecord getFirstRecordAfterWithZero(long time2) {
        return BackupRecordWorkspace.findFirstRecord$default(this, (Function1)new Function1<BackupRecord, Boolean>(time2){
            final /* synthetic */ long $time;
            {
                this.$time = $time;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull BackupRecord it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return kd.bos.olapServer2.replication.BackupRecordWorkspace$Companion.access$parseTotalBackupTime(BackupRecordWorkspace.Companion, it.getName()) > this.$time;
            }
        }, false, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getBackupRecords(int lastCount, boolean includeZero) {
        void $this$mapTo$iv$iv;
        BackupRecord[] $this$map$iv = this.findLastCountRecord(lastCount, includeZero);
        boolean $i$f$map = false;
        BackupRecord[] backupRecordArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var11_11 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List getBackupRecords$default(BackupRecordWorkspace backupRecordWorkspace, int n, boolean bl, int n2, Object object2) {
        if ((n2 & 1) != 0) {
            n = 10;
        }
        if ((n2 & 2) != 0) {
            bl = false;
        }
        return backupRecordWorkspace.getBackupRecords(n, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeBackupRecord(@NotNull String dirName, long start, long end) {
        Intrinsics.checkNotNullParameter((Object)dirName, (String)"dirName");
        BackupRecordWorkspace backupRecordWorkspace = this;
        synchronized (backupRecordWorkspace) {
            BackupRecordMetadata newMetadata;
            boolean bl = false;
            BackupRecordMetadataBuilder builder = BackupRecordMetadataBuilder.Companion.readFrom(this.backupPath);
            BackupRecordV3 record = new BackupRecordV3(dirName, start, end, null, 8, null);
            builder.getBackupRecords().add(record);
            builder.save();
            this._metadata = newMetadata = builder.build();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cleanBackupRecords(@NotNull IOlapLogger logger2, long nowTime) {
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        if (this._cleaning.compareAndSet(false, true)) {
            try {
                this.cleanTotalBackup(logger2);
                this.cleanBackupFiles(logger2, nowTime);
            }
            finally {
                this._cleaning.set(false);
            }
        }
    }

    public static /* synthetic */ void cleanBackupRecords$default(BackupRecordWorkspace backupRecordWorkspace, IOlapLogger iOlapLogger, long l, int n, Object object2) {
        if ((n & 2) != 0) {
            l = System.currentTimeMillis();
        }
        backupRecordWorkspace.cleanBackupRecords(iOlapLogger, l);
    }

    /*
     * WARNING - void declaration
     */
    private final void cleanTotalBackup(IOlapLogger logger2) {
        void $this$sortedBy$iv;
        void $this$filterTo$iv$iv;
        int minTotalBackups = OlapConfigItems.INSTANCE.getMinTotalBackups$bos_olap_core2().getValue();
        Object $this$filter$iv = this.getMetadata().getBackRecords();
        boolean $i$f$filter = false;
        BackupRecordV3[] backupRecordV3Array = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        int n = ((void)$this$filterTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = $this$filterTo$iv$iv[i];
            boolean bl = false;
            if (!(it.getType() == BackupRecordType.Total)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        List sortedRecords = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                BackupRecordV3 it = (BackupRecordV3)a;
                boolean bl = false;
                Comparable comparable = Long.valueOf(kd.bos.olapServer2.replication.BackupRecordWorkspace$Companion.access$parseTotalBackupTime(BackupRecordWorkspace.Companion, it.getName()));
                it = (BackupRecordV3)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(kd.bos.olapServer2.replication.BackupRecordWorkspace$Companion.access$parseTotalBackupTime(BackupRecordWorkspace.Companion, it.getName())));
            }
        });
        if (sortedRecords.size() - minTotalBackups > 0) {
            BackupRecordMetadataBuilder builder = BackupRecordMetadataBuilder.Companion.readFrom(this.backupPath);
            for (BackupRecordV3 record : sortedRecords.subList(0, sortedRecords.size() - minTotalBackups)) {
                File totalRecordFolder = RedoUtil.getTotalRecordFolder$default(RedoUtil.INSTANCE, this.backupPath, record.getName(), false, 4, null);
                if (totalRecordFolder.exists()) {
                    FileUtils.deleteDirectory((File)totalRecordFolder);
                    logger2.info("clean total backup " + record.getName() + " finished.");
                }
                builder.getBackupRecords().removeIf(arg_0 -> BackupRecordWorkspace.cleanTotalBackup$lambda$6((Function1)new Function1<BackupRecordV3, Boolean>(record){
                    final /* synthetic */ BackupRecordV3 $record;
                    {
                        this.$record = $record;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull BackupRecordV3 it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return Intrinsics.areEqual((Object)it.getName(), (Object)this.$record.getName());
                    }
                }, arg_0));
            }
            builder.save();
            this._metadata = builder.build();
        }
    }

    private final void cleanBackupFiles(IOlapLogger logger2, long nowTime) {
        Map<String, List<BackupFileInfo>> realBackupFiles = this.getRealBackupFiles();
        this.cleanRuleByTime(realBackupFiles, nowTime);
        this.cleanRuleByNumberAndTotalBackup(realBackupFiles);
        Iterable $this$forEach$iv = realBackupFiles.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List list2 = (List)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = list2;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                BackupFileInfo it = (BackupFileInfo)element$iv2;
                boolean bl2 = false;
                File file = it.getFile();
                if (it.isRetain() || !file.exists()) continue;
                file.delete();
                logger2.info("clean backup file " + file.getName() + " finished.");
                File[] fileArray = file.getParentFile().listFiles();
                boolean bl3 = fileArray != null ? fileArray.length == 0 : false;
                if (!bl3) continue;
                file.getParentFile().delete();
                logger2.info("clean directory " + file.getParentFile().getName() + " finished.");
            }
        }
    }

    private final void cleanRuleByTime(Map<String, ? extends List<BackupFileInfo>> realBackupFiles, long nowTime) {
        long atLeastRetainTime = nowTime - (long)OlapConfigItems.INSTANCE.getRetainDaysConfigItem$bos_olap_core2().getValue() * 24L * (long)3600 * (long)1000;
        realBackupFiles.forEach((arg_0, arg_1) -> BackupRecordWorkspace.cleanRuleByTime$lambda$9((Function2)new Function2<String, List<? extends BackupFileInfo>, Unit>(atLeastRetainTime){
            final /* synthetic */ long $atLeastRetainTime;
            {
                this.$atLeastRetainTime = $atLeastRetainTime;
                super(2);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull String cubeName, @NotNull List<BackupFileInfo> list2) {
                int index2;
                block4: {
                    int n;
                    void $this$indexOfFirst$iv;
                    Intrinsics.checkNotNullParameter((Object)cubeName, (String)"cubeName");
                    Intrinsics.checkNotNullParameter(list2, (String)"list");
                    List<BackupFileInfo> list3 = list2;
                    long l = this.$atLeastRetainTime;
                    boolean $i$f$indexOfFirst = false;
                    int index$iv = 0;
                    for (E item$iv : $this$indexOfFirst$iv) {
                        BackupFileInfo it = (BackupFileInfo)item$iv;
                        boolean bl = false;
                        if (it.getBackupTime() >= l) {
                            n = index$iv;
                            break block4;
                        }
                        ++index$iv;
                    }
                    n = index2 = -1;
                }
                if (index2 >= 0) {
                    Iterable $this$forEach$iv = list2.subList(index2, list2.size());
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        BackupFileInfo it = (BackupFileInfo)element$iv;
                        boolean bl = false;
                        it.setRetain(true);
                    }
                }
            }
        }, arg_0, arg_1));
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Set<String>> getCubeTotalBackupFiles() {
        void $this$filterTo$iv$iv;
        HashMap map2 = new HashMap();
        BackupRecordV3[] $this$filter$iv = this.getMetadata().getBackRecords();
        boolean $i$f$filter = false;
        BackupRecordV3[] backupRecordV3Array = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        int n = ((void)$this$filterTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = $this$filterTo$iv$iv[i];
            boolean bl = false;
            if (!(it.getType() == BackupRecordType.Total)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BackupRecordV3 record = (BackupRecordV3)element$iv;
            boolean bl = false;
            String string2 = RedoUtil.getTotalRecordFolder$default(RedoUtil.INSTANCE, this.backupPath, record.getName(), false, 4, null).getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAbsolutePath(...)");
            Iterable $this$forEach$iv2 = new CubeMapFileContainer(string2).read();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Object object2;
                void $this$getOrPut$iv;
                Map.Entry entry = (Map.Entry)element$iv2;
                boolean bl2 = false;
                Map map3 = map2;
                Object key$iv = entry.getKey();
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl3 = false;
                    Set answer$iv = new HashSet();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object2 = answer$iv;
                } else {
                    object2 = value$iv;
                }
                ((Set)object2).add(((CubeMapValue)entry.getValue()).getFileName());
            }
        }
        return map2;
    }

    private final void cleanRuleByNumberAndTotalBackup(Map<String, ? extends List<BackupFileInfo>> realBackupFiles) {
        int minRetainFileCount = OlapConfigItems.INSTANCE.getMinRetainFilesConfigItem$bos_olap_core2().getValue();
        Map<String, Set<String>> totalBackups = this.getCubeTotalBackupFiles();
        if (totalBackups.isEmpty()) {
            realBackupFiles.forEach((arg_0, arg_1) -> BackupRecordWorkspace.cleanRuleByNumberAndTotalBackup$lambda$14((Function2)new Function2<String, List<? extends BackupFileInfo>, Unit>(minRetainFileCount){
                final /* synthetic */ int $minRetainFileCount;
                {
                    this.$minRetainFileCount = $minRetainFileCount;
                    super(2);
                }

                public final void invoke(@NotNull String string2, @NotNull List<BackupFileInfo> list2) {
                    Intrinsics.checkNotNullParameter((Object)string2, (String)"<anonymous parameter 0>");
                    Intrinsics.checkNotNullParameter(list2, (String)"list");
                    Iterable $this$forEach$iv = list2.subList(Math.max(0, list2.size() - this.$minRetainFileCount), list2.size());
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        BackupFileInfo it = (BackupFileInfo)element$iv;
                        boolean bl = false;
                        it.setRetain(true);
                    }
                }
            }, arg_0, arg_1));
        } else {
            realBackupFiles.forEach((arg_0, arg_1) -> BackupRecordWorkspace.cleanRuleByNumberAndTotalBackup$lambda$15((Function2)new Function2<String, List<? extends BackupFileInfo>, Unit>(totalBackups, minRetainFileCount){
                final /* synthetic */ Map<String, Set<String>> $totalBackups;
                final /* synthetic */ int $minRetainFileCount;
                {
                    this.$totalBackups = $totalBackups;
                    this.$minRetainFileCount = $minRetainFileCount;
                    super(2);
                }

                public final void invoke(@NotNull String cubeName, @NotNull List<BackupFileInfo> list2) {
                    Intrinsics.checkNotNullParameter((Object)cubeName, (String)"cubeName");
                    Intrinsics.checkNotNullParameter(list2, (String)"list");
                    Set<String> cubeTotalBackup = this.$totalBackups.get(cubeName);
                    if (cubeTotalBackup != null) {
                        BackupFileInfo it;
                        Iterable $this$forEach$iv = list2.subList(Math.max(0, list2.size() - this.$minRetainFileCount), list2.size());
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            it = (BackupFileInfo)element$iv;
                            boolean bl = false;
                            it.setRetain(true);
                        }
                        if (list2.size() > this.$minRetainFileCount) {
                            $this$forEach$iv = list2.subList(0, list2.size() - this.$minRetainFileCount);
                            $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                it = (BackupFileInfo)element$iv;
                                boolean bl = false;
                                if (!cubeTotalBackup.contains(it.getFile().getName())) continue;
                                it.setRetain(true);
                            }
                        }
                    }
                }
            }, arg_0, arg_1));
        }
    }

    private final Map<String, List<BackupFileInfo>> getRealBackupFiles() {
        HashMap<String, List<BackupFileInfo>> map2 = new HashMap<String, List<BackupFileInfo>>();
        Files.walk(Paths.INSTANCE.get(this.backupPath, new String[0]), new FileVisitOption[0]).forEach(arg_0 -> BackupRecordWorkspace.getRealBackupFiles$lambda$16((Function1)new Function1<Path, Unit>(map2){
            final /* synthetic */ HashMap<String, List<BackupFileInfo>> $map;
            {
                this.$map = $map;
                super(1);
            }

            public final void invoke(Path path) {
                File file = path.toFile();
                String fileName = file.getName();
                if (file.isFile()) {
                    Intrinsics.checkNotNull((Object)fileName);
                    CharSequence charSequence = fileName;
                    if (new Regex("^.*-\\d{14}\\.backup").matches(charSequence)) {
                        Object object2;
                        int dashIndex = StringsKt.lastIndexOf$default((CharSequence)fileName, (String)"-", (int)0, (boolean)false, (int)6, null);
                        int dotIndex = StringsKt.lastIndexOf$default((CharSequence)fileName, (String)".backup", (int)0, (boolean)false, (int)6, null);
                        String string2 = fileName.substring(0, dashIndex);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                        String cubeName = string2;
                        String string3 = fileName.substring(dashIndex + 1, dotIndex);
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                        long time2 = TimeUtil.Companion.toTimeStamp(string3);
                        Map $this$getOrPut$iv = this.$map;
                        boolean $i$f$getOrPut = false;
                        V value$iv = $this$getOrPut$iv.get(cubeName);
                        if (value$iv == null) {
                            boolean bl = false;
                            List answer$iv = new ArrayList<E>();
                            $this$getOrPut$iv.put(cubeName, answer$iv);
                            object2 = answer$iv;
                        } else {
                            object2 = value$iv;
                        }
                        List list2 = (List)object2;
                        Intrinsics.checkNotNull((Object)file);
                        list2.add(new BackupFileInfo(file, time2, false, 4, null));
                    }
                }
            }
        }, arg_0));
        Collection<List<BackupFileInfo>> collection = map2.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List list2 = (List)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)list2);
            List $this$sortBy$iv = list2;
            boolean $i$f$sortBy = false;
            if ($this$sortBy$iv.size() <= 1) continue;
            CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    BackupFileInfo it = (BackupFileInfo)a;
                    boolean bl = false;
                    Comparable comparable = Long.valueOf(it.getBackupTime());
                    it = (BackupFileInfo)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getBackupTime()));
                }
            });
        }
        return map2;
    }

    /*
     * WARNING - void declaration
     */
    private final BackupRecord[] findLastCountRecord(int count, boolean includeZero) {
        BackupRecord[] backupRecordArray;
        void $this$toTypedArray$iv;
        boolean $i$f$toTypedArray;
        boolean $i$f$map;
        Object $this$map$iv;
        if (!(count > 0)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        int recordCount = 0;
        Object[] lastCountRecords = new Pair[count];
        BackupRecordV3[] $this$forEach$iv = this.getMetadata().getBackRecords();
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            BackupRecordV3 element$iv;
            BackupRecordV3 backupRecord = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            if (includeZero) {
                lastCountRecords[recordCount % count] = new Pair((Object)recordCount, (Object)backupRecord);
                ++recordCount;
                continue;
            }
            if (this.isZeroEmptyTotalRecord(backupRecord)) continue;
            lastCountRecords[recordCount % count] = new Pair((Object)recordCount, (Object)backupRecord);
            ++recordCount;
        }
        if (recordCount <= count) {
            void $this$mapTo$iv$iv;
            $this$map$iv = (Object[])ArraysKt.toMutableList((Object[])lastCountRecords).subList(0, recordCount);
            $i$f$map = false;
            Object[] objectArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Pair pair = (Pair)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                void v0 = it;
                Intrinsics.checkNotNull((Object)v0);
                collection.add((BackupRecord)v0.getSecond());
            }
            $this$map$iv = (List)destination$iv$iv;
            $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            backupRecordArray = thisCollection$iv.toArray(new BackupRecord[0]);
        } else {
            void $this$mapTo$iv$iv;
            Object[] $this$sortBy$iv = lastCountRecords;
            boolean $i$f$sortBy = false;
            if ($this$sortBy$iv.length > 1) {
                ArraysKt.sortWith((Object[])$this$sortBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        Pair it = (Pair)a;
                        boolean bl = false;
                        Pair pair = it;
                        Intrinsics.checkNotNull((Object)pair);
                        it = (Pair)b;
                        Comparable comparable = (Integer)pair.getFirst();
                        bl = false;
                        Pair pair2 = it;
                        Intrinsics.checkNotNull((Object)pair2);
                        return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Integer)pair2.getFirst()));
                    }
                });
            }
            $this$map$iv = lastCountRecords;
            $i$f$map = false;
            Object[] thisCollection$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((Object[])$this$map$iv).length);
            boolean $i$f$mapTo = false;
            int n2 = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n2; ++i) {
                void it;
                void item$iv$iv;
                void bl = item$iv$iv = $this$mapTo$iv$iv[i];
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                void v2 = it;
                Intrinsics.checkNotNull((Object)v2);
                collection.add((BackupRecord)v2.getSecond());
            }
            $this$map$iv = (List)destination$iv$iv;
            $i$f$toTypedArray = false;
            thisCollection$iv = $this$toTypedArray$iv;
            backupRecordArray = thisCollection$iv.toArray(new BackupRecord[0]);
        }
        return backupRecordArray;
    }

    private final BackupRecord findFirstRecord(Function1<? super BackupRecord, Boolean> condition, boolean includeZero) {
        BackupRecordV3[] $this$forEach$iv = this.getMetadata().getBackRecords();
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            BackupRecordV3 element$iv;
            BackupRecordV3 backupRecord = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            if (!(includeZero ? (Boolean)condition.invoke((Object)backupRecord) != false : (Boolean)condition.invoke((Object)backupRecord) != false && !this.isZeroEmptyTotalRecord(backupRecord))) continue;
            return backupRecord;
        }
        return null;
    }

    static /* synthetic */ BackupRecord findFirstRecord$default(BackupRecordWorkspace backupRecordWorkspace, Function1 function1, boolean bl, int n, Object object2) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return backupRecordWorkspace.findFirstRecord((Function1<? super BackupRecord, Boolean>)function1, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<BackupRecord> findAllTotalRecordsWithSort() {
        void $this$filterTo$iv$iv;
        BackupRecordV3[] $this$filter$iv = this.getMetadata().getBackRecords();
        boolean $i$f$filter = false;
        BackupRecordV3[] backupRecordV3Array = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        int n = ((void)$this$filterTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void backupRecord = element$iv$iv = $this$filterTo$iv$iv[i];
            boolean bl = false;
            if (!(backupRecord.getStart() == backupRecord.getEnd() && !this.isZeroEmptyTotalRecord((BackupRecord)backupRecord))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                BackupRecordV3 it = (BackupRecordV3)a;
                boolean bl = false;
                Comparable comparable = Long.valueOf(it.getStart());
                it = (BackupRecordV3)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getStart()));
            }
        });
    }

    private static final boolean cleanTotalBackup$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void cleanRuleByTime$lambda$9(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    private static final void cleanRuleByNumberAndTotalBackup$lambda$14(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    private static final void cleanRuleByNumberAndTotalBackup$lambda$15(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    private static final void getRealBackupFiles$lambda$16(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u0012\f\b\u0002\u0010\u0007\u001a\u00060\bj\u0002`\t\u00a2\u0006\u0002\u0010\nR\u0015\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001e\u0010\u0007\u001a\u00060\bj\u0002`\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lkd/bos/olapServer2/replication/BackupRecordWorkspace$BackupFileInfo;", "", "file", "Ljava/io/File;", "backupTime", "", "Lkd/bos/olapServer2/common/long;", "isRetain", "", "Lkd/bos/olapServer2/common/bool;", "(Ljava/io/File;JZ)V", "getBackupTime", "()J", "getFile", "()Ljava/io/File;", "()Z", "setRetain", "(Z)V", "bos-olap-core2"})
    private static final class BackupFileInfo {
        @NotNull
        private final File file;
        private final long backupTime;
        private boolean isRetain;

        public BackupFileInfo(@NotNull File file, long backupTime, boolean isRetain) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            this.file = file;
            this.backupTime = backupTime;
            this.isRetain = isRetain;
        }

        public /* synthetic */ BackupFileInfo(File file, long l, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                bl = false;
            }
            this(file, l, bl);
        }

        @NotNull
        public final File getFile() {
            return this.file;
        }

        public final long getBackupTime() {
            return this.backupTime;
        }

        public final boolean isRetain() {
            return this.isRetain;
        }

        public final void setRetain(boolean bl) {
            this.isRetain = bl;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u00060\u0004j\u0002`\n2\n\u0010\u000b\u001a\u00060\fj\u0002`\r2\n\u0010\u000e\u001a\u00060\fj\u0002`\r2\n\u0010\u000f\u001a\u00060\u0004j\u0002`\nJ\u0012\u0010\u0010\u001a\u00020\u00112\n\u0010\u0012\u001a\u00060\u0004j\u0002`\nJ\u000e\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0015J\u0018\u0010\u0016\u001a\u00060\fj\u0002`\u00172\n\u0010\u0018\u001a\u00060\u0004j\u0002`\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lkd/bos/olapServer2/replication/BackupRecordWorkspace$Companion;", "", "()V", "INCREMENT_NAME", "", "RECOVERY_FILES_NAME", "TOTAL_NAME", "copyRecoveryFiles", "", "sourcePath", "Lkd/bos/olapServer2/common/string;", "startLsn", "", "Lkd/bos/olapServer2/common/LSN;", "endLsn", "targetPath", "create", "Lkd/bos/olapServer2/replication/BackupRecordWorkspace;", "backupPath", "getBackupFileTransactionVersion", "backupFile", "Ljava/io/File;", "parseTotalBackupTime", "Lkd/bos/olapServer2/common/long;", "backupDir", "bos-olap-core2"})
    @SourceDebugExtension(value={"SMAP\nBackupRecordWorkspace.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackupRecordWorkspace.kt\nkd/bos/olapServer2/replication/BackupRecordWorkspace$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,472:1\n13309#2,2:473\n*S KotlinDebug\n*F\n+ 1 BackupRecordWorkspace.kt\nkd/bos/olapServer2/replication/BackupRecordWorkspace$Companion\n*L\n388#1:473,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BackupRecordWorkspace create(@NotNull String backupPath) {
            Intrinsics.checkNotNullParameter((Object)backupPath, (String)"backupPath");
            BackupRecordMetadata backupRecordMetadata = BackupRecordMetadataBuilder.Companion.readFrom(backupPath).build();
            return new BackupRecordWorkspace(backupPath, backupRecordMetadata);
        }

        public final void copyRecoveryFiles(@NotNull String sourcePath, long startLsn, long endLsn, @NotNull String targetPath) {
            block4: {
                Intrinsics.checkNotNullParameter((Object)sourcePath, (String)"sourcePath");
                Intrinsics.checkNotNullParameter((Object)targetPath, (String)"targetPath");
                String path = RecoveryFiles.getOrCreatePath$default(RecoveryFiles.INSTANCE, sourcePath, false, 2, null);
                if (!FileTools.INSTANCE.isExist(path)) break block4;
                File[] files = Paths.INSTANCE.toFile(path).listFiles(Companion::copyRecoveryFiles$lambda$0);
                File[] fileArray = files;
                String realTargetPath = RecoveryFiles.INSTANCE.getOrCreatePath(targetPath, !(fileArray == null || fileArray.length == 0));
                if (files != null) {
                    File[] $this$forEach$iv = files;
                    boolean $i$f$forEach = false;
                    int n = $this$forEach$iv.length;
                    for (int i = 0; i < n; ++i) {
                        File element$iv;
                        File file = element$iv = $this$forEach$iv[i];
                        boolean bl = false;
                        String name2 = file.getName();
                        Intrinsics.checkNotNull((Object)file);
                        long fileLsn = LSNUtil.INSTANCE.getLsnByBackupFileName(FilesKt.getNameWithoutExtension((File)file));
                        boolean bl2 = startLsn <= fileLsn ? fileLsn < endLsn : false;
                        if (!bl2) continue;
                        Object[] objectArray = new String[1];
                        Intrinsics.checkNotNull((Object)name2);
                        objectArray[0] = name2;
                        Path targetFilePath = Paths.INSTANCE.get(realTargetPath, (String[])objectArray);
                        if (Files.exists(targetFilePath, new LinkOption[0])) continue;
                        try {
                            objectArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                            Files.copy(file.toPath(), targetFilePath, (CopyOption[])objectArray);
                            continue;
                        }
                        catch (Throwable t2) {
                            Files.delete(targetFilePath);
                            throw t2;
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final long getBackupFileTransactionVersion(@NotNull File backupFile) {
            Intrinsics.checkNotNullParameter((Object)backupFile, (String)"backupFile");
            Closeable closeable = new DataInputStream(new BufferedInputStream(new FileInputStream(backupFile)));
            Throwable throwable = null;
            try {
                long l;
                int n;
                DataInputStream inputStream = (DataInputStream)closeable;
                boolean bl = false;
                byte[] headerByte = new byte[23];
                int len = CommonTypesKt.readByteArray(inputStream, headerByte);
                if (len != 23) {
                    throw new RuntimeException(Res.INSTANCE.getCubeRecoveryException_2());
                }
                String string2 = new String(headerByte, Charsets.UTF_8);
                if (Intrinsics.areEqual((Object)string2, (Object)"Kingdee Shrek backup v1")) {
                    n = 1;
                } else if (Intrinsics.areEqual((Object)string2, (Object)BackupConstant.INSTANCE.getBackupFileHeader_v2())) {
                    n = 2;
                } else if (Intrinsics.areEqual((Object)string2, (Object)BackupConstant.INSTANCE.getBackupFileHeader_v3())) {
                    n = 3;
                } else if (Intrinsics.areEqual((Object)string2, (Object)BackupConstant.INSTANCE.getBackupFileHeader_v4())) {
                    n = 4;
                } else if (Intrinsics.areEqual((Object)string2, (Object)BackupConstant.INSTANCE.getBackupFileHeader_v5())) {
                    n = 5;
                } else if (Intrinsics.areEqual((Object)string2, (Object)BackupConstant.INSTANCE.getBackupFileHeader_v6())) {
                    n = 6;
                } else {
                    throw new RuntimeException(Res.INSTANCE.getCubeRecoveryException_2());
                }
                int fileVersion = n;
                switch (fileVersion) {
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        l = inputStream.readLong();
                        break;
                    }
                    default: {
                        l = 0L;
                    }
                }
                long l2 = l;
                return l2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }

        private final long parseTotalBackupTime(String backupDir) {
            char[] cArray = new char[]{'-'};
            return TimeUtil.Companion.toTimeStamp((String)StringsKt.split$default((CharSequence)backupDir, (char[])cArray, (boolean)false, (int)2, (int)2, null).get(0));
        }

        private static final boolean copyRecoveryFiles$lambda$0(File file, String name2) {
            Intrinsics.checkNotNull((Object)name2);
            return StringsKt.endsWith$default((String)name2, (String)".backup", (boolean)false, (int)2, null);
        }

        public static final /* synthetic */ long access$parseTotalBackupTime(Companion $this, String backupDir) {
            return $this.parseTotalBackupTime(backupDir);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BackupType.values().length];
            try {
                nArray[BackupType.Total.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BackupType.LockTotal.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

