/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.replication;

import java.io.File;
import java.io.FileInputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import kd.bos.olapServer2.backup.DirectFile;
import kd.bos.olapServer2.backup.RecoveryCommandExecutor;
import kd.bos.olapServer2.common.Paths;
import kd.bos.olapServer2.dataSources.RecoveryCommandInfo;
import kd.bos.olapServer2.replication.ICubeRecoverRecord;
import kd.bos.olapServer2.replication.IRedoRecordHead;
import kd.bos.olapServer2.replication.RecoveryFiles;
import kd.bos.olapServer2.replication.RedoType;
import kd.bos.olapServer2.storages.OlapWorkspace;
import kd.bos.olapServer2.tools.FileTools;
import kd.bos.olapServer2.tools.Res;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0010\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\f\u0010$\u001a\u00060\nj\u0002`\u000bH\u0002J\f\u0010%\u001a\u00060\u000fj\u0002`\u0010H\u0002J\n\u0010&\u001a\u00060\u000fj\u0002`\u0010J@\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\n\u0010+\u001a\u00060\u000fj\u0002`\u00102\n\u0010,\u001a\u00060\u000fj\u0002`\u00102\n\u0010-\u001a\u00060 j\u0002`.2\n\u0010/\u001a\u00060\u0018j\u0002`\u0019H\u0016J4\u00100\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\n\u0010+\u001a\u00060\u000fj\u0002`\u00102\n\u0010,\u001a\u00060\u000fj\u0002`\u00102\n\u0010-\u001a\u00060 j\u0002`.H\u0002J\b\u00101\u001a\u00020\u000fH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0018\u0010\t\u001a\u00060\nj\u0002`\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0015\u0010\u000e\u001a\u00060\u000fj\u0002`\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0015\u0010\u0013\u001a\u00060\u000fj\u0002`\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0018\u0010\u0017\u001a\u00060\u0018j\u0002`\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0018\u0010\u001f\u001a\u00060 j\u0002`!8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#\u00a8\u00062"}, d2={"Lkd/bos/olapServer2/replication/CubeRecoverRecord;", "Lkd/bos/olapServer2/replication/ICubeRecoverRecord;", "head", "Lkd/bos/olapServer2/replication/IRedoRecordHead;", "body", "Ljava/nio/ByteBuffer;", "(Lkd/bos/olapServer2/replication/IRedoRecordHead;Ljava/nio/ByteBuffer;)V", "getBody", "()Ljava/nio/ByteBuffer;", "cubeId", "", "Lkd/bos/olapServer2/common/int;", "getCubeId", "()I", "cubeName", "", "Lkd/bos/olapServer2/common/string;", "getCubeName", "()Ljava/lang/String;", "fileName", "getFileName", "getHead", "()Lkd/bos/olapServer2/replication/IRedoRecordHead;", "isOlapLevel", "", "Lkd/bos/olapServer2/common/bool;", "()Z", "redoType", "Lkd/bos/olapServer2/replication/RedoType;", "getRedoType", "()Lkd/bos/olapServer2/replication/RedoType;", "tid", "", "Lkd/bos/olapServer2/common/long;", "getTid", "()J", "parseCubeId", "parseCubeName", "parseFileName", "recoveryCube", "", "olapWorkspace", "Lkd/bos/olapServer2/storages/OlapWorkspace;", "redoPath", "backupPath", "pageLsn", "Lkd/bos/olapServer2/common/LSN;", "isIncrement", "recoveryCubeIncrement", "toString", "bos-olap-core2"})
public class CubeRecoverRecord
implements ICubeRecoverRecord {
    @NotNull
    private final IRedoRecordHead head;
    @NotNull
    private final ByteBuffer body;
    @NotNull
    private final String cubeName;
    @NotNull
    private final String fileName;

    public CubeRecoverRecord(@NotNull IRedoRecordHead head, @NotNull ByteBuffer body) {
        Intrinsics.checkNotNullParameter((Object)head, (String)"head");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        this.head = head;
        this.body = body;
        this.cubeName = this.parseCubeName();
        this.fileName = this.parseFileName();
    }

    @NotNull
    public final IRedoRecordHead getHead() {
        return this.head;
    }

    @NotNull
    public final ByteBuffer getBody() {
        return this.body;
    }

    @Override
    @NotNull
    public RedoType getRedoType() {
        return this.head.getType();
    }

    @Override
    public int getCubeId() {
        return this.parseCubeId();
    }

    @Override
    public boolean isOlapLevel() {
        return true;
    }

    @Override
    public long getTid() {
        return this.head.getTid();
    }

    private final int parseCubeId() {
        int cId = this.head.getCubeId();
        if (!(cId < 0)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        return ~cId;
    }

    @NotNull
    public final String getCubeName() {
        return this.cubeName;
    }

    private final String parseCubeName() {
        int length = this.body.get() & 0xFF;
        if (!(length > 0)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        ByteBuffer name2 = ByteBuffer.allocate(length);
        this.body.get(name2.array(), 0, length);
        byte[] byArray = name2.array();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"array(...)");
        byte[] byArray2 = byArray;
        Charset charset = Charsets.UTF_8;
        return new String(byArray2, charset);
    }

    @NotNull
    public final String getFileName() {
        return this.fileName;
    }

    @NotNull
    public final String parseFileName() {
        int length = this.body.get() & 0xFF;
        if (!(length > 0)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        ByteBuffer fName = ByteBuffer.allocate(length);
        this.body.get(fName.array(), 0, length);
        byte[] byArray = fName.array();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"array(...)");
        byte[] byArray2 = byArray;
        Charset charset = Charsets.UTF_8;
        return new String(byArray2, charset);
    }

    @Override
    public void recoveryCube(@NotNull OlapWorkspace olapWorkspace, @NotNull String redoPath, @NotNull String backupPath, long pageLsn, boolean isIncrement) {
        Intrinsics.checkNotNullParameter((Object)olapWorkspace, (String)"olapWorkspace");
        Intrinsics.checkNotNullParameter((Object)redoPath, (String)"redoPath");
        Intrinsics.checkNotNullParameter((Object)backupPath, (String)"backupPath");
        if (isIncrement) {
            this.recoveryCubeIncrement(olapWorkspace, redoPath, backupPath, pageLsn);
            return;
        }
        String recoveryFilesPath = RecoveryFiles.getOrCreatePath$default(RecoveryFiles.INSTANCE, redoPath, false, 2, null);
        File cubeBackupFile = Paths.INSTANCE.toFile(recoveryFilesPath, this.fileName);
        if (!cubeBackupFile.exists()) {
            recoveryFilesPath = RecoveryFiles.getOrCreatePath$default(RecoveryFiles.INSTANCE, backupPath, false, 2, null);
            cubeBackupFile = Paths.INSTANCE.toFile(recoveryFilesPath, this.fileName);
        }
        if (cubeBackupFile.exists()) {
            new RecoveryCommandExecutor(olapWorkspace, new RecoveryCommandInfo(this.cubeName, new DirectFile()), this.cubeName, olapWorkspace.getRootPath(), new FileInputStream(cubeBackupFile), this.getCubeId(), null, null, 192, null).run();
            String newName = this.cubeName + '_' + pageLsn + ".backup";
            File newBackupFile = Paths.INSTANCE.toFile(recoveryFilesPath, newName);
            if (newBackupFile.exists()) {
                newBackupFile.delete();
            }
            if (!FileTools.INSTANCE.rename(cubeBackupFile, newName)) {
                throw Res.INSTANCE.getRuntimeException("error,replay backupFile[" + cubeBackupFile.getAbsolutePath() + "] rename failed.", new Object[0]);
            }
        } else {
            String targetName = this.cubeName + '_' + pageLsn + ".backup";
            File targetBackupFile = Paths.INSTANCE.toFile(recoveryFilesPath, targetName);
            new RecoveryCommandExecutor(olapWorkspace, new RecoveryCommandInfo(this.cubeName, new DirectFile()), this.cubeName, olapWorkspace.getRootPath(), new FileInputStream(targetBackupFile), this.getCubeId(), null, null, 192, null).run();
        }
    }

    private final void recoveryCubeIncrement(OlapWorkspace olapWorkspace, String redoPath, String backupPath, long pageLsn) {
        String backupName = this.cubeName + '_' + pageLsn + ".backup";
        File cubeBackupFile = Paths.INSTANCE.toFile(RecoveryFiles.getOrCreatePath$default(RecoveryFiles.INSTANCE, redoPath, false, 2, null), backupName);
        if (!cubeBackupFile.exists()) {
            cubeBackupFile = Paths.INSTANCE.toFile(RecoveryFiles.getOrCreatePath$default(RecoveryFiles.INSTANCE, backupPath, false, 2, null), backupName);
        }
        new RecoveryCommandExecutor(olapWorkspace, new RecoveryCommandInfo(this.cubeName, new DirectFile()), this.cubeName, olapWorkspace.getRootPath(), new FileInputStream(cubeBackupFile), this.getCubeId(), null, null, 192, null).run();
    }

    @NotNull
    public String toString() {
        return "cubeID: " + this.getCubeId() + ", tid: " + this.head.getTid() + ", cubeName:" + this.cubeName + ", fileName:" + this.fileName + " cubeRecover\n";
    }
}

