/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.replication;

import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.Arrays;
import kd.bos.olapServer2.replication.ICubeRecoverRecord;
import kd.bos.olapServer2.replication.RedoRecordHead;
import kd.bos.olapServer2.replication.RedoType;
import kd.bos.olapServer2.storages.CubeWorkspace;
import kd.bos.olapServer2.storages.OlapWorkspace;
import kd.bos.olapServer2.tools.Res;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010 \u001a\u00020\u001eH\u0002J@\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\n\u0010&\u001a\u00060'j\u0002`(2\n\u0010)\u001a\u00060'j\u0002`(2\n\u0010*\u001a\u00060\u0019j\u0002`+2\n\u0010,\u001a\u00060\u0011j\u0002`\u0012H\u0016J\b\u0010-\u001a\u00020'H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0018\u0010\t\u001a\u00060\nj\u0002`\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0018\u0010\u0010\u001a\u00060\u0011j\u0002`\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0018\u0010\u0018\u001a\u00060\u0019j\u0002`\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0018\u0010\u001d\u001a\u00020\u001e*\u00020\u001f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!\u00a8\u0006."}, d2={"Lkd/bos/olapServer2/replication/CubeRecoverRecordV0;", "Lkd/bos/olapServer2/replication/ICubeRecoverRecord;", "head", "Lkd/bos/olapServer2/replication/RedoRecordHead;", "body", "Ljava/nio/ByteBuffer;", "(Lkd/bos/olapServer2/replication/RedoRecordHead;Ljava/nio/ByteBuffer;)V", "getBody", "()Ljava/nio/ByteBuffer;", "cubeId", "", "Lkd/bos/olapServer2/common/int;", "getCubeId", "()I", "getHead", "()Lkd/bos/olapServer2/replication/RedoRecordHead;", "isOlapLevel", "", "Lkd/bos/olapServer2/common/bool;", "()Z", "redoType", "Lkd/bos/olapServer2/replication/RedoType;", "getRedoType", "()Lkd/bos/olapServer2/replication/RedoType;", "tid", "", "Lkd/bos/olapServer2/common/long;", "getTid", "()J", "md5", "", "Lkd/bos/olapServer2/storages/CubeWorkspace;", "getMd5", "(Lkd/bos/olapServer2/storages/CubeWorkspace;)[B", "recoveryCube", "", "olapWorkspace", "Lkd/bos/olapServer2/storages/OlapWorkspace;", "redoPath", "", "Lkd/bos/olapServer2/common/string;", "backupPath", "pageLsn", "Lkd/bos/olapServer2/common/LSN;", "isIncrement", "toString", "bos-olap-core2"})
public final class CubeRecoverRecordV0
implements ICubeRecoverRecord {
    @NotNull
    private final RedoRecordHead head;
    @NotNull
    private final ByteBuffer body;

    public CubeRecoverRecordV0(@NotNull RedoRecordHead head, @NotNull ByteBuffer body) {
        Intrinsics.checkNotNullParameter((Object)head, (String)"head");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        this.head = head;
        this.body = body;
    }

    @NotNull
    public final RedoRecordHead getHead() {
        return this.head;
    }

    @NotNull
    public final ByteBuffer getBody() {
        return this.body;
    }

    @Override
    @NotNull
    public RedoType getRedoType() {
        return this.head.getType();
    }

    @Override
    public int getCubeId() {
        return this.head.getCubeId();
    }

    @Override
    public boolean isOlapLevel() {
        return true;
    }

    @Override
    public long getTid() {
        return this.head.getTid();
    }

    private final byte[] getMd5() {
        if (!(this.head.getType() == RedoType.CubeRecover)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        byte[] byArray = this.body.array();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"array(...)");
        return byArray;
    }

    @Override
    public void recoveryCube(@NotNull OlapWorkspace olapWorkspace, @NotNull String redoPath, @NotNull String backupPath, long pageLsn, boolean isIncrement) {
        byte[] actualMd5;
        Intrinsics.checkNotNullParameter((Object)olapWorkspace, (String)"olapWorkspace");
        Intrinsics.checkNotNullParameter((Object)redoPath, (String)"redoPath");
        Intrinsics.checkNotNullParameter((Object)backupPath, (String)"backupPath");
        CubeWorkspace cubeWorkspace = olapWorkspace.tryGetByCubeId(this.getCubeId());
        if (cubeWorkspace == null) {
            String string2 = Res.INSTANCE.getReplayCoordinatorException_2();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-ReplayCoordinatorException_2>(...)");
            Object[] objectArray = new Object[]{this.getCubeId()};
            throw Res.INSTANCE.getRuntimeException(Res.INSTANCE.format(string2, objectArray), new Object[0]);
        }
        CubeWorkspace cubeWorkspace2 = cubeWorkspace;
        byte[] expectmMd5 = this.getMd5(cubeWorkspace2);
        if (!Arrays.equals(expectmMd5, actualMd5 = this.getMd5())) {
            String string3 = Res.INSTANCE.getReplayCoordinatorException_3();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"<get-ReplayCoordinatorException_3>(...)");
            Object[] objectArray = new Object[]{this.getCubeId(), cubeWorkspace2.getMetadata().getName()};
            throw Res.INSTANCE.getRuntimeException(Res.INSTANCE.format(string3, objectArray), new Object[0]);
        }
    }

    private final byte[] getMd5(CubeWorkspace $this$md5) {
        MessageDigest md = MessageDigest.getInstance("MD5");
        String string2 = String.valueOf($this$md5.getCubeId());
        byte[] byArray = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        md.update(byArray);
        string2 = $this$md5.getMetadata().getName();
        byte[] byArray2 = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"this as java.lang.String).getBytes(charset)");
        md.update(byArray2);
        byte[] byArray3 = md.digest();
        Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"digest(...)");
        return byArray3;
    }

    @NotNull
    public String toString() {
        return "cubeID: " + this.head.getCubeId() + ", tid: " + this.head.getTid() + ", cubeRecover\n";
    }
}

