/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.replication;

import java.nio.ByteBuffer;
import java.util.Arrays;
import kd.bos.olapServer2.replication.AbstractDDLRecord;
import kd.bos.olapServer2.replication.IDDLRecord;
import kd.bos.olapServer2.replication.IRedoRecord;
import kd.bos.olapServer2.replication.RedoRecordHead;
import kd.bos.olapServer2.replication.RedoType;
import kd.bos.olapServer2.tools.Res;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\bH\u0016J\f\u0010\u000f\u001a\u00060\u0010j\u0002`\u0011H\u0016J\f\u0010\u0012\u001a\u00060\u0010j\u0002`\u0011H\u0002J\f\u0010\u0013\u001a\u00060\u0010j\u0002`\u0011H\u0016R\u0016\u0010\u0007\u001a\n\u0018\u00010\bj\u0004\u0018\u0001`\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lkd/bos/olapServer2/replication/DDLRecord;", "Lkd/bos/olapServer2/replication/AbstractDDLRecord;", "head", "Lkd/bos/olapServer2/replication/RedoRecordHead;", "body", "Ljava/nio/ByteBuffer;", "(Lkd/bos/olapServer2/replication/RedoRecordHead;Ljava/nio/ByteBuffer;)V", "_ddlCommandStr", "", "Lkd/bos/olapServer2/common/string;", "consolidate", "Lkd/bos/olapServer2/replication/IDDLRecord;", "record", "Lkd/bos/olapServer2/replication/IRedoRecord;", "getDDLCommand", "isBofDDL", "", "Lkd/bos/olapServer2/common/bool;", "isEofCommand", "isEofDDL", "bos-olap-core2"})
@SourceDebugExtension(value={"SMAP\nDDLRecord.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DDLRecord.kt\nkd/bos/olapServer2/replication/DDLRecord\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,69:1\n1#2:70\n*E\n"})
public final class DDLRecord
extends AbstractDDLRecord {
    @Nullable
    private String _ddlCommandStr;

    public DDLRecord(@NotNull RedoRecordHead head, @NotNull ByteBuffer body) {
        Intrinsics.checkNotNullParameter((Object)head, (String)"head");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        super(head, body);
    }

    private final boolean isEofCommand() {
        if (!(this.getHead().getType() == RedoType.METADATA)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        return this.getBody().limit() >= this.getHead().getLength() && this.getBody().get(this.getHead().getLength() - 1) == 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String getDDLCommand() {
        String string2;
        if (!(this.getHead().getType() == RedoType.METADATA && this.getBody().capacity() >= this.getHead().getLength())) {
            boolean $i$a$-require-DDLRecord$getDDLCommand$22 = false;
            String $i$a$-require-DDLRecord$getDDLCommand$22 = "\u89e3\u6790DDL\u547d\u4ee4\u5931\u8d25," + (Object)((Object)this.getHead().getType()) + ':' + this.getHead().getLength() + ',' + this.getBody().capacity();
            throw new IllegalArgumentException($i$a$-require-DDLRecord$getDDLCommand$22.toString());
        }
        String ddlCommandStr = this._ddlCommandStr;
        if (ddlCommandStr == null) {
            void var2_3;
            String resultStr;
            String string3;
            int n;
            byte[] byArray;
            if (this.isEofCommand()) {
                byte[] byArray2 = this.getBody().array();
                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"array(...)");
                byArray = byArray2;
                n = this.getHead().getLength() - 1;
                byte[] byArray3 = Arrays.copyOf(byArray, n);
                Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"copyOf(this, newSize)");
                byArray = byArray3;
                string3 = new String(byArray, Charsets.UTF_8);
            } else if (this.getBody().capacity() == this.getHead().getLength()) {
                byte[] byArray4 = this.getBody().array();
                Intrinsics.checkNotNullExpressionValue((Object)byArray4, (String)"array(...)");
                byArray = byArray4;
                string3 = new String(byArray, Charsets.UTF_8);
            } else {
                byte[] byArray5 = this.getBody().array();
                Intrinsics.checkNotNullExpressionValue((Object)byArray5, (String)"array(...)");
                byArray = byArray5;
                n = this.getHead().getLength();
                byte[] byArray6 = Arrays.copyOf(byArray, n);
                Intrinsics.checkNotNullExpressionValue((Object)byArray6, (String)"copyOf(this, newSize)");
                byArray = byArray6;
                string3 = new String(byArray, Charsets.UTF_8);
            }
            this._ddlCommandStr = resultStr = string3;
            string2 = var2_3;
        } else {
            string2 = ddlCommandStr;
        }
        return string2;
    }

    @Override
    public boolean isEofDDL() {
        return this.isEofCommand();
    }

    @Override
    public boolean isBofDDL() {
        throw Res.INSTANCE.getNotSupportedException("DDLRecord is not bof", new Object[0]);
    }

    @Override
    @NotNull
    public IDDLRecord consolidate(@NotNull IRedoRecord record) {
        Intrinsics.checkNotNullParameter((Object)record, (String)"record");
        if (!(record instanceof IDDLRecord)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        DDLRecord prevRecord = (DDLRecord)record;
        ByteBuffer conBody = ByteBuffer.allocate(prevRecord.getBody().capacity() + this.getBody().capacity());
        prevRecord.getBody().clear();
        conBody.put(prevRecord.getBody());
        conBody.put(this.getBody());
        RedoRecordHead ddlRecordHead = new RedoRecordHead(RedoType.METADATA, conBody.capacity(), ((DDLRecord)record).getHead().getCubeId(), ((DDLRecord)record).getHead().getTid());
        Intrinsics.checkNotNull((Object)conBody);
        return new DDLRecord(ddlRecordHead, conBody);
    }
}

