/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.replication;

import java.nio.ByteBuffer;
import java.util.Arrays;
import kd.bos.olapServer2.common.CommandTypes;
import kd.bos.olapServer2.dataSources.MetadataCommandInfo;
import kd.bos.olapServer2.metadata.CubeCreateMetadataCommand;
import kd.bos.olapServer2.metadata.MetadataCommandExecutor;
import kd.bos.olapServer2.metadata.MetadataTypes;
import kd.bos.olapServer2.replication.AbstractDDLRecord;
import kd.bos.olapServer2.replication.IDDLRecord;
import kd.bos.olapServer2.replication.IRedoRecord;
import kd.bos.olapServer2.replication.OlapLogger;
import kd.bos.olapServer2.replication.RedoRecordHead;
import kd.bos.olapServer2.replication.RedoType;
import kd.bos.olapServer2.storages.CubeWorkspace;
import kd.bos.olapServer2.storages.OlapWorkspace;
import kd.bos.olapServer2.tools.JsonHelper;
import kd.bos.olapServer2.tools.Res;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\bH\u0016J\f\u0010\u000f\u001a\u00060\u0010j\u0002`\u0011H\u0016J\f\u0010\u0012\u001a\u00060\u0010j\u0002`\u0011H\u0002J\f\u0010\u0013\u001a\u00060\u0010j\u0002`\u0011H\u0016J\f\u0010\u0014\u001a\u00060\u0015j\u0002`\u0016H\u0016J\f\u0010\u0017\u001a\u00060\u0010j\u0002`\u0011H\u0016J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u001bH\u0016J\u0010\u0010 \u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u0016\u0010\u0007\u001a\n\u0018\u00010\bj\u0004\u0018\u0001`\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lkd/bos/olapServer2/replication/DDLRecordV0;", "Lkd/bos/olapServer2/replication/AbstractDDLRecord;", "head", "Lkd/bos/olapServer2/replication/RedoRecordHead;", "body", "Ljava/nio/ByteBuffer;", "(Lkd/bos/olapServer2/replication/RedoRecordHead;Ljava/nio/ByteBuffer;)V", "_ddlCommandStr", "", "Lkd/bos/olapServer2/common/string;", "consolidate", "Lkd/bos/olapServer2/replication/IDDLRecord;", "record", "Lkd/bos/olapServer2/replication/IRedoRecord;", "getDDLCommand", "isBofDDL", "", "Lkd/bos/olapServer2/common/bool;", "isEofCommand", "isEofDDL", "parseCubeId", "", "Lkd/bos/olapServer2/common/int;", "parseDDlOlapLevel", "replayCubeDDL", "", "olap", "Lkd/bos/olapServer2/storages/OlapWorkspace;", "cube", "Lkd/bos/olapServer2/storages/CubeWorkspace;", "replayDDL", "olapWorkspace", "replayOlapDDL", "bos-olap-core2"})
@SourceDebugExtension(value={"SMAP\nDDLRecordV0.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DDLRecordV0.kt\nkd/bos/olapServer2/replication/DDLRecordV0\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,123:1\n1#2:124\n*E\n"})
public final class DDLRecordV0
extends AbstractDDLRecord {
    @Nullable
    private String _ddlCommandStr;

    public DDLRecordV0(@NotNull RedoRecordHead head, @NotNull ByteBuffer body) {
        Intrinsics.checkNotNullParameter((Object)head, (String)"head");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        super(head, body);
    }

    @Override
    public int parseCubeId() {
        return this.getHead().getCubeId();
    }

    @Override
    public boolean parseDDlOlapLevel() {
        boolean bl;
        if (this.getHead().getCubeId() == 0) {
            bl = true;
        } else {
            String commandStr = this.getDDLCommand();
            MetadataCommandInfo command = (MetadataCommandInfo)JsonHelper.INSTANCE.getMapper().readValue(commandStr, MetadataCommandInfo.class);
            bl = command.getMetadataType() == MetadataTypes.Cube && (command.getAction() == CommandTypes.create || command.getAction() == CommandTypes.drop);
        }
        return bl;
    }

    private final boolean isEofCommand() {
        if (!(this.getHead().getType() == RedoType.METADATA)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        return this.getBody().limit() >= this.getHead().getLength() && this.getBody().get(this.getHead().getLength() - 1) == 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String getDDLCommand() {
        String string2;
        if (!(this.getHead().getType() == RedoType.METADATA && this.getBody().capacity() >= this.getHead().getLength())) {
            boolean $i$a$-require-DDLRecordV0$getDDLCommand$22 = false;
            String $i$a$-require-DDLRecordV0$getDDLCommand$22 = "\u89e3\u6790DDL\u547d\u4ee4\u5931\u8d25," + (Object)((Object)this.getHead().getType()) + ':' + this.getHead().getLength() + ',' + this.getBody().capacity();
            throw new IllegalArgumentException($i$a$-require-DDLRecordV0$getDDLCommand$22.toString());
        }
        String ddlCommandStr = this._ddlCommandStr;
        if (ddlCommandStr == null) {
            void var2_3;
            String resultStr;
            String string3;
            int n;
            byte[] byArray;
            if (this.isEofCommand()) {
                byte[] byArray2 = this.getBody().array();
                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"array(...)");
                byArray = byArray2;
                n = this.getHead().getLength() - 1;
                byte[] byArray3 = Arrays.copyOf(byArray, n);
                Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"copyOf(this, newSize)");
                byArray = byArray3;
                string3 = new String(byArray, Charsets.UTF_8);
            } else if (this.getBody().capacity() == this.getHead().getLength()) {
                byte[] byArray4 = this.getBody().array();
                Intrinsics.checkNotNullExpressionValue((Object)byArray4, (String)"array(...)");
                byArray = byArray4;
                string3 = new String(byArray, Charsets.UTF_8);
            } else {
                byte[] byArray5 = this.getBody().array();
                Intrinsics.checkNotNullExpressionValue((Object)byArray5, (String)"array(...)");
                byArray = byArray5;
                n = this.getHead().getLength();
                byte[] byArray6 = Arrays.copyOf(byArray, n);
                Intrinsics.checkNotNullExpressionValue((Object)byArray6, (String)"copyOf(this, newSize)");
                byArray = byArray6;
                string3 = new String(byArray, Charsets.UTF_8);
            }
            this._ddlCommandStr = resultStr = string3;
            string2 = var2_3;
        } else {
            string2 = ddlCommandStr;
        }
        return string2;
    }

    private final void replayOlapDDL(OlapWorkspace olap) {
        String cmd = this.getDDLCommand();
        try {
            Object object2 = JsonHelper.INSTANCE.getMapper().readValue(cmd, MetadataCommandInfo.class);
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"readValue(...)");
            MetadataCommandInfo command = (MetadataCommandInfo)object2;
            String idProperty = (String)command.getProperties().get((Object)"id");
            new CubeCreateMetadataCommand(command, olap, Integer.parseInt(idProperty)).execute();
        }
        catch (Exception e) {
            throw Res.INSTANCE.getRuntimeException("olap \u91cd\u505aDDL redo\u65e5\u5fd7\u51fa\u9519, \u547d\u4ee4\u4e3a: " + cmd, e, new Object[0]);
        }
    }

    private final void replayCubeDDL(OlapWorkspace olap, CubeWorkspace cube) {
        String cmd = this.getDDLCommand();
        try {
            MetadataCommandInfo command = (MetadataCommandInfo)JsonHelper.INSTANCE.getMapper().readValue(cmd, MetadataCommandInfo.class);
            Intrinsics.checkNotNull((Object)command);
            new MetadataCommandExecutor(command, olap, cube).run();
            OlapLogger.Companion.info("cube: {}({}): \u91cd\u505aDDL redo\u65e5\u5fd7\u6210\u529f, \u547d\u4ee4\u4e3a: {}", cube.getMetadata().getName(), cube.getCubeId(), cmd);
        }
        catch (Exception e) {
            throw Res.INSTANCE.getRuntimeException("cube: " + cube.getMetadata().getName() + '(' + cube.getCubeId() + "): \u91cd\u505aDDL redo\u65e5\u5fd7\u51fa\u9519, \u547d\u4ee4\u4e3a: " + cmd, e, new Object[0]);
        }
    }

    @Override
    public void replayDDL(@NotNull OlapWorkspace olapWorkspace) {
        Intrinsics.checkNotNullParameter((Object)olapWorkspace, (String)"olapWorkspace");
        if (this.getCubeId() == 0) {
            this.replayOlapDDL(olapWorkspace);
            return;
        }
        CubeWorkspace cubeWorkspace = olapWorkspace.getCubeWorkspaceByCubeId(this.getCubeId());
        this.replayCubeDDL(olapWorkspace, cubeWorkspace);
    }

    @Override
    public boolean isEofDDL() {
        return this.isEofCommand();
    }

    @Override
    public boolean isBofDDL() {
        throw Res.INSTANCE.getNotSupportedException("DDLRecordV0 is not bof", new Object[0]);
    }

    @Override
    @NotNull
    public IDDLRecord consolidate(@NotNull IRedoRecord record) {
        Intrinsics.checkNotNullParameter((Object)record, (String)"record");
        if (!(record instanceof DDLRecordV0)) {
            boolean $i$a$-require-DDLRecordV0$consolidate$22 = false;
            String $i$a$-require-DDLRecordV0$consolidate$22 = "current record must be DDLRecordV0";
            throw new IllegalArgumentException($i$a$-require-DDLRecordV0$consolidate$22.toString());
        }
        ByteBuffer conBody = ByteBuffer.allocate(((DDLRecordV0)record).getBody().capacity() + this.getBody().capacity());
        ((DDLRecordV0)record).getBody().clear();
        conBody.put(((DDLRecordV0)record).getBody());
        conBody.put(this.getBody());
        RedoRecordHead ddlRecordHead = new RedoRecordHead(RedoType.METADATA, conBody.capacity(), ((DDLRecordV0)record).getHead().getCubeId(), ((DDLRecordV0)record).getHead().getTid());
        Intrinsics.checkNotNull((Object)conBody);
        return new DDLRecordV0(ddlRecordHead, conBody);
    }
}

