/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.replication;

import java.nio.ByteBuffer;
import kd.bos.olapServer2.common.CommonTypesKt;
import kd.bos.olapServer2.common.NotSupportedException;
import kd.bos.olapServer2.dataEntities.InputRow;
import kd.bos.olapServer2.memoryMappedFiles.dynamicData.Encoding;
import kd.bos.olapServer2.replication.AbstractDMLRecord;
import kd.bos.olapServer2.replication.IDMLRecord;
import kd.bos.olapServer2.replication.RedoRecordHead;
import kd.bos.olapServer2.replication.RedoRecordMeasureHead;
import kd.bos.olapServer2.replication.RedoType;
import kd.bos.olapServer2.storages.CubeWorkspace;
import kd.bos.olapServer2.storages.IInputRowWriter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016J\f\u0010\n\u001a\u00060\u000bj\u0002`\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\f\u0010\u0011\u001a\u00060\u0012j\u0002`\u0013H\u0016J\u001c\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\n\u0010\u0015\u001a\u00060\u0012j\u0002`\u0013H\u0016J\f\u0010\u0016\u001a\u00060\u0017j\u0002`\u0018H\u0016J\f\u0010\u0019\u001a\u00060\u0017j\u0002`\u0018H\u0016J\u0010\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J8\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u000f\u001a\u00020\u00102\n\u0010 \u001a\u00060!j\u0002`\"2\n\u0010#\u001a\u00060!j\u0002`\"H\u0016\u00a8\u0006$"}, d2={"Lkd/bos/olapServer2/replication/DMLRecord;", "Lkd/bos/olapServer2/replication/AbstractDMLRecord;", "head", "Lkd/bos/olapServer2/replication/RedoRecordHead;", "body", "Ljava/nio/ByteBuffer;", "(Lkd/bos/olapServer2/replication/RedoRecordHead;Ljava/nio/ByteBuffer;)V", "consolidate", "Lkd/bos/olapServer2/replication/IDMLRecord;", "record", "dmlRecordToString", "", "Lkd/bos/olapServer2/common/string;", "getMeasures", "", "row", "Lkd/bos/olapServer2/dataEntities/InputRow;", "getPartitionId", "", "Lkd/bos/olapServer2/common/int;", "getRow", "realDimensionCount", "getRowIndex", "", "Lkd/bos/olapServer2/common/long;", "getUndoTid", "getUndoValues", "replayDML", "cube", "Lkd/bos/olapServer2/storages/CubeWorkspace;", "writer", "Lkd/bos/olapServer2/storages/IInputRowWriter;", "isSkip", "", "Lkd/bos/olapServer2/common/bool;", "isAddOrUpdate", "bos-olap-core2"})
public final class DMLRecord
extends AbstractDMLRecord {
    public DMLRecord(@NotNull RedoRecordHead head, @NotNull ByteBuffer body) {
        Intrinsics.checkNotNullParameter((Object)head, (String)"head");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        super(head, body);
    }

    @Override
    public void replayDML(@NotNull CubeWorkspace cube, @NotNull IInputRowWriter writer, @NotNull InputRow row, boolean isSkip, boolean isAddOrUpdate) {
        Intrinsics.checkNotNullParameter((Object)cube, (String)"cube");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Intrinsics.checkNotNullParameter((Object)row, (String)"row");
        row.reset();
        switch (WhenMappings.$EnumSwitchMapping$0[this.getRedoType().ordinal()]) {
            case 1: {
                int partitionId = this.getPartitionId();
                int markDimensionCount = partitionId >= 0 ? cube.getMetadata().getPartitionItems().get(partitionId).getMarkDimensionsAndMembers().size() : 0;
                this.getRow(row, row.getKeys().getCount() - markDimensionCount);
                if (isSkip) {
                    this.clearMeasures(row);
                }
                writer.add4Redo(partitionId, row.getKeys(), row.getValues(), -1L);
                break;
            }
            case 2: 
            case 3: {
                if (isSkip) {
                    return;
                }
                this.getMeasures(row);
                writer.update4Redo(this.getPartitionId(), this.getRowIndex(), row.getValues(), null);
                break;
            }
            default: {
                throw new NotSupportedException("not supported type: " + (Object)((Object)this.getRedoType()));
            }
        }
    }

    @Override
    public int getPartitionId() {
        if (!(this.getHead().getType() == RedoType.INSERT || this.getHead().getType() == RedoType.UPDATE)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        return this.getBody().getInt(0);
    }

    @Override
    public long getRowIndex() {
        if (!(this.getHead().getType() == RedoType.UPDATE)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        return CommonTypesKt.toLongNoNegative(this.getBody().getInt(4));
    }

    @Override
    public void getMeasures(@NotNull InputRow row) {
        Intrinsics.checkNotNullParameter((Object)row, (String)"row");
        if (!(this.getHead().getType() == RedoType.UPDATE)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        int pos = 8;
        this.getBody().position(pos);
        Encoding decoder = new Encoding();
        int n = row.getValues().getCount();
        for (int i = 0; i < n; ++i) {
            if (pos >= this.getHead().getLength()) {
                row.setMeasureValue(i, CommonTypesKt.getIgnoreValue());
                continue;
            }
            RedoRecordMeasureHead measureHead = new RedoRecordMeasureHead(this.getBody().getShort());
            if (measureHead.getIndex() != i) {
                row.setMeasureValue(i, CommonTypesKt.getIgnoreValue());
                this.getBody().position(pos);
                continue;
            }
            pos += 2 + measureHead.getLength();
            if (measureHead.getDecodeType()) {
                int intValue = this.getBody().getInt();
                if (intValue == 0) {
                    row.setMeasureValue(measureHead.getIndex(), null);
                    continue;
                }
                row.setMeasureValue(measureHead.getIndex(), decoder.decode(intValue & Integer.MAX_VALUE));
                continue;
            }
            byte[] byteArray = new byte[measureHead.getLength()];
            this.getBody().get(byteArray, 0, measureHead.getLength());
            row.setMeasureValue(measureHead.getIndex(), decoder.decode(byteArray, measureHead.getLength()));
        }
        if (!(pos == this.getHead().getLength())) {
            String string3 = "Failed requirement.";
            throw new IllegalArgumentException(string3.toString());
        }
    }

    @Override
    public void getRow(@NotNull InputRow row, int realDimensionCount) {
        Intrinsics.checkNotNullParameter((Object)row, (String)"row");
        if (!(this.getHead().getType() == RedoType.INSERT)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        this.getBody().position(4);
        for (int i = 0; i < realDimensionCount; ++i) {
            row.setDimensionValue(i, this.getBody().getInt());
        }
        Encoding decoder = new Encoding();
        while (this.getBody().remaining() > 0) {
            RedoRecordMeasureHead measureHead = new RedoRecordMeasureHead(this.getBody().getShort());
            if (measureHead.getDecodeType()) {
                int intValue = this.getBody().getInt();
                if (intValue == 0) {
                    row.setMeasureValue(measureHead.getIndex(), null);
                    continue;
                }
                row.setMeasureValue(measureHead.getIndex(), decoder.decode(intValue & Integer.MAX_VALUE));
                continue;
            }
            byte[] byteArray = new byte[measureHead.getLength()];
            this.getBody().get(byteArray, 0, measureHead.getLength());
            row.setMeasureValue(measureHead.getIndex(), decoder.decode(byteArray, measureHead.getLength()));
        }
    }

    @Override
    public long getUndoTid() {
        throw new NotSupportedException();
    }

    @Override
    public void getUndoValues(@NotNull InputRow row) {
        Intrinsics.checkNotNullParameter((Object)row, (String)"row");
        throw new NotSupportedException();
    }

    @Override
    @NotNull
    public String dmlRecordToString() {
        String string2;
        switch (WhenMappings.$EnumSwitchMapping$0[this.getRedoType().ordinal()]) {
            case 1: {
                string2 = "cubeID: " + this.getHead().getCubeId() + ", tid: " + this.getHead().getTid() + ", insert\n";
                break;
            }
            case 2: {
                string2 = "cubeID: " + this.getHead().getCubeId() + ", tid: " + this.getHead().getTid() + ", update, partitionID: " + this.getPartitionId() + ", rowIndex: " + this.getRowIndex() + '\n';
                break;
            }
            default: {
                throw new NotSupportedException("Don't support such type: " + this.getHead().getType().name());
            }
        }
        return string2;
    }

    @Override
    @NotNull
    public IDMLRecord consolidate(@NotNull IDMLRecord record) {
        Intrinsics.checkNotNullParameter((Object)record, (String)"record");
        throw new NotSupportedException("DMLRecord not support consolidate");
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RedoType.values().length];
            try {
                nArray[RedoType.INSERT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RedoType.UPDATE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RedoType.Compensation.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

