/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.replication;

import java.nio.ByteBuffer;
import kd.bos.olapServer2.common.CommonTypesKt;
import kd.bos.olapServer2.common.NotSupportedException;
import kd.bos.olapServer2.dataEntities.InputRow;
import kd.bos.olapServer2.memoryMappedFiles.dynamicData.Encoding;
import kd.bos.olapServer2.replication.AbstractDMLRecord;
import kd.bos.olapServer2.replication.IDMLRecord;
import kd.bos.olapServer2.replication.RedoRecordHead;
import kd.bos.olapServer2.replication.RedoRecordMeasureHead;
import kd.bos.olapServer2.replication.RedoType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\n\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\f\u0010\u000e\u001a\u00060\u000fj\u0002`\u0010H\u0016J\u001c\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\n\u0010\u0012\u001a\u00060\u000fj\u0002`\u0010H\u0016J\f\u0010\u0013\u001a\u00060\u0014j\u0002`\u0015H\u0016J\f\u0010\u0016\u001a\u00060\u0017j\u0002`\u0018H\u0002J\f\u0010\u0019\u001a\u00060\u0014j\u0002`\u0015H\u0016J\u0010\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u001b"}, d2={"Lkd/bos/olapServer2/replication/DMLRecordV2;", "Lkd/bos/olapServer2/replication/AbstractDMLRecord;", "head", "Lkd/bos/olapServer2/replication/RedoRecordHead;", "body", "Ljava/nio/ByteBuffer;", "(Lkd/bos/olapServer2/replication/RedoRecordHead;Ljava/nio/ByteBuffer;)V", "consolidate", "Lkd/bos/olapServer2/replication/IDMLRecord;", "record", "getMeasures", "", "row", "Lkd/bos/olapServer2/dataEntities/InputRow;", "getPartitionId", "", "Lkd/bos/olapServer2/common/int;", "getRow", "realDimensionCount", "getRowIndex", "", "Lkd/bos/olapServer2/common/long;", "getUndoStartOffset", "", "Lkd/bos/olapServer2/common/short;", "getUndoTid", "getUndoValues", "bos-olap-core2"})
public final class DMLRecordV2
extends AbstractDMLRecord {
    public DMLRecordV2(@NotNull RedoRecordHead head, @NotNull ByteBuffer body) {
        Intrinsics.checkNotNullParameter((Object)head, (String)"head");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        super(head, body);
    }

    @Override
    public int getPartitionId() {
        return this.getBody().getInt(0);
    }

    @Override
    public long getRowIndex() {
        if (!(this.getHead().getType() == RedoType.UPDATE || this.getHead().getType() == RedoType.INSERT || this.getHead().getType() == RedoType.Compensation)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        return this.getBody().getLong(4);
    }

    private final short getUndoStartOffset() {
        if (!(this.getHead().getType() == RedoType.UPDATE || this.getHead().getType() == RedoType.Compensation)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        int pos = 12;
        this.getBody().position(pos);
        return this.getBody().getShort();
    }

    @Override
    public void getMeasures(@NotNull InputRow row) {
        Intrinsics.checkNotNullParameter((Object)row, (String)"row");
        if (!(this.getHead().getType() == RedoType.UPDATE || this.getHead().getType() == RedoType.Compensation)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        int undoStartOffset = this.getUndoStartOffset();
        int pos = 14;
        this.getBody().position(pos);
        Encoding decoder = new Encoding();
        int n = row.getValues().getCount();
        for (int i = 0; i < n; ++i) {
            if (pos >= undoStartOffset) {
                row.setMeasureValue(i, CommonTypesKt.getIgnoreValue());
                continue;
            }
            RedoRecordMeasureHead measureHead = new RedoRecordMeasureHead(this.getBody().getShort());
            if (measureHead.getIndex() != i) {
                row.setMeasureValue(i, CommonTypesKt.getIgnoreValue());
                this.getBody().position(pos);
                continue;
            }
            pos += 2 + measureHead.getLength();
            if (measureHead.getDecodeType()) {
                int intValue = this.getBody().getInt();
                if (intValue == 0) {
                    row.setMeasureValue(measureHead.getIndex(), null);
                    continue;
                }
                row.setMeasureValue(measureHead.getIndex(), decoder.decode(intValue & Integer.MAX_VALUE));
                continue;
            }
            byte[] byteArray = new byte[measureHead.getLength()];
            this.getBody().get(byteArray, 0, measureHead.getLength());
            row.setMeasureValue(measureHead.getIndex(), decoder.decode(byteArray, measureHead.getLength()));
        }
        if (!((short)pos == undoStartOffset)) {
            String string3 = "Failed requirement.";
            throw new IllegalArgumentException(string3.toString());
        }
    }

    @Override
    public void getRow(@NotNull InputRow row, int realDimensionCount) {
        Intrinsics.checkNotNullParameter((Object)row, (String)"row");
        if (!(this.getHead().getType() == RedoType.INSERT)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        this.getBody().position(12);
        for (int i = 0; i < realDimensionCount; ++i) {
            row.setDimensionValue(i, this.getBody().getInt());
        }
        Encoding decoder = new Encoding();
        while (this.getBody().remaining() > 0) {
            RedoRecordMeasureHead measureHead = new RedoRecordMeasureHead(this.getBody().getShort());
            if (measureHead.getDecodeType()) {
                int intValue = this.getBody().getInt();
                if (intValue == 0) {
                    row.setMeasureValue(measureHead.getIndex(), null);
                    continue;
                }
                row.setMeasureValue(measureHead.getIndex(), decoder.decode(intValue & Integer.MAX_VALUE));
                continue;
            }
            byte[] byteArray = new byte[measureHead.getLength()];
            this.getBody().get(byteArray, 0, measureHead.getLength());
            row.setMeasureValue(measureHead.getIndex(), decoder.decode(byteArray, measureHead.getLength()));
        }
    }

    @Override
    public long getUndoTid() {
        long l;
        switch (WhenMappings.$EnumSwitchMapping$0[this.getHead().getType().ordinal()]) {
            case 1: {
                l = -1L;
                break;
            }
            case 2: 
            case 3: {
                short pos = this.getUndoStartOffset();
                this.getBody().position(pos);
                l = this.getBody().getLong();
                break;
            }
            default: {
                throw new NotSupportedException("unexpected record type " + this.getHead().getType().name());
            }
        }
        return l;
    }

    @Override
    public void getUndoValues(@NotNull InputRow row) {
        Intrinsics.checkNotNullParameter((Object)row, (String)"row");
        switch (WhenMappings.$EnumSwitchMapping$0[this.getHead().getType().ordinal()]) {
            case 1: {
                int n = row.getValues().getCount();
                for (int i = 0; i < n; ++i) {
                    row.setMeasureValue(i, null);
                }
                break;
            }
            case 2: {
                int pos = this.getUndoStartOffset() + 8;
                this.getBody().position(pos);
                Encoding decoder = new Encoding();
                int n = row.getValues().getCount();
                for (int i = 0; i < n; ++i) {
                    RedoRecordMeasureHead measureHead = new RedoRecordMeasureHead(this.getBody().getShort());
                    if (measureHead.getDecodeType()) {
                        int intValue = this.getBody().getInt();
                        if (intValue == 0) {
                            row.setMeasureValue(measureHead.getIndex(), null);
                            continue;
                        }
                        row.setMeasureValue(measureHead.getIndex(), decoder.decode(intValue & Integer.MAX_VALUE));
                        continue;
                    }
                    byte[] byteArray = new byte[measureHead.getLength()];
                    this.getBody().get(byteArray, 0, measureHead.getLength());
                    row.setMeasureValue(measureHead.getIndex(), decoder.decode(byteArray, measureHead.getLength()));
                }
                break;
            }
            default: {
                throw new NotSupportedException("unexpected record type " + this.getHead().getType().name());
            }
        }
    }

    @Override
    @NotNull
    public IDMLRecord consolidate(@NotNull IDMLRecord record) {
        Intrinsics.checkNotNullParameter((Object)record, (String)"record");
        throw new NotSupportedException("DMLRecordV2 not support consolidate");
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RedoType.values().length];
            try {
                nArray[RedoType.INSERT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RedoType.UPDATE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RedoType.Compensation.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

