/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.replication;

import java.nio.ByteBuffer;
import kd.bos.olapServer2.common.CommonTypesKt;
import kd.bos.olapServer2.common.NotSupportedException;
import kd.bos.olapServer2.dataEntities.InputRow;
import kd.bos.olapServer2.memoryMappedFiles.concurrentDynamicData.Encoding;
import kd.bos.olapServer2.memoryMappedFiles.concurrentDynamicData.EncodingVersion;
import kd.bos.olapServer2.replication.AbstractDMLRecord;
import kd.bos.olapServer2.replication.IDMLRecord;
import kd.bos.olapServer2.replication.RedoRecordHeadV3;
import kd.bos.olapServer2.replication.RedoRecordMeasureHeadV3;
import kd.bos.olapServer2.replication.RedoType;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\f\u0010\u000e\u001a\u00060\u000fj\u0002`\u0010H\u0016J\u001c\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\n\u0010\u0012\u001a\u00060\u000fj\u0002`\u0010H\u0016J\f\u0010\u0013\u001a\u00060\u0014j\u0002`\u0015H\u0016J\f\u0010\u0016\u001a\u00060\u000fj\u0002`\u0010H\u0002J\f\u0010\u0017\u001a\u00060\u0014j\u0002`\u0015H\u0016J\u0010\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\f\u0010\u0019\u001a\u00060\u001aj\u0002`\u001bH\u0016J\f\u0010\u001c\u001a\u00060\u001aj\u0002`\u001bH\u0016J \u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010 \u001a\u00020!H\u0002\u00a8\u0006#"}, d2={"Lkd/bos/olapServer2/replication/DMLRecordV3;", "Lkd/bos/olapServer2/replication/AbstractDMLRecord;", "head", "Lkd/bos/olapServer2/replication/RedoRecordHeadV3;", "body", "Ljava/nio/ByteBuffer;", "(Lkd/bos/olapServer2/replication/RedoRecordHeadV3;Ljava/nio/ByteBuffer;)V", "consolidate", "Lkd/bos/olapServer2/replication/IDMLRecord;", "record", "getMeasures", "", "row", "Lkd/bos/olapServer2/dataEntities/InputRow;", "getPartitionId", "", "Lkd/bos/olapServer2/common/int;", "getRow", "realDimensionCount", "getRowIndex", "", "Lkd/bos/olapServer2/common/long;", "getUndoStartOffset", "getUndoTid", "getUndoValues", "isBofDML", "", "Lkd/bos/olapServer2/common/bool;", "isEofDML", "parseMeasure", "measureHead", "Lkd/bos/olapServer2/replication/RedoRecordMeasureHeadV3;", "decoder", "Lkd/bos/olapServer2/memoryMappedFiles/concurrentDynamicData/Encoding;", "Companion", "bos-olap-core2"})
public final class DMLRecordV3
extends AbstractDMLRecord {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public DMLRecordV3(@NotNull RedoRecordHeadV3 head, @NotNull ByteBuffer body) {
        Intrinsics.checkNotNullParameter((Object)head, (String)"head");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        super(head, body);
    }

    @Override
    public int getPartitionId() {
        if (!(this.getHead() instanceof RedoRecordHeadV3)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        return ((RedoRecordHeadV3)this.getHead()).getPartitionId();
    }

    @Override
    public long getRowIndex() {
        if (!(this.getHead().getType() == RedoType.UPDATE || this.getHead().getType() == RedoType.INSERT || this.getHead().getType() == RedoType.Compensation)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        return this.getBody().getLong(0);
    }

    @Override
    public boolean isEofDML() {
        if (!(this.getHead() instanceof RedoRecordHeadV3)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        return ((RedoRecordHeadV3)this.getHead()).getEof() == 1;
    }

    @Override
    public boolean isBofDML() {
        if (!(this.getHead() instanceof RedoRecordHeadV3)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        return ((RedoRecordHeadV3)this.getHead()).getBof() == 1;
    }

    @Override
    @NotNull
    public IDMLRecord consolidate(@NotNull IDMLRecord record) {
        Intrinsics.checkNotNullParameter((Object)record, (String)"record");
        if (!(record instanceof DMLRecordV3 && ((DMLRecordV3)record).getHead() instanceof RedoRecordHeadV3)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        ByteBuffer conBody = ByteBuffer.allocate(((DMLRecordV3)record).getBody().capacity() + this.getBody().capacity());
        ((DMLRecordV3)record).getBody().clear();
        this.getBody().clear();
        conBody.put(((DMLRecordV3)record).getBody());
        conBody.put(this.getBody());
        if (!(this.getHead() instanceof RedoRecordHeadV3)) {
            String string3 = "Failed requirement.";
            throw new IllegalArgumentException(string3.toString());
        }
        RedoRecordHeadV3 dmlRecordHead = new RedoRecordHeadV3(record.getRedoType(), conBody.capacity(), ((RedoRecordHeadV3)this.getHead()).getBof(), ((RedoRecordHeadV3)this.getHead()).getEof(), ((DMLRecordV3)record).getHead().getCubeId(), ((DMLRecordV3)record).getHead().getTid(), ((RedoRecordHeadV3)((DMLRecordV3)record).getHead()).getPartitionId());
        Intrinsics.checkNotNull((Object)conBody);
        return new DMLRecordV3(dmlRecordHead, conBody);
    }

    private final int getUndoStartOffset() {
        if (!(this.getHead().getType() == RedoType.UPDATE || this.getHead().getType() == RedoType.Compensation)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        int position = this.getHead().getLength() - 4;
        this.getBody().position(position);
        return this.getBody().getInt();
    }

    @Override
    public void getMeasures(@NotNull InputRow row) {
        Intrinsics.checkNotNullParameter((Object)row, (String)"row");
        if (!(this.getHead().getType() == RedoType.UPDATE || this.getHead().getType() == RedoType.Compensation)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        int undoStartOffset = this.getUndoStartOffset();
        int pos = 8;
        this.getBody().position(pos);
        Encoding decoder = new Encoding(EncodingVersion.V3);
        while (pos < undoStartOffset) {
            RedoRecordMeasureHeadV3 measureHead = new RedoRecordMeasureHeadV3(this.getBody().getInt());
            this.parseMeasure(measureHead, row, decoder);
            this.getBody().position(pos += 4 + measureHead.getLength());
        }
        if (!(pos == undoStartOffset)) {
            String string3 = "Failed requirement.";
            throw new IllegalArgumentException(string3.toString());
        }
    }

    @Override
    public void getRow(@NotNull InputRow row, int realDimensionCount) {
        Intrinsics.checkNotNullParameter((Object)row, (String)"row");
        if (!(this.getHead().getType() == RedoType.INSERT)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        this.getBody().position(8);
        for (int i = 0; i < realDimensionCount; ++i) {
            row.setDimensionValue(i, this.getBody().getInt());
        }
        Encoding decoder = new Encoding(EncodingVersion.V3);
        while (this.getBody().remaining() > 0) {
            RedoRecordMeasureHeadV3 measureHead = new RedoRecordMeasureHeadV3(this.getBody().getInt());
            this.parseMeasure(measureHead, row, decoder);
        }
    }

    @Override
    public long getUndoTid() {
        long l;
        switch (WhenMappings.$EnumSwitchMapping$0[this.getHead().getType().ordinal()]) {
            case 1: {
                l = -1L;
                break;
            }
            case 2: 
            case 3: {
                int pos = this.getUndoStartOffset();
                this.getBody().position(pos);
                l = this.getBody().getLong();
                break;
            }
            default: {
                throw new NotSupportedException("unexpected record type " + this.getHead().getType().name());
            }
        }
        return l;
    }

    @Override
    public void getUndoValues(@NotNull InputRow row) {
        Intrinsics.checkNotNullParameter((Object)row, (String)"row");
        switch (WhenMappings.$EnumSwitchMapping$0[this.getHead().getType().ordinal()]) {
            case 1: {
                int n = row.getValues().getCount();
                for (int i = 0; i < n; ++i) {
                    row.setMeasureValue(i, CommonTypesKt.getUndefined());
                }
                break;
            }
            case 2: {
                int pos = this.getUndoStartOffset() + 8;
                this.getBody().position(pos);
                Encoding decoder = new Encoding(EncodingVersion.V3);
                while (this.getBody().remaining() > 4) {
                    RedoRecordMeasureHeadV3 measureHead = new RedoRecordMeasureHeadV3(this.getBody().getInt());
                    this.parseMeasure(measureHead, row, decoder);
                }
                break;
            }
            default: {
                throw new NotSupportedException("unexpected record type " + this.getHead().getType().name());
            }
        }
    }

    private final void parseMeasure(RedoRecordMeasureHeadV3 measureHead, InputRow row, Encoding decoder) {
        if (measureHead.getDecodeType()) {
            long intValue = this.getBody().getLong();
            if (intValue == 0L) {
                row.setMeasureValue(measureHead.getIndex(), CommonTypesKt.getUndefined());
            } else if (intValue < 0L) {
                row.setMeasureValue(measureHead.getIndex(), decoder.decode(intValue));
            } else {
                int len = Companion.getLength(intValue);
                row.setMeasureValue(measureHead.getIndex(), decoder.decode(intValue, len));
            }
        } else {
            byte[] byteArray = new byte[measureHead.getLength()];
            long intValue = this.getBody().getLong();
            int contentLen = measureHead.getLength() - 8;
            this.getBody().get(byteArray, 0, contentLen);
            row.setMeasureValue(measureHead.getIndex(), decoder.decode(intValue, byteArray, contentLen));
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u00a8\u0006\b"}, d2={"Lkd/bos/olapServer2/replication/DMLRecordV3$Companion;", "", "()V", "getLength", "", "indexValue", "", "Lkd/bos/olapServer2/common/long;", "bos-olap-core2"})
    public static final class Companion {
        private Companion() {
        }

        public final int getLength(long indexValue) {
            return (int)((indexValue & 0xFF000000000000L) >> 48);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RedoType.values().length];
            try {
                nArray[RedoType.INSERT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RedoType.UPDATE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RedoType.Compensation.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

