/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.replication;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.olapServer2.backup.CubeBackup;
import kd.bos.olapServer2.backup.sequenceLog.SeqRedoLogNameStrategy;
import kd.bos.olapServer2.backup.sequenceLog.SeqRedoLogger;
import kd.bos.olapServer2.common.CommandTypes;
import kd.bos.olapServer2.common.DefaultThreadPoolExecutor;
import kd.bos.olapServer2.common.ITempFolder;
import kd.bos.olapServer2.common.NotSupportedException;
import kd.bos.olapServer2.common.OlapContext;
import kd.bos.olapServer2.common.OlapRuntimeException;
import kd.bos.olapServer2.common.Paths;
import kd.bos.olapServer2.common.PathsKt;
import kd.bos.olapServer2.dataSources.MetadataCommandInfo;
import kd.bos.olapServer2.metadata.MetadataTypes;
import kd.bos.olapServer2.metadata.OlapMetadata;
import kd.bos.olapServer2.metadata.builds.CubeEntry;
import kd.bos.olapServer2.metadata.builds.OlapMetadataBuilder;
import kd.bos.olapServer2.replication.BackupRecord;
import kd.bos.olapServer2.replication.BackupRecordWorkspace;
import kd.bos.olapServer2.replication.BackupReplayInfo;
import kd.bos.olapServer2.replication.BackupReplayItems;
import kd.bos.olapServer2.replication.BackupReplayType;
import kd.bos.olapServer2.replication.BackupType;
import kd.bos.olapServer2.replication.ControlConfig;
import kd.bos.olapServer2.replication.ControlHead;
import kd.bos.olapServer2.replication.CubeMapFileContainer;
import kd.bos.olapServer2.replication.CubeMapValue;
import kd.bos.olapServer2.replication.CubeRecoverRecord;
import kd.bos.olapServer2.replication.IDDLRecord;
import kd.bos.olapServer2.replication.IRedoRecord;
import kd.bos.olapServer2.replication.LSNContext;
import kd.bos.olapServer2.replication.MasterLSNContext;
import kd.bos.olapServer2.replication.OlapControlFile;
import kd.bos.olapServer2.replication.OlapRecovery;
import kd.bos.olapServer2.replication.RedoPageInfo;
import kd.bos.olapServer2.replication.RedoRecordCombineReader;
import kd.bos.olapServer2.replication.RedoRecordWithPage;
import kd.bos.olapServer2.replication.RedoType;
import kd.bos.olapServer2.replication.RedoUtil;
import kd.bos.olapServer2.replication.ReplayContext;
import kd.bos.olapServer2.replication.ReplayCoordinator;
import kd.bos.olapServer2.replication.SlaveLSNContext;
import kd.bos.olapServer2.replication.TotalBackupBuilderV1;
import kd.bos.olapServer2.server.IOlapLogger;
import kd.bos.olapServer2.server.ReplicationWorkspace;
import kd.bos.olapServer2.storages.CubeWorkspace;
import kd.bos.olapServer2.storages.CubeWorkspaceCreator;
import kd.bos.olapServer2.storages.OlapWorkspace;
import kd.bos.olapServer2.tools.FileTools;
import kd.bos.olapServer2.tools.JsonHelper;
import kd.bos.olapServer2.tools.Res;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 '2\u00020\u0001:\u0001'B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J,\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u00060\bj\u0002`\t2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001c\u0010\u0014\u001a\n\u0018\u00010\bj\u0004\u0018\u0001`\t2\n\u0010\u0015\u001a\u00060\u0016j\u0002`\u0017H\u0002J\u001a\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u001a2\n\u0010\u001b\u001a\u00060\u001cj\u0002`\u001dJ@\u0010\u001e\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\n\u0010\u001b\u001a\u00060\u001cj\u0002`\u001d2\n\u0010\u001f\u001a\u00060\u001cj\u0002`\u001d2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J4\u0010 \u001a\u00020\u00112\n\u0010\u001b\u001a\u00060\u001cj\u0002`\u001d2\n\u0010\u001f\u001a\u00060\u001cj\u0002`\u001d2\u0006\u0010!\u001a\u00020\u00132\n\u0010\u000e\u001a\u00060\bj\u0002`\tH\u0002J8\u0010\"\u001a\u00020\r2\n\u0010\u001b\u001a\u00060\u001cj\u0002`\u001d2\n\u0010\u001f\u001a\u00060\u001cj\u0002`\u001d2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0011H\u0002JB\u0010#\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u00032\n\u0010\u001b\u001a\u00060\u001cj\u0002`\u001d2\n\u0010\u001f\u001a\u00060\u001cj\u0002`\u001d2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010$\u001a\u0004\u0018\u00010%H\u0002J\u0012\u0010&\u001a\u00020\r2\n\u0010\u001b\u001a\u00060\u001cj\u0002`\u001dR\u0012\u0010\u0007\u001a\u00060\bj\u0002`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lkd/bos/olapServer2/replication/OlapBackup;", "", "replicationWorkspace", "Lkd/bos/olapServer2/server/ReplicationWorkspace;", "lsnContext", "Lkd/bos/olapServer2/replication/LSNContext;", "(Lkd/bos/olapServer2/server/ReplicationWorkspace;Lkd/bos/olapServer2/replication/LSNContext;)V", "backupPath", "", "Lkd/bos/olapServer2/common/string;", "backupRecordWorkspace", "Lkd/bos/olapServer2/replication/BackupRecordWorkspace;", "dealIndexJsonAndBackupJson", "", "totalBackupPath", "tmpOlapWorkspace", "replayItems", "Lkd/bos/olapServer2/replication/BackupReplayItems;", "backupBuilder", "Lkd/bos/olapServer2/replication/TotalBackupBuilderV1;", "getCubeNameByCubeId", "cubeId", "", "Lkd/bos/olapServer2/common/int;", "lockTotalBackup", "olapWorkspace", "Lkd/bos/olapServer2/storages/OlapWorkspace;", "backupPoint", "", "Lkd/bos/olapServer2/common/LSN;", "recoveryAndReplay", "checkPoint", "redoItr", "totalBackupBuilder", "redoReplay", "replyDifferCube", "logger", "Lkd/bos/olapServer2/server/IOlapLogger;", "totalBackup", "Companion", "bos-olap-core2"})
@SourceDebugExtension(value={"SMAP\nOlapBackup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OlapBackup.kt\nkd/bos/olapServer2/replication/OlapBackup\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,565:1\n215#2,2:566\n215#2,2:573\n215#2,2:576\n13309#3,2:568\n1855#4,2:570\n1855#4:572\n1856#4:575\n*S KotlinDebug\n*F\n+ 1 OlapBackup.kt\nkd/bos/olapServer2/replication/OlapBackup\n*L\n192#1:566,2\n279#1:573,2\n287#1:576,2\n235#1:568,2\n270#1:570,2\n277#1:572\n277#1:575\n*E\n"})
public final class OlapBackup {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ReplicationWorkspace replicationWorkspace;
    @NotNull
    private final LSNContext lsnContext;
    @NotNull
    private final BackupRecordWorkspace backupRecordWorkspace;
    @NotNull
    private final String backupPath;
    public static final int WAITCHECKPOINTTIMEOUT = 300000;

    public OlapBackup(@NotNull ReplicationWorkspace replicationWorkspace, @NotNull LSNContext lsnContext) {
        Intrinsics.checkNotNullParameter((Object)replicationWorkspace, (String)"replicationWorkspace");
        Intrinsics.checkNotNullParameter((Object)lsnContext, (String)"lsnContext");
        this.replicationWorkspace = replicationWorkspace;
        this.lsnContext = lsnContext;
        this.backupRecordWorkspace = this.replicationWorkspace.getBackupRecordWorkspace();
        this.backupPath = this.backupRecordWorkspace.getBackupPath();
    }

    public final void lockTotalBackup(@NotNull OlapWorkspace olapWorkspace, long backupPoint) {
        Intrinsics.checkNotNullParameter((Object)olapWorkspace, (String)"olapWorkspace");
        if (!(olapWorkspace.getMetadata().getCubes().getCount() > 0)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        File totalBackupDir = null;
        try {
            TotalBackupBuilderV1 totalBackupBuilderV1;
            BackupRecord lastPoint;
            BackupRecord backupRecord = lastPoint = this.backupRecordWorkspace.getLastTotalBackupWithoutZero();
            long beginPoint = backupRecord != null ? backupRecord.getEnd() : 0L;
            if (!(backupPoint >= 0L && beginPoint <= backupPoint)) {
                String string3 = "Failed requirement.";
                throw new IllegalArgumentException(string3.toString());
            }
            String totalName = this.backupRecordWorkspace.getBackupDir(BackupType.Total).getName();
            if (lastPoint != null && beginPoint == backupPoint) {
                File file = Companion.getOrCreateTotalFolder(this.backupPath, lastPoint.getName());
                Intrinsics.checkNotNull((Object)totalName);
                FilesKt.copyRecursively$default((File)file, (File)Companion.getOrCreateTotalFolder(this.backupPath, totalName), (boolean)true, null, (int)4, null);
                this.backupRecordWorkspace.writeBackupRecord(totalName, lastPoint.getStart(), lastPoint.getEnd());
                return;
            }
            Intrinsics.checkNotNull((Object)totalName);
            totalBackupDir = Companion.getOrCreateTotalFolder(this.backupPath, totalName);
            if (lastPoint == null) {
                totalBackupBuilderV1 = new TotalBackupBuilderV1();
            } else {
                String lastRecordPath = Companion.getOrCreateTotalFolder(this.backupPath, lastPoint.getName()).getPath();
                Intrinsics.checkNotNull((Object)lastRecordPath);
                totalBackupBuilderV1 = new CubeMapFileContainer(lastRecordPath).read();
            }
            TotalBackupBuilderV1 backupBuilder = totalBackupBuilderV1;
            backupBuilder = Companion.differBackup(olapWorkspace, backupBuilder, this.backupPath, totalBackupDir);
            String string4 = totalBackupDir.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getAbsolutePath(...)");
            new CubeMapFileContainer(string4).save(backupBuilder);
            OlapControlFile olapControlFile = new OlapControlFile(new ControlConfig(backupPoint, backupPoint, backupPoint), new ControlHead(0, 0, 0, 0L, 15, null));
            String string5 = totalBackupDir.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getPath(...)");
            OlapControlFile.save$default(olapControlFile, string5, false, 2, null);
            String string6 = totalBackupDir.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getName(...)");
            this.backupRecordWorkspace.writeBackupRecord(string6, backupPoint, backupPoint);
        }
        catch (Exception ex) {
            if (totalBackupDir != null) {
                FileTools.INSTANCE.deleteDir(totalBackupDir);
            }
            throw ex;
        }
    }

    public final void totalBackup(long backupPoint) {
        File totalBackupDir = null;
        try {
            TotalBackupBuilderV1 totalBackupBuilderV1;
            BackupRecord lastPoint;
            BackupRecord backupRecord = lastPoint = this.backupRecordWorkspace.getLastTotalBackupWithoutZero();
            long beginPoint = backupRecord != null ? backupRecord.getEnd() : 0L;
            if (!(backupPoint >= 0L && beginPoint <= backupPoint)) {
                String string2 = "Failed requirement.";
                throw new IllegalArgumentException(string2.toString());
            }
            String totalName = this.backupRecordWorkspace.getBackupDir(BackupType.Total).getName();
            if (lastPoint != null && beginPoint == backupPoint) {
                File file = Companion.getOrCreateTotalFolder(this.backupPath, lastPoint.getName());
                Intrinsics.checkNotNull((Object)totalName);
                FilesKt.copyRecursively$default((File)file, (File)Companion.getOrCreateTotalFolder(this.backupPath, totalName), (boolean)true, null, (int)4, null);
                this.backupRecordWorkspace.writeBackupRecord(totalName, lastPoint.getStart(), lastPoint.getEnd());
                return;
            }
            Intrinsics.checkNotNull((Object)totalName);
            totalBackupDir = Companion.getOrCreateTotalFolder(this.backupPath, totalName);
            if (lastPoint == null) {
                totalBackupBuilderV1 = new TotalBackupBuilderV1();
            } else {
                String lastRecordPath = Companion.getOrCreateTotalFolder(this.backupPath, lastPoint.getName()).getPath();
                Intrinsics.checkNotNull((Object)lastRecordPath);
                totalBackupBuilderV1 = new CubeMapFileContainer(lastRecordPath).read();
            }
            TotalBackupBuilderV1 backupBuilder = totalBackupBuilderV1;
            backupBuilder = Companion.differBackup(this.replicationWorkspace.getOlapWorkspace$bos_olap_core2(), backupBuilder, this.backupPath, totalBackupDir);
            if (!(this.lsnContext instanceof MasterLSNContext)) {
                throw new NotSupportedException();
            }
            long currentLSN = ((MasterLSNContext)this.lsnContext).getCurrentPage();
            long checkPoint = 0L;
            long startTime = System.currentTimeMillis();
            while (true) {
                if (System.currentTimeMillis() - startTime > 300000L) {
                    String string3 = Res.INSTANCE.getOlapBackupException_2();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"<get-OlapBackupException_2>(...)");
                    Object[] objectArray = new Object[]{backupPoint, currentLSN, this.lsnContext.getCheckPoint()};
                    throw Res.INSTANCE.getRuntimeException(string3, objectArray);
                }
                if (this.lsnContext.getCheckPoint() >= currentLSN) break;
                Thread.sleep(10L);
            }
            checkPoint = this.lsnContext.getCheckPoint();
            if (backupPoint != checkPoint) {
                IOlapLogger logger2;
                IOlapLogger iOlapLogger = logger2 = OlapContext.Companion.tryGetContext(IOlapLogger.class);
                if (iOlapLogger != null) {
                    iOlapLogger.info("TotalBackup start replay, backupPoint: " + backupPoint + ", checkPoint: " + checkPoint);
                }
                String string4 = totalBackupDir.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getName(...)");
                this.replyDifferCube(this.replicationWorkspace, backupPoint, checkPoint, string4, backupBuilder, logger2);
            }
            String string5 = totalBackupDir.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getAbsolutePath(...)");
            new CubeMapFileContainer(string5).save(backupBuilder);
            OlapControlFile olapControlFile = new OlapControlFile(new ControlConfig(checkPoint, checkPoint, checkPoint), new ControlHead(0, 0, 0, 0L, 15, null));
            String string6 = totalBackupDir.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getPath(...)");
            OlapControlFile.save$default(olapControlFile, string6, false, 2, null);
            String string7 = totalBackupDir.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"getName(...)");
            this.backupRecordWorkspace.writeBackupRecord(string7, checkPoint, checkPoint);
        }
        catch (Throwable t2) {
            if (totalBackupDir != null) {
                FileTools.INSTANCE.deleteDir(totalBackupDir);
            }
            throw t2;
        }
    }

    private final void replyDifferCube(ReplicationWorkspace replicationWorkspace, long backupPoint, long checkPoint, String totalBackupPath, TotalBackupBuilderV1 backupBuilder, IOlapLogger logger2) {
        BackupReplayItems replayItems = this.redoItr(backupPoint, checkPoint, backupBuilder, totalBackupPath);
        if (replayItems.getSize() == 0) {
            return;
        }
        Map $this$forEach$iv = replayItems.getReplayMap();
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator2.next();
            boolean bl = false;
            BackupReplayInfo item = (BackupReplayInfo)entry.getValue();
            IOlapLogger iOlapLogger = logger2;
            if (iOlapLogger == null) continue;
            iOlapLogger.info("TotalBackup replay info: cubeName: " + item.getCubeName() + ", lastMetadataTid: " + item.getLastMetadataTid() + ", curTid: " + item.getCurTid() + ", type: " + (Object)((Object)item.getType()));
        }
        this.recoveryAndReplay(totalBackupPath, backupBuilder, backupPoint, checkPoint, replicationWorkspace, replayItems);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void recoveryAndReplay(String totalBackupPath, TotalBackupBuilderV1 backupBuilder, long backupPoint, long checkPoint, ReplicationWorkspace replicationWorkspace, BackupReplayItems replayItems) {
        File tempDir = null;
        try {
            Closeable closeable;
            ReplicationWorkspace replicationWorkspace2;
            tempDir = ITempFolder.Companion.createTempDirectory("OlapCompensate_TotalBackup");
            String string2 = tempDir.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
            String[] stringArray = new String[]{"tmpDatabase"};
            String tempDirDatabasePath = ((Object)Paths.INSTANCE.get(string2, stringArray).toAbsolutePath()).toString();
            FileTools.INSTANCE.autoMakeDir(tempDirDatabasePath);
            ReplicationWorkspace tmpOlapWorkspace = null;
            try {
                tmpOlapWorkspace = ReplicationWorkspace.Companion.createNoneWorkspace(tempDirDatabasePath);
                HashSet<String> cubeNameSet = replayItems.getNeedRecoveryCubes();
                String[] stringArray2 = new String[]{"total", totalBackupPath};
                OlapRecovery.Companion.recovery(tmpOlapWorkspace.getOlapWorkspace$bos_olap_core2(), ((Object)Paths.INSTANCE.get(this.backupPath, stringArray2)).toString(), this.backupPath, backupBuilder, (Set<String>)cubeNameSet);
                this.redoReplay(backupPoint, checkPoint, tmpOlapWorkspace, replicationWorkspace, replayItems);
                String string3 = tempDir.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getPath(...)");
                String[] stringArray3 = new String[]{"tmpBackup"};
                File tempDirBackup = Paths.INSTANCE.joinToFile(string3, stringArray3);
                String string4 = tempDirBackup.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getPath(...)");
                FileTools.INSTANCE.autoMakeDir(string4);
                HashSet<String> backupList = replayItems.getBackupCubes();
                OlapWorkspace olapWorkspace = tmpOlapWorkspace.getOlapWorkspace$bos_olap_core2();
                String string5 = tempDirBackup.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getPath(...)");
                Companion.backup(olapWorkspace, string5, (Set<String>)backupList);
                File[] fileArray = tempDirBackup.listFiles();
                if (fileArray != null) {
                    File[] $this$forEach$iv = fileArray;
                    boolean $i$f$forEach = false;
                    int n = $this$forEach$iv.length;
                    for (int i = 0; i < n; ++i) {
                        File element$iv;
                        File file = element$iv = $this$forEach$iv[i];
                        boolean bl = false;
                        if (!file.isFile()) continue;
                        Intrinsics.checkNotNull((Object)file);
                        if (!Intrinsics.areEqual((Object)FilesKt.getExtension((File)file), (Object)"backup")) continue;
                        String cubeName = FilesKt.getNameWithoutExtension((File)file);
                        String[] stringArray4 = new String[]{"-"};
                        String prefix = (String)StringsKt.split$default((CharSequence)totalBackupPath, (String[])stringArray4, (boolean)false, (int)2, (int)2, null).get(0);
                        String cubeBackupFileName = cubeName + '-' + prefix + ".backup";
                        String[] stringArray5 = new String[]{cubeName, cubeBackupFileName};
                        File destFile = Paths.INSTANCE.joinToFile(this.backupPath, stringArray5);
                        destFile.delete();
                        FileUtils.moveFile((File)file, (File)destFile);
                    }
                }
                this.dealIndexJsonAndBackupJson(totalBackupPath, tmpOlapWorkspace, replayItems, backupBuilder);
                replicationWorkspace2 = tmpOlapWorkspace;
            }
            catch (Throwable throwable) {
                Closeable closeable2;
                ReplicationWorkspace replicationWorkspace3 = tmpOlapWorkspace;
                if (replicationWorkspace3 != null) {
                    replicationWorkspace3.close();
                }
                if ((closeable2 = tmpOlapWorkspace) != null && (closeable2 = ((ReplicationWorkspace)closeable2).getOlapWorkspace$bos_olap_core2()) != null) {
                    ((OlapWorkspace)closeable2).close();
                }
                throw throwable;
            }
            if (replicationWorkspace2 != null) {
                replicationWorkspace2.close();
            }
            if ((closeable = tmpOlapWorkspace) != null && (closeable = ((ReplicationWorkspace)closeable).getOlapWorkspace$bos_olap_core2()) != null) {
                ((OlapWorkspace)closeable).close();
            }
        }
        finally {
            if (tempDir != null) {
                FileTools.INSTANCE.deleteDir(tempDir);
            }
        }
    }

    private final void dealIndexJsonAndBackupJson(String totalBackupPath, ReplicationWorkspace tmpOlapWorkspace, BackupReplayItems replayItems, TotalBackupBuilderV1 backupBuilder) {
        Object element$iv;
        HashSet<String> dropCubes = replayItems.getDropCubes();
        String[] stringArray = new String[]{"total", totalBackupPath};
        OlapMetadataBuilder indexJsonBuilder = OlapMetadataBuilder.Companion.readFrom(((Object)Paths.INSTANCE.get(this.backupPath, stringArray)).toString());
        Iterable $this$forEach$iv = dropCubes;
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            String it = (String)element$iv2;
            boolean bl = false;
            backupBuilder.remove(it);
            indexJsonBuilder.remove(it);
        }
        OlapMetadata replayedIndexJson = OlapMetadataBuilder.Companion.readFrom(tmpOlapWorkspace.getOlapWorkspace$bos_olap_core2().getRootPath()).build();
        Object $this$forEach$iv2 = replayedIndexJson.getCubes();
        boolean $i$f$forEach2 = false;
        Iterator<Object> iterator2 = $this$forEach$iv2.iterator();
        while (iterator2.hasNext()) {
            element$iv = iterator2.next();
            CubeEntry cube = (CubeEntry)element$iv;
            boolean bl = false;
            HashMap<String, String> propertyMap = new HashMap<String, String>();
            Map $this$forEach$iv3 = cube.getProperties();
            boolean $i$f$forEach3 = false;
            Iterator iterator3 = $this$forEach$iv3.entrySet().iterator();
            while (iterator3.hasNext()) {
                Map.Entry element$iv3;
                Map.Entry it = element$iv3 = iterator3.next();
                boolean bl2 = false;
                ((Map)propertyMap).put(it.getKey(), it.getValue());
            }
            indexJsonBuilder.remove(cube.getName());
            List<CubeEntry> list2 = indexJsonBuilder.getCubes();
            Integer n = replayItems.getCubeId(cube.getName());
            Intrinsics.checkNotNull((Object)n);
            list2.add(new CubeEntry(n, cube.getName(), propertyMap));
        }
        indexJsonBuilder.setMaxId(Math.max(indexJsonBuilder.getMaxId(), replayItems.getMaxCubeId()));
        indexJsonBuilder.save();
        $this$forEach$iv2 = replayItems.getReplayMap();
        $i$f$forEach2 = false;
        iterator2 = $this$forEach$iv2.entrySet().iterator();
        while (iterator2.hasNext()) {
            Object it = element$iv = (Map.Entry)iterator2.next();
            boolean bl = false;
            BackupReplayInfo info = (BackupReplayInfo)it.getValue();
            if (info.getType() == BackupReplayType.DELETE) continue;
            backupBuilder.set(info.getCubeName(), new CubeMapValue(info.getCurTid(), info.getCubeName() + '-' + replayItems.getPrefixTotalBackupPath() + ".backup"));
        }
    }

    private final void redoReplay(long backupPoint, long checkPoint, ReplicationWorkspace tmpOlapWorkspace, ReplicationWorkspace replicationWorkspace, BackupReplayItems replayItems) {
        SlaveLSNContext slaveContext = new SlaveLSNContext(backupPoint, checkPoint, checkPoint);
        ReplayCoordinator coordinator = new ReplayCoordinator(tmpOlapWorkspace.getOlapWorkspace$bos_olap_core2(), slaveContext, replicationWorkspace.getRedoSeqLogger$bos_olap_core2().getRootPath(), replicationWorkspace.getBackupRecordWorkspace().getBackupPath(), tmpOlapWorkspace.getLogger$bos_olap_core2(), new ReplayContext(null, true, false, true, replayItems, 5, null));
        coordinator.start();
        while (true) {
            if (coordinator.isError()) {
                String string2 = Res.INSTANCE.getOlapBackupException_4();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-OlapBackupException_4>(...)");
                Object[] objectArray = new Object[]{backupPoint, checkPoint};
                throw Res.INSTANCE.getRuntimeException(string2, objectArray);
            }
            if (slaveContext.getNextReadPage() == checkPoint) {
                coordinator.close();
                if (!coordinator.isError()) break;
                String string3 = Res.INSTANCE.getOlapBackupException_4();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"<get-OlapBackupException_4>(...)");
                Object[] objectArray = new Object[]{backupPoint, checkPoint};
                throw Res.INSTANCE.getRuntimeException(string3, objectArray);
            }
            Thread.sleep(10L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final BackupReplayItems redoItr(long backupPoint, long checkPoint, TotalBackupBuilderV1 totalBackupBuilder, String totalBackupPath) {
        String[] stringArray = new String[]{"-"};
        String prefix = (String)StringsKt.split$default((CharSequence)totalBackupPath, (String[])stringArray, (boolean)false, (int)2, (int)2, null).get(0);
        BackupReplayItems replayItems = new BackupReplayItems(prefix);
        SeqRedoLogger redoSeqLogger = new SeqRedoLogger(this.replicationWorkspace.getRedoSeqLogger$bos_olap_core2().getRootPath(), 16, new SeqRedoLogNameStrategy(".redo", ".redoz"), null, false, 8, null);
        SeqRedoLogger incrementRedoSeqLogger2 = new SeqRedoLogger(RedoUtil.INSTANCE.getOrCreateIncrementPath(this.replicationWorkspace.getBackupRecordWorkspace().getBackupPath()), 16, new SeqRedoLogNameStrategy(".redo", ".redoz"), null, true, 8, null);
        SlaveLSNContext slaveLSNContext = new SlaveLSNContext(backupPoint, checkPoint, checkPoint);
        RedoRecordCombineReader recordItr = new RedoRecordCombineReader(redoSeqLogger, incrementRedoSeqLogger2, slaveLSNContext, null, false, 24, null);
        Closeable closeable = recordItr;
        Throwable throwable = null;
        try {
            RedoRecordCombineReader it = (RedoRecordCombineReader)closeable;
            boolean bl = false;
            while (recordItr.next()) {
                boolean isValidTid;
                String cubeName;
                RedoRecordWithPage recordWithPage = recordItr.getCurrent();
                RedoPageInfo page = recordWithPage.getStartPage();
                int n = page.getVersion();
                if (!(0 <= n ? n < 4 : false)) {
                    throw Res.INSTANCE.getNotSupportedException("replay error,not support new page version.", new Object[0]);
                }
                IRedoRecord record = recordWithPage.getRecord();
                replayItems.setMaxCubeId(Math.max(replayItems.getMaxCubeId(), record.getCubeId()));
                if (record.getRedoType() == RedoType.CubeRecover) {
                    Intrinsics.checkNotNull((Object)record, (String)"null cannot be cast to non-null type kd.bos.olapServer2.replication.CubeRecoverRecord");
                    cubeName = ((CubeRecoverRecord)record).getCubeName();
                    BackupReplayInfo replayInfo = new BackupReplayInfo(cubeName, Long.MIN_VALUE, record.getTid(), BackupReplayType.NEW);
                    replayItems.set(record.getCubeId(), replayInfo);
                    continue;
                }
                if (record.getRedoType() == RedoType.METADATA) {
                    Intrinsics.checkNotNull((Object)record, (String)"null cannot be cast to non-null type kd.bos.olapServer2.replication.IDDLRecord");
                    String ddlCmd = ((IDDLRecord)record).getDDLCommand();
                    MetadataCommandInfo command = (MetadataCommandInfo)JsonHelper.INSTANCE.getMapper().readValue(ddlCmd, MetadataCommandInfo.class);
                    if (command.getMetadataType() == MetadataTypes.Cube) {
                        BackupReplayInfo replayInfo;
                        if (command.getAction() == CommandTypes.drop) {
                            replayInfo = new BackupReplayInfo(command.getName(), Long.MIN_VALUE, record.getTid(), BackupReplayType.DELETE);
                            replayItems.set(record.getCubeId(), replayInfo);
                            continue;
                        }
                        if (command.getAction() == CommandTypes.create) {
                            replayInfo = new BackupReplayInfo(command.getName(), Long.MIN_VALUE, record.getTid(), BackupReplayType.NEW);
                            replayItems.set(record.getCubeId(), replayInfo);
                            continue;
                        }
                    }
                }
                if (replayItems.isCreateCube(record.getCubeId())) {
                    replayItems.updateCurTid(record.getCubeId(), record.getTid());
                    continue;
                }
                cubeName = this.getCubeNameByCubeId(record.getCubeId());
                if (cubeName == null) continue;
                boolean bl2 = isValidTid = record.getTid() > 0L && record.getTid() <= totalBackupBuilder.get(cubeName).getTid() && record.getRedoType() == RedoType.METADATA;
                if (replayItems.contains(record.getCubeId())) {
                    if (isValidTid) {
                        replayItems.updateLastMetadataTid(record.getCubeId(), record.getTid());
                    }
                    replayItems.updateCurTid(record.getCubeId(), record.getTid());
                    continue;
                }
                long tid = isValidTid ? record.getTid() : Long.MIN_VALUE;
                BackupReplayInfo replayInfo = new BackupReplayInfo(cubeName, tid, record.getTid(), BackupReplayType.REPLAY);
                replayItems.set(record.getCubeId(), replayInfo);
            }
            if (!(slaveLSNContext.getNextReadPage() == checkPoint)) {
                boolean bl3 = false;
                String string2 = "read redo error: slaveLSNContext.nextReadPage: " + slaveLSNContext.getNextReadPage() + ", checkPoint: " + checkPoint;
                throw new IllegalArgumentException(string2.toString());
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return replayItems;
    }

    private final String getCubeNameByCubeId(int cubeId) {
        return this.replicationWorkspace.getOlapWorkspace$bos_olap_core2().getMetadata().getCubes().tryGetCubeNameById(cubeId);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u00060\nj\u0002`\u000bJ,\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u00060\nj\u0002`\u000b2\u0010\u0010\f\u001a\f\u0012\b\u0012\u00060\nj\u0002`\u000b0\rJ*\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u000f2\n\u0010\t\u001a\u00060\nj\u0002`\u000b2\u0006\u0010\u0011\u001a\u00020\u0012J$\u0010\u0013\u001a\u00060\nj\u0002`\u000b2\n\u0010\t\u001a\u00060\nj\u0002`\u000b2\n\u0010\u0014\u001a\u00060\nj\u0002`\u000bH\u0002J\u001e\u0010\u0015\u001a\u00020\u00122\n\u0010\t\u001a\u00060\nj\u0002`\u000b2\n\u0010\u0016\u001a\u00060\nj\u0002`\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lkd/bos/olapServer2/replication/OlapBackup$Companion;", "", "()V", "WAITCHECKPOINTTIMEOUT", "", "backup", "", "olapWorkspace", "Lkd/bos/olapServer2/storages/OlapWorkspace;", "backupPath", "", "Lkd/bos/olapServer2/common/string;", "backupList", "", "differBackup", "Lkd/bos/olapServer2/replication/TotalBackupBuilderV1;", "preTotal", "totalBackupDir", "Ljava/io/File;", "getOrCreateCubeFolder", "cubeName", "getOrCreateTotalFolder", "totalName", "bos-olap-core2"})
    @SourceDebugExtension(value={"SMAP\nOlapBackup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OlapBackup.kt\nkd/bos/olapServer2/replication/OlapBackup$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,565:1\n1855#2,2:566\n1855#2,2:568\n1855#2,2:570\n*S KotlinDebug\n*F\n+ 1 OlapBackup.kt\nkd/bos/olapServer2/replication/OlapBackup$Companion\n*L\n448#1:566,2\n519#1:568,2\n543#1:570,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TotalBackupBuilderV1 differBackup(@NotNull OlapWorkspace olapWorkspace, @NotNull TotalBackupBuilderV1 preTotal, @NotNull String backupPath, @NotNull File totalBackupDir) {
            Intrinsics.checkNotNullParameter((Object)olapWorkspace, (String)"olapWorkspace");
            Intrinsics.checkNotNullParameter((Object)preTotal, (String)"preTotal");
            Intrinsics.checkNotNullParameter((Object)backupPath, (String)"backupPath");
            Intrinsics.checkNotNullParameter((Object)totalBackupDir, (String)"totalBackupDir");
            String rootPath = olapWorkspace.getRootPath();
            TotalBackupBuilderV1 backupBuilder = new TotalBackupBuilderV1();
            OlapMetadata metadata = olapWorkspace.getMetadata();
            Iterable $this$forEach$iv = metadata.getCubes();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CubeEntry cubeEntry = (CubeEntry)element$iv;
                boolean bl = false;
                String metaCubeName = cubeEntry.getName();
                CubeWorkspaceCreator cubeWorkspaceCreator = olapWorkspace.tryGetCubeWorkspaceCreator(metaCubeName);
                if (cubeWorkspaceCreator == null) continue;
                boolean isNeedUnload = !cubeWorkspaceCreator.isInitialized();
                try {
                    cubeWorkspaceCreator.enterReadForBackup((Function2)new Function2<CubeWorkspace, Closeable, Unit>(preTotal, metaCubeName, backupPath, totalBackupDir, backupBuilder, rootPath){
                        final /* synthetic */ TotalBackupBuilderV1 $preTotal;
                        final /* synthetic */ String $metaCubeName;
                        final /* synthetic */ String $backupPath;
                        final /* synthetic */ File $totalBackupDir;
                        final /* synthetic */ TotalBackupBuilderV1 $backupBuilder;
                        final /* synthetic */ String $rootPath;
                        {
                            this.$preTotal = $preTotal;
                            this.$metaCubeName = $metaCubeName;
                            this.$backupPath = $backupPath;
                            this.$totalBackupDir = $totalBackupDir;
                            this.$backupBuilder = $backupBuilder;
                            this.$rootPath = $rootPath;
                            super(2);
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public final void invoke(@NotNull CubeWorkspace cubeWorkspace, @NotNull Closeable lock) {
                            Intrinsics.checkNotNullParameter((Object)cubeWorkspace, (String)"cubeWorkspace");
                            Intrinsics.checkNotNullParameter((Object)lock, (String)"lock");
                            CubeMapValue lastMapValue = this.$preTotal.tryGet(this.$metaCubeName);
                            if (lastMapValue == null || lastMapValue.getTid() == 0L || cubeWorkspace.getTransactionManager().getLastCommittedTransactionId() != lastMapValue.getTid()) {
                                String cubeDir = kd.bos.olapServer2.replication.OlapBackup$Companion.access$getOrCreateCubeFolder(OlapBackup.Companion, this.$backupPath, this.$metaCubeName);
                                String string2 = this.$totalBackupDir.getName();
                                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                                String[] stringArray = new String[]{"-"};
                                String prefix = (String)StringsKt.split$default((CharSequence)string2, (String[])stringArray, (boolean)false, (int)2, (int)2, null).get(0);
                                String cubeFileName = this.$metaCubeName + '-' + prefix + ".backup";
                                File backupFile = Paths.INSTANCE.toFile(cubeDir, cubeFileName);
                                Closeable closeable = PathsKt.safeOutputStream(backupFile);
                                String string3 = this.$rootPath;
                                TotalBackupBuilderV1 totalBackupBuilderV1 = this.$backupBuilder;
                                String string4 = this.$metaCubeName;
                                Throwable throwable = null;
                                try {
                                    FileOutputStream outputStream = (FileOutputStream)closeable;
                                    boolean bl = false;
                                    Closeable closeable2 = new CubeBackup(cubeWorkspace, outputStream, lock, string3);
                                    Throwable throwable2 = null;
                                    try {
                                        CubeBackup it = (CubeBackup)closeable2;
                                        boolean bl2 = false;
                                        long tid = it.backup();
                                        totalBackupBuilderV1.set(string4, new CubeMapValue(tid, cubeFileName));
                                        Unit unit = Unit.INSTANCE;
                                    }
                                    catch (Throwable throwable3) {
                                        throwable2 = throwable3;
                                        throw throwable3;
                                    }
                                    finally {
                                        CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                                    }
                                    Unit unit = Unit.INSTANCE;
                                }
                                catch (Throwable throwable4) {
                                    throwable = throwable4;
                                    throw throwable4;
                                }
                                finally {
                                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                                }
                            }
                            this.$backupBuilder.set(this.$metaCubeName, lastMapValue);
                        }
                    });
                    if (!isNeedUnload) continue;
                    cubeWorkspaceCreator.tryUnload();
                }
                catch (Exception ex) {
                    throw new OlapRuntimeException("backup " + metaCubeName + " failed. " + ex.getMessage(), metaCubeName, ex);
                }
            }
            File indexJsonFile = Paths.INSTANCE.toFile(rootPath, "index.json");
            String string2 = indexJsonFile.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            FilesKt.copyTo$default((File)indexJsonFile, (File)Paths.INSTANCE.toFile(totalBackupDir, string2), (boolean)false, (int)0, (int)6, null);
            return backupBuilder;
        }

        private final String getOrCreateCubeFolder(String backupPath, String cubeName) {
            String cubePath = RedoUtil.INSTANCE.getCubeBackupFolder(backupPath, cubeName).getAbsolutePath();
            Intrinsics.checkNotNull((Object)cubePath);
            FileTools.INSTANCE.autoMakeDir(cubePath);
            return cubePath;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void backup(@NotNull OlapWorkspace olapWorkspace, @NotNull String backupPath) {
            Intrinsics.checkNotNullParameter((Object)olapWorkspace, (String)"olapWorkspace");
            Intrinsics.checkNotNullParameter((Object)backupPath, (String)"backupPath");
            String rootPath = olapWorkspace.getRootPath();
            Closeable closeable = new DefaultThreadPoolExecutor("totalBackup");
            Throwable throwable = null;
            try {
                DefaultThreadPoolExecutor threadPool = (DefaultThreadPoolExecutor)closeable;
                boolean bl = false;
                Iterable $this$forEach$iv = olapWorkspace.getMetadata().getCubes();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    CubeEntry cubeEntry = (CubeEntry)element$iv;
                    boolean bl2 = false;
                    String metaCubeName = cubeEntry.getName();
                    threadPool.submit((Function0<Unit>)((Function0)new Function0<Unit>(backupPath, metaCubeName, olapWorkspace, rootPath){
                        final /* synthetic */ String $backupPath;
                        final /* synthetic */ String $metaCubeName;
                        final /* synthetic */ OlapWorkspace $olapWorkspace;
                        final /* synthetic */ String $rootPath;
                        {
                            this.$backupPath = $backupPath;
                            this.$metaCubeName = $metaCubeName;
                            this.$olapWorkspace = $olapWorkspace;
                            this.$rootPath = $rootPath;
                            super(0);
                        }

                        public final void invoke() {
                            File backupFile = Paths.INSTANCE.toFile(this.$backupPath, this.$metaCubeName + ".backup");
                            this.$olapWorkspace.enterReadForBackup(this.$metaCubeName, (Function2)new Function2<CubeWorkspace, Closeable, Unit>(backupFile, this.$rootPath){
                                final /* synthetic */ File $backupFile;
                                final /* synthetic */ String $rootPath;
                                {
                                    this.$backupFile = $backupFile;
                                    this.$rootPath = $rootPath;
                                    super(2);
                                }

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public final void invoke(@NotNull CubeWorkspace cubeWorkspace, @NotNull Closeable lock) {
                                    Intrinsics.checkNotNullParameter((Object)cubeWorkspace, (String)"cubeWorkspace");
                                    Intrinsics.checkNotNullParameter((Object)lock, (String)"lock");
                                    Closeable closeable = PathsKt.safeOutputStream(this.$backupFile);
                                    String string2 = this.$rootPath;
                                    Throwable throwable = null;
                                    try {
                                        FileOutputStream outputStream = (FileOutputStream)closeable;
                                        boolean bl = false;
                                        Closeable closeable2 = new CubeBackup(cubeWorkspace, outputStream, lock, string2);
                                        Throwable throwable2 = null;
                                        try {
                                            CubeBackup it = (CubeBackup)closeable2;
                                            boolean bl2 = false;
                                            it.backup();
                                            Unit unit = Unit.INSTANCE;
                                        }
                                        catch (Throwable throwable3) {
                                            throwable2 = throwable3;
                                            throw throwable3;
                                        }
                                        finally {
                                            CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                                        }
                                        Unit unit = Unit.INSTANCE;
                                    }
                                    catch (Throwable throwable4) {
                                        throwable = throwable4;
                                        throw throwable4;
                                    }
                                    finally {
                                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                                    }
                                }
                            });
                        }
                    }));
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            File indexJsonFile = Paths.INSTANCE.toFile(rootPath, "index.json");
            String string2 = indexJsonFile.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            FilesKt.copyTo$default((File)indexJsonFile, (File)Paths.INSTANCE.toFile(backupPath, string2), (boolean)false, (int)0, (int)6, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void backup(@NotNull OlapWorkspace olapWorkspace, @NotNull String backupPath, @NotNull Set<String> backupList) {
            Intrinsics.checkNotNullParameter((Object)olapWorkspace, (String)"olapWorkspace");
            Intrinsics.checkNotNullParameter((Object)backupPath, (String)"backupPath");
            Intrinsics.checkNotNullParameter(backupList, (String)"backupList");
            String rootPath = olapWorkspace.getRootPath();
            Closeable closeable = new DefaultThreadPoolExecutor("totalBackup");
            Throwable throwable = null;
            try {
                DefaultThreadPoolExecutor threadPool = (DefaultThreadPoolExecutor)closeable;
                boolean bl = false;
                Iterable $this$forEach$iv = backupList;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String metaCubeName = (String)element$iv;
                    boolean bl2 = false;
                    threadPool.submit((Function0<Unit>)((Function0)new Function0<Unit>(backupPath, metaCubeName, olapWorkspace, rootPath){
                        final /* synthetic */ String $backupPath;
                        final /* synthetic */ String $metaCubeName;
                        final /* synthetic */ OlapWorkspace $olapWorkspace;
                        final /* synthetic */ String $rootPath;
                        {
                            this.$backupPath = $backupPath;
                            this.$metaCubeName = $metaCubeName;
                            this.$olapWorkspace = $olapWorkspace;
                            this.$rootPath = $rootPath;
                            super(0);
                        }

                        public final void invoke() {
                            File backupFile = Paths.INSTANCE.toFile(this.$backupPath, this.$metaCubeName + ".backup");
                            this.$olapWorkspace.enterReadForBackup(this.$metaCubeName, (Function2)new Function2<CubeWorkspace, Closeable, Unit>(backupFile, this.$rootPath){
                                final /* synthetic */ File $backupFile;
                                final /* synthetic */ String $rootPath;
                                {
                                    this.$backupFile = $backupFile;
                                    this.$rootPath = $rootPath;
                                    super(2);
                                }

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public final void invoke(@NotNull CubeWorkspace cubeWorkspace, @NotNull Closeable lock) {
                                    Intrinsics.checkNotNullParameter((Object)cubeWorkspace, (String)"cubeWorkspace");
                                    Intrinsics.checkNotNullParameter((Object)lock, (String)"lock");
                                    Closeable closeable = PathsKt.safeOutputStream(this.$backupFile);
                                    String string2 = this.$rootPath;
                                    Throwable throwable = null;
                                    try {
                                        FileOutputStream outputStream = (FileOutputStream)closeable;
                                        boolean bl = false;
                                        Closeable closeable2 = new CubeBackup(cubeWorkspace, outputStream, lock, string2);
                                        Throwable throwable2 = null;
                                        try {
                                            CubeBackup it = (CubeBackup)closeable2;
                                            boolean bl2 = false;
                                            it.backup();
                                            Unit unit = Unit.INSTANCE;
                                        }
                                        catch (Throwable throwable3) {
                                            throwable2 = throwable3;
                                            throw throwable3;
                                        }
                                        finally {
                                            CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                                        }
                                        Unit unit = Unit.INSTANCE;
                                    }
                                    catch (Throwable throwable4) {
                                        throwable = throwable4;
                                        throw throwable4;
                                    }
                                    finally {
                                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                                    }
                                }
                            });
                        }
                    }));
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }

        @NotNull
        public final File getOrCreateTotalFolder(@NotNull String backupPath, @NotNull String totalName) {
            Intrinsics.checkNotNullParameter((Object)backupPath, (String)"backupPath");
            Intrinsics.checkNotNullParameter((Object)totalName, (String)"totalName");
            return RedoUtil.INSTANCE.getTotalRecordFolder(backupPath, totalName, true);
        }

        public static final /* synthetic */ String access$getOrCreateCubeFolder(Companion $this, String backupPath, String cubeName) {
            return $this.getOrCreateCubeFolder(backupPath, cubeName);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

