/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.replication;

import kd.bos.olapServer2.replication.BackupType;
import kd.bos.olapServer2.replication.IReplicationNode;
import kd.bos.olapServer2.replication.ReplicationMaster;
import kd.bos.olapServer2.replication.ReplicationNone;
import kd.bos.olapServer2.replication.ReplicationSlave;
import kd.bos.olapServer2.replication.ReplicationStatus;
import kd.bos.olapServer2.security.OlapActions;
import kd.bos.olapServer2.server.ReplicationWorkspace;
import kd.bos.olapServer2.tools.Res;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0002J\u0006\u0010\t\u001a\u00020\bJ\b\u0010\n\u001a\u00020\bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lkd/bos/olapServer2/replication/OlapBackupCommandExecutor;", "", "replicationWorkspace", "Lkd/bos/olapServer2/server/ReplicationWorkspace;", "backupType", "Lkd/bos/olapServer2/replication/BackupType;", "(Lkd/bos/olapServer2/server/ReplicationWorkspace;Lkd/bos/olapServer2/replication/BackupType;)V", "masterOlapBackup", "", "run", "slaveOlapBackup", "Companion", "bos-olap-core2"})
public final class OlapBackupCommandExecutor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ReplicationWorkspace replicationWorkspace;
    @NotNull
    private final BackupType backupType;

    public OlapBackupCommandExecutor(@NotNull ReplicationWorkspace replicationWorkspace, @NotNull BackupType backupType) {
        Intrinsics.checkNotNullParameter((Object)replicationWorkspace, (String)"replicationWorkspace");
        Intrinsics.checkNotNullParameter((Object)((Object)backupType), (String)"backupType");
        this.replicationWorkspace = replicationWorkspace;
        this.backupType = backupType;
    }

    public final void run() {
        if (this.replicationWorkspace.getCurrentNode().getValue() instanceof ReplicationNone) {
            String string2 = Res.INSTANCE.getOlapBackupCommandExecutorException_1();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-OlapBackupCommandExecutorException_1>(...)");
            Object[] objectArray = new Object[]{this.replicationWorkspace.getStatus()};
            throw Res.INSTANCE.getNotSupportedException(string2, objectArray);
        }
        this.replicationWorkspace.verify$bos_olap_core2(null, OlapActions.ActionTotalBackup);
        switch (WhenMappings.$EnumSwitchMapping$0[this.replicationWorkspace.getStatus().ordinal()]) {
            case 1: {
                this.masterOlapBackup();
                break;
            }
            case 2: {
                this.slaveOlapBackup();
                break;
            }
            default: {
                String string3 = Res.INSTANCE.getOlapBackupCommandExecutorException_1();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"<get-OlapBackupCommandExecutorException_1>(...)");
                Object[] objectArray = new Object[]{this.replicationWorkspace.getStatus()};
                throw Res.INSTANCE.getNotSupportedException(string3, objectArray);
            }
        }
    }

    private final void masterOlapBackup() {
        switch (WhenMappings.$EnumSwitchMapping$1[this.backupType.ordinal()]) {
            case 1: {
                IReplicationNode masterNode = this.replicationWorkspace.getCurrentNode().getValue();
                if (!(masterNode instanceof ReplicationMaster)) {
                    String string2 = "Failed requirement.";
                    throw new IllegalArgumentException(string2.toString());
                }
                ((ReplicationMaster)masterNode).totalBackup();
                break;
            }
            case 2: {
                kd.bos.olapServer2.replication.OlapBackupCommandExecutor$Companion.lockTotalBackup$default(Companion, this.replicationWorkspace, null, 2, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void slaveOlapBackup() {
        if (!this.replicationWorkspace.compareAndSetStatus(ReplicationStatus.Slave, ReplicationStatus.Backup)) return;
        try {
            IReplicationNode slaveNode = this.replicationWorkspace.getCurrentNode().getValue();
            if (!(slaveNode instanceof ReplicationSlave)) {
                String string2 = "Failed requirement.";
                throw new IllegalArgumentException(string2.toString());
            }
            switch (WhenMappings.$EnumSwitchMapping$1[this.backupType.ordinal()]) {
                case 1: 
                case 2: {
                    this.replicationWorkspace.getOlapWorkspace$bos_olap_core2().getLockManager().enterWrite((Function0)new Function0<Unit>(slaveNode){
                        final /* synthetic */ IReplicationNode $slaveNode;
                        {
                            this.$slaveNode = $slaveNode;
                            super(0);
                        }

                        public final void invoke() {
                            ((ReplicationSlave)this.$slaveNode).totalBackup();
                        }
                    });
                    return;
                }
            }
            return;
        }
        finally {
            this.replicationWorkspace.compareAndSetStatus(ReplicationStatus.Backup, ReplicationStatus.Slave);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lkd/bos/olapServer2/replication/OlapBackupCommandExecutor$Companion;", "", "()V", "lockTotalBackup", "", "replicationWorkspace", "Lkd/bos/olapServer2/server/ReplicationWorkspace;", "expectStatus", "Lkd/bos/olapServer2/replication/ReplicationStatus;", "bos-olap-core2"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void lockTotalBackup(@NotNull ReplicationWorkspace replicationWorkspace, @NotNull ReplicationStatus expectStatus) {
            block4: {
                Intrinsics.checkNotNullParameter((Object)replicationWorkspace, (String)"replicationWorkspace");
                Intrinsics.checkNotNullParameter((Object)((Object)expectStatus), (String)"expectStatus");
                try {
                    if (replicationWorkspace.compareAndSetStatus(expectStatus, ReplicationStatus.Backup)) {
                        replicationWorkspace.getOlapWorkspace$bos_olap_core2().getOlapMetadataLock().enterRead((Function0)new Function0<Unit>(replicationWorkspace){
                            final /* synthetic */ ReplicationWorkspace $replicationWorkspace;
                            {
                                this.$replicationWorkspace = $replicationWorkspace;
                                super(0);
                            }

                            public final void invoke() {
                                IReplicationNode masterNode = this.$replicationWorkspace.getCurrentNode().getValue();
                                if (!(masterNode instanceof ReplicationMaster)) {
                                    String string2 = "Failed requirement.";
                                    throw new IllegalArgumentException(string2.toString());
                                }
                                ((ReplicationMaster)masterNode).lockTotalBackup();
                            }
                        });
                        break block4;
                    }
                    String string2 = Res.INSTANCE.getReplicationManagerException_3();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-ReplicationManagerException_3>(...)");
                    Object[] objectArray = new Object[]{replicationWorkspace.getStatus()};
                    throw Res.INSTANCE.getRuntimeException(string2, objectArray);
                }
                finally {
                    replicationWorkspace.compareAndSetStatus(ReplicationStatus.Backup, expectStatus);
                }
            }
        }

        public static /* synthetic */ void lockTotalBackup$default(Companion companion, ReplicationWorkspace replicationWorkspace, ReplicationStatus replicationStatus, int n, Object object2) {
            if ((n & 2) != 0) {
                replicationStatus = ReplicationStatus.Master;
            }
            companion.lockTotalBackup(replicationWorkspace, replicationStatus);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[ReplicationStatus.values().length];
            try {
                nArray[ReplicationStatus.Master.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReplicationStatus.Slave.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[BackupType.values().length];
            try {
                nArray[BackupType.Total.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BackupType.LockTotal.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

