/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.replication;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import kd.bos.olapServer2.common.Paths;
import kd.bos.olapServer2.common.PathsKt;
import kd.bos.olapServer2.replication.ControlConfig;
import kd.bos.olapServer2.replication.ControlHead;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u00060\u000ej\u0002`\u000f2\f\b\u0002\u0010\u0010\u001a\u00060\u0011j\u0002`\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lkd/bos/olapServer2/replication/OlapControlFile;", "", "controlConfig", "Lkd/bos/olapServer2/replication/ControlConfig;", "controlHead", "Lkd/bos/olapServer2/replication/ControlHead;", "(Lkd/bos/olapServer2/replication/ControlConfig;Lkd/bos/olapServer2/replication/ControlHead;)V", "getControlConfig", "()Lkd/bos/olapServer2/replication/ControlConfig;", "getControlHead", "()Lkd/bos/olapServer2/replication/ControlHead;", "save", "", "dataBasePath", "", "Lkd/bos/olapServer2/common/string;", "isIncludeFileName", "", "Lkd/bos/olapServer2/common/bool;", "Companion", "bos-olap-core2"})
public final class OlapControlFile {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ControlConfig controlConfig;
    @NotNull
    private final ControlHead controlHead;

    public OlapControlFile(@NotNull ControlConfig controlConfig, @NotNull ControlHead controlHead) {
        Intrinsics.checkNotNullParameter((Object)controlConfig, (String)"controlConfig");
        Intrinsics.checkNotNullParameter((Object)controlHead, (String)"controlHead");
        this.controlConfig = controlConfig;
        this.controlHead = controlHead;
    }

    @NotNull
    public final ControlConfig getControlConfig() {
        return this.controlConfig;
    }

    @NotNull
    public final ControlHead getControlHead() {
        return this.controlHead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void save(@NotNull String dataBasePath, boolean isIncludeFileName) {
        Intrinsics.checkNotNullParameter((Object)dataBasePath, (String)"dataBasePath");
        if (!Paths.INSTANCE.toFile(dataBasePath).exists()) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        File olapControlFile = isIncludeFileName ? Paths.INSTANCE.toFile(dataBasePath) : Paths.INSTANCE.toFile(dataBasePath, "olap.control");
        Closeable closeable = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(olapControlFile)));
        Throwable throwable = null;
        try {
            DataOutputStream it = (DataOutputStream)closeable;
            boolean bl = false;
            it.writeShort(this.controlHead.getVersion());
            it.writeShort(this.controlHead.getCRC());
            it.writeInt(this.controlHead.getRelease1());
            it.writeLong(this.controlHead.getRelease2());
            it.writeLong(this.controlConfig.getCheckPointLSN());
            it.writeLong(this.controlConfig.getRecoveryStartLSN());
            it.writeLong(this.controlConfig.getRecoveryEndLSN());
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public static /* synthetic */ void save$default(OlapControlFile olapControlFile, String string2, boolean bl, int n, Object object2) {
        if ((n & 2) != 0) {
            bl = false;
        }
        olapControlFile.save(string2, bl);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\n\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007J\u0012\u0010\b\u001a\u00020\u00042\n\u0010\t\u001a\u00060\u0006j\u0002`\u0007J\u0018\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lkd/bos/olapServer2/replication/OlapControlFile$Companion;", "", "()V", "readControlConfig", "Lkd/bos/olapServer2/replication/OlapControlFile;", "path", "", "Lkd/bos/olapServer2/common/string;", "readOlapControl", "filePath", "readV1", "dataInputStream", "Ljava/io/DataInputStream;", "version", "", "bos-olap-core2"})
    public static final class Companion {
        private Companion() {
        }

        private final OlapControlFile readV1(DataInputStream dataInputStream, short version) {
            short crc = dataInputStream.readShort();
            int release1 = dataInputStream.readInt();
            long release2 = dataInputStream.readLong();
            long checkPointLSN = dataInputStream.readLong();
            long startLSN = dataInputStream.readLong();
            long endLSN = dataInputStream.readLong();
            if (!(0L <= startLSN ? startLSN <= endLSN : false)) {
                String string2 = "Failed requirement.";
                throw new IllegalArgumentException(string2.toString());
            }
            ControlHead controlHead = new ControlHead(version, crc, release1, release2);
            return new OlapControlFile(new ControlConfig(startLSN, endLSN, checkPointLSN), controlHead);
        }

        @NotNull
        public final OlapControlFile readControlConfig(@NotNull String path) {
            OlapControlFile olapControlFile;
            Object filePath;
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Object object2 = new String[]{"olap.control"};
            object2 = Paths.INSTANCE.get(path, (String)object2);
            Object[] objectArray = new LinkOption[]{};
            if (Files.exists((Path)object2, Arrays.copyOf(objectArray, objectArray.length))) {
                objectArray = new String[]{"olap.control"};
                filePath = ((Object)Paths.INSTANCE.get(path, (String[])objectArray)).toString();
                olapControlFile = this.readOlapControl((String)filePath);
            } else {
                filePath = new String[]{"lsn.control"};
                if (Files.exists((Path)(filePath = Paths.INSTANCE.get(path, (String)filePath)), (LinkOption[])Arrays.copyOf(objectArray = new LinkOption[0], objectArray.length))) {
                    objectArray = new String[]{"lsn.control"};
                    ControlConfig controlConfig = ControlConfig.Companion.readControlConfig(((Object)Paths.INSTANCE.get(path, (String[])objectArray)).toString());
                    OlapControlFile.save$default(new OlapControlFile(controlConfig, new ControlHead(0, 0, 0, 0L, 15, null)), path, false, 2, null);
                    Paths.INSTANCE.toFile(path, "lsn.control").delete();
                    olapControlFile = new OlapControlFile(controlConfig, new ControlHead(0, 0, 0, 0L, 14, null));
                } else {
                    olapControlFile = new OlapControlFile(new ControlConfig(0L, 0L, 0L), new ControlHead(0, 0, 0, 0L, 15, null));
                }
            }
            return olapControlFile;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final OlapControlFile readOlapControl(@NotNull String filePath) {
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            Closeable closeable = new DataInputStream(new BufferedInputStream(PathsKt.fileInputStreamSafeConstructor(filePath)));
            Throwable throwable = null;
            try {
                DataInputStream it = (DataInputStream)closeable;
                boolean bl = false;
                short version = it.readShort();
                if (version != 1) {
                    throw new RuntimeException("This version(" + version + ") of olap.control is not supported yet");
                }
                OlapControlFile olapControlFile = Companion.readV1(it, version);
                return olapControlFile;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

