/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.replication;

import java.io.Closeable;
import java.io.File;
import java.nio.file.Path;
import kd.bos.olapServer2.common.ITempFolder;
import kd.bos.olapServer2.common.Paths;
import kd.bos.olapServer2.replication.BackupRecord;
import kd.bos.olapServer2.replication.BackupRecordWorkspace;
import kd.bos.olapServer2.replication.BackupType;
import kd.bos.olapServer2.replication.ControlConfig;
import kd.bos.olapServer2.replication.ControlHead;
import kd.bos.olapServer2.replication.CubeMapFileContainer;
import kd.bos.olapServer2.replication.CubeMapValue;
import kd.bos.olapServer2.replication.OlapBackup;
import kd.bos.olapServer2.replication.OlapControlFile;
import kd.bos.olapServer2.replication.OlapRecovery;
import kd.bos.olapServer2.replication.RedoUtil;
import kd.bos.olapServer2.replication.TotalBackupBuilderV1;
import kd.bos.olapServer2.server.ReplicationWorkspace;
import kd.bos.olapServer2.storages.OlapWorkspace;
import kd.bos.olapServer2.tools.FileTools;
import kd.bos.olapServer2.tools.Res;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u00060\bj\u0002`\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lkd/bos/olapServer2/replication/OlapHotBackup;", "", "backupRecordWorkspace", "Lkd/bos/olapServer2/replication/BackupRecordWorkspace;", "(Lkd/bos/olapServer2/replication/BackupRecordWorkspace;)V", "totalBackup", "", "checkPoint", "", "Lkd/bos/olapServer2/common/LSN;", "bos-olap-core2"})
@SourceDebugExtension(value={"SMAP\nOlapHotBackup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OlapHotBackup.kt\nkd/bos/olapServer2/replication/OlapHotBackup\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,109:1\n13309#2,2:110\n*S KotlinDebug\n*F\n+ 1 OlapHotBackup.kt\nkd/bos/olapServer2/replication/OlapHotBackup\n*L\n72#1:110,2\n*E\n"})
public final class OlapHotBackup {
    @NotNull
    private final BackupRecordWorkspace backupRecordWorkspace;

    public OlapHotBackup(@NotNull BackupRecordWorkspace backupRecordWorkspace) {
        Intrinsics.checkNotNullParameter((Object)backupRecordWorkspace, (String)"backupRecordWorkspace");
        this.backupRecordWorkspace = backupRecordWorkspace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void totalBackup(long checkPoint) {
        block18: {
            File tempDir;
            File hotTotalBackupDir;
            String backupPath;
            block17: {
                backupPath = this.backupRecordWorkspace.getBackupPath();
                hotTotalBackupDir = null;
                tempDir = null;
                BackupRecord backupRecord = this.backupRecordWorkspace.getLastTotalBackupWithZero();
                if (backupRecord == null) {
                    String string2 = Res.INSTANCE.getOlapBackupException_1();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-OlapBackupException_1>(...)");
                    Object[] objectArray = new Object[]{backupPath};
                    throw Res.INSTANCE.getRuntimeException(string2, objectArray);
                }
                BackupRecord lastTotalPoint = backupRecord;
                long beginPoint = lastTotalPoint.getEnd();
                if (!(checkPoint >= 0L && checkPoint >= beginPoint)) {
                    String string3 = "Failed requirement.";
                    throw new IllegalArgumentException(string3.toString());
                }
                if (beginPoint != checkPoint) break block17;
                return;
            }
            try {
                Closeable closeable;
                ReplicationWorkspace replicationWorkspace;
                tempDir = ITempFolder.Companion.createTempDirectory("OlapHotBackup_TotalBackup");
                String string4 = tempDir.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getPath(...)");
                String[] stringArray = new String[]{"tmpDatabase"};
                String tempDirDatabasePath = ((Object)Paths.INSTANCE.get(string4, stringArray).toAbsolutePath()).toString();
                FileTools.INSTANCE.autoMakeDir(tempDirDatabasePath);
                ReplicationWorkspace tmpOlapWorkspace = null;
                try {
                    tmpOlapWorkspace = ReplicationWorkspace.Companion.createNoneWorkspace(tempDirDatabasePath);
                    String[] stringArray2 = new String[]{"redo"};
                    Path redoPath = Paths.INSTANCE.get(((Object)Paths.INSTANCE.get(backupPath, new String[0]).getParent()).toString(), stringArray2);
                    new OlapRecovery(tmpOlapWorkspace, ((Object)redoPath).toString(), backupPath, checkPoint).recoveryAndReplay();
                    hotTotalBackupDir = this.backupRecordWorkspace.getBackupDir(BackupType.Total);
                    String string5 = hotTotalBackupDir.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getPath(...)");
                    FileTools.INSTANCE.autoMakeDir(string5);
                    OlapWorkspace olapWorkspace = tmpOlapWorkspace.getOlapWorkspace$bos_olap_core2();
                    String string6 = hotTotalBackupDir.getAbsolutePath();
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getAbsolutePath(...)");
                    OlapBackup.Companion.backup(olapWorkspace, string6);
                    TotalBackupBuilderV1 collection = new TotalBackupBuilderV1();
                    File[] fileArray = hotTotalBackupDir.listFiles();
                    if (fileArray != null) {
                        File[] $this$forEach$iv = fileArray;
                        boolean $i$f$forEach = false;
                        int n = $this$forEach$iv.length;
                        for (int i = 0; i < n; ++i) {
                            String string7;
                            File element$iv;
                            File file = element$iv = $this$forEach$iv[i];
                            boolean bl = false;
                            if (!file.isFile()) continue;
                            Intrinsics.checkNotNull((Object)file);
                            if (!Intrinsics.areEqual((Object)FilesKt.getExtension((File)file), (Object)"backup")) continue;
                            String cubeName = FilesKt.getNameWithoutExtension((File)file);
                            StringBuilder stringBuilder = new StringBuilder().append(cubeName).append('-');
                            Intrinsics.checkNotNullExpressionValue((Object)hotTotalBackupDir.getName(), (String)"getName(...)");
                            int n2 = 0;
                            int n3 = hotTotalBackupDir.getName().length() - 6;
                            String string8 = string7.substring(n2, n3);
                            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                            String cubeBackupFileName = stringBuilder.append(string8).append(".backup").toString();
                            collection.set(cubeName, new CubeMapValue(BackupRecordWorkspace.Companion.getBackupFileTransactionVersion(file), cubeBackupFileName));
                            FileUtils.moveFile((File)file, (File)RedoUtil.INSTANCE.getBackupFile(backupPath, cubeName, cubeBackupFileName));
                        }
                    }
                    String string9 = hotTotalBackupDir.getAbsolutePath();
                    Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"getAbsolutePath(...)");
                    new CubeMapFileContainer(string9).save(collection);
                    OlapControlFile olapControlFile = new OlapControlFile(new ControlConfig(checkPoint, checkPoint, checkPoint), new ControlHead(0, 0, 0, 0L, 15, null));
                    String string10 = hotTotalBackupDir.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"getPath(...)");
                    OlapControlFile.save$default(olapControlFile, string10, false, 2, null);
                    String string11 = hotTotalBackupDir.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"getName(...)");
                    this.backupRecordWorkspace.writeBackupRecord(string11, checkPoint, checkPoint);
                    replicationWorkspace = tmpOlapWorkspace;
                }
                catch (Throwable throwable) {
                    Closeable closeable2;
                    ReplicationWorkspace replicationWorkspace2 = tmpOlapWorkspace;
                    if (replicationWorkspace2 != null) {
                        replicationWorkspace2.close();
                    }
                    if ((closeable2 = tmpOlapWorkspace) != null && (closeable2 = ((ReplicationWorkspace)closeable2).getOlapWorkspace$bos_olap_core2()) != null) {
                        ((OlapWorkspace)closeable2).close();
                    }
                    throw throwable;
                }
                if (replicationWorkspace != null) {
                    replicationWorkspace.close();
                }
                if ((closeable = tmpOlapWorkspace) != null && (closeable = ((ReplicationWorkspace)closeable).getOlapWorkspace$bos_olap_core2()) != null) {
                    ((OlapWorkspace)closeable).close();
                }
                if (tempDir == null) break block18;
                FileTools.INSTANCE.deleteDir(tempDir);
            }
            catch (Exception ex) {
                try {
                    if (hotTotalBackupDir != null) {
                        FileTools.INSTANCE.deleteDir(hotTotalBackupDir);
                    }
                    throw ex;
                }
                catch (Throwable throwable) {
                    if (tempDir != null) {
                        FileTools.INSTANCE.deleteDir(tempDir);
                    }
                    throw throwable;
                }
            }
        }
    }
}

