/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.replication;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.util.Set;
import kd.bos.olapServer2.backup.CubeRecovery;
import kd.bos.olapServer2.common.CancellableToken;
import kd.bos.olapServer2.common.DefaultThreadPoolExecutor;
import kd.bos.olapServer2.common.Paths;
import kd.bos.olapServer2.metadata.builds.CubeEntry;
import kd.bos.olapServer2.metadata.builds.OlapMetadataBuilder;
import kd.bos.olapServer2.replication.BackupRecord;
import kd.bos.olapServer2.replication.BackupRecordWorkspace;
import kd.bos.olapServer2.replication.ControlConfig;
import kd.bos.olapServer2.replication.ControlHead;
import kd.bos.olapServer2.replication.CubeMapFileContainer;
import kd.bos.olapServer2.replication.LSNUtil;
import kd.bos.olapServer2.replication.OlapControlFile;
import kd.bos.olapServer2.replication.RedoUtil;
import kd.bos.olapServer2.replication.ReplayContext;
import kd.bos.olapServer2.replication.ReplayCoordinator;
import kd.bos.olapServer2.replication.SlaveLSNContext;
import kd.bos.olapServer2.replication.TotalBackupBuilderV1;
import kd.bos.olapServer2.server.ReplicationWorkspace;
import kd.bos.olapServer2.storages.CubeWorkspace;
import kd.bos.olapServer2.storages.CubeWorkspaceCreator;
import kd.bos.olapServer2.storages.OlapWorkspace;
import kd.bos.olapServer2.tools.FileTools;
import kd.bos.olapServer2.tools.Res;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\t\b\u0000\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u0012\n\u0010\u0007\u001a\u00060\u0005j\u0002`\u0006\u0012\u0010\b\u0002\u0010\b\u001a\n\u0018\u00010\tj\u0004\u0018\u0001`\n\u00a2\u0006\u0002\u0010\u000bJ \u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u00060\tj\u0002`\n2\n\u0010\u0010\u001a\u00060\tj\u0002`\nH\u0002J\u0006\u0010\u0011\u001a\u00020\u000eJ,\u0010\u0012\u001a\u00020\u000e2\n\u0010\u0013\u001a\u00060\u0005j\u0002`\u00062\n\u0010\u0014\u001a\u00060\tj\u0002`\n2\n\u0010\u0015\u001a\u00060\tj\u0002`\nH\u0002R\u0012\u0010\u0007\u001a\u00060\u0005j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\b\u001a\n\u0018\u00010\tj\u0004\u0018\u0001`\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u0012\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lkd/bos/olapServer2/replication/OlapRecovery;", "", "replicationWorkspace", "Lkd/bos/olapServer2/server/ReplicationWorkspace;", "redoPath", "", "Lkd/bos/olapServer2/common/string;", "backupPath", "checkPoint", "", "Lkd/bos/olapServer2/common/LSN;", "(Lkd/bos/olapServer2/server/ReplicationWorkspace;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Long;)V", "Ljava/lang/Long;", "incrementRecovery", "", "replayStart", "replayEnd", "recoveryAndReplay", "saveControlFile", "path", "completeLsn", "checkPointLsn", "Companion", "bos-olap-core2"})
public final class OlapRecovery {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ReplicationWorkspace replicationWorkspace;
    @NotNull
    private final String redoPath;
    @NotNull
    private final String backupPath;
    @Nullable
    private final Long checkPoint;

    public OlapRecovery(@NotNull ReplicationWorkspace replicationWorkspace, @NotNull String redoPath, @NotNull String backupPath, @Nullable Long checkPoint) {
        Intrinsics.checkNotNullParameter((Object)replicationWorkspace, (String)"replicationWorkspace");
        Intrinsics.checkNotNullParameter((Object)redoPath, (String)"redoPath");
        Intrinsics.checkNotNullParameter((Object)backupPath, (String)"backupPath");
        this.replicationWorkspace = replicationWorkspace;
        this.redoPath = redoPath;
        this.backupPath = backupPath;
        this.checkPoint = checkPoint;
    }

    public /* synthetic */ OlapRecovery(ReplicationWorkspace replicationWorkspace, String string2, String string3, Long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            l = null;
        }
        this(replicationWorkspace, string2, string3, l);
    }

    public final void recoveryAndReplay() {
        long latestLsn;
        Long replayEndLsn;
        BackupRecord lastTotalRecord;
        OlapWorkspace olapWorkspace = this.replicationWorkspace.getOlapWorkspace$bos_olap_core2();
        BackupRecordWorkspace backupRecordWorkspace = BackupRecordWorkspace.Companion.create(this.backupPath);
        BackupRecord backupRecord = lastTotalRecord = backupRecordWorkspace.getLastTotalBackupWithoutZero();
        Long l = replayEndLsn = backupRecord != null ? Long.valueOf(backupRecord.getEnd()) : null;
        if (lastTotalRecord != null) {
            if (!(lastTotalRecord.getStart() == lastTotalRecord.getEnd())) {
                String string2 = "Failed requirement.";
                throw new IllegalArgumentException(string2.toString());
            }
            String totalPath = RedoUtil.getTotalRecordFolder$default(RedoUtil.INSTANCE, this.backupPath, lastTotalRecord.getName(), false, 4, null).getAbsolutePath();
            Intrinsics.checkNotNull((Object)totalPath);
            TotalBackupBuilderV1 collection = new CubeMapFileContainer(totalPath).read();
            kd.bos.olapServer2.replication.OlapRecovery$Companion.recovery$default(Companion, olapWorkspace, totalPath, this.backupPath, collection, null, 16, null);
        }
        long l2 = latestLsn = !Intrinsics.areEqual((Object)this.redoPath, (Object)"") ? LSNUtil.INSTANCE.getRealLsnRangeByFolderPath(this.redoPath).getLast() : LSNUtil.INSTANCE.getRealLsnRangeByFolderPath(RedoUtil.INSTANCE.getOrCreateIncrementPath(this.backupPath)).getLast();
        if (latestLsn != 0L && latestLsn != -1L) {
            if (!(lastTotalRecord != null ? latestLsn == lastTotalRecord.getEnd() : false)) {
                Long l3 = this.checkPoint;
                if (l3 == null) {
                    l3 = latestLsn;
                }
                replayEndLsn = l3;
                BackupRecord backupRecord2 = lastTotalRecord;
                long replayStartLsn = backupRecord2 != null ? backupRecord2.getStart() : 0L;
                this.incrementRecovery(replayStartLsn, replayEndLsn);
            }
        }
        if ((latestLsn == 0L || latestLsn == -1L) && lastTotalRecord == null) {
            String string3 = Res.INSTANCE.getOlapRecoveryException_2();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"<get-OlapRecoveryException_2>(...)");
            Object[] objectArray = new Object[]{backupRecordWorkspace.getBackupPath()};
            throw Res.INSTANCE.getRuntimeException(string3, objectArray);
        }
        if (!(replayEndLsn != null)) {
            String string4 = "Failed requirement.";
            throw new IllegalArgumentException(string4.toString());
        }
        this.saveControlFile(olapWorkspace.getRootPath(), replayEndLsn, replayEndLsn);
    }

    private final void saveControlFile(String path, long completeLsn, long checkPointLsn) {
        OlapControlFile.save$default(new OlapControlFile(new ControlConfig(completeLsn, completeLsn, checkPointLsn), new ControlHead(0, 0, 0, 0L, 15, null)), path, false, 2, null);
    }

    private final void incrementRecovery(long replayStart, long replayEnd) {
        if (replayStart >= replayEnd) {
            String string2 = Res.INSTANCE.getOlapRecoveryException_3();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-OlapRecoveryException_3>(...)");
            Object[] objectArray = new Object[]{replayStart, replayEnd};
            throw Res.INSTANCE.getIllegalArgumentException(string2, objectArray);
        }
        ControlConfig replayControl = new ControlConfig(replayStart, replayEnd, -1L);
        Companion.replayRedo(this.replicationWorkspace, replayControl, this.redoPath, this.backupPath, true);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u00060\bj\u0002`\tH\u0002J\u001c\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\n\u0010\u000b\u001a\u00060\bj\u0002`\tH\u0002JD\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\n\u0010\u000b\u001a\u00060\bj\u0002`\t2\n\u0010\r\u001a\u00060\bj\u0002`\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0014\b\u0002\u0010\u0010\u001a\u000e\u0012\b\u0012\u00060\bj\u0002`\t\u0018\u00010\u0011J@\u0010\u0012\u001a\u00060\u0013j\u0002`\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\n\u0010\u0019\u001a\u00060\bj\u0002`\t2\n\u0010\r\u001a\u00060\bj\u0002`\t2\f\b\u0002\u0010\u001a\u001a\u00060\u001bj\u0002`\u001c\u00a8\u0006\u001d"}, d2={"Lkd/bos/olapServer2/replication/OlapRecovery$Companion;", "", "()V", "checkTotalRecovery", "", "olapWorkspace", "Lkd/bos/olapServer2/storages/OlapWorkspace;", "totalBackupPath", "", "Lkd/bos/olapServer2/common/string;", "dealOlapRecoveryExceptionResource", "sourceTotalBackupPath", "recovery", "backupPath", "cubeMapValue", "Lkd/bos/olapServer2/replication/TotalBackupBuilderV1;", "cubes", "", "replayRedo", "", "Lkd/bos/olapServer2/common/LSN;", "workspace", "Lkd/bos/olapServer2/server/ReplicationWorkspace;", "controlConfig", "Lkd/bos/olapServer2/replication/ControlConfig;", "redoPath", "isIncrement", "", "Lkd/bos/olapServer2/common/bool;", "bos-olap-core2"})
    @SourceDebugExtension(value={"SMAP\nOlapRecovery.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OlapRecovery.kt\nkd/bos/olapServer2/replication/OlapRecovery$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,259:1\n1855#2,2:260\n1855#2,2:263\n1#3:262\n*S KotlinDebug\n*F\n+ 1 OlapRecovery.kt\nkd/bos/olapServer2/replication/OlapRecovery$Companion\n*L\n113#1:260,2\n185#1:263,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void recovery(@NotNull OlapWorkspace olapWorkspace, @NotNull String sourceTotalBackupPath, @NotNull String backupPath, @NotNull TotalBackupBuilderV1 cubeMapValue, @Nullable Set<String> cubes) {
            Intrinsics.checkNotNullParameter((Object)olapWorkspace, (String)"olapWorkspace");
            Intrinsics.checkNotNullParameter((Object)sourceTotalBackupPath, (String)"sourceTotalBackupPath");
            Intrinsics.checkNotNullParameter((Object)backupPath, (String)"backupPath");
            Intrinsics.checkNotNullParameter((Object)cubeMapValue, (String)"cubeMapValue");
            this.checkTotalRecovery(olapWorkspace, sourceTotalBackupPath);
            Closeable closeable = new DefaultThreadPoolExecutor("totalRecovery");
            Throwable throwable = null;
            try {
                DefaultThreadPoolExecutor threadPool = (DefaultThreadPoolExecutor)closeable;
                boolean bl = false;
                OlapMetadataBuilder sourceMetadata = OlapMetadataBuilder.Companion.readFrom(sourceTotalBackupPath);
                Iterable $this$forEach$iv = sourceMetadata.getCubes();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    CubeEntry cubeEntry = (CubeEntry)element$iv;
                    boolean bl2 = false;
                    String cubeName = cubeEntry.getName();
                    if (cubes != null && !cubes.contains(cubeName)) continue;
                    String[] stringArray = new String[]{cubeName, cubeMapValue.get(cubeName).getFileName()};
                    File cubeBackupFile = Paths.INSTANCE.joinToFile(backupPath, stringArray);
                    threadPool.submit((Function0<Unit>)((Function0)new Function0<Unit>(cubeBackupFile, olapWorkspace, cubeEntry, cubeName){
                        final /* synthetic */ File $cubeBackupFile;
                        final /* synthetic */ OlapWorkspace $olapWorkspace;
                        final /* synthetic */ CubeEntry $cubeEntry;
                        final /* synthetic */ String $cubeName;
                        {
                            this.$cubeBackupFile = $cubeBackupFile;
                            this.$olapWorkspace = $olapWorkspace;
                            this.$cubeEntry = $cubeEntry;
                            this.$cubeName = $cubeName;
                            super(0);
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public final void invoke() {
                            if (!this.$cubeBackupFile.exists()) {
                                String string2 = Res.INSTANCE.getOlapWorkspaceException_7();
                                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-OlapWorkspaceException_7>(...)");
                                Object[] objectArray = new Object[]{this.$cubeBackupFile};
                                throw Res.INSTANCE.getRuntimeException(string2, objectArray);
                            }
                            Closeable closeable = new DataInputStream(Paths.INSTANCE.createInputStream(this.$cubeBackupFile));
                            Object[] objectArray = this.$olapWorkspace;
                            String string3 = this.$cubeName;
                            CubeEntry cubeEntry = this.$cubeEntry;
                            Throwable throwable = null;
                            try {
                                DataInputStream it = (DataInputStream)closeable;
                                boolean bl = false;
                                new CubeRecovery((OlapWorkspace)objectArray, string3, objectArray.getRootPath(), it, cubeEntry.getId()).recovery();
                                Unit unit = Unit.INSTANCE;
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                            }
                            String actualCubeName = this.$olapWorkspace.getMetadata().getCubes().tryGetCubeNameById(this.$cubeEntry.getId());
                            if (actualCubeName == null) {
                                String string4 = Res.INSTANCE.getOlapWorkspaceException_8();
                                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"<get-OlapWorkspaceException_8>(...)");
                                objectArray = new Object[]{this.$cubeEntry.getId(), this.$cubeEntry.getName()};
                                throw Res.INSTANCE.getRuntimeException(string4, objectArray);
                            }
                            if (!Intrinsics.areEqual((Object)this.$cubeName, (Object)actualCubeName)) {
                                String string5 = Res.INSTANCE.getOlapWorkspaceException_9();
                                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"<get-OlapWorkspaceException_9>(...)");
                                objectArray = new Object[]{this.$cubeEntry.getId(), this.$cubeEntry.getName(), actualCubeName};
                                throw Res.INSTANCE.getRuntimeException(string5, objectArray);
                            }
                            CubeWorkspaceCreator cubeWorkspaceCreator = this.$olapWorkspace.getCubeWorkspaceCreator(this.$cubeName);
                            cubeWorkspaceCreator.tryUnload();
                        }
                    }));
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            if (cubes == null) {
                this.dealOlapRecoveryExceptionResource(olapWorkspace, sourceTotalBackupPath);
            }
        }

        public static /* synthetic */ void recovery$default(Companion companion, OlapWorkspace olapWorkspace, String string2, String string3, TotalBackupBuilderV1 totalBackupBuilderV1, Set set, int n, Object object2) {
            if ((n & 0x10) != 0) {
                set = null;
            }
            companion.recovery(olapWorkspace, string2, string3, totalBackupBuilderV1, set);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void dealOlapRecoveryExceptionResource(OlapWorkspace olapWorkspace, String sourceTotalBackupPath) {
            boolean canContinue = true;
            File sourceJsonFile = Paths.INSTANCE.toFile(sourceTotalBackupPath, "index.json");
            String string2 = olapWorkspace.getRootPath();
            String string3 = sourceJsonFile.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
            File targetJsonFile = Paths.INSTANCE.toFile(string2, string3);
            try {
                CancellableToken.INSTANCE.getContinueToken().canContinue();
            }
            catch (Throwable t2) {
                try {
                    canContinue = false;
                    throw t2;
                }
                catch (Throwable throwable) {
                    if (canContinue) {
                        FilesKt.copyTo$default((File)sourceJsonFile, (File)targetJsonFile, (boolean)true, (int)0, (int)4, null);
                    } else {
                        if (targetJsonFile.exists() && !targetJsonFile.delete()) {
                            boolean $i$a$-require-OlapRecovery$Companion$dealOlapRecoveryExceptionResource$22 = false;
                            String $i$a$-require-OlapRecovery$Companion$dealOlapRecoveryExceptionResource$22 = "olap recovery error,delete " + targetJsonFile.getName() + " failed.";
                            throw new IllegalArgumentException($i$a$-require-OlapRecovery$Companion$dealOlapRecoveryExceptionResource$22.toString());
                        }
                        Iterable $this$forEach$iv = olapWorkspace.getLoadedWorkspaces$bos_olap_core2();
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            CubeWorkspace cubeWorkspace = (CubeWorkspace)element$iv;
                            boolean bl = false;
                            cubeWorkspace.close();
                            File deleteDir = Paths.INSTANCE.toFile(olapWorkspace.getRootPath(), cubeWorkspace.getMetadata().getName());
                            if (FileTools.INSTANCE.deleteDir(deleteDir)) continue;
                            boolean bl2 = false;
                            String string4 = "olap recovery error,delete directory " + deleteDir.getName() + " failed.";
                            throw new IllegalArgumentException(string4.toString());
                        }
                    }
                    olapWorkspace.reloadOlapMetadata();
                    throw throwable;
                }
            }
            FilesKt.copyTo$default((File)sourceJsonFile, (File)targetJsonFile, (boolean)true, (int)0, (int)4, null);
            olapWorkspace.reloadOlapMetadata();
        }

        private final void checkTotalRecovery(OlapWorkspace olapWorkspace, String totalBackupPath) {
            if (olapWorkspace.getMetadata().getCubes().getCount() != 0) {
                String string2 = Res.INSTANCE.getOlapWorkspaceException_2();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-OlapWorkspaceException_2>(...)");
                throw Res.INSTANCE.getRuntimeException(string2, new Object[0]);
            }
            if (!Paths.INSTANCE.toFile(totalBackupPath).exists()) {
                String string3 = Res.INSTANCE.getOlapWorkspaceException_5();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"<get-OlapWorkspaceException_5>(...)");
                Object[] objectArray = new Object[]{totalBackupPath};
                throw Res.INSTANCE.getRuntimeException(string3, objectArray);
            }
            ControlConfig controlConfig = OlapControlFile.Companion.readControlConfig(olapWorkspace.getRootPath()).getControlConfig();
            if (controlConfig.getRecoveryStartLSN() != 0L || controlConfig.getRecoveryEndLSN() != 0L) {
                String string4 = Res.INSTANCE.getOlapWorkspaceException_6();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"<get-OlapWorkspaceException_6>(...)");
                Object[] objectArray = new Object[]{olapWorkspace.getRootPath(), controlConfig.getRecoveryStartLSN(), controlConfig.getRecoveryEndLSN()};
                throw Res.INSTANCE.getRuntimeException(string4, objectArray);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public final long replayRedo(@NotNull ReplicationWorkspace workspace, @NotNull ControlConfig controlConfig, @NotNull String redoPath, @NotNull String backupPath, boolean isIncrement) {
            Intrinsics.checkNotNullParameter((Object)workspace, (String)"workspace");
            Intrinsics.checkNotNullParameter((Object)controlConfig, (String)"controlConfig");
            Intrinsics.checkNotNullParameter((Object)redoPath, (String)"redoPath");
            Intrinsics.checkNotNullParameter((Object)backupPath, (String)"backupPath");
            SlaveLSNContext slaveContext = new SlaveLSNContext(controlConfig.getRecoveryStartLSN(), controlConfig.getRecoveryEndLSN(), controlConfig.getCheckPointLSN());
            if (controlConfig.getRecoveryStartLSN() == controlConfig.getRecoveryEndLSN()) {
                return slaveContext.getCheckPoint();
            }
            Closeable closeable = new ReplayCoordinator(workspace.getOlapWorkspace$bos_olap_core2(), slaveContext, redoPath, backupPath, workspace.getLogger$bos_olap_core2(), new ReplayContext(null, isIncrement, false, false, null, 29, null));
            Throwable throwable = null;
            try {
                ReplayCoordinator coordinator = (ReplayCoordinator)closeable;
                boolean bl = false;
                coordinator.start();
                while (true) {
                    if (coordinator.isError()) {
                        String string2 = Res.INSTANCE.getReplicationManagerException_1();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-ReplicationManagerException_1>(...)");
                        throw Res.INSTANCE.getRuntimeException(string2, new Object[0]);
                    }
                    if (slaveContext.getNextReadPage() == controlConfig.getRecoveryEndLSN()) {
                        long l = slaveContext.getCheckPoint();
                        return l;
                    }
                    Thread.sleep(10L);
                    continue;
                    break;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }

        public static /* synthetic */ long replayRedo$default(Companion companion, ReplicationWorkspace replicationWorkspace, ControlConfig controlConfig, String string2, String string3, boolean bl, int n, Object object2) {
            if ((n & 0x10) != 0) {
                bl = false;
            }
            return companion.replayRedo(replicationWorkspace, controlConfig, string2, string3, bl);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

