/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.replication;

import java.io.File;
import kd.bos.olapServer2.common.CommandTypes;
import kd.bos.olapServer2.common.Paths;
import kd.bos.olapServer2.dataSources.CommandInfo;
import kd.bos.olapServer2.dataSources.MetadataCommandInfo;
import kd.bos.olapServer2.dataSources.RecoveryCommandInfo;
import kd.bos.olapServer2.metadata.MetadataTypes;
import kd.bos.olapServer2.metadata.MetadataUpdatedEventArgs;
import kd.bos.olapServer2.replication.IReplicationMaster;
import kd.bos.olapServer2.replication.IReplicationNode;
import kd.bos.olapServer2.replication.LocalRedo;
import kd.bos.olapServer2.replication.OlapReplicationMasterPlugin;
import kd.bos.olapServer2.replication.RecoveryFiles;
import kd.bos.olapServer2.replication.ReplicationContext;
import kd.bos.olapServer2.replication.ReplicationMaster;
import kd.bos.olapServer2.server.ReplicationWorkspace;
import kd.bos.olapServer2.storages.RedoCubeDataObserver;
import kd.bos.olapServer2.storages.plugins.CubeWorkspacePlugin;
import kd.bos.olapServer2.storages.plugins.CubeWorkspacePluginContext;
import kd.bos.olapServer2.storages.plugins.InputRowWriterCreatingEventArgs;
import kd.bos.olapServer2.storages.plugins.OlapWorkspaceBasicPlugin;
import kd.bos.olapServer2.storages.plugins.OlapWorkspacePluginContext;
import kd.bos.olapServer2.tools.FileTools;
import kd.bos.olapServer2.tools.Res;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KFunction;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00132\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0013\u0014B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0012H\u0014R\u0014\u0010\b\u001a\u00020\t8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\u0004\u0018\u00010\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u000e\u0010\u000e\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0015"}, d2={"Lkd/bos/olapServer2/replication/OlapReplicationMasterPlugin;", "Lkd/bos/olapServer2/storages/plugins/OlapWorkspaceBasicPlugin;", "Lkd/bos/olapServer2/replication/OlapReplicationMasterPlugin$CubeReplicationMasterPlugin;", "context", "Lkd/bos/olapServer2/storages/plugins/OlapWorkspacePluginContext;", "replicationContext", "Lkd/bos/olapServer2/replication/ReplicationContext;", "(Lkd/bos/olapServer2/storages/plugins/OlapWorkspacePluginContext;Lkd/bos/olapServer2/replication/ReplicationContext;)V", "cubePluginKey", "", "getCubePluginKey", "()Ljava/lang/Object;", "key", "getKey", "olapContext", "getReplicationContext", "()Lkd/bos/olapServer2/replication/ReplicationContext;", "createCubePlugin", "Lkd/bos/olapServer2/storages/plugins/CubeWorkspacePluginContext;", "Companion", "CubeReplicationMasterPlugin", "bos-olap-core2"})
public final class OlapReplicationMasterPlugin
extends OlapWorkspaceBasicPlugin<CubeReplicationMasterPlugin> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ReplicationContext replicationContext;
    @NotNull
    private final OlapWorkspacePluginContext olapContext;
    @NotNull
    private static final Class<KFunction<OlapReplicationMasterPlugin>> OlapReplicationPluginKey = ((Object)((Object)Companion.OlapReplicationPluginKey.1.INSTANCE)).getClass();
    @NotNull
    private static final Class<KFunction<CubeReplicationMasterPlugin>> CubeReplicationMasterPluginKey = ((Object)((Object)Companion.CubeReplicationMasterPluginKey.1.INSTANCE)).getClass();

    public OlapReplicationMasterPlugin(@NotNull OlapWorkspacePluginContext context, @NotNull ReplicationContext replicationContext) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)replicationContext, (String)"replicationContext");
        super(context, true);
        this.replicationContext = replicationContext;
        this.olapContext = context;
    }

    @NotNull
    public final ReplicationContext getReplicationContext() {
        return this.replicationContext;
    }

    @Override
    @Nullable
    public Object getKey() {
        return OlapReplicationPluginKey;
    }

    @Override
    @NotNull
    protected Object getCubePluginKey() {
        return CubeReplicationMasterPluginKey;
    }

    @Override
    @NotNull
    protected CubeReplicationMasterPlugin createCubePlugin(@NotNull CubeWorkspacePluginContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new CubeReplicationMasterPlugin(this.olapContext, context, this.replicationContext);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002RY\u0010\u0003\u001aM\u0012I\u0012G\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u000e0\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000RG\u0010\u000f\u001a8\u00124\u00122\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u00110\u00100\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lkd/bos/olapServer2/replication/OlapReplicationMasterPlugin$Companion;", "", "()V", "CubeReplicationMasterPluginKey", "Ljava/lang/Class;", "Lkotlin/reflect/KFunction3;", "Lkd/bos/olapServer2/storages/plugins/OlapWorkspacePluginContext;", "Lkotlin/ParameterName;", "name", "olapContext", "Lkd/bos/olapServer2/storages/plugins/CubeWorkspacePluginContext;", "context", "Lkd/bos/olapServer2/replication/ReplicationContext;", "replicationContext", "Lkd/bos/olapServer2/replication/OlapReplicationMasterPlugin$CubeReplicationMasterPlugin;", "OlapReplicationPluginKey", "Lkotlin/reflect/KFunction2;", "Lkd/bos/olapServer2/replication/OlapReplicationMasterPlugin;", "getOlapReplicationPluginKey", "()Ljava/lang/Class;", "bos-olap-core2"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Class<KFunction<OlapReplicationMasterPlugin>> getOlapReplicationPluginKey() {
            return OlapReplicationPluginKey;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ8\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u00060\u0010j\u0002`\u00112\n\u0010\u0012\u001a\u00060\u0013j\u0002`\u00142\n\u0010\u0015\u001a\u00060\u0013j\u0002`\u00142\n\u0010\u0016\u001a\u00060\u0013j\u0002`\u0014H\u0002R\u0016\u0010\t\u001a\u0004\u0018\u00010\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lkd/bos/olapServer2/replication/OlapReplicationMasterPlugin$CubeReplicationMasterPlugin;", "Lkd/bos/olapServer2/storages/plugins/CubeWorkspacePlugin;", "olapContext", "Lkd/bos/olapServer2/storages/plugins/OlapWorkspacePluginContext;", "context", "Lkd/bos/olapServer2/storages/plugins/CubeWorkspacePluginContext;", "replicationContext", "Lkd/bos/olapServer2/replication/ReplicationContext;", "(Lkd/bos/olapServer2/storages/plugins/OlapWorkspacePluginContext;Lkd/bos/olapServer2/storages/plugins/CubeWorkspacePluginContext;Lkd/bos/olapServer2/replication/ReplicationContext;)V", "key", "", "getKey", "()Ljava/lang/Object;", "renameRecoveryFile", "", "lsn", "", "Lkd/bos/olapServer2/common/LSN;", "redoPath", "", "Lkd/bos/olapServer2/common/string;", "fileName", "cubeName", "bos-olap-core2"})
    public static final class CubeReplicationMasterPlugin
    extends CubeWorkspacePlugin {
        public CubeReplicationMasterPlugin(@NotNull OlapWorkspacePluginContext olapContext, final @NotNull CubeWorkspacePluginContext context, final @NotNull ReplicationContext replicationContext) {
            Intrinsics.checkNotNullParameter((Object)olapContext, (String)"olapContext");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)replicationContext, (String)"replicationContext");
            super(context);
            context.getInputRowWriterCreating().plusAssign((Function2<CubeWorkspacePluginContext, InputRowWriterCreatingEventArgs, Unit>)((Function2)new Function2<CubeWorkspacePluginContext, InputRowWriterCreatingEventArgs, Unit>(){

                public final void invoke(@NotNull CubeWorkspacePluginContext cubeWorkspacePluginContext, @NotNull InputRowWriterCreatingEventArgs e) {
                    Intrinsics.checkNotNullParameter((Object)cubeWorkspacePluginContext, (String)"<anonymous parameter 0>");
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    ReplicationWorkspace replicationWorkspace = replicationContext.getWorkspace$bos_olap_core2();
                    if (replicationWorkspace.isMaster()) {
                        IReplicationNode node = replicationWorkspace.getCurrentNode().getValue();
                        if (!(node instanceof ReplicationMaster)) {
                            String string2 = "Failed requirement.";
                            throw new IllegalArgumentException(string2.toString());
                        }
                        e.registerObserver(new RedoCubeDataObserver(e.getDataObserverContext$bos_olap_core2()));
                    }
                }
            }));
            context.getCubeWorkspace$bos_olap_core2().getMetadataUpdated().plusAssign((Function2<CubeWorkspacePluginContext, MetadataUpdatedEventArgs, Unit>)((Function2)new Function2<CubeWorkspacePluginContext, MetadataUpdatedEventArgs, Unit>(){

                public final void invoke(@NotNull CubeWorkspacePluginContext sender, @NotNull MetadataUpdatedEventArgs e) {
                    Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    ReplicationWorkspace replicationWorkspace = replicationContext.getWorkspace$bos_olap_core2();
                    if (replicationWorkspace.isMaster()) {
                        IReplicationNode node = replicationWorkspace.getCurrentNode().getValue();
                        if (!(node instanceof ReplicationMaster)) {
                            String string2 = "Failed requirement.";
                            throw new IllegalArgumentException(string2.toString());
                        }
                        int cubeId = context.getCubeId();
                        CommandInfo commandInfo = e.getCommandInfo();
                        if (commandInfo instanceof RecoveryCommandInfo) {
                            LocalRedo localRedo = new LocalRedo((IReplicationMaster)node);
                            String cubeName = context.getCubeWorkspace$bos_olap_core2().getMetadata().getName();
                            String string3 = e.getRecoveryFileName();
                            Intrinsics.checkNotNull((Object)string3);
                            String recoveryFileName = string3;
                            byte[] byArray = cubeName.getBytes(Charsets.UTF_8);
                            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                            byte[] cubeNameByteArray = byArray;
                            byte[] byArray2 = recoveryFileName.getBytes(Charsets.UTF_8);
                            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"this as java.lang.String).getBytes(charset)");
                            byte[] recoveryFileNameByteArray = byArray2;
                            localRedo.addCubeRecoverRecord(e.getTransactionId(), ~cubeId, cubeNameByteArray, recoveryFileNameByteArray);
                            long lsn = localRedo.flushSyncSlaves();
                            this.renameRecoveryFile(lsn, replicationWorkspace.getCurrentNode().getConf().get_node().getRedoPath(), recoveryFileName, cubeName);
                        } else if (commandInfo instanceof MetadataCommandInfo) {
                            int realCubeId = ((MetadataCommandInfo)e.getCommandInfo()).getMetadataType() == MetadataTypes.Cube && ((MetadataCommandInfo)e.getCommandInfo()).getAction() == CommandTypes.create ? ~cubeId : cubeId;
                            LocalRedo localRedo = new LocalRedo((IReplicationMaster)node);
                            localRedo.addDDLRecord(e.getTransactionId(), realCubeId, e.getCommandInfo().toString());
                            localRedo.flushSyncSlaves();
                        }
                    }
                }
            }));
        }

        @Override
        @Nullable
        public Object getKey() {
            return CubeReplicationMasterPluginKey;
        }

        private final void renameRecoveryFile(long lsn, String redoPath, String fileName, String cubeName) {
            String recoveryFilesPath = RecoveryFiles.getOrCreatePath$default(RecoveryFiles.INSTANCE, redoPath, false, 2, null);
            File file = Paths.INSTANCE.toFile(recoveryFilesPath, fileName);
            if (!file.exists()) {
                String string2 = Res.INSTANCE.getOlapReplicationMasterPluginException_1();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-OlapReplicationMasterPluginException_1>(...)");
                Object[] objectArray = new Object[]{file.getAbsolutePath()};
                throw Res.INSTANCE.getRuntimeException(string2, objectArray);
            }
            String newName = cubeName + '_' + lsn + ".backup";
            if (!FileTools.INSTANCE.rename(file, newName)) {
                String string3 = Res.INSTANCE.getOlapReplicationMasterPluginException_2();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"<get-OlapReplicationMasterPluginException_2>(...)");
                Object[] objectArray = new Object[]{file.getAbsolutePath()};
                throw Res.INSTANCE.getRuntimeException(string3, objectArray);
            }
        }
    }
}

