/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.replication;

import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.Iterator;
import kd.bos.olapServer2.replication.LSNUtil;
import kd.bos.olapServer2.replication.ReadedRedoPage;
import kd.bos.olapServer2.replication.RedoFile;
import kd.bos.olapServer2.replication.SlaveLSNContext;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\u0019\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\u000b\u001a\u00020\fH\u0096\u0002J\t\u0010\r\u001a\u00020\u0003H\u0096\u0002R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lkd/bos/olapServer2/replication/ReadedRedoFile;", "Lkd/bos/olapServer2/replication/RedoFile;", "", "Lkd/bos/olapServer2/replication/ReadedRedoPage;", "path", "", "Lkd/bos/olapServer2/common/string;", "slaveLSNContext", "Lkd/bos/olapServer2/replication/SlaveLSNContext;", "(Ljava/lang/String;Lkd/bos/olapServer2/replication/SlaveLSNContext;)V", "redoPage", "hasNext", "", "next", "bos-olap-core2"})
public final class ReadedRedoFile
extends RedoFile
implements Iterator<ReadedRedoPage>,
KMappedMarker {
    @NotNull
    private final SlaveLSNContext slaveLSNContext;
    @NotNull
    private final ReadedRedoPage redoPage;

    public ReadedRedoFile(@NotNull String path, @NotNull SlaveLSNContext slaveLSNContext) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)slaveLSNContext, (String)"slaveLSNContext");
        OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.READ};
        super(slaveLSNContext.getNextReadPage(), path, openOptionArray);
        this.slaveLSNContext = slaveLSNContext;
        this.redoPage = new ReadedRedoPage();
    }

    @Override
    public boolean hasNext() {
        return this.slaveLSNContext.getNextReadPage() < this.slaveLSNContext.getNextWritePage();
    }

    @Override
    @NotNull
    public ReadedRedoPage next() {
        long currentPage = this.slaveLSNContext.getNextReadPage();
        if (currentPage == this.getNextFileLsn()) {
            super.switchFile();
        }
        this.redoPage.getBuffer().clear();
        int result2 = this.getFd().read(this.redoPage.getBuffer(), LSNUtil.INSTANCE.getPageStartPosition(currentPage));
        this.redoPage.getBuffer().flip();
        if (!(result2 > 0)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        return this.redoPage;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }
}

