/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.replication;

import java.nio.ByteBuffer;
import java.util.Iterator;
import kd.bos.olapServer2.replication.CubeRecoverRecord;
import kd.bos.olapServer2.replication.CubeRecoverRecordV0;
import kd.bos.olapServer2.replication.DDLRecord;
import kd.bos.olapServer2.replication.DDLRecordV0;
import kd.bos.olapServer2.replication.DDLRecordV3;
import kd.bos.olapServer2.replication.DMLRecord;
import kd.bos.olapServer2.replication.DMLRecordV2;
import kd.bos.olapServer2.replication.DMLRecordV3;
import kd.bos.olapServer2.replication.IRedoRecord;
import kd.bos.olapServer2.replication.IRedoRecordHead;
import kd.bos.olapServer2.replication.RedoPage;
import kd.bos.olapServer2.replication.RedoRecordHead;
import kd.bos.olapServer2.replication.RedoRecordHeadV3;
import kd.bos.olapServer2.replication.RedoType;
import kd.bos.olapServer2.replication.TranStatusRecord;
import kd.bos.olapServer2.tools.Res;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\u0005\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0005\u001a\u00020\u0006H\u0096\u0002J\t\u0010\u0007\u001a\u00020\u0003H\u0096\u0002\u00a8\u0006\b"}, d2={"Lkd/bos/olapServer2/replication/ReadedRedoPage;", "Lkd/bos/olapServer2/replication/RedoPage;", "", "Lkd/bos/olapServer2/replication/IRedoRecord;", "()V", "hasNext", "", "next", "bos-olap-core2"})
@SourceDebugExtension(value={"SMAP\nReadedRedoPage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReadedRedoPage.kt\nkd/bos/olapServer2/replication/ReadedRedoPage\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,91:1\n1#2:92\n*E\n"})
public final class ReadedRedoPage
extends RedoPage
implements Iterator<IRedoRecord>,
KMappedMarker {
    @Override
    public boolean hasNext() {
        if (this.getBuffer().position() == 0) {
            this.getBuffer().position(22);
            this.getBuffer().limit(this.getLen());
        }
        return this.getBuffer().hasRemaining();
    }

    @Override
    @NotNull
    public IRedoRecord next() {
        switch (this.getVersion()) {
            case 0: {
                IRedoRecord iRedoRecord;
                RedoRecordHead head = new RedoRecordHead(this.getBuffer().getShort(), this.getBuffer().getInt(), this.getBuffer().getLong());
                ByteBuffer body = ByteBuffer.allocate(head.getLength());
                this.getBuffer().get(body.array(), 0, head.getLength());
                switch (WhenMappings.$EnumSwitchMapping$0[head.getType().ordinal()]) {
                    case 1: {
                        Intrinsics.checkNotNull((Object)body);
                        iRedoRecord = new DDLRecordV0(head, body);
                        break;
                    }
                    case 2: 
                    case 3: {
                        Intrinsics.checkNotNull((Object)body);
                        iRedoRecord = new DMLRecord(head, body);
                        break;
                    }
                    case 4: {
                        Intrinsics.checkNotNull((Object)body);
                        iRedoRecord = new CubeRecoverRecordV0(head, body);
                        break;
                    }
                    case 5: {
                        IRedoRecordHead iRedoRecordHead = head;
                        Intrinsics.checkNotNull((Object)body);
                        iRedoRecord = new TranStatusRecord(iRedoRecordHead, body);
                        break;
                    }
                    case 6: {
                        throw Res.INSTANCE.getRuntimeException("redo version 0 not support compensation record", new Object[0]);
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                return iRedoRecord;
            }
            case 1: {
                IRedoRecord iRedoRecord;
                short head = this.getBuffer().getShort();
                int cubeId = this.getBuffer().getInt();
                long tid = this.getBuffer().getLong();
                RedoRecordHead recordHead = new RedoRecordHead(head, cubeId, tid);
                if (!(cubeId != 0)) {
                    boolean $i$a$-require-ReadedRedoPage$next$42 = false;
                    String $i$a$-require-ReadedRedoPage$next$42 = "redoPage.v1 cubeId must be not equal to zero.";
                    throw new IllegalArgumentException($i$a$-require-ReadedRedoPage$next$42.toString());
                }
                ByteBuffer body = ByteBuffer.allocate(recordHead.getLength());
                this.getBuffer().get(body.array(), 0, recordHead.getLength());
                switch (WhenMappings.$EnumSwitchMapping$0[recordHead.getType().ordinal()]) {
                    case 1: {
                        Intrinsics.checkNotNull((Object)body);
                        iRedoRecord = new DDLRecord(recordHead, body);
                        break;
                    }
                    case 2: 
                    case 3: {
                        Intrinsics.checkNotNull((Object)body);
                        iRedoRecord = new DMLRecord(recordHead, body);
                        break;
                    }
                    case 4: {
                        IRedoRecordHead iRedoRecordHead = recordHead;
                        Intrinsics.checkNotNull((Object)body);
                        iRedoRecord = new CubeRecoverRecord(iRedoRecordHead, body);
                        break;
                    }
                    case 5: {
                        IRedoRecordHead iRedoRecordHead = recordHead;
                        Intrinsics.checkNotNull((Object)body);
                        iRedoRecord = new TranStatusRecord(iRedoRecordHead, body);
                        break;
                    }
                    case 6: {
                        throw Res.INSTANCE.getRuntimeException("redo version 1 not support compensation record", new Object[0]);
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                return iRedoRecord;
            }
            case 2: {
                IRedoRecord iRedoRecord;
                short head = this.getBuffer().getShort();
                int cubeId = this.getBuffer().getInt();
                long tid = this.getBuffer().getLong();
                RedoRecordHead recordHead = new RedoRecordHead(head, cubeId, tid);
                if (!(cubeId != 0)) {
                    boolean $i$a$-require-ReadedRedoPage$next$52 = false;
                    String $i$a$-require-ReadedRedoPage$next$52 = "redoPage.v2 cubeId must be not equal to zero.";
                    throw new IllegalArgumentException($i$a$-require-ReadedRedoPage$next$52.toString());
                }
                ByteBuffer body = ByteBuffer.allocate(recordHead.getLength());
                this.getBuffer().get(body.array(), 0, recordHead.getLength());
                switch (WhenMappings.$EnumSwitchMapping$0[recordHead.getType().ordinal()]) {
                    case 1: {
                        Intrinsics.checkNotNull((Object)body);
                        iRedoRecord = new DDLRecord(recordHead, body);
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 6: {
                        Intrinsics.checkNotNull((Object)body);
                        iRedoRecord = new DMLRecordV2(recordHead, body);
                        break;
                    }
                    case 4: {
                        IRedoRecordHead iRedoRecordHead = recordHead;
                        Intrinsics.checkNotNull((Object)body);
                        iRedoRecord = new CubeRecoverRecord(iRedoRecordHead, body);
                        break;
                    }
                    case 5: {
                        IRedoRecordHead iRedoRecordHead = recordHead;
                        Intrinsics.checkNotNull((Object)body);
                        iRedoRecord = new TranStatusRecord(iRedoRecordHead, body);
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                return iRedoRecord;
            }
            case 3: {
                IRedoRecord iRedoRecord;
                short head = this.getBuffer().getShort();
                byte bofAndEof = this.getBuffer().get();
                int cubeId = this.getBuffer().getInt();
                long tid = this.getBuffer().getLong();
                int partitionId = this.getBuffer().getInt();
                RedoRecordHeadV3 recordHead = new RedoRecordHeadV3(head, bofAndEof, cubeId, tid, partitionId);
                if (!(recordHead.getCubeId() != 0)) {
                    boolean bl = false;
                    String string2 = "redoPage.v3 cubeId must be not equal to zero.";
                    throw new IllegalArgumentException(string2.toString());
                }
                ByteBuffer body = ByteBuffer.allocate(recordHead.getLength());
                this.getBuffer().get(body.array(), 0, recordHead.getLength());
                switch (WhenMappings.$EnumSwitchMapping$0[recordHead.getType().ordinal()]) {
                    case 1: {
                        Intrinsics.checkNotNull((Object)body);
                        iRedoRecord = new DDLRecordV3(recordHead, body);
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 6: {
                        Intrinsics.checkNotNull((Object)body);
                        iRedoRecord = new DMLRecordV3(recordHead, body);
                        break;
                    }
                    case 4: {
                        IRedoRecordHead iRedoRecordHead = recordHead;
                        Intrinsics.checkNotNull((Object)body);
                        iRedoRecord = new CubeRecoverRecord(iRedoRecordHead, body);
                        break;
                    }
                    case 5: {
                        IRedoRecordHead iRedoRecordHead = recordHead;
                        Intrinsics.checkNotNull((Object)body);
                        iRedoRecord = new TranStatusRecord(iRedoRecordHead, body);
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                return iRedoRecord;
            }
        }
        String string3 = Res.INSTANCE.getReadedRedoPageException_1();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"<get-ReadedRedoPageException_1>(...)");
        Object[] objectArray = new Object[]{this.getVersion()};
        throw Res.INSTANCE.getRuntimeException(string3, objectArray);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RedoType.values().length];
            try {
                nArray[RedoType.METADATA.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RedoType.INSERT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RedoType.UPDATE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RedoType.CubeRecover.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RedoType.TranStatus.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RedoType.Compensation.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

