/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.replication;

import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import kd.bos.olapServer2.common.Paths;
import kd.bos.olapServer2.replication.LSNUtil;
import kd.bos.olapServer2.tools.FileTools;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00042\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007J$\u0010\b\u001a\u00060\u0006j\u0002`\u00072\n\u0010\t\u001a\u00060\u0006j\u0002`\u00072\f\b\u0002\u0010\n\u001a\u00060\u000bj\u0002`\fJ$\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u00072\n\u0010\u0010\u001a\u00060\u0011j\u0002`\u0012\u00a8\u0006\u0013"}, d2={"Lkd/bos/olapServer2/replication/RecoveryFiles;", "", "()V", "getMd5Info", "", "redoPath", "", "Lkd/bos/olapServer2/common/string;", "getOrCreatePath", "basePath", "autoCreate", "", "Lkd/bos/olapServer2/common/bool;", "getRecoveryFilesByStartLsn", "", "Ljava/io/File;", "startLsn", "", "Lkd/bos/olapServer2/common/LSN;", "bos-olap-core2"})
@SourceDebugExtension(value={"SMAP\nRecoveryFiles.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecoveryFiles.kt\nkd/bos/olapServer2/replication/RecoveryFiles\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,73:1\n13309#2,2:74\n13309#2,2:78\n1002#3,2:76\n*S KotlinDebug\n*F\n+ 1 RecoveryFiles.kt\nkd/bos/olapServer2/replication/RecoveryFiles\n*L\n23#1:74,2\n50#1:78,2\n31#1:76,2\n*E\n"})
public final class RecoveryFiles {
    @NotNull
    public static final RecoveryFiles INSTANCE = new RecoveryFiles();

    private RecoveryFiles() {
    }

    @Nullable
    public final byte[] getMd5Info(@NotNull String redoPath) {
        byte[] byArray;
        File[] files;
        Intrinsics.checkNotNullParameter((Object)redoPath, (String)"redoPath");
        String recoveryFilesPath = RecoveryFiles.getOrCreatePath$default(this, redoPath, false, 2, null);
        File[] fileArray = files = Paths.INSTANCE.toFile(recoveryFilesPath).listFiles(RecoveryFiles::getMd5Info$lambda$0);
        if (fileArray == null || fileArray.length == 0) {
            byArray = null;
        } else {
            ArrayList<Pair> list2 = new ArrayList<Pair>();
            Intrinsics.checkNotNull((Object)files);
            File[] $this$forEach$iv = files;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                File element$iv;
                File file = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                Intrinsics.checkNotNull((Object)file);
                String fileName = FilesKt.getNameWithoutExtension((File)file);
                list2.add(new Pair((Object)fileName, (Object)file.length()));
            }
            if (list2.isEmpty()) {
                byArray = null;
            } else {
                List $this$sortBy$iv = list2;
                boolean $i$f$sortBy = false;
                if ($this$sortBy$iv.size() > 1) {
                    CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                        public final int compare(T a, T b) {
                            Pair it = (Pair)a;
                            boolean bl = false;
                            Comparable comparable = (Long)it.getSecond();
                            it = (Pair)b;
                            Comparable comparable2 = comparable;
                            bl = false;
                            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Long)it.getSecond()));
                        }
                    });
                }
                Object[] objectArray = list2.toArray();
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"toArray(...)");
                String string2 = ArraysKt.joinToString$default((Object[])objectArray, null, null, null, (int)0, null, null, (int)63, null);
                byte[] byArray2 = string2.getBytes(Charsets.UTF_8);
                byArray = byArray2;
                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"this as java.lang.String).getBytes(charset)");
            }
        }
        return byArray;
    }

    @NotNull
    public final List<File> getRecoveryFilesByStartLsn(@NotNull String redoPath, long startLsn) {
        List list2;
        File[] files;
        Intrinsics.checkNotNullParameter((Object)redoPath, (String)"redoPath");
        String recoveryFilesPath = RecoveryFiles.getOrCreatePath$default(this, redoPath, false, 2, null);
        File[] fileArray = files = Paths.INSTANCE.toFile(recoveryFilesPath).listFiles(RecoveryFiles::getRecoveryFilesByStartLsn$lambda$3);
        if (fileArray == null || fileArray.length == 0) {
            list2 = new ArrayList();
        } else {
            ArrayList<File> resultFiles = new ArrayList<File>();
            Intrinsics.checkNotNull((Object)files);
            File[] $this$forEach$iv = files;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                File element$iv;
                File file = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                Intrinsics.checkNotNull((Object)file);
                String fileName = FilesKt.getNameWithoutExtension((File)file);
                if (LSNUtil.INSTANCE.getLsnByBackupFileName(fileName) < startLsn) continue;
                resultFiles.add(file);
            }
            list2 = resultFiles;
        }
        return list2;
    }

    @NotNull
    public final String getOrCreatePath(@NotNull String basePath, boolean autoCreate) {
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        String[] stringArray = new String[]{"recoveryFiles"};
        String path = ((Object)Paths.INSTANCE.get(basePath, stringArray)).toString();
        if (autoCreate) {
            FileTools.INSTANCE.autoMakeDir(path);
        }
        return path;
    }

    public static /* synthetic */ String getOrCreatePath$default(RecoveryFiles recoveryFiles, String string2, boolean bl, int n, Object object2) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return recoveryFiles.getOrCreatePath(string2, bl);
    }

    private static final boolean getMd5Info$lambda$0(File file, String name2) {
        Intrinsics.checkNotNull((Object)name2);
        return StringsKt.endsWith$default((String)name2, (String)".backup", (boolean)false, (int)2, null);
    }

    private static final boolean getRecoveryFilesByStartLsn$lambda$3(File file, String name2) {
        Intrinsics.checkNotNull((Object)name2);
        return StringsKt.endsWith$default((String)name2, (String)".backup", (boolean)false, (int)2, null);
    }
}

