/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.replication;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import kd.bos.olapServer2.backup.sequenceLog.SeqRedoLogger;
import kd.bos.olapServer2.common.OlapConfigItems;
import kd.bos.olapServer2.common.Paths;
import kd.bos.olapServer2.common.PathsKt;
import kd.bos.olapServer2.monitorReports.HealthReport;
import kd.bos.olapServer2.monitorReports.HealthReportLevel;
import kd.bos.olapServer2.replication.LSNContext;
import kd.bos.olapServer2.replication.LSNUtil;
import kd.bos.olapServer2.replication.OlapLogger;
import kd.bos.olapServer2.replication.RecoveryFiles;
import kd.bos.olapServer2.replication.ReplicationContext;
import kd.bos.olapServer2.security.PrivilegeType;
import kd.bos.olapServer2.storages.DiskFreeSpaceChecker;
import kd.bos.olapServer2.tools.FileTools;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.LongRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u00017B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ(\u0010\u001b\u001a\u00020\u001c2\u0010\b\u0002\u0010\u001d\u001a\n\u0018\u00010\u0007j\u0004\u0018\u0001`\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001c0 H\u0002J\u0014\u0010!\u001a\u00020\u001c2\n\u0010\"\u001a\u00060\u000fj\u0002`\u0013H\u0002J\b\u0010#\u001a\u00020\u001cH\u0002J\b\u0010$\u001a\u00020\u001cH\u0002J\b\u0010%\u001a\u00020\u001cH\u0016J\u0018\u0010&\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020(H\u0002J\u001a\u0010*\u001a\u00020\u001c2\u0010\u0010+\u001a\f\u0012\b\u0012\u00060\u000fj\u0002`\u00130 H\u0002J\b\u0010,\u001a\u00020\u001cH\u0002J\u0014\u0010-\u001a\u00020\u001c2\n\u0010.\u001a\u00060\u000fj\u0002`\u0013H\u0002J\u0014\u0010/\u001a\u00020\u001c2\n\u0010\"\u001a\u00060\u000fj\u0002`\u0013H\u0002J\f\u00100\u001a\u00060\rj\u0002`1H\u0002J\b\u00102\u001a\u00020\u001cH\u0002J\u0006\u00103\u001a\u00020\u001cJ\"\u00104\u001a\u00020\u001c2\u0006\u00105\u001a\u0002062\u0010\b\u0002\u0010\u001d\u001a\n\u0018\u00010\u0007j\u0004\u0018\u0001`\u001eH\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000e\u001a\n\u0018\u00010\u000fj\u0004\u0018\u0001`\u0010X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0012\u001a\u00060\u000fj\u0002`\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0014\u001a\u00060\u000fj\u0002`\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0016\u001a\u00060\u0017j\u0002`\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0019\u001a\u00060\u001aR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lkd/bos/olapServer2/replication/RedoArchiver;", "Ljava/io/Closeable;", "lsnContext", "Lkd/bos/olapServer2/replication/LSNContext;", "replicationContext", "Lkd/bos/olapServer2/replication/ReplicationContext;", "redoPath", "", "backupPath", "(Lkd/bos/olapServer2/replication/LSNContext;Lkd/bos/olapServer2/replication/ReplicationContext;Ljava/lang/String;Ljava/lang/String;)V", "diskFreeSpaceChecker", "Lkd/bos/olapServer2/storages/DiskFreeSpaceChecker;", "isArchiverFailed", "", "lastDeleteOutDateRedozFileTime", "", "Lkd/bos/olapServer2/common/long;", "Ljava/lang/Long;", "nextArchiveRedoFileStartLsn", "Lkd/bos/olapServer2/common/LSN;", "nextDeletedRedoFileLsn", "redoArchiverPath", "redoKeepSegments", "", "Lkd/bos/olapServer2/common/int;", "worker", "Lkd/bos/olapServer2/replication/RedoArchiver$Worker;", "check", "", "actionName", "Lkd/bos/olapServer2/common/string;", "action", "Lkotlin/Function0;", "checkArchivedFile", "curRedoFileLsn", "checkTmpRedoFile", "clearSrcRedoFiles", "close", "copyFile", "src", "Ljava/nio/file/Path;", "dst", "copyRedoFiles", "getCurRedoFileLsn", "deleteOutDateRedoFiles", "deleteRecoveryFiles", "delLsn", "deleteSrcRedoFile", "isNeedDelete", "Lkd/bos/olapServer2/common/bool;", "start", "wakeup", "warn", "t", "", "Worker", "bos-olap-core2"})
@SourceDebugExtension(value={"SMAP\nRedoArchiver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RedoArchiver.kt\nkd/bos/olapServer2/replication/RedoArchiver\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 OlapLogger.kt\nkd/bos/olapServer2/replication/OlapLogger\n*L\n1#1,425:1\n13309#2,2:426\n3792#2:429\n4307#2,2:430\n3792#2:434\n4307#2,2:435\n13309#2,2:462\n13309#2,2:464\n1#3:428\n1855#4,2:432\n1855#4,2:437\n64#5,23:439\n*S KotlinDebug\n*F\n+ 1 RedoArchiver.kt\nkd/bos/olapServer2/replication/RedoArchiver\n*L\n72#1:426,2\n174#1:429\n174#1:430,2\n190#1:434\n190#1:435,2\n401#1:462,2\n417#1:464,2\n175#1:432,2\n191#1:437,2\n356#1:439,23\n*E\n"})
public final class RedoArchiver
implements Closeable {
    @NotNull
    private final LSNContext lsnContext;
    @NotNull
    private final ReplicationContext replicationContext;
    @NotNull
    private final String redoPath;
    @NotNull
    private final Worker worker;
    @NotNull
    private final String redoArchiverPath;
    private long nextArchiveRedoFileStartLsn;
    private long nextDeletedRedoFileLsn;
    private boolean isArchiverFailed;
    private final int redoKeepSegments;
    @NotNull
    private final DiskFreeSpaceChecker diskFreeSpaceChecker;
    @Nullable
    private Long lastDeleteOutDateRedozFileTime;

    public RedoArchiver(@NotNull LSNContext lsnContext, @NotNull ReplicationContext replicationContext, @NotNull String redoPath, @NotNull String backupPath) {
        Intrinsics.checkNotNullParameter((Object)lsnContext, (String)"lsnContext");
        Intrinsics.checkNotNullParameter((Object)replicationContext, (String)"replicationContext");
        Intrinsics.checkNotNullParameter((Object)redoPath, (String)"redoPath");
        Intrinsics.checkNotNullParameter((Object)backupPath, (String)"backupPath");
        this.lsnContext = lsnContext;
        this.replicationContext = replicationContext;
        this.redoPath = redoPath;
        String string2 = RedoArchiver.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        this.worker = new Worker(string2);
        String[] stringArray = new String[]{"increment"};
        this.redoArchiverPath = ((Object)Paths.INSTANCE.get(backupPath, stringArray)).toString();
        this.redoKeepSegments = this.replicationContext.getWorkspace$bos_olap_core2().getCurrentNode().getConf().get_node().getRedoKeepSegments();
        this.diskFreeSpaceChecker = new DiskFreeSpaceChecker("RedoArchiver-Out-Of-Disk-Space", this.redoArchiverPath, this.replicationContext.getWorkspace$bos_olap_core2().getOlapWorkspace$bos_olap_core2().getHealthReports(), true);
        FileTools.INSTANCE.autoMakeDir(this.redoArchiverPath);
        this.start();
    }

    private final void checkTmpRedoFile() {
        block1: {
            File[] fileArray = Paths.INSTANCE.toFile(this.redoArchiverPath).listFiles(RedoArchiver::checkTmpRedoFile$lambda$0);
            if (fileArray == null) break block1;
            File[] $this$forEach$iv = fileArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                File element$iv;
                File it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                it.delete();
                String[] stringArray = new String[1];
                Intrinsics.checkNotNull((Object)it);
                stringArray[0] = FilesKt.getNameWithoutExtension((File)it);
                Path srcPath = Paths.INSTANCE.get(this.redoPath, stringArray);
                stringArray = new String[]{FilesKt.getNameWithoutExtension((File)it)};
                this.copyFile(srcPath, Paths.INSTANCE.get(this.redoArchiverPath, stringArray));
            }
        }
    }

    private final void checkArchivedFile(long curRedoFileLsn) {
        if (LSNUtil.INSTANCE.fileLSN(curRedoFileLsn) == 0L) {
            return;
        }
        this.copyRedoFiles((Function0<Long>)((Function0)new Function0<Long>(curRedoFileLsn){
            final /* synthetic */ long $curRedoFileLsn;
            {
                this.$curRedoFileLsn = $curRedoFileLsn;
                super(0);
            }

            @NotNull
            public final Long invoke() {
                return this.$curRedoFileLsn;
            }
        }));
    }

    private final boolean isNeedDelete() {
        Instant instant;
        long nowTime = new Date().getTime();
        Instant cutoffTime = Instant.ofEpochMilli(nowTime).minus(1L, ChronoUnit.DAYS);
        Long l = this.lastDeleteOutDateRedozFileTime;
        if (l != null) {
            long it = ((Number)l).longValue();
            boolean bl = false;
            instant = Instant.ofEpochMilli(it);
        } else {
            instant = null;
        }
        Instant lastDeleteTime = instant;
        return lastDeleteTime != null && cutoffTime.isBefore(lastDeleteTime);
    }

    private final void copyRedoFiles(Function0<Long> getCurRedoFileLsn) {
        long latestRedoFileStartLsn;
        long beginPoint = this.nextArchiveRedoFileStartLsn;
        long curRedoFileLsn = 0L;
        if (this.isNeedDelete()) {
            this.deleteOutDateRedoFiles();
        }
        do {
            if (this.worker.isStopped()) {
                return;
            }
            if (this.isArchiverFailed) {
                try {
                    this.checkTmpRedoFile();
                    this.isArchiverFailed = false;
                }
                catch (Throwable t2) {
                    RedoArchiver.warn$default(this, t2, null, 2, null);
                }
            }
            this.diskFreeSpaceChecker.checkExecuteByFreeSpace();
            curRedoFileLsn = ((Number)getCurRedoFileLsn.invoke()).longValue();
            latestRedoFileStartLsn = LSNUtil.INSTANCE.fileLSN(curRedoFileLsn);
            if (latestRedoFileStartLsn <= this.nextArchiveRedoFileStartLsn) break;
            String filename = LSNUtil.getFileName$default(LSNUtil.INSTANCE, this.nextArchiveRedoFileStartLsn, false, 2, null);
            String[] stringArray = new String[]{filename};
            Path destinationPath = Paths.INSTANCE.get(this.redoArchiverPath, stringArray);
            String[] stringArray2 = new String[]{filename};
            Path sourcePath = Paths.INSTANCE.get(this.redoPath, stringArray2);
            this.check("copyRedoFiles", (Function0<Unit>)((Function0)new Function0<Unit>(this, sourcePath, destinationPath){
                final /* synthetic */ RedoArchiver this$0;
                final /* synthetic */ Path $sourcePath;
                final /* synthetic */ Path $destinationPath;
                {
                    this.this$0 = $receiver;
                    this.$sourcePath = $sourcePath;
                    this.$destinationPath = $destinationPath;
                    super(0);
                }

                public final void invoke() {
                    RedoArchiver.access$copyFile(this.this$0, this.$sourcePath, this.$destinationPath);
                    RedoArchiver.access$setNextArchiveRedoFileStartLsn$p(this.this$0, LSNUtil.INSTANCE.nextFileLSN(RedoArchiver.access$getNextArchiveRedoFileStartLsn$p(this.this$0)));
                }
            }));
            this.deleteSrcRedoFile(curRedoFileLsn);
        } while (latestRedoFileStartLsn > this.nextArchiveRedoFileStartLsn);
        this.replicationContext.getWorkspace$bos_olap_core2().getBackupRecordWorkspace().copyRecoveryFilesToBackup(this.redoPath, beginPoint, curRedoFileLsn);
        this.deleteRecoveryFiles(this.nextDeletedRedoFileLsn);
    }

    /*
     * WARNING - void declaration
     */
    private final void deleteOutDateRedoFiles() {
        int n;
        void $this$forEach$iv;
        boolean $i$f$forEach;
        Object it;
        Object element$iv$iv;
        File[] $this$filterTo$iv$iv;
        boolean $i$f$filterTo;
        Collection destination$iv$iv;
        boolean $i$f$filter;
        Object $this$filter$iv;
        long nowTime = new Date().getTime();
        Instant cutoffTime = Instant.ofEpochMilli(nowTime).minus(OlapConfigItems.INSTANCE.getIncrementRetentionDaysConfigItem$bos_olap_core2().getValue(), ChronoUnit.DAYS);
        long endLSN = 0L;
        endLSN = Long.MAX_VALUE;
        boolean deleted = false;
        File[] fileArray = new File(this.redoArchiverPath).listFiles();
        if (fileArray != null) {
            $this$filter$iv = fileArray;
            $i$f$filter = false;
            File[] fileArray2 = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            int n2 = $this$filterTo$iv$iv.length;
            for (int i = 0; i < n2; ++i) {
                it = element$iv$iv = $this$filterTo$iv$iv[i];
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                if (!Intrinsics.areEqual((Object)FilesKt.getExtension((File)it), (Object)"redoz")) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File file = (File)element$iv;
                n = 0;
                BasicFileAttributes attrs = Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]);
                Instant creationTime = attrs.lastModifiedTime().toInstant();
                if (!creationTime.isBefore(cutoffTime)) continue;
                Intrinsics.checkNotNull((Object)file);
                LongRange range = LSNUtil.INSTANCE.getLsnRangeByFileName(FilesKt.getNameWithoutExtension((File)file));
                if (range.getFirst() < endLSN) {
                    endLSN = range.getFirst();
                    deleted = true;
                }
                file.delete();
            }
        }
        if (deleted) {
            File[] fileArray3 = new File(this.redoArchiverPath).listFiles();
            if (fileArray3 != null) {
                $this$filter$iv = fileArray3;
                $i$f$filter = false;
                $this$filterTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                $i$f$filterTo = false;
                int attrs = $this$filterTo$iv$iv.length;
                for (n = 0; n < attrs; ++n) {
                    it = element$iv$iv = $this$filterTo$iv$iv[n];
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it);
                    if (!Intrinsics.areEqual((Object)FilesKt.getExtension((File)it), (Object)"redoz")) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    File file = (File)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)file);
                    LongRange range = LSNUtil.INSTANCE.getLsnRangeByFileName(FilesKt.getNameWithoutExtension((File)file));
                    if (range.getFirst() > endLSN) continue;
                    file.delete();
                }
            }
        }
        this.lastDeleteOutDateRedozFileTime = new Date().getTime();
    }

    private final void copyFile(Path src, Path dst) {
        Path tmpPath = Paths.INSTANCE.get(dst + ".tmp", new String[0]);
        try {
            Files.deleteIfExists(dst);
            File file = src.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
            File file2 = tmpPath.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"toFile(...)");
            FileTools.INSTANCE.copyFileByChannel(file, file2);
            if (!tmpPath.toFile().renameTo(dst.toFile())) {
                throw new IOException("" + '{' + tmpPath + "} failed to rename");
            }
            SeqRedoLogger seqRedoLogger = this.replicationContext.getWorkspace$bos_olap_core2().getIncrementRedoSeqLogger$bos_olap_core2();
            File file3 = dst.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"toFile(...)");
            seqRedoLogger.addFile(file3);
        }
        catch (FileNotFoundException e) {
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.exists(tmpPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                Files.delete(tmpPath);
            }
            RedoArchiver.warn$default(this, e, null, 2, null);
        }
    }

    private final void start() {
        this.worker.start();
    }

    public final void wakeup() {
        LockSupport.unpark(this.worker);
    }

    @Override
    public void close() {
        if (!this.worker.isAlive() || this.worker.isStopped()) {
            return;
        }
        this.worker.setStopped(true);
        this.wakeup();
        this.worker.join();
    }

    private final void check(String actionName, Function0<Unit> action) {
        try {
            action.invoke();
        }
        catch (Throwable t2) {
            CharSequence charSequence = actionName;
            if (charSequence == null || charSequence.length() == 0) {
                RedoArchiver.warn$default(this, t2, null, 2, null);
            } else {
                this.warn(t2, actionName);
            }
            this.isArchiverFailed = true;
        }
    }

    static /* synthetic */ void check$default(RedoArchiver redoArchiver, String string2, Function0 function0, int n, Object object2) {
        if ((n & 1) != 0) {
            string2 = null;
        }
        redoArchiver.check(string2, (Function0<Unit>)function0);
    }

    private final void warn(Throwable t2, String actionName) {
        String rid = "Redo-Archiver-Waring";
        if (actionName != null) {
            rid = rid + '-' + actionName;
        }
        OlapLogger this_$iv = this.replicationContext.getWorkspace$bos_olap_core2().getLogger$bos_olap_core2();
        boolean $i$f$warn = false;
        OlapLogger this_$iv$iv = this_$iv;
        boolean $i$f$reportAndLog = false;
        if (this_$iv$iv.isWarnEnabled()) {
            boolean bl = false;
            StringBuilder stringBuilder = new StringBuilder().append("redo archived error: ");
            String string2 = t2.getMessage();
            if (string2 == null) {
                string2 = "";
            }
            String message$iv$iv = stringBuilder.append(string2).toString();
            HealthReport report$iv$iv = new HealthReport(rid, null, this_$iv$iv.getStatus().get().name() + "-ReplicationWarn: " + message$iv$iv, HealthReportLevel.Warning, PrivilegeType.None.getCode());
            this_$iv$iv.getOlapWorkspace().getHealthReports().commit(report$iv$iv);
            if (t2 == null) {
                OlapLogger.access$getLogger$cp().warn(message$iv$iv);
            } else {
                OlapLogger.access$getLogger$cp().warn("{}", (Object)message$iv$iv, (Object)t2);
            }
        }
    }

    static /* synthetic */ void warn$default(RedoArchiver redoArchiver, Throwable throwable, String string2, int n, Object object2) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        redoArchiver.warn(throwable, string2);
    }

    private final void deleteSrcRedoFile(long curRedoFileLsn) {
        if (this.redoKeepSegments <= 0) {
            return;
        }
        long lastDeleteLsn = LSNUtil.INSTANCE.prevNFileLSN(curRedoFileLsn, this.redoKeepSegments);
        if (lastDeleteLsn == -1L || lastDeleteLsn < this.nextDeletedRedoFileLsn) {
            return;
        }
        File deleteFile = Paths.INSTANCE.toFile(this.redoPath, LSNUtil.getFileName$default(LSNUtil.INSTANCE, this.nextDeletedRedoFileLsn, false, 2, null));
        if (deleteFile.exists()) {
            deleteFile.delete();
        }
        this.nextDeletedRedoFileLsn = LSNUtil.INSTANCE.nextFileLSN(this.nextDeletedRedoFileLsn);
    }

    private final void clearSrcRedoFiles() {
        File[] redoFiles;
        if (this.redoKeepSegments <= 0) {
            return;
        }
        long nextLsn = this.lsnContext.getNextWritePage();
        long lastDeleteLsn = LSNUtil.INSTANCE.prevNFileLSN(nextLsn, this.redoKeepSegments);
        if (lastDeleteLsn == -1L) {
            return;
        }
        if (!(lastDeleteLsn != LSNUtil.INSTANCE.fileLSN(nextLsn))) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        String lastDeleteFile = LSNUtil.getFileName$default(LSNUtil.INSTANCE, lastDeleteLsn, false, 2, null);
        if (redoFiles != null) {
            File[] $this$forEach$iv = redoFiles = PathsKt.fileSafeConstructor(this.redoPath).listFiles(RedoArchiver::clearSrcRedoFiles$lambda$8);
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                File element$iv;
                File file = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                if (file.getName().compareTo(lastDeleteFile) > 0) continue;
                file.delete();
            }
        }
        this.deleteRecoveryFiles(lastDeleteLsn);
    }

    private final void deleteRecoveryFiles(long delLsn) {
        block1: {
            File[] files;
            String recoveryBackupPath = RecoveryFiles.getOrCreatePath$default(RecoveryFiles.INSTANCE, this.redoPath, false, 2, null);
            if (files == null) break block1;
            File[] $this$forEach$iv = files = PathsKt.fileSafeConstructor(recoveryBackupPath).listFiles(RedoArchiver::deleteRecoveryFiles$lambda$10);
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                File element$iv;
                File file = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                Intrinsics.checkNotNull((Object)file);
                long fileLsn = LSNUtil.INSTANCE.getLsnByBackupFileName(FilesKt.getNameWithoutExtension((File)file));
                if (fileLsn > delLsn) continue;
                file.delete();
            }
        }
    }

    private static final boolean checkTmpRedoFile$lambda$0(File file, String name2) {
        Intrinsics.checkNotNull((Object)name2);
        return StringsKt.endsWith$default((String)name2, (String)"redo.tmp", (boolean)false, (int)2, null);
    }

    private static final boolean clearSrcRedoFiles$lambda$8(File file, String fileName) {
        Intrinsics.checkNotNull((Object)fileName);
        return StringsKt.endsWith$default((String)fileName, (String)".redo", (boolean)false, (int)2, null);
    }

    private static final boolean deleteRecoveryFiles$lambda$10(File file, String fileName) {
        Intrinsics.checkNotNull((Object)fileName);
        return StringsKt.endsWith$default((String)fileName, (String)".backup", (boolean)false, (int)2, null);
    }

    public static final /* synthetic */ void access$copyFile(RedoArchiver $this, Path src, Path dst) {
        $this.copyFile(src, dst);
    }

    public static final /* synthetic */ long access$getNextArchiveRedoFileStartLsn$p(RedoArchiver $this) {
        return $this.nextArchiveRedoFileStartLsn;
    }

    public static final /* synthetic */ void access$copyRedoFiles(RedoArchiver $this, Function0 getCurRedoFileLsn) {
        $this.copyRedoFiles((Function0<Long>)getCurRedoFileLsn);
    }

    public static final /* synthetic */ void access$checkTmpRedoFile(RedoArchiver $this) {
        $this.checkTmpRedoFile();
    }

    public static final /* synthetic */ void access$deleteOutDateRedoFiles(RedoArchiver $this) {
        $this.deleteOutDateRedoFiles();
    }

    public static final /* synthetic */ void access$checkArchivedFile(RedoArchiver $this, long curRedoFileLsn) {
        $this.checkArchivedFile(curRedoFileLsn);
    }

    public static final /* synthetic */ void access$clearSrcRedoFiles(RedoArchiver $this) {
        $this.clearSrcRedoFiles();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\f\u001a\u00020\u000bH\u0016J\f\u0010\r\u001a\u00060\u000ej\u0002`\u000fH\u0002R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u0010"}, d2={"Lkd/bos/olapServer2/replication/RedoArchiver$Worker;", "Ljava/lang/Thread;", "name", "", "(Lkd/bos/olapServer2/replication/RedoArchiver;Ljava/lang/String;)V", "isStopped", "", "()Z", "setStopped", "(Z)V", "preCheck", "", "run", "updateNextArchiveRedoFileStartLsn", "", "Lkd/bos/olapServer2/common/LSN;", "bos-olap-core2"})
    private final class Worker
    extends Thread {
        private volatile boolean isStopped;

        public Worker(String name2) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            super(name2);
        }

        public final boolean isStopped() {
            return this.isStopped;
        }

        public final void setStopped(boolean bl) {
            this.isStopped = bl;
        }

        @Override
        public void run() {
            this.preCheck();
            while (!this.isStopped) {
                RedoArchiver.check$default(RedoArchiver.this, null, (Function0)new Function0<Unit>(this, RedoArchiver.this){
                    final /* synthetic */ Worker this$0;
                    final /* synthetic */ RedoArchiver this$1;
                    {
                        this.this$0 = $receiver;
                        this.this$1 = $receiver2;
                        super(0);
                    }

                    public final void invoke() {
                        long timeout = TimeUnit.MINUTES.toNanos(1L);
                        LockSupport.parkNanos(this.this$0, timeout);
                        RedoArchiver.access$copyRedoFiles(this.this$1, (Function0)new MutablePropertyReference0Impl(RedoArchiver.access$getLsnContext$p(this.this$1)){

                            @Nullable
                            public Object get() {
                                return ((LSNContext)this.receiver).getNextWritePage();
                            }

                            public void set(@Nullable Object value2) {
                                ((LSNContext)this.receiver).setNextWritePage(((Number)value2).longValue());
                            }
                        });
                    }
                }, 1, null);
            }
        }

        private final void preCheck() {
            RedoArchiver.this.check("checkTmpRedoFile", (Function0<Unit>)((Function0)new Function0<Unit>(RedoArchiver.this){
                final /* synthetic */ RedoArchiver this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    RedoArchiver.access$checkTmpRedoFile(this.this$0);
                }
            }));
            RedoArchiver.this.check("deleteOutDateRedoFiles", (Function0<Unit>)((Function0)new Function0<Unit>(RedoArchiver.this){
                final /* synthetic */ RedoArchiver this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    RedoArchiver.access$deleteOutDateRedoFiles(this.this$0);
                }
            }));
            RedoArchiver.this.nextArchiveRedoFileStartLsn = this.updateNextArchiveRedoFileStartLsn();
            RedoArchiver.this.check("checkArchivedFile", (Function0<Unit>)((Function0)new Function0<Unit>(RedoArchiver.this){
                final /* synthetic */ RedoArchiver this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    RedoArchiver.access$checkArchivedFile(this.this$0, RedoArchiver.access$getLsnContext$p(this.this$0).getNextWritePage());
                }
            }));
            RedoArchiver.this.check("clearSrcRedoFiles", (Function0<Unit>)((Function0)new Function0<Unit>(RedoArchiver.this){
                final /* synthetic */ RedoArchiver this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    RedoArchiver.access$clearSrcRedoFiles(this.this$0);
                }
            }));
            long lastDeleteLsn = LSNUtil.INSTANCE.prevNFileLSN(RedoArchiver.this.lsnContext.getNextWritePage(), RedoArchiver.this.redoKeepSegments);
            RedoArchiver.this.nextDeletedRedoFileLsn = lastDeleteLsn == -1L ? 0L : LSNUtil.INSTANCE.nextFileLSN(lastDeleteLsn);
        }

        private final long updateNextArchiveRedoFileStartLsn() {
            long lsn = LSNUtil.INSTANCE.getRealLsnRangeByFolderPath(RedoArchiver.this.redoArchiverPath).getLast();
            if (lsn == -1L) {
                lsn = 0L;
            }
            if (lsn % SeqRedoLogger.Companion.getRedoFileSize() != 0L) {
                lsn = LSNUtil.INSTANCE.fileLSN(lsn);
            }
            return lsn;
        }
    }
}

