/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.replication;

import java.io.Closeable;
import java.nio.ByteBuffer;
import kd.bos.olapServer2.replication.MasterLSNContext;
import kd.bos.olapServer2.replication.RedoPage;
import kd.bos.olapServer2.replication.RedoWriterV2;
import kd.bos.olapServer2.replication.WritedRedoPage;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0011\u001a\u00020\u0007H\u0016J\u0019\u0010\u0012\u001a\u00060\u0013j\u0002`\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b\u0017J\u0019\u0010\u0018\u001a\u00020\u00072\n\u0010\u0019\u001a\u00060\u0013j\u0002`\u0014H\u0000\u00a2\u0006\u0002\b\u001aR\u000e\u0010\t\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lkd/bos/olapServer2/replication/RedoBuffer;", "Ljava/io/Closeable;", "masterLSNContext", "Lkd/bos/olapServer2/replication/MasterLSNContext;", "sync", "Lkotlin/Function1;", "Lkd/bos/olapServer2/replication/RedoPage;", "", "(Lkd/bos/olapServer2/replication/MasterLSNContext;Lkotlin/jvm/functions/Function1;)V", "count", "", "ringArray", "", "Lkd/bos/olapServer2/replication/WritedRedoPage;", "[Lkd/bos/olapServer2/replication/WritedRedoPage;", "rw", "Lkd/bos/olapServer2/replication/RedoWriterV2;", "close", "forceMerge", "", "Lkd/bos/olapServer2/common/LSN;", "src", "Ljava/nio/ByteBuffer;", "forceMerge$bos_olap_core2", "forceSync", "syncPoint", "forceSync$bos_olap_core2", "bos-olap-core2"})
public final class RedoBuffer
implements Closeable {
    private final int count;
    @NotNull
    private final WritedRedoPage[] ringArray;
    @NotNull
    private final RedoWriterV2 rw;

    public RedoBuffer(@NotNull MasterLSNContext masterLSNContext, @NotNull Function1<? super RedoPage, Unit> sync) {
        Intrinsics.checkNotNullParameter((Object)masterLSNContext, (String)"masterLSNContext");
        Intrinsics.checkNotNullParameter(sync, (String)"sync");
        this.count = 2048;
        int n = 0;
        int n2 = this.count;
        WritedRedoPage[] writedRedoPageArray = new WritedRedoPage[n2];
        RedoBuffer redoBuffer2 = this;
        while (n < n2) {
            int n3 = n++;
            writedRedoPageArray[n3] = new WritedRedoPage();
        }
        redoBuffer2.ringArray = writedRedoPageArray;
        this.rw = new RedoWriterV2(masterLSNContext, this.count, (Function1<? super Integer, Unit>)((Function1)new Function1<Integer, Unit>(this, sync){
            final /* synthetic */ RedoBuffer this$0;
            final /* synthetic */ Function1<RedoPage, Unit> $sync;
            {
                this.this$0 = $receiver;
                this.$sync = $sync;
                super(1);
            }

            public final void invoke(int it) {
                RedoBuffer.access$getRingArray$p(this.this$0)[it].flush$bos_olap_core2(this.$sync);
            }
        }));
    }

    @Override
    public void close() {
        this.rw.close();
    }

    public final long forceMerge$bos_olap_core2(@NotNull ByteBuffer src) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        int bufferSize = src.remaining();
        if (!(bufferSize <= 8170)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        long writePageLsn = 0L;
        int index2 = 0;
        int position = 0;
        do {
            Triple<Long, Integer, Integer> triple = this.rw.markOccupy(bufferSize);
            writePageLsn = ((Number)triple.getFirst()).longValue();
            index2 = ((Number)triple.getSecond()).intValue();
            position = ((Number)triple.getThird()).intValue();
        } while (writePageLsn == -1L);
        WritedRedoPage redoPage = this.ringArray[index2];
        redoPage.writeByteBuffer(position, src, bufferSize, writePageLsn);
        this.rw.markMergeBuffer(index2);
        return writePageLsn;
    }

    public final void forceSync$bos_olap_core2(long syncPoint) {
        this.rw.forceSync(syncPoint);
    }

    public static final /* synthetic */ WritedRedoPage[] access$getRingArray$p(RedoBuffer $this) {
        return $this.ringArray;
    }
}

