/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.replication;

import java.io.Closeable;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import kd.bos.olapServer2.common.Paths;
import kd.bos.olapServer2.replication.LSNUtil;
import kd.bos.olapServer2.tools.Res;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b \u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB+\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0018\u001a\u00020\u0019H\u0016J\n\u0010\u001a\u001a\u00060\u0003j\u0002`\u001bJ\b\u0010\u001c\u001a\u00020\u0019H\u0004R\u001a\u0010\f\u001a\u00020\rX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u001e\u0010\u0013\u001a\u00060\u0003j\u0002`\u0004X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0012\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lkd/bos/olapServer2/replication/RedoFile;", "Ljava/io/Closeable;", "initFileLSN", "", "Lkd/bos/olapServer2/common/LSN;", "path", "", "Lkd/bos/olapServer2/common/string;", "fileOptions", "", "Ljava/nio/file/OpenOption;", "(JLjava/lang/String;[Ljava/nio/file/OpenOption;)V", "fd", "Ljava/nio/channels/FileChannel;", "getFd", "()Ljava/nio/channels/FileChannel;", "setFd", "(Ljava/nio/channels/FileChannel;)V", "[Ljava/nio/file/OpenOption;", "nextFileLsn", "getNextFileLsn", "()J", "setNextFileLsn", "(J)V", "close", "", "size", "Lkd/bos/olapServer2/common/long;", "switchFile", "Companion", "bos-olap-core2"})
public abstract class RedoFile
implements Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String path;
    @NotNull
    private final OpenOption[] fileOptions;
    @NotNull
    private FileChannel fd;
    private long nextFileLsn;
    public static final int fileSize = 0x1000000;

    public RedoFile(long initFileLSN, @NotNull String path, @NotNull OpenOption[] fileOptions) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)fileOptions, (String)"fileOptions");
        this.path = path;
        this.fileOptions = fileOptions;
        this.nextFileLsn = LSNUtil.INSTANCE.nextFileLSN(initFileLSN);
        long fileLSN = LSNUtil.INSTANCE.fileLSN(initFileLSN);
        Object[] objectArray = new String[]{LSNUtil.getFileName$default(LSNUtil.INSTANCE, fileLSN, false, 2, null)};
        Path filepath = Paths.INSTANCE.get(this.path, (String[])objectArray);
        Path path2 = filepath.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"getParent(...)");
        if (!Paths.INSTANCE.toFile(((Object)path2.toAbsolutePath()).toString()).exists()) {
            String string2 = Res.INSTANCE.getRedoFileException_1();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-RedoFileException_1>(...)");
            objectArray = new Object[]{((Object)filepath).toString()};
            throw Res.INSTANCE.getRuntimeException(string2, objectArray);
        }
        OpenOption[] openOptionArray = this.fileOptions;
        FileChannel fileChannel = FileChannel.open(filepath, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)fileChannel, (String)"open(...)");
        this.fd = fileChannel;
    }

    @NotNull
    protected final FileChannel getFd() {
        return this.fd;
    }

    protected final void setFd(@NotNull FileChannel fileChannel) {
        Intrinsics.checkNotNullParameter((Object)fileChannel, (String)"<set-?>");
        this.fd = fileChannel;
    }

    protected final long getNextFileLsn() {
        return this.nextFileLsn;
    }

    protected final void setNextFileLsn(long l) {
        this.nextFileLsn = l;
    }

    protected final void switchFile() {
        this.fd.close();
        if (this.nextFileLsn == 0L) {
            String string2 = Res.INSTANCE.getRedoFileException_2();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-RedoFileException_2>(...)");
            throw Res.INSTANCE.getRuntimeException(string2, new Object[0]);
        }
        String[] stringArray = new String[]{LSNUtil.getFileName$default(LSNUtil.INSTANCE, this.nextFileLsn, false, 2, null)};
        Path nextFilepath = Paths.INSTANCE.get(this.path, stringArray);
        OpenOption[] openOptionArray = this.fileOptions;
        FileChannel fileChannel = FileChannel.open(nextFilepath, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)fileChannel, (String)"open(...)");
        this.fd = fileChannel;
        this.nextFileLsn = LSNUtil.INSTANCE.nextFileLSN(this.nextFileLsn);
    }

    public final long size() {
        return this.fd.size();
    }

    @Override
    public void close() {
        this.fd.close();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lkd/bos/olapServer2/replication/RedoFile$Companion;", "", "()V", "fileSize", "", "bos-olap-core2"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

