/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.replication;

import java.io.Closeable;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.olapServer2.common.NotSupportedException;
import kd.bos.olapServer2.common.OlapConfigItems;
import kd.bos.olapServer2.monitorReports.HealthReport;
import kd.bos.olapServer2.monitorReports.HealthReportLevel;
import kd.bos.olapServer2.replication.LSNUtil;
import kd.bos.olapServer2.replication.OlapLogger;
import kd.bos.olapServer2.replication.RedoArchiver;
import kd.bos.olapServer2.replication.ReplicationConf;
import kd.bos.olapServer2.replication.ReplicationContext;
import kd.bos.olapServer2.replication.ReplicationStatus;
import kd.bos.olapServer2.replication.SignalType;
import kd.bos.olapServer2.replication.SlaveLSNContext;
import kd.bos.olapServer2.replication.TimeStatQueue;
import kd.bos.olapServer2.replication.WritedRedoFile;
import kd.bos.olapServer2.replication.WritedRedoPage;
import kd.bos.olapServer2.security.PrivilegeType;
import kd.bos.olapServer2.server.ReplicationWorkspace;
import kd.bos.olapServer2.tools.CubeToolKt;
import kd.bos.olapServer2.tools.Res;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 M2\u00020\u00012\u00020\u0002:\u0001MB3\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\rJ\b\u00102\u001a\u000203H\u0002J\b\u00104\u001a\u000203H\u0016J\b\u00105\u001a\u000203H\u0002J\b\u00106\u001a\u000203H\u0002J\b\u00107\u001a\u000203H\u0002J\b\u00108\u001a\u000203H\u0002J\b\u00109\u001a\u000203H\u0002J\b\u0010:\u001a\u000203H\u0002J\b\u0010;\u001a\u000203H\u0002J\b\u0010<\u001a\u000203H\u0002J\b\u0010=\u001a\u000203H\u0002J\b\u0010>\u001a\u000203H\u0002J\b\u0010?\u001a\u000203H\u0002J\b\u0010@\u001a\u000203H\u0016J\b\u0010A\u001a\u000203H\u0002J\b\u0010B\u001a\u000203H\u0002J\b\u0010C\u001a\u000203H\u0002J\u0014\u0010D\u001a\u0002032\n\u0010\u001f\u001a\u00060\u001aj\u0002` H\u0002J\b\u0010E\u001a\u000203H\u0002J\b\u0010F\u001a\u000203H\u0002J\b\u0010G\u001a\u000203H\u0002J\b\u0010H\u001a\u000203H\u0016J\u0010\u0010I\u001a\u00060\u0016j\u0002`J*\u000200H\u0002J\u0014\u0010K\u001a\u000203*\u00020\u000f2\u0006\u0010L\u001a\u000200H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u00020\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0012\u0010\u001d\u001a\u00060\u001aj\u0002`\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001f\u001a\u00060\u001aj\u0002` X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010!\u001a\u00020\"8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b%\u0010&\u001a\u0004\b#\u0010$R\u0014\u0010'\u001a\u00020\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u001cR\u000e\u0010)\u001a\u00020*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010+\u001a\u0004\u0018\u00010,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010-\u001a\n \u0010*\u0004\u0018\u00010.0.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010/\u001a\n \u0010*\u0004\u0018\u00010000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00101\u001a\n \u0010*\u0004\u0018\u00010000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006N"}, d2={"Lkd/bos/olapServer2/replication/RedoReceiver;", "Ljava/lang/Thread;", "Ljava/io/Closeable;", "redoArchiver", "Lkd/bos/olapServer2/replication/RedoArchiver;", "conf", "Lkd/bos/olapServer2/replication/ReplicationConf;", "slaveLSNContext", "Lkd/bos/olapServer2/replication/SlaveLSNContext;", "context", "Lkd/bos/olapServer2/replication/ReplicationContext;", "delayTimeStat", "Lkd/bos/olapServer2/replication/TimeStatQueue;", "(Lkd/bos/olapServer2/replication/RedoArchiver;Lkd/bos/olapServer2/replication/ReplicationConf;Lkd/bos/olapServer2/replication/SlaveLSNContext;Lkd/bos/olapServer2/replication/ReplicationContext;Lkd/bos/olapServer2/replication/TimeStatQueue;)V", "controlChannel", "Ljava/nio/channels/SocketChannel;", "kotlin.jvm.PlatformType", "controlChannelKey", "Ljava/nio/channels/SelectionKey;", "dataChannel", "dataChannelKey", "isRunning", "", "isSwitching", "Ljava/util/concurrent/atomic/AtomicBoolean;", "keepAliveTimeoutNs", "", "getKeepAliveTimeoutNs", "()J", "lastKeepAliveTime", "Lkd/bos/olapServer2/common/long;", "lastPage", "Lkd/bos/olapServer2/common/LSN;", "logger", "Lkd/bos/olapServer2/replication/OlapLogger;", "getLogger", "()Lkd/bos/olapServer2/replication/OlapLogger;", "logger$delegate", "Lkotlin/Lazy;", "maxWaitVipNs", "getMaxWaitVipNs", "recvPage", "Lkd/bos/olapServer2/replication/WritedRedoPage;", "redoFile", "Lkd/bos/olapServer2/replication/WritedRedoFile;", "selector", "Ljava/nio/channels/Selector;", "signalReadBuffer", "Ljava/nio/ByteBuffer;", "signalSendBuffer", "checkVip", "", "close", "createThreadToSwitch", "dealAgree", "dealClose", "dealDisagree", "dealKeepAlive", "dealMasterClose", "dealNetworkException", "dealSignal", "dealTimeout", "readControlChannel", "readDataChannel", "run", "sendControlConnect", "sendDataConnect", "sendEndStream", "sendMasterCloseAck", "sendRedoAck", "sendStartStream", "sendSwitchToMaster", "start", "hasCompleteSignal", "Lkd/bos/olapServer2/common/bool;", "writeBuffer", "buffer", "Companion", "bos-olap-core2"})
@SourceDebugExtension(value={"SMAP\nRedoReceiver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RedoReceiver.kt\nkd/bos/olapServer2/replication/RedoReceiver\n+ 2 OlapLogger.kt\nkd/bos/olapServer2/replication/OlapLogger\n*L\n1#1,461:1\n112#2,2:462\n91#2,24:464\n110#2,4:488\n91#2,24:492\n112#2,2:516\n91#2,24:518\n110#2,4:542\n91#2,24:546\n110#2,4:570\n91#2,24:574\n110#2,4:598\n91#2,24:602\n112#2,2:626\n91#2,24:628\n112#2,2:652\n91#2,24:654\n112#2,2:678\n91#2,24:680\n*S KotlinDebug\n*F\n+ 1 RedoReceiver.kt\nkd/bos/olapServer2/replication/RedoReceiver\n*L\n100#1:462,2\n100#1:464,24\n113#1:488,4\n113#1:492,24\n125#1:516,2\n125#1:518,24\n195#1:542,4\n195#1:546,24\n258#1:570,4\n258#1:574,24\n265#1:598,4\n265#1:602,24\n288#1:626,2\n288#1:628,24\n386#1:652,2\n386#1:654,24\n454#1:678,2\n454#1:680,24\n*E\n"})
public final class RedoReceiver
extends Thread
implements Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final RedoArchiver redoArchiver;
    @NotNull
    private final ReplicationConf conf;
    @NotNull
    private final SlaveLSNContext slaveLSNContext;
    @NotNull
    private final ReplicationContext context;
    @Nullable
    private final TimeStatQueue delayTimeStat;
    private volatile boolean isRunning;
    @NotNull
    private final Lazy logger$delegate;
    private final ByteBuffer signalReadBuffer;
    private final ByteBuffer signalSendBuffer;
    @NotNull
    private final WritedRedoPage recvPage;
    @Nullable
    private WritedRedoFile redoFile;
    private SocketChannel controlChannel;
    private SocketChannel dataChannel;
    private final Selector selector;
    @Nullable
    private SelectionKey controlChannelKey;
    @Nullable
    private SelectionKey dataChannelKey;
    private long lastPage;
    private long lastKeepAliveTime;
    @NotNull
    private AtomicBoolean isSwitching;
    private static final int bufferSize = 1024;
    private static final long selectTimeoutMs = 1000L;

    public RedoReceiver(@Nullable RedoArchiver redoArchiver, @NotNull ReplicationConf conf, @NotNull SlaveLSNContext slaveLSNContext, @NotNull ReplicationContext context, @Nullable TimeStatQueue delayTimeStat) {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        Intrinsics.checkNotNullParameter((Object)slaveLSNContext, (String)"slaveLSNContext");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(RedoReceiver.class.getName());
        this.redoArchiver = redoArchiver;
        this.conf = conf;
        this.slaveLSNContext = slaveLSNContext;
        this.context = context;
        this.delayTimeStat = delayTimeStat;
        this.logger$delegate = LazyKt.lazy((Function0)((Function0)new Function0<OlapLogger>(this){
            final /* synthetic */ RedoReceiver this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final OlapLogger invoke() {
                return RedoReceiver.access$getContext$p(this.this$0).getWorkspace$bos_olap_core2().getLogger$bos_olap_core2();
            }
        }));
        this.signalReadBuffer = ByteBuffer.allocate(1024);
        this.signalSendBuffer = ByteBuffer.allocate(1024);
        this.recvPage = new WritedRedoPage();
        this.controlChannel = SocketChannel.open();
        this.dataChannel = SocketChannel.open();
        this.selector = Selector.open();
        this.lastPage = -1L;
        this.isSwitching = new AtomicBoolean(false);
    }

    public /* synthetic */ RedoReceiver(RedoArchiver redoArchiver, ReplicationConf replicationConf, SlaveLSNContext slaveLSNContext, ReplicationContext replicationContext, TimeStatQueue timeStatQueue, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            timeStatQueue = null;
        }
        this(redoArchiver, replicationConf, slaveLSNContext, replicationContext, timeStatQueue);
    }

    private final long getKeepAliveTimeoutNs() {
        return (long)(OlapConfigItems.INSTANCE.getKeepAliveTimeout$bos_olap_core2().getValue() * 1000) * 1000000L;
    }

    private final long getMaxWaitVipNs() {
        return (long)(OlapConfigItems.INSTANCE.getKeepAliveTimeout$bos_olap_core2().getValue() * 1000) * 1000000L + 50000000000L;
    }

    private final OlapLogger getLogger() {
        Lazy lazy = this.logger$delegate;
        return (OlapLogger)lazy.getValue();
    }

    @Override
    public void run() {
        block7: {
            while (this.isRunning) {
                try {
                    this.selector.select(1000L);
                    Set<SelectionKey> keys = this.selector.selectedKeys();
                    if (keys.isEmpty()) {
                        this.dealTimeout();
                    }
                    Iterator<SelectionKey> keyIter = keys.iterator();
                    while (keyIter.hasNext()) {
                        SelectionKey key2 = keyIter.next();
                        keyIter.remove();
                        if (!key2.isValid() || !key2.isReadable()) continue;
                        SelectableChannel selectableChannel = key2.channel();
                        Intrinsics.checkNotNull((Object)selectableChannel, (String)"null cannot be cast to non-null type java.nio.channels.SocketChannel");
                        SocketChannel sc = (SocketChannel)selectableChannel;
                        if (Intrinsics.areEqual((Object)sc, (Object)this.controlChannel)) {
                            this.readControlChannel();
                            continue;
                        }
                        this.readDataChannel();
                    }
                    this.checkVip();
                }
                catch (Exception e) {
                    OlapLogger this_$iv = this.getLogger();
                    boolean $i$f$error = false;
                    String reportId$iv = this_$iv.getStatus().get().name() + "-ReplicationError-" + CubeToolKt.getCurrentTime();
                    OlapLogger this_$iv$iv = this_$iv;
                    boolean $i$f$error2 = false;
                    if (!this_$iv$iv.isErrorEnabled()) continue;
                    boolean bl = false;
                    String message$iv$iv = "\u63a5\u6536\u7ebf\u7a0b\u5f02\u5e38\u3002";
                    HealthReport report$iv$iv = new HealthReport(reportId$iv, null, this_$iv$iv.getStatus().get().name() + "-ReplicationError: " + message$iv$iv, HealthReportLevel.Error, PrivilegeType.None.getCode());
                    this_$iv$iv.getOlapWorkspace().getHealthReports().commit(report$iv$iv);
                    if ((Throwable)e == null) {
                        OlapLogger.access$getLogger$cp().error(message$iv$iv);
                        continue;
                    }
                    OlapLogger.access$getLogger$cp().error("{}", (Object)message$iv$iv, (Object)e);
                }
            }
            this.controlChannel.close();
            this.dataChannel.close();
            WritedRedoFile writedRedoFile = this.redoFile;
            if (writedRedoFile == null) break block7;
            writedRedoFile.close();
        }
    }

    private final void readControlChannel() {
        try {
            int readByte = this.controlChannel.read(this.signalReadBuffer);
            if (readByte == -1) {
                OlapLogger $this$iv = this.getLogger();
                Object t$iv = null;
                boolean $i$f$error = false;
                String reportId$iv = $this$iv.getStatus().get().name() + "-ReplicationError-" + CubeToolKt.getCurrentTime();
                OlapLogger this_$iv$iv = $this$iv;
                boolean $i$f$error2 = false;
                if (this_$iv$iv.isErrorEnabled()) {
                    boolean bl = false;
                    String message$iv$iv = "\u8bfb\u53d6\u63a7\u5236\u6307\u4ee4\u9519\u8bef,readByte=-1";
                    HealthReport report$iv$iv = new HealthReport(reportId$iv, null, this_$iv$iv.getStatus().get().name() + "-ReplicationError: " + message$iv$iv, HealthReportLevel.Error, PrivilegeType.None.getCode());
                    this_$iv$iv.getOlapWorkspace().getHealthReports().commit(report$iv$iv);
                    OlapLogger.access$getLogger$cp().error(message$iv$iv);
                }
                this.dealNetworkException();
                return;
            }
            this.signalReadBuffer.flip();
            while (true) {
                ByteBuffer byteBuffer = this.signalReadBuffer;
                Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"signalReadBuffer");
                if (!this.hasCompleteSignal(byteBuffer)) break;
                this.dealSignal();
            }
            this.signalReadBuffer.compact();
        }
        catch (Exception e) {
            OlapLogger this_$iv = this.getLogger();
            boolean $i$f$error = false;
            String reportId$iv = this_$iv.getStatus().get().name() + "-ReplicationError-" + CubeToolKt.getCurrentTime();
            OlapLogger this_$iv$iv = this_$iv;
            boolean $i$f$error3 = false;
            if (this_$iv$iv.isErrorEnabled()) {
                boolean bl = false;
                String message$iv$iv = "\u8bfb\u53d6\u63a7\u5236\u6307\u4ee4\u53d1\u751f\u9519\u8bef\u3002";
                HealthReport report$iv$iv = new HealthReport(reportId$iv, null, this_$iv$iv.getStatus().get().name() + "-ReplicationError: " + message$iv$iv, HealthReportLevel.Error, PrivilegeType.None.getCode());
                this_$iv$iv.getOlapWorkspace().getHealthReports().commit(report$iv$iv);
                if ((Throwable)e == null) {
                    OlapLogger.access$getLogger$cp().error(message$iv$iv);
                } else {
                    OlapLogger.access$getLogger$cp().error("{}", (Object)message$iv$iv, (Object)e);
                }
            }
            this.dealNetworkException();
            return;
        }
    }

    private final void dealSignal() {
        this.signalReadBuffer.get();
        SignalType signal = SignalType.Companion.byteToSignalType(this.signalReadBuffer.get());
        if (signal != SignalType.KEEP_ALIVE) {
            OlapLogger.Companion.info("RedoReceiver \u63a5\u53d7\u5230\u63a7\u5236\u6307\u4ee4:{}", (Object)signal);
        }
        switch (WhenMappings.$EnumSwitchMapping$0[signal.ordinal()]) {
            case 1: {
                this.dealAgree();
                break;
            }
            case 2: {
                this.dealDisagree();
                break;
            }
            case 3: {
                this.dealKeepAlive();
                break;
            }
            case 4: {
                this.dealMasterClose();
                break;
            }
            default: {
                String string2 = Res.INSTANCE.getRedoReceiverException_3();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-RedoReceiverException_3>(...)");
                throw Res.INSTANCE.getRuntimeException(string2, new Object[0]);
            }
        }
    }

    private final void dealAgree() {
        switch (WhenMappings.$EnumSwitchMapping$0[SignalType.Companion.byteToSignalType(this.signalReadBuffer.get()).ordinal()]) {
            case 5: {
                this.sendDataConnect();
                break;
            }
            case 6: {
                this.sendStartStream();
                break;
            }
            case 7: {
                this.dataChannel.register(this.selector, 1);
                this.context.getWorkspace$bos_olap_core2().switchStatus(ReplicationStatus.Slave);
                break;
            }
            case 8: {
                this.isRunning = false;
                break;
            }
            case 9: {
                break;
            }
            default: {
                String string2 = Res.INSTANCE.getRedoReceiverException_2();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-RedoReceiverException_2>(...)");
                throw Res.INSTANCE.getRuntimeException(string2, new Object[0]);
            }
        }
    }

    private final void dealDisagree() {
        switch (WhenMappings.$EnumSwitchMapping$0[SignalType.Companion.byteToSignalType(this.signalReadBuffer.get()).ordinal()]) {
            case 5: 
            case 6: 
            case 7: {
                this.dealClose();
                break;
            }
            default: {
                String string2 = Res.INSTANCE.getRedoReceiverException_2();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-RedoReceiverException_2>(...)");
                throw Res.INSTANCE.getRuntimeException(string2, new Object[0]);
            }
        }
    }

    private final void dealKeepAlive() {
        this.sendRedoAck();
        this.lastKeepAliveTime = System.nanoTime();
    }

    private final void dealMasterClose() {
        this.lastPage = this.signalReadBuffer.getLong();
        if (this.lastPage == LSNUtil.INSTANCE.prePageLSN(this.slaveLSNContext.getNextWritePage())) {
            this.sendMasterCloseAck(this.lastPage);
            this.createThreadToSwitch();
        }
    }

    private final void dealTimeout() {
        if (System.nanoTime() - this.lastKeepAliveTime < this.getKeepAliveTimeoutNs()) {
            return;
        }
        if (System.nanoTime() - this.lastKeepAliveTime > this.getMaxWaitVipNs()) {
            OlapLogger $this$iv = this.getLogger();
            Object t$iv = null;
            boolean $i$f$error = false;
            String reportId$iv = $this$iv.getStatus().get().name() + "-ReplicationError-" + CubeToolKt.getCurrentTime();
            OlapLogger this_$iv$iv = $this$iv;
            boolean $i$f$error2 = false;
            if (this_$iv$iv.isErrorEnabled()) {
                boolean bl = false;
                String message$iv$iv = "\u4ece\u7ed3\u70b9 " + this.conf.get_node().getServerID() + " \u4e3b\u52a8\u65ad\u5f00\uff0c\u5f85DBA\u5904\u7406";
                HealthReport report$iv$iv = new HealthReport(reportId$iv, null, this_$iv$iv.getStatus().get().name() + "-ReplicationError: " + message$iv$iv, HealthReportLevel.Error, PrivilegeType.None.getCode());
                this_$iv$iv.getOlapWorkspace().getHealthReports().commit(report$iv$iv);
                OlapLogger.access$getLogger$cp().error(message$iv$iv);
            }
            this.dealClose();
            return;
        }
        OlapLogger.Companion.info("\u5df2\u8d85\u65f6,\u5f53\u524d\u72b6\u6001\uff1a" + (Object)((Object)this.context.getWorkspace$bos_olap_core2().getStatus()));
        this.dealNetworkException();
    }

    private final void dealClose() {
        ReplicationWorkspace current = this.context.getWorkspace$bos_olap_core2();
        if (WhenMappings.$EnumSwitchMapping$1[current.getStatus().ordinal()] == 1) {
            try {
                this.sendEndStream();
            }
            catch (Exception e) {
                this.isRunning = false;
            }
        } else {
            this.isRunning = false;
        }
        OlapLogger.Companion.info("\u6b63\u5728\u5c06\u5f53\u524d\u670d\u52a1\u72b6\u6001\u5207\u6362\u4e3a Unavailable\uff0c\u9700\u8981\u7b49\u5f85 {} \u79d2\uff0c\u624d\u80fd\u7ec8\u6b62 {}", OlapConfigItems.INSTANCE.getKeepAliveTimeout$bos_olap_core2().getValue(), this.getClass().getSimpleName());
        current.switchStatus(ReplicationStatus.Unavailable);
    }

    private final void dealNetworkException() {
        ReplicationStatus currentStatus = this.context.getWorkspace$bos_olap_core2().getStatus();
        OlapLogger.Companion.info("\u7f51\u7edc\u5f02\u5e38,\u5f53\u524d\u72b6\u6001\uff1a" + (Object)((Object)currentStatus));
        SelectionKey selectionKey = this.controlChannelKey;
        if (selectionKey != null) {
            selectionKey.cancel();
        }
        SelectionKey selectionKey2 = this.dataChannelKey;
        if (selectionKey2 != null) {
            selectionKey2.cancel();
        }
        switch (WhenMappings.$EnumSwitchMapping$1[currentStatus.ordinal()]) {
            case 2: {
                this.dealClose();
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 4: {
                this.createThreadToSwitch();
                break;
            }
            default: {
                throw new NotSupportedException();
            }
        }
    }

    private final void readDataChannel() {
        try {
            int readByte = this.dataChannel.read(this.recvPage.getBuffer());
            if (readByte == -1) {
                OlapLogger $this$iv = this.getLogger();
                Object t$iv = null;
                boolean $i$f$error = false;
                String reportId$iv = $this$iv.getStatus().get().name() + "-ReplicationError-" + CubeToolKt.getCurrentTime();
                OlapLogger this_$iv$iv = $this$iv;
                boolean $i$f$error2 = false;
                if (this_$iv$iv.isErrorEnabled()) {
                    boolean bl = false;
                    String message$iv$iv = "\u8bfb\u53d6\u6570\u636e\u6307\u4ee4\u9519\u8bef,readByte=-1";
                    HealthReport report$iv$iv = new HealthReport(reportId$iv, null, this_$iv$iv.getStatus().get().name() + "-ReplicationError: " + message$iv$iv, HealthReportLevel.Error, PrivilegeType.None.getCode());
                    this_$iv$iv.getOlapWorkspace().getHealthReports().commit(report$iv$iv);
                    OlapLogger.access$getLogger$cp().error(message$iv$iv);
                }
                this.dealNetworkException();
                return;
            }
            if (!this.recvPage.getBuffer().hasRemaining()) {
                if (this.recvPage.getPageLSN() != this.slaveLSNContext.getNextWritePage()) {
                    OlapLogger $this$iv = this.getLogger();
                    Object t$iv = null;
                    boolean $i$f$error = false;
                    String reportId$iv = $this$iv.getStatus().get().name() + "-ReplicationError-" + CubeToolKt.getCurrentTime();
                    OlapLogger this_$iv$iv = $this$iv;
                    boolean $i$f$error3 = false;
                    if (this_$iv$iv.isErrorEnabled()) {
                        boolean bl = false;
                        String message$iv$iv = "slave\u671f\u5f85\u6536\u5230page:" + this.slaveLSNContext.getNextWritePage() + ",\u5374\u6536\u5230\u4e3apage:" + this.recvPage.getPageLSN();
                        HealthReport report$iv$iv = new HealthReport(reportId$iv, null, this_$iv$iv.getStatus().get().name() + "-ReplicationError: " + message$iv$iv, HealthReportLevel.Error, PrivilegeType.None.getCode());
                        this_$iv$iv.getOlapWorkspace().getHealthReports().commit(report$iv$iv);
                        OlapLogger.access$getLogger$cp().error(message$iv$iv);
                    }
                    this.dealClose();
                    return;
                }
                TimeStatQueue timeStatQueue = this.delayTimeStat;
                if (timeStatQueue != null) {
                    timeStatQueue.setBegin(this.slaveLSNContext.getNextWritePage());
                }
                WritedRedoFile writedRedoFile = this.redoFile;
                Intrinsics.checkNotNull((Object)writedRedoFile);
                writedRedoFile.writePage(this.recvPage);
                this.recvPage.getBuffer().clear();
                if (this.lastPage == this.slaveLSNContext.getNextWritePage()) {
                    this.sendMasterCloseAck(this.lastPage);
                    this.createThreadToSwitch();
                }
                this.slaveLSNContext.setNextWritePage(LSNUtil.INSTANCE.nextPageLSN(this.slaveLSNContext.getNextWritePage()));
                if (LSNUtil.INSTANCE.isFileLSN$bos_olap_core2(this.slaveLSNContext.getNextWritePage())) {
                    RedoArchiver redoArchiver = this.redoArchiver;
                    if (redoArchiver != null) {
                        redoArchiver.wakeup();
                    }
                }
                this.sendRedoAck();
            }
        }
        catch (Exception e) {
            OlapLogger this_$iv = this.getLogger();
            boolean $i$f$error = false;
            String reportId$iv = this_$iv.getStatus().get().name() + "-ReplicationError-" + CubeToolKt.getCurrentTime();
            OlapLogger this_$iv$iv = this_$iv;
            boolean $i$f$error4 = false;
            if (this_$iv$iv.isErrorEnabled()) {
                boolean bl = false;
                String message$iv$iv = "\u8bfb\u53d6\u6570\u636e\u6307\u4ee4\u53d1\u751f\u9519\u8bef\u3002";
                HealthReport report$iv$iv = new HealthReport(reportId$iv, null, this_$iv$iv.getStatus().get().name() + "-ReplicationError: " + message$iv$iv, HealthReportLevel.Error, PrivilegeType.None.getCode());
                this_$iv$iv.getOlapWorkspace().getHealthReports().commit(report$iv$iv);
                if ((Throwable)e == null) {
                    OlapLogger.access$getLogger$cp().error(message$iv$iv);
                } else {
                    OlapLogger.access$getLogger$cp().error("{}", (Object)message$iv$iv, (Object)e);
                }
            }
            this.dealNetworkException();
            return;
        }
    }

    private final void sendControlConnect() {
        this.signalSendBuffer.clear();
        byte len = 23;
        this.signalSendBuffer.put(len);
        byte cmdType = SignalType.CONTROL_CONNECT.getCode();
        this.signalSendBuffer.put(cmdType);
        this.signalSendBuffer.put((byte)this.conf.get_node().getServerID());
        byte[] slaveConfigMd5 = this.context.refreshMd5(this.conf.get_node().getRedoPath());
        this.signalSendBuffer.put(slaveConfigMd5);
        this.signalSendBuffer.putInt(this.context.getWebPort());
        SocketChannel socketChannel = this.controlChannel;
        Intrinsics.checkNotNullExpressionValue((Object)socketChannel, (String)"controlChannel");
        ByteBuffer byteBuffer = this.signalSendBuffer;
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"signalSendBuffer");
        this.writeBuffer(socketChannel, byteBuffer);
    }

    private final void sendDataConnect() {
        this.signalSendBuffer.clear();
        byte len = 3;
        this.signalSendBuffer.put(len);
        byte cmdType = SignalType.DATA_CONNECT.getCode();
        this.signalSendBuffer.put(cmdType);
        this.signalSendBuffer.put((byte)this.conf.get_node().getServerID());
        SocketChannel socketChannel = this.dataChannel;
        Intrinsics.checkNotNullExpressionValue((Object)socketChannel, (String)"dataChannel");
        ByteBuffer byteBuffer = this.signalSendBuffer;
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"signalSendBuffer");
        this.writeBuffer(socketChannel, byteBuffer);
    }

    private final void sendStartStream() {
        this.signalSendBuffer.clear();
        byte len = 10;
        this.signalSendBuffer.put(len);
        byte cmdType = SignalType.START_STREAM.getCode();
        this.signalSendBuffer.put(cmdType);
        this.signalSendBuffer.putLong(this.slaveLSNContext.getNextWritePage());
        SocketChannel socketChannel = this.controlChannel;
        Intrinsics.checkNotNullExpressionValue((Object)socketChannel, (String)"controlChannel");
        ByteBuffer byteBuffer = this.signalSendBuffer;
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"signalSendBuffer");
        this.writeBuffer(socketChannel, byteBuffer);
    }

    private final void sendEndStream() {
        this.signalSendBuffer.clear();
        byte len = 10;
        this.signalSendBuffer.put(len);
        byte cmdType = SignalType.END_STREAM.getCode();
        this.signalSendBuffer.put(cmdType);
        this.signalSendBuffer.putLong(0L);
        SocketChannel socketChannel = this.controlChannel;
        Intrinsics.checkNotNullExpressionValue((Object)socketChannel, (String)"controlChannel");
        ByteBuffer byteBuffer = this.signalSendBuffer;
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"signalSendBuffer");
        this.writeBuffer(socketChannel, byteBuffer);
    }

    private final void sendRedoAck() {
        this.signalSendBuffer.clear();
        byte len = 10;
        this.signalSendBuffer.put(len);
        byte cmdType = SignalType.REDO_ACK.getCode();
        this.signalSendBuffer.put(cmdType);
        this.signalSendBuffer.putLong(LSNUtil.INSTANCE.prePageLSN(this.slaveLSNContext.getNextWritePage()));
        SocketChannel socketChannel = this.controlChannel;
        Intrinsics.checkNotNullExpressionValue((Object)socketChannel, (String)"controlChannel");
        ByteBuffer byteBuffer = this.signalSendBuffer;
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"signalSendBuffer");
        this.writeBuffer(socketChannel, byteBuffer);
    }

    private final void sendSwitchToMaster() {
        this.signalSendBuffer.clear();
        byte len = 3;
        this.signalSendBuffer.put(len);
        byte cmdType = SignalType.SWITCH_TO_MASTER.getCode();
        this.signalSendBuffer.put(cmdType);
        this.signalSendBuffer.put((byte)this.conf.get_node().getServerID());
        SocketChannel socketChannel = this.controlChannel;
        Intrinsics.checkNotNullExpressionValue((Object)socketChannel, (String)"controlChannel");
        ByteBuffer byteBuffer = this.signalSendBuffer;
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"signalSendBuffer");
        this.writeBuffer(socketChannel, byteBuffer);
    }

    private final void sendMasterCloseAck(long lastPage) {
        this.signalSendBuffer.clear();
        byte len = 10;
        this.signalSendBuffer.put(len);
        byte cmdType = SignalType.MASTER_CLOSE_ACK.getCode();
        this.signalSendBuffer.put(cmdType);
        this.signalSendBuffer.putLong(lastPage);
        SocketChannel socketChannel = this.controlChannel;
        Intrinsics.checkNotNullExpressionValue((Object)socketChannel, (String)"controlChannel");
        ByteBuffer byteBuffer = this.signalSendBuffer;
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"signalSendBuffer");
        this.writeBuffer(socketChannel, byteBuffer);
    }

    @Override
    public void start() {
        try {
            if (!this.controlChannel.isOpen()) {
                this.controlChannel = SocketChannel.open();
            }
            this.controlChannel.connect(new InetSocketAddress(this.conf.get_slave().getHost(), this.conf.get_slave().getPort()));
            if (!this.dataChannel.isOpen()) {
                this.dataChannel = SocketChannel.open();
            }
            this.dataChannel.connect(new InetSocketAddress(this.conf.get_slave().getHost(), this.conf.get_slave().getPort()));
            this.redoFile = new WritedRedoFile(this.conf.get_node().getRedoPath(), this.slaveLSNContext);
        }
        catch (Exception ex) {
            this.close();
            OlapLogger this_$iv = this.getLogger();
            boolean $i$f$error = false;
            String reportId$iv = this_$iv.getStatus().get().name() + "-ReplicationError-" + CubeToolKt.getCurrentTime();
            OlapLogger this_$iv$iv = this_$iv;
            boolean $i$f$error2 = false;
            if (this_$iv$iv.isErrorEnabled()) {
                boolean bl = false;
                String string2 = Res.INSTANCE.getRedoReceiverException_1();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-RedoReceiverException_1>(...)");
                Object[] objectArray = new Object[]{this.conf.get_slave().getHost(), this.conf.get_slave().getPort()};
                String message$iv$iv = Res.INSTANCE.format(string2, objectArray);
                HealthReport report$iv$iv = new HealthReport(reportId$iv, null, this_$iv$iv.getStatus().get().name() + "-ReplicationError: " + message$iv$iv, HealthReportLevel.Error, PrivilegeType.None.getCode());
                this_$iv$iv.getOlapWorkspace().getHealthReports().commit(report$iv$iv);
                if ((Throwable)ex == null) {
                    OlapLogger.access$getLogger$cp().error(message$iv$iv);
                } else {
                    OlapLogger.access$getLogger$cp().error("{}", (Object)message$iv$iv, (Object)ex);
                }
            }
            String string3 = Res.INSTANCE.getRedoReceiverException_1();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"<get-RedoReceiverException_1>(...)");
            Object[] objectArray = new Object[]{this.conf.get_slave().getHost(), this.conf.get_slave().getPort()};
            throw Res.INSTANCE.getRuntimeException(string3, objectArray);
        }
        this.controlChannel.configureBlocking(false);
        this.dataChannel.configureBlocking(false);
        this.controlChannelKey = this.controlChannel.register(this.selector, 1);
        this.dataChannelKey = this.dataChannel.register(this.selector, 1);
        this.sendControlConnect();
        this.isRunning = true;
        this.lastKeepAliveTime = System.nanoTime();
        super.start();
    }

    @Override
    public void close() {
        OlapLogger.Companion.info("{} \u6b63\u5728\u5173\u95ed", this.getClass().getSimpleName());
        this.dealClose();
        this.join();
        WritedRedoFile writedRedoFile = this.redoFile;
        if (writedRedoFile != null) {
            writedRedoFile.close();
        }
        OlapLogger.Companion.info("{} \u5173\u95ed\u6210\u529f", this.getClass().getSimpleName());
    }

    private final void checkVip() {
        ReplicationWorkspace current = this.context.getWorkspace$bos_olap_core2();
        if (current.isVip() && current.compareAndSetStatus(ReplicationStatus.Slave, ReplicationStatus.Transfering)) {
            this.sendSwitchToMaster();
        }
    }

    private final void createThreadToSwitch() {
        if (this.context.getWorkspace$bos_olap_core2().getStatus() != ReplicationStatus.Transfering || !this.isSwitching.compareAndSet(false, true)) {
            return;
        }
        this.context.getWorkspace$bos_olap_core2().slaveToMaster();
    }

    private final boolean hasCompleteSignal(ByteBuffer $this$hasCompleteSignal) {
        if ($this$hasCompleteSignal.remaining() == 0) {
            return false;
        }
        return $this$hasCompleteSignal.remaining() >= $this$hasCompleteSignal.get($this$hasCompleteSignal.position());
    }

    private final void writeBuffer(SocketChannel $this$writeBuffer, ByteBuffer buffer) {
        buffer.flip();
        while (buffer.hasRemaining()) {
            try {
                $this$writeBuffer.write(buffer);
            }
            catch (Exception e) {
                e.printStackTrace();
                OlapLogger this_$iv = this.getLogger();
                boolean $i$f$error = false;
                String reportId$iv = this_$iv.getStatus().get().name() + "-ReplicationError-" + CubeToolKt.getCurrentTime();
                OlapLogger this_$iv$iv = this_$iv;
                boolean $i$f$error2 = false;
                if (this_$iv$iv.isErrorEnabled()) {
                    boolean bl = false;
                    String message$iv$iv = "\u5199socket\u53d1\u751f\u9519\u8bef\u3002";
                    HealthReport report$iv$iv = new HealthReport(reportId$iv, null, this_$iv$iv.getStatus().get().name() + "-ReplicationError: " + message$iv$iv, HealthReportLevel.Error, PrivilegeType.None.getCode());
                    this_$iv$iv.getOlapWorkspace().getHealthReports().commit(report$iv$iv);
                    if ((Throwable)e == null) {
                        OlapLogger.access$getLogger$cp().error(message$iv$iv);
                    } else {
                        OlapLogger.access$getLogger$cp().error("{}", (Object)message$iv$iv, (Object)e);
                    }
                }
                this.dealNetworkException();
                return;
            }
        }
    }

    public static final /* synthetic */ ReplicationContext access$getContext$p(RedoReceiver $this) {
        return $this.context;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lkd/bos/olapServer2/replication/RedoReceiver$Companion;", "", "()V", "bufferSize", "", "selectTimeoutMs", "", "Lkd/bos/olapServer2/common/long;", "bos-olap-core2"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[SignalType.values().length];
            try {
                nArray[SignalType.AGREE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SignalType.DISAGREE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SignalType.KEEP_ALIVE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SignalType.MASTER_CLOSE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SignalType.CONTROL_CONNECT.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SignalType.DATA_CONNECT.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SignalType.START_STREAM.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SignalType.END_STREAM.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SignalType.SWITCH_TO_MASTER.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ReplicationStatus.values().length];
            try {
                nArray[ReplicationStatus.Slave.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReplicationStatus.Unavailable.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReplicationStatus.Backup.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReplicationStatus.Transfering.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

