/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.replication;

import java.util.Iterator;
import kd.bos.olapServer2.backup.sequenceLog.NeedCloseThings;
import kd.bos.olapServer2.backup.sequenceLog.RedoFilter;
import kd.bos.olapServer2.backup.sequenceLog.SeqRedoLogger;
import kd.bos.olapServer2.backup.sequenceLog.SeqRedoReader;
import kd.bos.olapServer2.replication.AbstractRedoReader;
import kd.bos.olapServer2.replication.LSNUtil;
import kd.bos.olapServer2.replication.ReadedRedoPage;
import kd.bos.olapServer2.replication.SlaveLSNContext;
import kd.bos.olapServer2.tools.Res;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.LongRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0010\b\u0002\u0010\b\u001a\n\u0018\u00010\tj\u0004\u0018\u0001`\n\u0012\f\b\u0002\u0010\u000b\u001a\u00060\fj\u0002`\r\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00130\u00192\u0006\u0010\u0004\u001a\u00020\u0005H\u0002R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u00060\fj\u0002`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001a"}, d2={"Lkd/bos/olapServer2/replication/RedoRecordCombineReader;", "Lkd/bos/olapServer2/replication/AbstractRedoReader;", "redoLogger", "Lkd/bos/olapServer2/backup/sequenceLog/SeqRedoLogger;", "lsnContext", "Lkd/bos/olapServer2/replication/SlaveLSNContext;", "(Lkd/bos/olapServer2/backup/sequenceLog/SeqRedoLogger;Lkd/bos/olapServer2/replication/SlaveLSNContext;)V", "incrementLogger", "cubeId", "", "Lkd/bos/olapServer2/common/int;", "isRedoReader", "", "Lkd/bos/olapServer2/common/bool;", "(Lkd/bos/olapServer2/backup/sequenceLog/SeqRedoLogger;Lkd/bos/olapServer2/backup/sequenceLog/SeqRedoLogger;Lkd/bos/olapServer2/replication/SlaveLSNContext;Ljava/lang/Integer;Z)V", "needCloseThings", "Lkd/bos/olapServer2/backup/sequenceLog/NeedCloseThings;", "redoPageItr", "", "Lkd/bos/olapServer2/replication/ReadedRedoPage;", "getRedoPageItr", "()Ljava/util/Iterator;", "close", "", "redoPageSequence", "Lkotlin/sequences/Sequence;", "bos-olap-core2"})
public final class RedoRecordCombineReader
extends AbstractRedoReader {
    @NotNull
    private final SeqRedoLogger redoLogger;
    @Nullable
    private final SeqRedoLogger incrementLogger;
    private final boolean isRedoReader;
    @NotNull
    private final NeedCloseThings needCloseThings;
    @NotNull
    private final Iterator<ReadedRedoPage> redoPageItr;

    public RedoRecordCombineReader(@NotNull SeqRedoLogger redoLogger, @Nullable SeqRedoLogger incrementLogger, @NotNull SlaveLSNContext lsnContext, @Nullable Integer cubeId, boolean isRedoReader) {
        Intrinsics.checkNotNullParameter((Object)redoLogger, (String)"redoLogger");
        Intrinsics.checkNotNullParameter((Object)lsnContext, (String)"lsnContext");
        super(lsnContext, cubeId, isRedoReader);
        this.redoLogger = redoLogger;
        this.incrementLogger = incrementLogger;
        this.isRedoReader = isRedoReader;
        this.needCloseThings = new NeedCloseThings();
        this.redoPageItr = this.redoPageSequence(lsnContext).iterator();
    }

    public /* synthetic */ RedoRecordCombineReader(SeqRedoLogger seqRedoLogger, SeqRedoLogger seqRedoLogger2, SlaveLSNContext slaveLSNContext, Integer n, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            n = null;
        }
        if ((n2 & 0x10) != 0) {
            bl = true;
        }
        this(seqRedoLogger, seqRedoLogger2, slaveLSNContext, n, bl);
    }

    public RedoRecordCombineReader(@NotNull SeqRedoLogger redoLogger, @NotNull SlaveLSNContext lsnContext) {
        Intrinsics.checkNotNullParameter((Object)redoLogger, (String)"redoLogger");
        Intrinsics.checkNotNullParameter((Object)lsnContext, (String)"lsnContext");
        this(redoLogger, null, lsnContext, null, false, 24, null);
    }

    @Override
    @NotNull
    public Iterator<ReadedRedoPage> getRedoPageItr() {
        return this.redoPageItr;
    }

    private final Sequence<ReadedRedoPage> redoPageSequence(SlaveLSNContext lsnContext) {
        RedoFilter redoFilter = new RedoFilter(lsnContext);
        long startLSN = lsnContext.getNextReadPage();
        long endLSN = lsnContext.getNextWritePage();
        long checkPoint = lsnContext.getCheckPoint();
        SeqRedoReader seqRedoReader = new SeqRedoReader();
        if (this.incrementLogger == null) {
            return this.redoLogger.readAsSequence$bos_olap_core2(redoFilter, seqRedoReader, this.needCloseThings, this.isRedoReader);
        }
        LongRange incrementLSNRange = LSNUtil.INSTANCE.getRealLsnRangeByFolderPath(this.incrementLogger.getRootPath());
        LongRange redoLSNRange = LSNUtil.INSTANCE.getRealLsnRangeByFolderPath(this.redoLogger.getRootPath());
        long redoStartLSN = redoLSNRange.getFirst();
        long redoEndLSN = redoLSNRange.getLast();
        long incrementStartLSN = incrementLSNRange.getFirst();
        long incrementEndLSN = incrementLSNRange.getLast();
        if (-1L == redoStartLSN) {
            return this.incrementLogger.readAsSequence$bos_olap_core2(redoFilter, seqRedoReader, this.needCloseThings, this.isRedoReader);
        }
        if (-1L == incrementStartLSN || startLSN >= incrementEndLSN) {
            return this.redoLogger.readAsSequence$bos_olap_core2(redoFilter, seqRedoReader, this.needCloseThings, this.isRedoReader);
        }
        if (!(redoEndLSN >= incrementEndLSN)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        if (startLSN < incrementStartLSN) {
            if (startLSN < redoStartLSN) {
                String string3 = Res.INSTANCE.getRedoFileException_3();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"<get-RedoFileException_3>(...)");
                Object[] objectArray = new Object[]{startLSN};
                throw Res.INSTANCE.getRuntimeException(string3, objectArray);
            }
            return this.redoLogger.readAsSequence$bos_olap_core2(redoFilter, seqRedoReader, this.needCloseThings, this.isRedoReader);
        }
        if (endLSN <= incrementEndLSN) {
            return this.incrementLogger.readAsSequence$bos_olap_core2(redoFilter, seqRedoReader, this.needCloseThings, this.isRedoReader);
        }
        Sequence sequence1 = this.redoLogger.readAsSequence$bos_olap_core2(new RedoFilter(new SlaveLSNContext(incrementEndLSN, endLSN, checkPoint)), seqRedoReader, this.needCloseThings, this.isRedoReader);
        Sequence sequence2 = this.incrementLogger.readAsSequence$bos_olap_core2(new RedoFilter(new SlaveLSNContext(startLSN, incrementEndLSN, checkPoint)), seqRedoReader, this.needCloseThings, this.isRedoReader);
        if (!this.isRedoReader) {
            return SequencesKt.plus(sequence1, sequence2);
        }
        return SequencesKt.plus(sequence2, sequence1);
    }

    @Override
    public void close() {
        this.needCloseThings.close();
    }
}

