/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.replication;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.olapServer2.common.OlapConfigItems;
import kd.bos.olapServer2.monitorReports.HealthReport;
import kd.bos.olapServer2.monitorReports.HealthReportLevel;
import kd.bos.olapServer2.replication.LSNUtil;
import kd.bos.olapServer2.replication.MasterLSNContext;
import kd.bos.olapServer2.replication.OlapLogger;
import kd.bos.olapServer2.replication.RedoPage;
import kd.bos.olapServer2.replication.ReplicationConf;
import kd.bos.olapServer2.replication.ReplicationContext;
import kd.bos.olapServer2.replication.ReplicationStatus;
import kd.bos.olapServer2.replication.SignalType;
import kd.bos.olapServer2.replication.SlaveNode;
import kd.bos.olapServer2.replication.TimeStatQueue;
import kd.bos.olapServer2.replication.TransferredRedoFile;
import kd.bos.olapServer2.security.PrivilegeType;
import kd.bos.olapServer2.server.ReplicationWorkspace;
import kd.bos.olapServer2.tools.CubeToolKt;
import kd.bos.olapServer2.tools.Res;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00ba\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 `2\u00020\u0001:\u0001`B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201J\u0010\u00102\u001a\u0004\u0018\u0001032\u0006\u00104\u001a\u000205J\b\u00106\u001a\u00020/H\u0002J\b\u00107\u001a\u00020/H\u0002J\u0006\u00108\u001a\u00020/J\u0010\u00109\u001a\u00020/2\u0006\u0010:\u001a\u00020)H\u0002J\b\u0010;\u001a\u00020/H\u0002J\u0010\u0010<\u001a\u00020/2\u0006\u0010:\u001a\u00020)H\u0002J\u0010\u0010=\u001a\u00020/2\u0006\u0010:\u001a\u00020)H\u0002J\u0010\u0010>\u001a\u00020/2\u0006\u0010:\u001a\u00020)H\u0002J\u0010\u0010?\u001a\u00020/2\u0006\u0010:\u001a\u00020)H\u0002J\u0010\u0010@\u001a\u00020/2\u0006\u0010:\u001a\u00020)H\u0002J\u0010\u0010A\u001a\u00020/2\u0006\u0010:\u001a\u00020)H\u0002J\u0010\u0010B\u001a\u00020/2\u0006\u0010:\u001a\u00020)H\u0002J\u0010\u0010C\u001a\u00020/2\u0006\u0010:\u001a\u00020)H\u0002J\u0010\u0010D\u001a\f\u0012\b\u0012\u000603j\u0002`F0EJ\u0018\u0010G\u001a\u00060\u0010j\u0002`H2\n\u0010I\u001a\u000605j\u0002`JH\u0002J\b\u0010K\u001a\u00020/H\u0002J\u0010\u0010L\u001a\u00020/2\u0006\u0010M\u001a\u00020NH\u0002J\u000e\u0010O\u001a\u00020/2\u0006\u00100\u001a\u000201J\b\u0010P\u001a\u00020/H\u0016J\u0018\u0010Q\u001a\u00020/2\u0006\u0010:\u001a\u00020)2\u0006\u0010R\u001a\u00020SH\u0002J\u0018\u0010T\u001a\u00020/2\u0006\u0010:\u001a\u00020)2\u0006\u0010R\u001a\u00020SH\u0002J\u0010\u0010U\u001a\u00020/2\u0006\u0010:\u001a\u00020)H\u0002J\u0010\u0010V\u001a\u00020/2\u0006\u0010:\u001a\u00020)H\u0002J\u0010\u0010W\u001a\u00020/2\u0006\u0010:\u001a\u00020)H\u0002J\b\u0010X\u001a\u00020/H\u0016J\u0010\u0010Y\u001a\u00020/2\u0006\u0010:\u001a\u00020)H\u0002J\u000e\u0010Z\u001a\u00020/2\u0006\u0010[\u001a\u00020\\J\u0016\u0010]\u001a\u0004\u0018\u00010)2\n\u0010I\u001a\u000605j\u0002`JH\u0002J\u0010\u0010^\u001a\u00060\u0010j\u0002`H*\u00020NH\u0002J\u0014\u0010_\u001a\u00020/*\u00020(2\u0006\u0010M\u001a\u00020NH\u0002R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0012\u0010\u0016\u001a\u00060\u0013j\u0002`\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0018\u001a\u00060\u0013j\u0002`\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0019\u001a\u00020\u001a8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0015R\u0016\u0010!\u001a\n #*\u0004\u0018\u00010\"0\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010$\u001a\n #*\u0004\u0018\u00010%0%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010&\u001a\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020)0'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010*\u001a\u00020+8F\u00a2\u0006\u0006\u001a\u0004\b,\u0010-\u00a8\u0006a"}, d2={"Lkd/bos/olapServer2/replication/RedoSender;", "Ljava/lang/Thread;", "conf", "Lkd/bos/olapServer2/replication/ReplicationConf;", "masterLSNContext", "Lkd/bos/olapServer2/replication/MasterLSNContext;", "context", "Lkd/bos/olapServer2/replication/ReplicationContext;", "AckTimeStat", "Lkd/bos/olapServer2/replication/TimeStatQueue;", "(Lkd/bos/olapServer2/replication/ReplicationConf;Lkd/bos/olapServer2/replication/MasterLSNContext;Lkd/bos/olapServer2/replication/ReplicationContext;Lkd/bos/olapServer2/replication/TimeStatQueue;)V", "current", "Lkd/bos/olapServer2/server/ReplicationWorkspace;", "getCurrent", "()Lkd/bos/olapServer2/server/ReplicationWorkspace;", "isRunning", "", "isSwitching", "keepAliveTimeoutNs", "", "getKeepAliveTimeoutNs", "()J", "lastKeepAliveTime", "Lkd/bos/olapServer2/common/long;", "lastVipTime", "logger", "Lkd/bos/olapServer2/replication/OlapLogger;", "getLogger", "()Lkd/bos/olapServer2/replication/OlapLogger;", "logger$delegate", "Lkotlin/Lazy;", "maxVipWaitTime", "getMaxVipWaitTime", "selector", "Ljava/nio/channels/Selector;", "kotlin.jvm.PlatformType", "serverSocket", "Ljava/nio/channels/ServerSocketChannel;", "slaves", "Ljava/util/HashMap;", "Ljava/nio/channels/SocketChannel;", "Lkd/bos/olapServer2/replication/SlaveNode;", "status", "Lkd/bos/olapServer2/replication/ReplicationStatus;", "getStatus", "()Lkd/bos/olapServer2/replication/ReplicationStatus;", "accept", "", "key", "Ljava/nio/channels/SelectionKey;", "byteToHex", "", "b", "", "checkSwitch", "checkVip", "close", "closeSlave", "slave", "createThreadSwitchToSlave", "dealCmd", "dealControlConnect", "dealDataConnect", "dealEndStream", "dealMasterCloseAck", "dealRedoAck", "dealStartStream", "dealSwitchToMaster", "getReadySlaves", "Ljava/util/ArrayList;", "Lkd/bos/olapServer2/common/string;", "isValidServerId", "Lkd/bos/olapServer2/common/bool;", "serverId", "Lkd/bos/olapServer2/common/byte;", "keepAlive", "printBuffer", "buffer", "Ljava/nio/ByteBuffer;", "read", "run", "sendAgree", "reqCmdType", "Lkd/bos/olapServer2/replication/SignalType;", "sendDisAgree", "sendKeepAlive", "sendMasterClose", "sendSignal", "start", "startAsyncSlave", "sync", "redo", "Lkd/bos/olapServer2/replication/RedoPage;", "tryGetControlSlave", "hasCompleteSignal", "writeBuffer", "Companion", "bos-olap-core2"})
@SourceDebugExtension(value={"SMAP\nRedoSender.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RedoSender.kt\nkd/bos/olapServer2/replication/RedoSender\n+ 2 OlapLogger.kt\nkd/bos/olapServer2/replication/OlapLogger\n*L\n1#1,609:1\n112#2,2:610\n91#2,24:612\n110#2,4:636\n91#2,24:640\n110#2,4:664\n91#2,24:668\n110#2,4:692\n91#2,24:696\n110#2,4:720\n91#2,24:724\n112#2,2:748\n91#2,24:750\n*S KotlinDebug\n*F\n+ 1 RedoSender.kt\nkd/bos/olapServer2/replication/RedoSender\n*L\n91#1:610,2\n91#1:612,24\n213#1:636,4\n213#1:640,24\n239#1:664,4\n239#1:668,24\n266#1:692,4\n266#1:696,24\n272#1:720,4\n272#1:724,24\n287#1:748,2\n287#1:750,24\n*E\n"})
public final class RedoSender
extends Thread {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ReplicationConf conf;
    @NotNull
    private final MasterLSNContext masterLSNContext;
    @NotNull
    private final ReplicationContext context;
    @Nullable
    private final TimeStatQueue AckTimeStat;
    @NotNull
    private final Lazy logger$delegate;
    private final Selector selector;
    private final ServerSocketChannel serverSocket;
    private volatile boolean isRunning;
    @NotNull
    private final HashMap<SocketChannel, SlaveNode> slaves;
    private long lastKeepAliveTime;
    private boolean isSwitching;
    private long lastVipTime;
    private static final long selectTimeoutMs = 1000L;
    private static final long keepAliveIntervalNs = 1000000000L;
    private static final int maxTimeOutCount = 5;

    public RedoSender(@NotNull ReplicationConf conf, @NotNull MasterLSNContext masterLSNContext, @NotNull ReplicationContext context, @Nullable TimeStatQueue AckTimeStat) {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        Intrinsics.checkNotNullParameter((Object)masterLSNContext, (String)"masterLSNContext");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(RedoSender.class.getName());
        this.conf = conf;
        this.masterLSNContext = masterLSNContext;
        this.context = context;
        this.AckTimeStat = AckTimeStat;
        this.logger$delegate = LazyKt.lazy((Function0)((Function0)new Function0<OlapLogger>(this){
            final /* synthetic */ RedoSender this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final OlapLogger invoke() {
                return this.this$0.getCurrent().getLogger$bos_olap_core2();
            }
        }));
        this.selector = Selector.open();
        this.serverSocket = ServerSocketChannel.open();
        this.slaves = new HashMap();
        this.serverSocket.configureBlocking(false);
    }

    public /* synthetic */ RedoSender(ReplicationConf replicationConf, MasterLSNContext masterLSNContext, ReplicationContext replicationContext, TimeStatQueue timeStatQueue, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            timeStatQueue = null;
        }
        this(replicationConf, masterLSNContext, replicationContext, timeStatQueue);
    }

    private final OlapLogger getLogger() {
        Lazy lazy = this.logger$delegate;
        return (OlapLogger)lazy.getValue();
    }

    @NotNull
    public final ReplicationWorkspace getCurrent() {
        return this.context.getWorkspace$bos_olap_core2();
    }

    @NotNull
    public final ReplicationStatus getStatus() {
        return this.context.getWorkspace$bos_olap_core2().getStatus();
    }

    private final long getKeepAliveTimeoutNs() {
        return (long)(OlapConfigItems.INSTANCE.getKeepAliveTimeout$bos_olap_core2().getValue() * 1000) * 1000000L;
    }

    private final long getMaxVipWaitTime() {
        return (long)(OlapConfigItems.INSTANCE.getKeepAliveTimeout$bos_olap_core2().getValue() * 1000) * 1000000L + 5000000000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block13: {
            try {
                while (this.isRunning) {
                    this.selector.select(1000L);
                    Set<SelectionKey> keys = this.selector.selectedKeys();
                    this.keepAlive();
                    Iterator iterator2 = keys.iterator();
                    while (iterator2.hasNext()) {
                        SelectionKey key2 = (SelectionKey)iterator2.next();
                        iterator2.remove();
                        if (!key2.isValid()) continue;
                        if (key2.isAcceptable()) {
                            Intrinsics.checkNotNull((Object)key2);
                            this.accept(key2);
                        }
                        if (!key2.isReadable()) continue;
                        Intrinsics.checkNotNull((Object)key2);
                        this.read(key2);
                    }
                    this.checkSwitch();
                    this.checkVip();
                }
            }
            catch (Exception e) {
                OlapLogger olapLogger = this.getLogger();
                boolean $i$f$error = false;
                String reportId$iv = olapLogger.getStatus().get().name() + "-ReplicationError-" + CubeToolKt.getCurrentTime();
                OlapLogger this_$iv$iv = olapLogger;
                boolean $i$f$error2 = false;
                if (this_$iv$iv.isErrorEnabled()) {
                    boolean bl = false;
                    String message$iv$iv = "\u53d1\u9001\u7ebf\u7a0b \u5f02\u5e38\u9000\u51fa\u3002";
                    HealthReport report$iv$iv = new HealthReport(reportId$iv, null, this_$iv$iv.getStatus().get().name() + "-ReplicationError: " + message$iv$iv, HealthReportLevel.Error, PrivilegeType.None.getCode());
                    this_$iv$iv.getOlapWorkspace().getHealthReports().commit(report$iv$iv);
                    if ((Throwable)e == null) {
                        OlapLogger.access$getLogger$cp().error(message$iv$iv);
                    } else {
                        OlapLogger.access$getLogger$cp().error("{}", (Object)message$iv$iv, (Object)e);
                    }
                }
                break block13;
            }
            finally {
                for (Map.Entry entry : ((Map)this.slaves).entrySet()) {
                    ((SlaveNode)entry.getValue()).close();
                }
                this.selector.close();
                this.serverSocket.close();
            }
            for (Map.Entry entry : ((Map)this.slaves).entrySet()) {
                ((SlaveNode)entry.getValue()).close();
            }
            this.selector.close();
            this.serverSocket.close();
        }
    }

    public final void accept(@NotNull SelectionKey key2) {
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        SelectableChannel selectableChannel = key2.channel();
        Intrinsics.checkNotNull((Object)selectableChannel, (String)"null cannot be cast to non-null type java.nio.channels.ServerSocketChannel");
        ServerSocketChannel ssc = (ServerSocketChannel)selectableChannel;
        SocketChannel clientChannel = ssc.accept();
        Socket socket = clientChannel.socket();
        int port = socket.getPort();
        InetAddress ipAddress = socket.getInetAddress();
        OlapLogger.Companion.info("new slave connection\uff0cIP: " + ipAddress + ", Port: " + port);
        clientChannel.configureBlocking(false);
        Intrinsics.checkNotNull((Object)clientChannel);
        SlaveNode slave = new SlaveNode(clientChannel);
        slave.setKey(clientChannel.register(this.selector, 1));
        ((Map)this.slaves).put(clientChannel, slave);
    }

    public final void read(@NotNull SelectionKey key2) {
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        SelectableChannel selectableChannel = key2.channel();
        Intrinsics.checkNotNull((Object)selectableChannel, (String)"null cannot be cast to non-null type java.nio.channels.SocketChannel");
        SocketChannel sc = (SocketChannel)selectableChannel;
        if (!this.slaves.containsKey(sc)) {
            String string2 = Res.INSTANCE.getRedoSenderException_2();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-RedoSenderException_2>(...)");
            throw Res.INSTANCE.getRuntimeException(string2, new Object[0]);
        }
        SlaveNode slaveNode = this.slaves.get(sc);
        Intrinsics.checkNotNull((Object)slaveNode, (String)"null cannot be cast to non-null type kd.bos.olapServer2.replication.SlaveNode");
        SlaveNode slave = slaveNode;
        try {
            int readByte = sc.read(slave.getReadBuffer());
            if (readByte == -1) {
                SlaveNode slaveNode2 = this.slaves.get(sc);
                Intrinsics.checkNotNull((Object)slaveNode2, (String)"null cannot be cast to non-null type kd.bos.olapServer2.replication.SlaveNode");
                this.closeSlave(slaveNode2);
                return;
            }
            slave.getReadBuffer().flip();
            while (true) {
                ByteBuffer byteBuffer = slave.getReadBuffer();
                Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"<get-readBuffer>(...)");
                if (!this.hasCompleteSignal(byteBuffer)) break;
                this.dealCmd(slave);
            }
            slave.getReadBuffer().compact();
        }
        catch (Exception e) {
            SlaveNode slaveNode3 = this.slaves.get(sc);
            Intrinsics.checkNotNull((Object)slaveNode3, (String)"null cannot be cast to non-null type kd.bos.olapServer2.replication.SlaveNode");
            this.closeSlave(slaveNode3);
            return;
        }
    }

    private final void checkVip() {
        if (this.getStatus() != ReplicationStatus.Master) {
            return;
        }
        long now = System.nanoTime();
        if (now - this.lastVipTime > this.getMaxVipWaitTime()) {
            OlapLogger.Companion.info("vip \u68c0\u6d4b\u95f4\u9694\u8d85\u8fc710s");
            if (!this.getCurrent().isVip()) {
                OlapLogger.Companion.info("vip \u4e0d\u5728\u672c\u673a,\u4e0d\u80fd\u4f5c\u4e3aMaster");
                this.getCurrent().switchStatus(ReplicationStatus.Unavailable);
                return;
            }
        }
        if (this.getCurrent().isVip()) {
            this.lastVipTime = now;
        } else {
            OlapLogger.Companion.info("\u68c0\u6d4bvip \u4e0d\u5728\u672c\u673a");
        }
    }

    @Nullable
    public final String byteToHex(byte b) {
        String hex = Integer.toHexString(b & 0xFF);
        if (hex.length() < 2) {
            hex = '0' + hex;
        }
        return hex;
    }

    private final void printBuffer(ByteBuffer buffer) {
        StringBuilder result2 = new StringBuilder("");
        byte[] byArray = buffer.array();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"array(...)");
        for (byte b : byArray) {
            result2.append(this.byteToHex(b) + ' ');
        }
        OlapLogger.Companion.info("readbuffer\u5185\u5bb9: {}", result2);
    }

    private final void dealCmd(SlaveNode slave) {
        slave.getReadBuffer().get();
        try {
            SignalType signal = SignalType.Companion.byteToSignalType(slave.getReadBuffer().get());
            if (signal != SignalType.REDO_ACK) {
                OlapLogger.Companion.info("RedoSender \u63a5\u53d7\u5230\u63a7\u5236\u6307\u4ee4:{}", (Object)signal);
            }
            switch (WhenMappings.$EnumSwitchMapping$0[signal.ordinal()]) {
                case 1: {
                    this.dealControlConnect(slave);
                    break;
                }
                case 2: {
                    this.dealDataConnect(slave);
                    break;
                }
                case 3: {
                    this.dealStartStream(slave);
                    break;
                }
                case 4: {
                    this.dealEndStream(slave);
                    break;
                }
                case 5: {
                    this.dealRedoAck(slave);
                    break;
                }
                case 6: {
                    this.dealSwitchToMaster(slave);
                    break;
                }
                case 7: {
                    this.dealMasterCloseAck(slave);
                    break;
                }
                default: {
                    String string2 = Res.INSTANCE.getRedoReceiverException_3();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-RedoReceiverException_3>(...)");
                    throw Res.INSTANCE.getRuntimeException(string2, new Object[0]);
                }
            }
        }
        catch (Exception e) {
            OlapLogger $this$iv = this.getLogger();
            Object t$iv = null;
            boolean $i$f$error = false;
            String reportId$iv = $this$iv.getStatus().get().name() + "-ReplicationError-" + CubeToolKt.getCurrentTime();
            OlapLogger this_$iv$iv = $this$iv;
            boolean $i$f$error2 = false;
            if (this_$iv$iv.isErrorEnabled()) {
                boolean bl = false;
                String message$iv$iv = "\u5f02\u5e38\u4fe1\u606f\uff1a" + Arrays.toString(e.getStackTrace());
                HealthReport report$iv$iv = new HealthReport(reportId$iv, null, this_$iv$iv.getStatus().get().name() + "-ReplicationError: " + message$iv$iv, HealthReportLevel.Error, PrivilegeType.None.getCode());
                this_$iv$iv.getOlapWorkspace().getHealthReports().commit(report$iv$iv);
                OlapLogger.access$getLogger$cp().error(message$iv$iv);
            }
            OlapLogger.Companion.info("buffer\u4fe1\u606f\uff1a{}", slave.getReadBuffer().toString());
            ByteBuffer byteBuffer = slave.getReadBuffer();
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"<get-readBuffer>(...)");
            this.printBuffer(byteBuffer);
        }
    }

    private final void dealControlConnect(SlaveNode slave) {
        byte serverId = slave.getReadBuffer().get();
        if (!this.isValidServerId(serverId)) {
            this.sendDisAgree(slave, SignalType.CONTROL_CONNECT);
            this.closeSlave(slave);
            return;
        }
        slave.setSlaveId(serverId);
        byte[] masterConfigMd5 = this.context.refreshMd5(this.conf.get_node().getRedoPath());
        byte[] slaveConfigMd5 = new byte[16];
        slave.getReadBuffer().get(slaveConfigMd5);
        slave.setWebPort(slave.getReadBuffer().getInt());
        if (!Arrays.equals(masterConfigMd5, slaveConfigMd5)) {
            OlapLogger $this$iv = this.getLogger();
            Object t$iv = null;
            boolean $i$f$error = false;
            String reportId$iv = $this$iv.getStatus().get().name() + "-ReplicationError-" + CubeToolKt.getCurrentTime();
            OlapLogger this_$iv$iv = $this$iv;
            boolean $i$f$error2 = false;
            if (this_$iv$iv.isErrorEnabled()) {
                boolean bl = false;
                String string2 = Res.INSTANCE.getRedoSenderException_4();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-RedoSenderException_4>(...)");
                String message$iv$iv = string2;
                HealthReport report$iv$iv = new HealthReport(reportId$iv, null, this_$iv$iv.getStatus().get().name() + "-ReplicationError: " + message$iv$iv, HealthReportLevel.Error, PrivilegeType.None.getCode());
                this_$iv$iv.getOlapWorkspace().getHealthReports().commit(report$iv$iv);
                OlapLogger.access$getLogger$cp().error(message$iv$iv);
            }
            this.sendDisAgree(slave, SignalType.CONTROL_CONNECT);
            this.closeSlave(slave);
            return;
        }
        this.sendAgree(slave, SignalType.CONTROL_CONNECT);
    }

    private final void dealDataConnect(SlaveNode slave) {
        byte serverId = slave.getReadBuffer().get();
        SelectionKey selectionKey = slave.getKey();
        if (selectionKey != null) {
            selectionKey.cancel();
        }
        this.slaves.remove(slave.getControlChannel());
        SlaveNode slaveNode = this.tryGetControlSlave(serverId);
        if (slaveNode == null) {
            String string2 = Res.INSTANCE.getRedoSenderException_3();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-RedoSenderException_3>(...)");
            throw Res.INSTANCE.getRuntimeException(string2, new Object[0]);
        }
        SlaveNode controlSlave = slaveNode;
        if (this.conf.get_master().getSynSlavesID().contains(serverId)) {
            controlSlave.setAsync(false);
        }
        controlSlave.setDataChannel(slave.getControlChannel());
        this.sendAgree(controlSlave, SignalType.DATA_CONNECT);
    }

    private final boolean isValidServerId(byte serverId) {
        if (serverId == (byte)this.conf.get_node().getServerID()) {
            OlapLogger $this$iv = this.getLogger();
            Object t$iv = null;
            boolean $i$f$error = false;
            String reportId$iv = $this$iv.getStatus().get().name() + "-ReplicationError-" + CubeToolKt.getCurrentTime();
            OlapLogger this_$iv$iv = $this$iv;
            boolean $i$f$error2 = false;
            if (this_$iv$iv.isErrorEnabled()) {
                boolean bl = false;
                String string2 = Res.INSTANCE.getRedoSenderException_5();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-RedoSenderException_5>(...)");
                Object[] objectArray = new Object[]{serverId};
                String message$iv$iv = Res.INSTANCE.format(string2, objectArray);
                HealthReport report$iv$iv = new HealthReport(reportId$iv, null, this_$iv$iv.getStatus().get().name() + "-ReplicationError: " + message$iv$iv, HealthReportLevel.Error, PrivilegeType.None.getCode());
                this_$iv$iv.getOlapWorkspace().getHealthReports().commit(report$iv$iv);
                OlapLogger.access$getLogger$cp().error(message$iv$iv);
            }
            return false;
        }
        SlaveNode controlSlave = this.tryGetControlSlave(serverId);
        if (controlSlave != null) {
            OlapLogger $this$iv = this.getLogger();
            Object t$iv = null;
            boolean $i$f$error = false;
            String reportId$iv = $this$iv.getStatus().get().name() + "-ReplicationError-" + CubeToolKt.getCurrentTime();
            OlapLogger this_$iv$iv = $this$iv;
            boolean $i$f$error3 = false;
            if (this_$iv$iv.isErrorEnabled()) {
                boolean bl = false;
                String string3 = Res.INSTANCE.getRedoSenderException_6();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"<get-RedoSenderException_6>(...)");
                Object[] objectArray = new Object[]{serverId};
                String message$iv$iv = Res.INSTANCE.format(string3, objectArray);
                HealthReport report$iv$iv = new HealthReport(reportId$iv, null, this_$iv$iv.getStatus().get().name() + "-ReplicationError: " + message$iv$iv, HealthReportLevel.Error, PrivilegeType.None.getCode());
                this_$iv$iv.getOlapWorkspace().getHealthReports().commit(report$iv$iv);
                OlapLogger.access$getLogger$cp().error(message$iv$iv);
            }
            return false;
        }
        return true;
    }

    private final void startAsyncSlave(SlaveNode slave) {
        OlapLogger.Companion.info("\u542f\u52a8\u5f02\u6b65\u590d\u5236\u7ed3\u70b9 slave{}", slave.getSlaveId());
        TransferredRedoFile transferFile = null;
        try {
            transferFile = new TransferredRedoFile(slave.getStartLSN(), this.conf.get_node().getRedoPath(), this.masterLSNContext);
        }
        catch (Throwable e) {
            OlapLogger this_$iv = this.getLogger();
            boolean $i$f$error = false;
            String reportId$iv = this_$iv.getStatus().get().name() + "-ReplicationError-" + CubeToolKt.getCurrentTime();
            OlapLogger this_$iv$iv = this_$iv;
            boolean $i$f$error2 = false;
            if (this_$iv$iv.isErrorEnabled()) {
                boolean bl = false;
                String message$iv$iv = "\u542f\u52a8\u5f02\u6b65\u590d\u5236\u7ed3\u70b9slave" + slave.getSlaveId() + "\u5931\u8d25\u3002";
                HealthReport report$iv$iv = new HealthReport(reportId$iv, null, this_$iv$iv.getStatus().get().name() + "-ReplicationError: " + message$iv$iv, HealthReportLevel.Error, PrivilegeType.None.getCode());
                this_$iv$iv.getOlapWorkspace().getHealthReports().commit(report$iv$iv);
                if (e == null) {
                    OlapLogger.access$getLogger$cp().error(message$iv$iv);
                } else {
                    OlapLogger.access$getLogger$cp().error("{}", (Object)message$iv$iv, (Object)e);
                }
            }
            this.closeSlave(slave);
            return;
        }
        slave.setAsyThread(ThreadsKt.thread$default((boolean)false, (boolean)false, null, (String)("Async slave " + slave.getSlaveId()), (int)0, (Function0)((Function0)new Function0<Unit>(slave, transferFile, this){
            final /* synthetic */ SlaveNode $slave;
            final /* synthetic */ TransferredRedoFile $transferFile;
            final /* synthetic */ RedoSender this$0;
            {
                this.$slave = $slave;
                this.$transferFile = $transferFile;
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                try {
                    while (this.$slave.getReady()) {
                        SocketChannel socketChannel = this.$slave.getDataChannel();
                        Intrinsics.checkNotNull((Object)socketChannel);
                        if (this.$transferFile.transferTo$bos_olap_core2(socketChannel)) continue;
                        Thread.sleep(100L);
                    }
                }
                catch (Throwable e) {
                    OlapLogger this_$iv = RedoSender.access$getLogger(this.this$0);
                    boolean $i$f$error = false;
                    String reportId$iv = this_$iv.getStatus().get().name() + "-ReplicationError-" + CubeToolKt.getCurrentTime();
                    OlapLogger this_$iv$iv = this_$iv;
                    boolean $i$f$error2 = false;
                    if (this_$iv$iv.isErrorEnabled()) {
                        boolean bl = false;
                        String message$iv$iv = "\u5f02\u6b65\u53d1\u9001\u51fa\u73b0\u5f02\u5e38\u3002";
                        HealthReport report$iv$iv = new HealthReport(reportId$iv, null, this_$iv$iv.getStatus().get().name() + "-ReplicationError: " + message$iv$iv, HealthReportLevel.Error, PrivilegeType.None.getCode());
                        this_$iv$iv.getOlapWorkspace().getHealthReports().commit(report$iv$iv);
                        if (e == null) {
                            OlapLogger.access$getLogger$cp().error(message$iv$iv);
                        } else {
                            OlapLogger.access$getLogger$cp().error("{}", (Object)message$iv$iv, (Object)e);
                        }
                    }
                    this.$slave.setAsyThread(null);
                    RedoSender.access$closeSlave(this.this$0, this.$slave);
                }
                finally {
                    this.$transferFile.close();
                }
            }
        }), (int)23, null));
    }

    private final void dealStartStream(SlaveNode slave) {
        boolean isValidAsync;
        long startLSN = slave.getReadBuffer().getLong();
        boolean isValidSync = !slave.isAsync() && startLSN == this.masterLSNContext.getCurrentPage();
        OlapLogger.Companion.info("slave.isAsync={},startLSN:{}, master.currentPage:{}", slave.isAsync(), startLSN, this.masterLSNContext.getCurrentPage());
        boolean isRedoExist = this.conf.get_node().getRedoKeepSegments() == 0 || startLSN >= LSNUtil.INSTANCE.nextPageLSN(this.masterLSNContext.getFlushLSN()) - (long)this.conf.get_node().getRedoKeepSegments() * (long)0x1000000;
        boolean bl = isValidAsync = slave.isAsync() && startLSN <= LSNUtil.INSTANCE.nextPageLSN(this.masterLSNContext.getFlushLSN()) && isRedoExist;
        if (!isValidSync && !isValidAsync) {
            this.sendDisAgree(slave, SignalType.START_STREAM);
            this.closeSlave(slave);
            return;
        }
        this.sendAgree(slave, SignalType.START_STREAM);
        slave.setStartLSN(startLSN);
        slave.setReady(true);
        slave.setLastAckTime(System.nanoTime());
        if (slave.isAsync()) {
            this.startAsyncSlave(slave);
        }
    }

    private final void dealEndStream(SlaveNode slave) {
        long stopLSN = slave.getReadBuffer().getLong();
        slave.setStopLSN(stopLSN);
        this.sendAgree(slave, SignalType.END_STREAM);
        if (stopLSN == 0L) {
            slave.latch();
            this.closeSlave(slave);
            slave.unlatch();
        }
    }

    private final void dealRedoAck(SlaveNode slave) {
        block1: {
            long lastPageAck = slave.getReadBuffer().getLong();
            slave.setLastAckTime(System.nanoTime());
            slave.setLastAck(lastPageAck);
            slave.setTimeOutCount(0);
            if (lastPageAck <= this.masterLSNContext.getLastACKLSN()) break block1;
            this.masterLSNContext.setLastACKLSN(lastPageAck);
            TimeStatQueue timeStatQueue = this.AckTimeStat;
            if (timeStatQueue != null) {
                timeStatQueue.setEnd(lastPageAck);
            }
        }
    }

    private final void dealSwitchToMaster(SlaveNode slave) {
        if (!Intrinsics.areEqual((Object)slave.getIp(), (Object)this.conf.get_slave().getHost())) {
            OlapLogger.Companion.info("\u975eslave\u53d1\u9001\u4e86SwitchToMaster\uff0cIP: " + slave.getIp());
            return;
        }
        slave.getReadBuffer().get();
        this.sendAgree(slave, SignalType.SWITCH_TO_MASTER);
        this.getCurrent().switchStatus(ReplicationStatus.Transfering);
    }

    private final void dealMasterCloseAck(SlaveNode slave) {
        if (!Intrinsics.areEqual((Object)slave.getIp(), (Object)this.conf.get_slave().getHost())) {
            OlapLogger.Companion.info("\u975eslave\u53d1\u9001\u4e86dealMasterCloseAck\uff0cIP: " + slave.getIp());
            return;
        }
        slave.getReadBuffer().getLong();
        this.closeSlave(slave);
        OlapLogger.Companion.info("\u63a5\u6536\u5230master close ack,\u6b64\u65f6 slave\u4e2a\u6570{}", this.slaves.size());
        if (this.slaves.size() == 0) {
            this.createThreadSwitchToSlave();
        }
    }

    private final void createThreadSwitchToSlave() {
        this.getCurrent().masterToSlave();
    }

    private final void sendAgree(SlaveNode slave, SignalType reqCmdType) {
        slave.getSendBuffer().clear();
        byte len = 3;
        slave.getSendBuffer().put(len);
        byte cmdType = SignalType.AGREE.getCode();
        slave.getSendBuffer().put(cmdType);
        slave.getSendBuffer().put(reqCmdType.getCode());
        this.sendSignal(slave);
    }

    private final void sendDisAgree(SlaveNode slave, SignalType reqCmdType) {
        slave.getSendBuffer().clear();
        byte len = 3;
        slave.getSendBuffer().put(len);
        byte cmdType = SignalType.DISAGREE.getCode();
        slave.getSendBuffer().put(cmdType);
        slave.getSendBuffer().put(reqCmdType.getCode());
        this.sendSignal(slave);
    }

    private final void sendKeepAlive(SlaveNode slave) {
        slave.getSendBuffer().clear();
        byte len = 2;
        slave.getSendBuffer().put(len);
        byte cmdType = SignalType.KEEP_ALIVE.getCode();
        slave.getSendBuffer().put(cmdType);
        this.sendSignal(slave);
    }

    private final void sendMasterClose(SlaveNode slave) {
        slave.getSendBuffer().clear();
        byte len = 10;
        slave.getSendBuffer().put(len);
        byte cmdType = SignalType.MASTER_CLOSE.getCode();
        slave.getSendBuffer().put(cmdType);
        long lastPage = this.masterLSNContext.getFlushLSN();
        slave.getSendBuffer().putLong(lastPage);
        this.sendSignal(slave);
    }

    private final boolean hasCompleteSignal(ByteBuffer $this$hasCompleteSignal) {
        if ($this$hasCompleteSignal.remaining() == 0) {
            return false;
        }
        return $this$hasCompleteSignal.remaining() >= $this$hasCompleteSignal.get($this$hasCompleteSignal.position());
    }

    private final SlaveNode tryGetControlSlave(byte serverId) {
        for (Map.Entry slave : ((Map)this.slaves).entrySet()) {
            if (((SlaveNode)slave.getValue()).getSlaveId() != serverId) continue;
            return (SlaveNode)slave.getValue();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void sync(@NotNull RedoPage redo) {
        block9: {
            Intrinsics.checkNotNullParameter((Object)redo, (String)"redo");
            if (!this.isRunning) {
                this.masterLSNContext.setLastACKLSN(Long.MAX_VALUE);
                return;
            }
            int writeCount = 0;
            for (Map.Entry slave : ((Map)this.slaves).entrySet()) {
                if (!((SlaveNode)slave.getValue()).getReady() || ((SlaveNode)slave.getValue()).isAsync()) continue;
                try {
                    ((SlaveNode)slave.getValue()).latch();
                    SocketChannel socketChannel = ((SlaveNode)slave.getValue()).getDataChannel();
                    if (socketChannel != null) {
                        this.writeBuffer(socketChannel, redo.getBuffer());
                    }
                    ++writeCount;
                }
                catch (Exception e) {
                    this.closeSlave((SlaveNode)slave.getValue());
                }
                finally {
                    ((SlaveNode)slave.getValue()).unlatch();
                }
            }
            if (writeCount == 0) {
                this.masterLSNContext.setLastACKLSN(Long.MAX_VALUE);
                return;
            }
            TimeStatQueue timeStatQueue = this.AckTimeStat;
            if (timeStatQueue == null) break block9;
            timeStatQueue.setBegin(this.masterLSNContext.getFlushLSN());
        }
    }

    private final void keepAlive() {
        long now = System.nanoTime();
        if (now - this.lastKeepAliveTime > 1000000000L) {
            List closeSlavesList = new ArrayList();
            for (Map.Entry slave : ((Map)this.slaves).entrySet()) {
                long interval;
                if (!((SlaveNode)slave.getValue()).getReady()) continue;
                if (now - ((SlaveNode)slave.getValue()).getLastAckTime() > this.getKeepAliveTimeoutNs()) {
                    SlaveNode slaveNode = (SlaveNode)slave.getValue();
                    int n = slaveNode.getTimeOutCount();
                    slaveNode.setTimeOutCount(n + 1);
                    OlapLogger.Companion.info("slave{}\u8fde\u63a5\u8d85\u65f6{}\u6b21", ((SlaveNode)slave.getValue()).getSlaveId(), ((SlaveNode)slave.getValue()).getTimeOutCount());
                    if (((SlaveNode)slave.getValue()).getTimeOutCount() > 5) {
                        OlapLogger.Companion.info("slave" + ((SlaveNode)slave.getValue()).getSlaveId() + " \u786e\u5b9a\u4e3a\u8d85\u65f6");
                        closeSlavesList.add(slave.getValue());
                        continue;
                    }
                } else {
                    ((SlaveNode)slave.getValue()).setTimeOutCount(0);
                }
                if ((interval = now - this.lastKeepAliveTime) > 2000000000L) {
                    OlapLogger.Companion.info("send alive interval:" + interval);
                }
                this.sendKeepAlive((SlaveNode)slave.getValue());
            }
            for (SlaveNode elem : closeSlavesList) {
                elem.latch();
                this.closeSlave(elem);
                elem.unlatch();
            }
            this.lastKeepAliveTime = now;
        }
    }

    private final void sendSignal(SlaveNode slave) {
        try {
            SocketChannel socketChannel = slave.getControlChannel();
            ByteBuffer byteBuffer = slave.getSendBuffer();
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"<get-sendBuffer>(...)");
            this.writeBuffer(socketChannel, byteBuffer);
        }
        catch (Exception e) {
            this.closeSlave(slave);
        }
    }

    private final void checkSwitch() {
        if (this.getStatus() == ReplicationStatus.Transfering && !this.isSwitching && this.getCurrent().canSwitch()) {
            this.isSwitching = true;
            Iterator iterator2 = ((Map)this.slaves).entrySet().iterator();
            while (iterator2.hasNext()) {
                SlaveNode slave = (SlaveNode)iterator2.next().getValue();
                this.sendMasterClose(slave);
            }
        }
    }

    @NotNull
    public final ArrayList<String> getReadySlaves() {
        ArrayList<String> readySlaves = new ArrayList<String>();
        for (Map.Entry slave : ((Map)this.slaves).entrySet()) {
            if (!((SlaveNode)slave.getValue()).getReady()) continue;
            readySlaves.add(((SlaveNode)slave.getValue()).toString());
        }
        return readySlaves;
    }

    private final void writeBuffer(SocketChannel $this$writeBuffer, ByteBuffer buffer) {
        buffer.flip();
        while (buffer.hasRemaining()) {
            $this$writeBuffer.write(buffer);
        }
    }

    private final void closeSlave(SlaveNode slave) {
        OlapLogger.Companion.info("\u5173\u95ed slave" + slave.getSlaveId() + " \u8fde\u63a5");
        this.slaves.remove(slave.getControlChannel());
        slave.close();
    }

    @Override
    public void start() {
        try {
            this.serverSocket.bind(new InetSocketAddress(this.conf.get_master().getBindPort()));
        }
        catch (Exception ex) {
            String string2 = Res.INSTANCE.getRedoSenderException_1();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-RedoSenderException_1>(...)");
            Object[] objectArray = new Object[]{this.conf.get_master().getBindPort()};
            throw Res.INSTANCE.getRuntimeException(string2, objectArray);
        }
        this.isRunning = true;
        this.serverSocket.register(this.selector, 16);
        this.lastVipTime = System.nanoTime();
        super.start();
    }

    public final void close() {
        this.isRunning = false;
        this.join();
        OlapLogger.Companion.info("\u5173\u95ed{}\u6210\u529f", this.getClass().getSimpleName());
    }

    public static final /* synthetic */ OlapLogger access$getLogger(RedoSender $this) {
        return $this.getLogger();
    }

    public static final /* synthetic */ void access$closeSlave(RedoSender $this, SlaveNode slave) {
        $this.closeSlave(slave);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00060\u0004j\u0002`\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lkd/bos/olapServer2/replication/RedoSender$Companion;", "", "()V", "keepAliveIntervalNs", "", "maxTimeOutCount", "", "selectTimeoutMs", "Lkd/bos/olapServer2/common/long;", "bos-olap-core2"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SignalType.values().length];
            try {
                nArray[SignalType.CONTROL_CONNECT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SignalType.DATA_CONNECT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SignalType.START_STREAM.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SignalType.END_STREAM.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SignalType.REDO_ACK.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SignalType.SWITCH_TO_MASTER.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SignalType.MASTER_CLOSE_ACK.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

