/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.replication;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.olapServer2.common.Paths;
import kd.bos.olapServer2.replication.BackupRecordType;
import kd.bos.olapServer2.replication.BackupRecordV3;
import kd.bos.olapServer2.storages.OlapWorkspace;
import kd.bos.olapServer2.tools.FileTools;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006J*\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u00060\nj\u0002`\u000b2\n\u0010\f\u001a\u00060\nj\u0002`\u000b2\n\u0010\r\u001a\u00060\nj\u0002`\u000bJ\u001e\u0010\u000e\u001a\u00020\b2\n\u0010\t\u001a\u00060\nj\u0002`\u000b2\n\u0010\f\u001a\u00060\nj\u0002`\u000bJ\u0012\u0010\u000f\u001a\u00020\b2\n\u0010\t\u001a\u00060\nj\u0002`\u000bJ-\u0010\u0010\u001a\n\u0018\u00010\nj\u0004\u0018\u0001`\u000b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\n\u0010\u0014\u001a\u00060\nj\u0002`\u000b\u00a2\u0006\u0002\u0010\u0015J\u0016\u0010\u0016\u001a\u00060\nj\u0002`\u000b2\n\u0010\t\u001a\u00060\nj\u0002`\u000bJ\u0016\u0010\u0017\u001a\u00060\nj\u0002`\u000b2\n\u0010\t\u001a\u00060\nj\u0002`\u000bJ-\u0010\u0018\u001a\n\u0018\u00010\nj\u0004\u0018\u0001`\u000b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\n\u0010\u0014\u001a\u00060\nj\u0002`\u000b\u00a2\u0006\u0002\u0010\u0015J\u0012\u0010\u0019\u001a\u00020\b2\n\u0010\t\u001a\u00060\nj\u0002`\u000bJ,\u0010\u001a\u001a\u00020\b2\n\u0010\t\u001a\u00060\nj\u0002`\u000b2\n\u0010\u0014\u001a\u00060\nj\u0002`\u000b2\f\b\u0002\u0010\u001b\u001a\u00060\u001cj\u0002`\u001d\u00a8\u0006\u001e"}, d2={"Lkd/bos/olapServer2/replication/RedoUtil;", "", "()V", "doWithFrequentGC", "", "doSomething", "Lkotlin/Function0;", "getBackupFile", "Ljava/io/File;", "backupDirPath", "", "Lkd/bos/olapServer2/common/string;", "cubeName", "backupFileName", "getCubeBackupFolder", "getIncrementFolder", "getNextTotalRecordName", "backupRecords", "", "Lkd/bos/olapServer2/replication/BackupRecordV3;", "totalRecordName", "([Lkd/bos/olapServer2/replication/BackupRecordV3;Ljava/lang/String;)Ljava/lang/String;", "getOrCreateIncrementPath", "getOrCreateTotalPath", "getPreviousTotalRecordName", "getTotalFolder", "getTotalRecordFolder", "createIfNotExist", "", "Lkd/bos/olapServer2/common/bool;", "bos-olap-core2"})
@SourceDebugExtension(value={"SMAP\nRedoUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RedoUtil.kt\nkd/bos/olapServer2/replication/RedoUtil\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,111:1\n3792#2:112\n4307#2,2:113\n13309#2,2:119\n1549#3:115\n1620#3,3:116\n1#4:121\n*S KotlinDebug\n*F\n+ 1 RedoUtil.kt\nkd/bos/olapServer2/replication/RedoUtil\n*L\n65#1:112\n65#1:113,2\n82#1:119,2\n65#1:115\n65#1:116,3\n*E\n"})
public final class RedoUtil {
    @NotNull
    public static final RedoUtil INSTANCE = new RedoUtil();

    private RedoUtil() {
    }

    @NotNull
    public final String getOrCreateTotalPath(@NotNull String backupDirPath) {
        Intrinsics.checkNotNullParameter((Object)backupDirPath, (String)"backupDirPath");
        return FileTools.INSTANCE.getOrCreateDir(backupDirPath, "total");
    }

    @NotNull
    public final File getTotalFolder(@NotNull String backupDirPath) {
        Intrinsics.checkNotNullParameter((Object)backupDirPath, (String)"backupDirPath");
        return Paths.INSTANCE.toFile(backupDirPath, "total");
    }

    @NotNull
    public final String getOrCreateIncrementPath(@NotNull String backupDirPath) {
        Intrinsics.checkNotNullParameter((Object)backupDirPath, (String)"backupDirPath");
        return FileTools.INSTANCE.getOrCreateDir(backupDirPath, "increment");
    }

    @NotNull
    public final File getIncrementFolder(@NotNull String backupDirPath) {
        Intrinsics.checkNotNullParameter((Object)backupDirPath, (String)"backupDirPath");
        return Paths.INSTANCE.toFile(backupDirPath, "increment");
    }

    @NotNull
    public final File getCubeBackupFolder(@NotNull String backupDirPath, @NotNull String cubeName) {
        Intrinsics.checkNotNullParameter((Object)backupDirPath, (String)"backupDirPath");
        Intrinsics.checkNotNullParameter((Object)cubeName, (String)"cubeName");
        return Paths.INSTANCE.toFile(backupDirPath, cubeName);
    }

    @NotNull
    public final File getTotalRecordFolder(@NotNull String backupDirPath, @NotNull String totalRecordName, boolean createIfNotExist) {
        Intrinsics.checkNotNullParameter((Object)backupDirPath, (String)"backupDirPath");
        Intrinsics.checkNotNullParameter((Object)totalRecordName, (String)"totalRecordName");
        Object object2 = new String[]{totalRecordName};
        Object file = object2 = Paths.INSTANCE.joinToFile(this.getOrCreateTotalPath(backupDirPath), (String[])object2);
        boolean bl = false;
        if (createIfNotExist && !((File)file).exists()) {
            ((File)file).mkdir();
        }
        return object2;
    }

    public static /* synthetic */ File getTotalRecordFolder$default(RedoUtil redoUtil, String string2, String string3, boolean bl, int n, Object object2) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return redoUtil.getTotalRecordFolder(string2, string3, bl);
    }

    @NotNull
    public final File getBackupFile(@NotNull String backupDirPath, @NotNull String cubeName, @NotNull String backupFileName) {
        Intrinsics.checkNotNullParameter((Object)backupDirPath, (String)"backupDirPath");
        Intrinsics.checkNotNullParameter((Object)cubeName, (String)"cubeName");
        Intrinsics.checkNotNullParameter((Object)backupFileName, (String)"backupFileName");
        String[] stringArray = new String[]{cubeName, backupFileName};
        return Paths.INSTANCE.joinToFile(backupDirPath, stringArray);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final String getPreviousTotalRecordName(@NotNull BackupRecordV3[] backupRecords, @NotNull String totalRecordName) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)backupRecords, (String)"backupRecords");
        Intrinsics.checkNotNullParameter((Object)totalRecordName, (String)"totalRecordName");
        Object $this$filter$iv = backupRecords;
        boolean $i$f$filter = false;
        BackupRecordV3[] backupRecordV3Array = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (BackupRecordV3 element$iv$iv : $this$filterTo$iv$iv) {
            void it = element$iv$iv;
            boolean bl = false;
            if (!(it.getType() == BackupRecordType.Total)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            BackupRecordV3 element$iv$iv;
            element$iv$iv = (BackupRecordV3)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        List totalList = (List)destination$iv$iv;
        int index2 = totalList.indexOf(totalRecordName);
        if (index2 == -1) {
            throw new RuntimeException("can not find total record name: " + totalRecordName);
        }
        return index2 != 0 ? (String)totalList.get(index2 - 1) : null;
    }

    @Nullable
    public final String getNextTotalRecordName(@NotNull BackupRecordV3[] backupRecords, @NotNull String totalRecordName) {
        Intrinsics.checkNotNullParameter((Object)backupRecords, (String)"backupRecords");
        Intrinsics.checkNotNullParameter((Object)totalRecordName, (String)"totalRecordName");
        boolean containTotalRecordName = false;
        BackupRecordV3[] $this$forEach$iv = backupRecords;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            BackupRecordV3 element$iv;
            BackupRecordV3 it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            if (containTotalRecordName && it.getType() == BackupRecordType.Total) {
                return it.getName();
            }
            if (!Intrinsics.areEqual((Object)it.getName(), (Object)totalRecordName)) continue;
            containTotalRecordName = true;
        }
        if (!containTotalRecordName) {
            boolean bl = false;
            String string2 = "can not find total record name: " + totalRecordName;
            throw new IllegalArgumentException(string2.toString());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doWithFrequentGC(@NotNull Function0<Unit> doSomething) {
        Intrinsics.checkNotNullParameter(doSomething, (String)"doSomething");
        String oldUnloadTimeout = OlapWorkspace.Companion.getCubeWorkspaceUnloadTimeoutConfigItem$bos_olap_core2().getLastValue();
        String oldTimePeriod = OlapWorkspace.Companion.getGcTimePeriodConfigItem$bos_olap_core2().getLastValue();
        try {
            doSomething.invoke();
        }
        finally {
            OlapWorkspace.Companion.getCubeWorkspaceUnloadTimeoutConfigItem$bos_olap_core2().update(oldUnloadTimeout);
            OlapWorkspace.Companion.getGcTimePeriodConfigItem$bos_olap_core2().update(oldTimePeriod);
        }
    }
}

