/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.replication;

import java.io.Closeable;
import java.util.concurrent.locks.LockSupport;
import kd.bos.olapServer2.collections.SpinWait;
import kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders.Bits;
import kd.bos.olapServer2.replication.LSNUtil;
import kd.bos.olapServer2.replication.MasterLSNContext;
import kd.bos.olapServer2.replication.OlapLogger;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.LongProgression;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u0000 (2\u00020\u0001:\u0003()*B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0016\u001a\u00020\tH\u0016J \u0010\u0017\u001a\u00020\u00182\n\u0010\u0019\u001a\u00060\u0010j\u0002`\u001a2\n\u0010\u001b\u001a\u00060\u0010j\u0002`\u001aH\u0002J\f\u0010\u001c\u001a\u00060\u0005j\u0002`\u0006H\u0002J\b\u0010\u001d\u001a\u00020\tH\u0002J\u0012\u0010\u001e\u001a\u00020\t2\n\u0010\u001f\u001a\u00060\u0010j\u0002`\u0011J\u0012\u0010 \u001a\u00020\t2\n\u0010!\u001a\u00060\u0005j\u0002`\u0006J\u001a\u0010\"\u001a\u0016\u0012\b\u0012\u00060\u0010j\u0002`\u0011\u0012\b\u0012\u00060\u0005j\u0002`\u00060#J\b\u0010$\u001a\u00020\tH\u0002J\u0014\u0010%\u001a\u00020\t2\n\u0010&\u001a\u00060\u0005j\u0002`\u0006H\u0002J\u0014\u0010'\u001a\u00060\u0005j\u0002`\u0006*\u00060\u0010j\u0002`\u0011H\u0002R\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u0012\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000f\u001a\u00060\u0010j\u0002`\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0013\u001a\u00060\u0010j\u0002`\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0014\u001a\u00060\u0015R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lkd/bos/olapServer2/replication/RedoWriter;", "Ljava/io/Closeable;", "masterLSNContext", "Lkd/bos/olapServer2/replication/MasterLSNContext;", "count", "", "Lkd/bos/olapServer2/common/int;", "sync", "Lkotlin/Function1;", "", "(Lkd/bos/olapServer2/replication/MasterLSNContext;ILkotlin/jvm/functions/Function1;)V", "availableBuffer", "", "Lkd/bos/olapServer2/replication/RedoWriter$WriteState;", "[Lkd/bos/olapServer2/replication/RedoWriter$WriteState;", "flushNext", "", "Lkd/bos/olapServer2/common/LSN;", "fullLength", "takeNext", "work", "Lkd/bos/olapServer2/replication/RedoWriter$Worker;", "close", "compareAndSet", "", "expectedValue", "Lkd/bos/olapServer2/common/long;", "newValue", "findFlushOffset", "forceFlush", "forceSync", "syncPoint", "markMergeBuffer", "index", "markOccupy", "Lkotlin/Pair;", "noticeSync", "syncRedoData", "offset", "toIndex", "Companion", "Worker", "WriteState", "bos-olap-core2"})
public final class RedoWriter
implements Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MasterLSNContext masterLSNContext;
    private final int count;
    @NotNull
    private final Function1<Integer, Unit> sync;
    @NotNull
    private final Worker work;
    @NotNull
    private final WriteState[] availableBuffer;
    private volatile long takeNext;
    private volatile long flushNext;
    private final int fullLength;
    private static final long takeNextOffset = Bits.INSTANCE.getUnsafe().objectFieldOffset(RedoWriter.class.getDeclaredField("takeNext"));

    public RedoWriter(@NotNull MasterLSNContext masterLSNContext, int count, @NotNull Function1<? super Integer, Unit> sync) {
        Intrinsics.checkNotNullParameter((Object)masterLSNContext, (String)"masterLSNContext");
        Intrinsics.checkNotNullParameter(sync, (String)"sync");
        this.masterLSNContext = masterLSNContext;
        this.count = count;
        this.sync = sync;
        String string2 = RedoWriter.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        this.work = new Worker(string2);
        int n = 0;
        int n2 = this.count;
        WriteState[] writeStateArray = new WriteState[n2];
        RedoWriter redoWriter = this;
        while (n < n2) {
            int n3 = n++;
            writeStateArray[n3] = WriteState.EMPTY;
        }
        redoWriter.availableBuffer = writeStateArray;
        this.flushNext = this.takeNext = this.masterLSNContext.getCurrentPage();
        this.fullLength = this.count * 8192;
        this.work.setPriority(10);
        this.work.start();
    }

    private final void noticeSync() {
        LockSupport.unpark(this.work);
    }

    public final void markMergeBuffer(int index2) {
        this.availableBuffer[index2] = WriteState.FINISH;
        this.noticeSync();
    }

    @NotNull
    public final Pair<Long, Integer> markOccupy() {
        Pair pair;
        long oldValue = this.takeNext;
        if (oldValue - this.flushNext >= (long)this.fullLength) {
            return new Pair((Object)-1L, (Object)-1);
        }
        long newValue = LSNUtil.INSTANCE.nextPageLSN(oldValue);
        if (this.compareAndSet(oldValue, newValue)) {
            int index2 = this.toIndex(oldValue);
            this.availableBuffer[index2] = WriteState.OCCUPY;
            this.masterLSNContext.setCurrentPage(this.takeNext);
            pair = new Pair((Object)oldValue, (Object)index2);
        } else {
            pair = new Pair((Object)-1L, (Object)-1);
        }
        return pair;
    }

    private final boolean compareAndSet(long expectedValue, long newValue) {
        return Bits.INSTANCE.getUnsafe().compareAndSwapLong(this, takeNextOffset, expectedValue, newValue);
    }

    private final void forceFlush() {
        try {
            int offset = this.findFlushOffset();
            this.syncRedoData(offset);
        }
        catch (Throwable t2) {
            OlapLogger.Companion.info("redoBuffer \u5f3a\u5236\u5237\u65b0\u540c\u6b65\u64cd\u4f5c\u53d1\u751f\u5f02\u5e38: {}", t2.getMessage());
        }
    }

    private final void syncRedoData(int offset) {
        int n = 0;
        while (n < offset) {
            int it = n++;
            boolean bl = false;
            int index2 = this.toIndex(this.flushNext);
            this.sync.invoke((Object)index2);
            this.masterLSNContext.setFlushLSN(this.flushNext);
            this.availableBuffer[index2] = WriteState.EMPTY;
            this.flushNext = LSNUtil.INSTANCE.nextPageLSN(this.flushNext);
        }
    }

    private final int findFlushOffset() {
        int nextIndex = 0;
        LongProgression longProgression = RangesKt.step((LongProgression)((LongProgression)RangesKt.until((long)this.flushNext, (long)this.takeNext)), (long)8192L);
        long i = longProgression.getFirst();
        long l = longProgression.getLast();
        long l2 = longProgression.getStep();
        if (l2 > 0L && i <= l || l2 < 0L && l <= i) {
            while (this.availableBuffer[this.toIndex(i)] == WriteState.FINISH) {
                ++nextIndex;
                if (i == l) break;
                i += l2;
            }
        }
        return nextIndex;
    }

    public final void forceSync(long syncPoint) {
        SpinWait.Companion.spinUntil((Function0<Boolean>)((Function0)new Function0<Boolean>(this, syncPoint){
            final /* synthetic */ RedoWriter this$0;
            final /* synthetic */ long $syncPoint;
            {
                this.this$0 = $receiver;
                this.$syncPoint = $syncPoint;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                boolean bl;
                if (RedoWriter.access$getMasterLSNContext$p(this.this$0).getFlushLSN() < this.$syncPoint) {
                    RedoWriter.access$noticeSync(this.this$0);
                    bl = false;
                } else {
                    bl = true;
                }
                return bl;
            }
        }));
    }

    @Override
    public void close() {
        SpinWait.Companion.spinUntil((Function0<Boolean>)((Function0)new Function0<Boolean>(this){
            final /* synthetic */ RedoWriter this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                boolean bl;
                if (RedoWriter.access$getTakeNext$p(this.this$0) != RedoWriter.access$getFlushNext$p(this.this$0)) {
                    RedoWriter.access$noticeSync(this.this$0);
                    bl = false;
                } else {
                    bl = true;
                }
                return bl;
            }
        }));
        this.work.interrupt();
        SpinWait.Companion.spinUntil((Function0<Boolean>)((Function0)new Function0<Boolean>(this){
            final /* synthetic */ RedoWriter this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                boolean bl;
                if (!RedoWriter.access$getWork$p(this.this$0).isStop()) {
                    RedoWriter.access$noticeSync(this.this$0);
                    bl = false;
                } else {
                    bl = true;
                }
                return bl;
            }
        }));
    }

    private final int toIndex(long $this$toIndex) {
        return (int)(($this$toIndex >> 13) % (long)this.count);
    }

    public static final /* synthetic */ MasterLSNContext access$getMasterLSNContext$p(RedoWriter $this) {
        return $this.masterLSNContext;
    }

    public static final /* synthetic */ void access$noticeSync(RedoWriter $this) {
        $this.noticeSync();
    }

    public static final /* synthetic */ Worker access$getWork$p(RedoWriter $this) {
        return $this.work;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0012\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lkd/bos/olapServer2/replication/RedoWriter$Companion;", "", "()V", "takeNextOffset", "", "Lkd/bos/olapServer2/common/long;", "bos-olap-core2"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u000b\u001a\u00020\fH\u0016R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Lkd/bos/olapServer2/replication/RedoWriter$Worker;", "Ljava/lang/Thread;", "name", "", "Lkd/bos/olapServer2/common/string;", "(Lkd/bos/olapServer2/replication/RedoWriter;Ljava/lang/String;)V", "isStop", "", "()Z", "setStop", "(Z)V", "run", "", "bos-olap-core2"})
    private final class Worker
    extends Thread {
        private volatile boolean isStop;

        public Worker(String name2) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            super(name2);
        }

        public final boolean isStop() {
            return this.isStop;
        }

        public final void setStop(boolean bl) {
            this.isStop = bl;
        }

        @Override
        public void run() {
            long emptyPollTimes = 0L;
            int yieldTimes = 0;
            while (true) {
                if (this.isInterrupted()) {
                    this.isStop = true;
                    return;
                }
                if (RedoWriter.this.takeNext != RedoWriter.this.flushNext) {
                    RedoWriter.this.forceFlush();
                    emptyPollTimes = 0L;
                    yieldTimes = 0;
                    continue;
                }
                long l = emptyPollTimes;
                if ((emptyPollTimes = l + 1L) > 100L) {
                    Thread.yield();
                    ++yieldTimes;
                }
                if (yieldTimes <= 10) continue;
                LockSupport.park(this);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0080\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lkd/bos/olapServer2/replication/RedoWriter$WriteState;", "", "(Ljava/lang/String;I)V", "EMPTY", "OCCUPY", "FINISH", "bos-olap-core2"})
    public static final class WriteState
    extends Enum<WriteState> {
        public static final /* enum */ WriteState EMPTY = new WriteState();
        public static final /* enum */ WriteState OCCUPY = new WriteState();
        public static final /* enum */ WriteState FINISH = new WriteState();
        private static final /* synthetic */ WriteState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static WriteState[] values() {
            return (WriteState[])$VALUES.clone();
        }

        public static WriteState valueOf(String value2) {
            return Enum.valueOf(WriteState.class, value2);
        }

        @NotNull
        public static EnumEntries<WriteState> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = writeStateArray = new WriteState[]{WriteState.EMPTY, WriteState.OCCUPY, WriteState.FINISH};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

