/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.replication;

import java.io.Closeable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import kd.bos.olapServer2.collections.SpinWait;
import kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders.Bits;
import kd.bos.olapServer2.replication.LSNUtil;
import kd.bos.olapServer2.replication.MasterLSNContext;
import kd.bos.olapServer2.replication.OlapLogger;
import kd.bos.olapServer2.replication.RedoWriter;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.LongProgression;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u0000 +2\u00020\u0001:\u0002+,B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0016\u001a\u00020\tH\u0016J$\u0010\u0017\u001a\u00060\u0018j\u0002`\u00192\n\u0010\u001a\u001a\u00060\u0010j\u0002`\u001b2\n\u0010\u001c\u001a\u00060\u0010j\u0002`\u001bH\u0002J\f\u0010\u001d\u001a\u00060\u0005j\u0002`\u0006H\u0002J\b\u0010\u001e\u001a\u00020\tH\u0002J\u0012\u0010\u001f\u001a\u00020\t2\n\u0010 \u001a\u00060\u0010j\u0002`\u0011J\u0012\u0010!\u001a\u00020\t2\n\u0010\"\u001a\u00060\u0005j\u0002`\u0006J0\u0010#\u001a \u0012\b\u0012\u00060\u0010j\u0002`\u001b\u0012\b\u0012\u00060\u0005j\u0002`\u0006\u0012\b\u0012\u00060\u0005j\u0002`\u00060$2\n\u0010%\u001a\u00060\u0005j\u0002`\u0006J\b\u0010&\u001a\u00020\tH\u0002J\u0014\u0010'\u001a\u00020\t2\n\u0010 \u001a\u00060\u0010j\u0002`\u0011H\u0002J\u0014\u0010(\u001a\u00020\t2\n\u0010)\u001a\u00060\u0005j\u0002`\u0006H\u0002J\u0014\u0010*\u001a\u00060\u0005j\u0002`\u0006*\u00060\u0010j\u0002`\u0011H\u0002R\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u0012\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000f\u001a\u00060\u0010j\u0002`\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0013\u001a\u00060\u0010j\u0002`\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0014\u001a\u00060\u0015R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lkd/bos/olapServer2/replication/RedoWriterV2;", "Ljava/io/Closeable;", "masterLSNContext", "Lkd/bos/olapServer2/replication/MasterLSNContext;", "count", "", "Lkd/bos/olapServer2/common/int;", "sync", "Lkotlin/Function1;", "", "(Lkd/bos/olapServer2/replication/MasterLSNContext;ILkotlin/jvm/functions/Function1;)V", "availableBuffer", "", "Ljava/util/concurrent/atomic/AtomicInteger;", "[Ljava/util/concurrent/atomic/AtomicInteger;", "flushNext", "", "Lkd/bos/olapServer2/common/LSN;", "fullLength", "takeNext", "work", "Lkd/bos/olapServer2/replication/RedoWriterV2$Worker;", "close", "compareAndSet", "", "Lkd/bos/olapServer2/common/bool;", "expectedValue", "Lkd/bos/olapServer2/common/long;", "newValue", "findFlushOffset", "forceFlush", "forceSync", "syncPoint", "markMergeBuffer", "index", "markOccupy", "Lkotlin/Triple;", "size", "noticeSync", "repairTakeNext", "syncRedoData", "offset", "toIndex", "Companion", "Worker", "bos-olap-core2"})
public final class RedoWriterV2
implements Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MasterLSNContext masterLSNContext;
    private final int count;
    @NotNull
    private final Function1<Integer, Unit> sync;
    @NotNull
    private final Worker work;
    @NotNull
    private final AtomicInteger[] availableBuffer;
    private volatile long takeNext;
    private volatile long flushNext;
    private final int fullLength;
    @NotNull
    private static final Triple<Long, Integer, Integer> NOT_OCCUPY = new Triple((Object)-1L, (Object)-1, (Object)-1);
    private static final long takeNextOffset = Bits.INSTANCE.getUnsafe().objectFieldOffset(RedoWriterV2.class.getDeclaredField("takeNext"));

    public RedoWriterV2(@NotNull MasterLSNContext masterLSNContext, int count, @NotNull Function1<? super Integer, Unit> sync) {
        Intrinsics.checkNotNullParameter((Object)masterLSNContext, (String)"masterLSNContext");
        Intrinsics.checkNotNullParameter(sync, (String)"sync");
        this.masterLSNContext = masterLSNContext;
        this.count = count;
        this.sync = sync;
        String string2 = RedoWriter.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        this.work = new Worker(string2);
        int n = 0;
        int n2 = this.count;
        AtomicInteger[] atomicIntegerArray = new AtomicInteger[n2];
        RedoWriterV2 redoWriterV2 = this;
        while (n < n2) {
            int n3 = n++;
            atomicIntegerArray[n3] = new AtomicInteger(0);
        }
        redoWriterV2.availableBuffer = atomicIntegerArray;
        this.flushNext = this.takeNext = this.masterLSNContext.getCurrentPage();
        this.fullLength = this.count * 8192;
        this.work.setPriority(10);
        this.work.start();
    }

    private final void noticeSync() {
        if (!this.work.isActive()) {
            LockSupport.unpark(this.work);
        }
    }

    public final void markMergeBuffer(int index2) {
        int count = this.availableBuffer[index2].decrementAndGet();
        if (count <= 0) {
            this.noticeSync();
        }
    }

    @NotNull
    public final Triple<Long, Integer, Integer> markOccupy(int size) {
        Triple triple;
        if (!(size > 0)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        long oldValue = this.takeNext;
        if (oldValue + (long)size - this.flushNext > (long)this.fullLength) {
            return NOT_OCCUPY;
        }
        long pageStartLsn = LSNUtil.INSTANCE.pageLSN(oldValue);
        long nextPageStartLsn = LSNUtil.INSTANCE.nextPageLSN(oldValue);
        long remaining = nextPageStartLsn - oldValue;
        int index2 = this.toIndex(pageStartLsn);
        int nextIndex = this.toIndex(nextPageStartLsn);
        AtomicInteger currentBufferCount = this.availableBuffer[index2];
        if (remaining >= (long)size) {
            Triple triple2;
            int n;
            long newValue = (long)size + oldValue;
            if (oldValue == pageStartLsn) {
                newValue += (long)22;
                n = 22;
            } else {
                n = (int)(oldValue - pageStartLsn);
            }
            int position = n;
            currentBufferCount.incrementAndGet();
            if (this.compareAndSet(oldValue, newValue)) {
                this.masterLSNContext.setCurrentPage(this.takeNext);
                triple2 = new Triple((Object)pageStartLsn, (Object)index2, (Object)position);
            } else {
                currentBufferCount.decrementAndGet();
                triple2 = NOT_OCCUPY;
            }
            return triple2;
        }
        if (nextPageStartLsn - this.flushNext >= (long)this.fullLength) {
            return NOT_OCCUPY;
        }
        int position = 22;
        long newValue = remaining + (long)22 + (long)size + oldValue;
        AtomicInteger nextBufferCount = this.availableBuffer[nextIndex];
        nextBufferCount.incrementAndGet();
        if (this.compareAndSet(oldValue, newValue)) {
            this.masterLSNContext.setCurrentPage(this.takeNext);
            triple = new Triple((Object)nextPageStartLsn, (Object)nextIndex, (Object)position);
        } else {
            nextBufferCount.decrementAndGet();
            triple = NOT_OCCUPY;
        }
        return triple;
    }

    private final boolean compareAndSet(long expectedValue, long newValue) {
        return Bits.INSTANCE.getUnsafe().compareAndSwapLong(this, takeNextOffset, expectedValue, newValue);
    }

    private final void forceFlush() {
        try {
            int offset = this.findFlushOffset();
            this.syncRedoData(offset);
        }
        catch (Throwable t2) {
            OlapLogger.Companion.info("redoBuffer \u5f3a\u5236\u5237\u65b0\u540c\u6b65\u64cd\u4f5c\u53d1\u751f\u5f02\u5e38: {}", t2.getMessage());
        }
    }

    private final void syncRedoData(int offset) {
        int n = 0;
        while (n < offset) {
            int it = n++;
            boolean bl = false;
            int index2 = this.toIndex(this.flushNext);
            this.sync.invoke((Object)index2);
            this.masterLSNContext.setFlushLSN(this.flushNext);
            this.flushNext = LSNUtil.INSTANCE.nextPageLSN(this.flushNext);
        }
    }

    private final int findFlushOffset() {
        int nextIndex = 0;
        LongProgression longProgression = RangesKt.step((LongProgression)((LongProgression)RangesKt.until((long)this.flushNext, (long)LSNUtil.INSTANCE.pageLSN(this.takeNext))), (long)8192L);
        long i = longProgression.getFirst();
        long l = longProgression.getLast();
        long l2 = longProgression.getStep();
        if (l2 > 0L && i <= l || l2 < 0L && l <= i) {
            while (this.availableBuffer[this.toIndex(i)].get() == 0) {
                ++nextIndex;
                if (i == l) break;
                i += l2;
            }
        }
        return nextIndex;
    }

    public final void forceSync(long syncPoint) {
        this.repairTakeNext(syncPoint);
        SpinWait.Companion.spinUntil((Function0<Boolean>)((Function0)new Function0<Boolean>(this, syncPoint){
            final /* synthetic */ RedoWriterV2 this$0;
            final /* synthetic */ long $syncPoint;
            {
                this.this$0 = $receiver;
                this.$syncPoint = $syncPoint;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                boolean bl;
                if (RedoWriterV2.access$getMasterLSNContext$p(this.this$0).getFlushLSN() < this.$syncPoint) {
                    RedoWriterV2.access$noticeSync(this.this$0);
                    bl = false;
                } else {
                    bl = true;
                }
                return bl;
            }
        }));
    }

    private final void repairTakeNext(long syncPoint) {
        long oldValue;
        while (LSNUtil.INSTANCE.pageLSN(oldValue = this.takeNext) <= syncPoint) {
            this.compareAndSet(oldValue, LSNUtil.INSTANCE.nextPageLSN(oldValue));
            this.masterLSNContext.setCurrentPage(this.takeNext);
        }
    }

    @Override
    public void close() {
        SpinWait.Companion.spinUntil((Function0<Boolean>)((Function0)new Function0<Boolean>(this){
            final /* synthetic */ RedoWriterV2 this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                boolean bl;
                long oldValue = RedoWriterV2.access$getTakeNext$p(this.this$0);
                if (oldValue % (long)8192 != 0L) {
                    RedoWriterV2.access$repairTakeNext(this.this$0, oldValue);
                }
                if (RedoWriterV2.access$getTakeNext$p(this.this$0) != RedoWriterV2.access$getFlushNext$p(this.this$0)) {
                    RedoWriterV2.access$noticeSync(this.this$0);
                    bl = false;
                } else {
                    bl = true;
                }
                return bl;
            }
        }));
        this.work.interrupt();
        SpinWait.Companion.spinUntil((Function0<Boolean>)((Function0)new Function0<Boolean>(this){
            final /* synthetic */ RedoWriterV2 this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                boolean bl;
                if (!RedoWriterV2.access$getWork$p(this.this$0).isStop()) {
                    RedoWriterV2.access$noticeSync(this.this$0);
                    bl = false;
                } else {
                    bl = true;
                }
                return bl;
            }
        }));
    }

    private final int toIndex(long $this$toIndex) {
        return (int)(($this$toIndex >> 13) % (long)this.count);
    }

    public static final /* synthetic */ MasterLSNContext access$getMasterLSNContext$p(RedoWriterV2 $this) {
        return $this.masterLSNContext;
    }

    public static final /* synthetic */ void access$noticeSync(RedoWriterV2 $this) {
        $this.noticeSync();
    }

    public static final /* synthetic */ void access$repairTakeNext(RedoWriterV2 $this, long syncPoint) {
        $this.repairTakeNext(syncPoint);
    }

    public static final /* synthetic */ Worker access$getWork$p(RedoWriterV2 $this) {
        return $this.work;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R \u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00060\u0005j\u0002`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lkd/bos/olapServer2/replication/RedoWriterV2$Companion;", "", "()V", "NOT_OCCUPY", "Lkotlin/Triple;", "", "", "takeNextOffset", "Lkd/bos/olapServer2/common/long;", "bos-olap-core2"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\r\u001a\u00020\u000eH\u0016R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\b\"\u0004\b\f\u0010\n\u00a8\u0006\u000f"}, d2={"Lkd/bos/olapServer2/replication/RedoWriterV2$Worker;", "Ljava/lang/Thread;", "name", "", "Lkd/bos/olapServer2/common/string;", "(Lkd/bos/olapServer2/replication/RedoWriterV2;Ljava/lang/String;)V", "isActive", "", "()Z", "setActive", "(Z)V", "isStop", "setStop", "run", "", "bos-olap-core2"})
    private final class Worker
    extends Thread {
        private volatile boolean isStop;
        private volatile boolean isActive;

        public Worker(String name2) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            super(name2);
            this.isActive = true;
        }

        public final boolean isStop() {
            return this.isStop;
        }

        public final void setStop(boolean bl) {
            this.isStop = bl;
        }

        public final boolean isActive() {
            return this.isActive;
        }

        public final void setActive(boolean bl) {
            this.isActive = bl;
        }

        @Override
        public void run() {
            long emptyPollTimes = 0L;
            int yieldTimes = 0;
            long nextTimeout = 1L;
            while (true) {
                if (this.isInterrupted()) {
                    this.isStop = true;
                    return;
                }
                if (RedoWriterV2.this.takeNext != RedoWriterV2.this.flushNext) {
                    RedoWriterV2.this.forceFlush();
                    emptyPollTimes = 0L;
                    yieldTimes = 0;
                    nextTimeout = 1L;
                    continue;
                }
                long l = emptyPollTimes;
                if ((emptyPollTimes = l + 1L) > 100L) {
                    Thread.yield();
                    ++yieldTimes;
                }
                if (yieldTimes <= 10) continue;
                long timeout = TimeUnit.MILLISECONDS.toNanos(nextTimeout);
                this.isActive = false;
                LockSupport.parkNanos(this, timeout);
                if ((nextTimeout *= (long)2) > 60000000000L) {
                    nextTimeout = 60000000000L;
                }
                this.isActive = true;
            }
        }
    }
}

