/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.replication;

import java.io.Closeable;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.olapServer2.backup.sequenceLog.SeqRedoLogNameStrategy;
import kd.bos.olapServer2.backup.sequenceLog.SeqRedoLogger;
import kd.bos.olapServer2.collections.IReferenceIterator;
import kd.bos.olapServer2.monitorReports.HealthReport;
import kd.bos.olapServer2.monitorReports.HealthReportLevel;
import kd.bos.olapServer2.replication.AbstractRedoReader;
import kd.bos.olapServer2.replication.ICubeRecoverRecord;
import kd.bos.olapServer2.replication.IDDLRecord;
import kd.bos.olapServer2.replication.IRedoRecord;
import kd.bos.olapServer2.replication.ITranStatusRecord;
import kd.bos.olapServer2.replication.OlapLogger;
import kd.bos.olapServer2.replication.RedoRecordCombineReader;
import kd.bos.olapServer2.replication.RedoRecordReader;
import kd.bos.olapServer2.replication.RedoRecordWithPage;
import kd.bos.olapServer2.replication.RedoReplayer;
import kd.bos.olapServer2.replication.RedoType;
import kd.bos.olapServer2.replication.RedoUtil;
import kd.bos.olapServer2.replication.ReplayContext;
import kd.bos.olapServer2.replication.ReplayCoordinator;
import kd.bos.olapServer2.replication.SlaveLSNContext;
import kd.bos.olapServer2.security.PrivilegeType;
import kd.bos.olapServer2.storages.OlapWorkspace;
import kd.bos.olapServer2.tools.CubeToolKt;
import kd.bos.olapServer2.transactions.TransactionStatus;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineExceptionHandler;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.CoroutineStart;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ChannelKt;
import kotlinx.coroutines.channels.SendChannel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00bc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 I2\u00020\u0001:\u0002IJBA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b\u0012\n\u0010\t\u001a\u00060\u0007j\u0002`\b\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\b\u00100\u001a\u000201H\u0016J(\u00102\u001a\u0002012\u0006\u00103\u001a\u0002042\n\u00105\u001a\u000606j\u0002`72\n\u00108\u001a\u00060\"j\u0002`9H\u0002J\u0019\u0010:\u001a\u0002012\u0006\u00103\u001a\u00020;H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010<J\u0019\u0010=\u001a\u0002012\u0006\u00103\u001a\u00020>H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010?J\u0019\u0010@\u001a\u0002012\u0006\u00103\u001a\u00020;H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010<J\b\u0010A\u001a\u000201H\u0002J\f\u0010B\u001a\u00060\"j\u0002`9H\u0002J\n\u0010C\u001a\u00060\"j\u0002`9J\u0006\u0010D\u001a\u000201J\u0011\u0010E\u001a\u000201H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010FJ\u0010\u0010G\u001a\u0002012\u0006\u00103\u001a\u00020HH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0011\u001a\u0016\u0012\b\u0012\u00060\u0010j\u0002`\u0013\u0012\b\u0012\u00060\u0014R\u00020\u00000\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0015\u001a\u0004\u0018\u00010\u00168FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010!\u001a\u00020\"8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010#R\u0011\u0010$\u001a\u00020%\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010&R\u000e\u0010'\u001a\u00020\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00060\u0007j\u0002`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020/X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006K"}, d2={"Lkd/bos/olapServer2/replication/ReplayCoordinator;", "Ljava/io/Closeable;", "olap", "Lkd/bos/olapServer2/storages/OlapWorkspace;", "LSNContext", "Lkd/bos/olapServer2/replication/SlaveLSNContext;", "redoPath", "", "Lkd/bos/olapServer2/common/string;", "backupPath", "logger", "Lkd/bos/olapServer2/replication/OlapLogger;", "context", "Lkd/bos/olapServer2/replication/ReplayContext;", "(Lkd/bos/olapServer2/storages/OlapWorkspace;Lkd/bos/olapServer2/replication/SlaveLSNContext;Ljava/lang/String;Ljava/lang/String;Lkd/bos/olapServer2/replication/OlapLogger;Lkd/bos/olapServer2/replication/ReplayContext;)V", "activeTransactionCount", "", "contextMap", "Ljava/util/concurrent/ConcurrentHashMap;", "Lkd/bos/olapServer2/common/int;", "Lkd/bos/olapServer2/replication/ReplayCoordinator$CubeReplayContext;", "errorThrowable", "", "getErrorThrowable", "()Ljava/lang/Throwable;", "setErrorThrowable", "(Ljava/lang/Throwable;)V", "exceptionHandler", "Lkotlinx/coroutines/CoroutineExceptionHandler;", "incrementRedoLogger", "Lkd/bos/olapServer2/backup/sequenceLog/SeqRedoLogger;", "innerReader", "Lkd/bos/olapServer2/replication/AbstractRedoReader;", "isError", "", "()Z", "isFinished", "Ljava/util/concurrent/atomic/AtomicBoolean;", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "isInterupted", "mainReplayJob", "Lkotlinx/coroutines/Job;", "redoLogger", "redoRecordReader", "Lkd/bos/olapServer2/collections/IReferenceIterator;", "Lkd/bos/olapServer2/replication/RedoRecordWithPage;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "close", "", "dealCubeRecoverRecord", "record", "Lkd/bos/olapServer2/replication/ICubeRecoverRecord;", "lsn", "", "Lkd/bos/olapServer2/common/LSN;", "isIncrement", "Lkd/bos/olapServer2/common/bool;", "dealDDLRecord", "Lkd/bos/olapServer2/replication/IDDLRecord;", "(Lkd/bos/olapServer2/replication/IDDLRecord;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "dispatch", "Lkd/bos/olapServer2/replication/IRedoRecord;", "(Lkd/bos/olapServer2/replication/IRedoRecord;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "execOlapDDL", "flushCheckpoint", "getExistUnCompleteRecord", "isActive", "start", "startReplay", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "tryCheckPoint", "Lkd/bos/olapServer2/replication/ITranStatusRecord;", "Companion", "CubeReplayContext", "bos-olap-core2"})
@SourceDebugExtension(value={"SMAP\nReplayCoordinator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReplayCoordinator.kt\nkd/bos/olapServer2/replication/ReplayCoordinator\n+ 2 IteratorUtils.kt\nkd/bos/olapServer2/computingEngine/batchTasks/IteratorUtilsKt\n+ 3 CoroutineExceptionHandler.kt\nkotlinx/coroutines/CoroutineExceptionHandlerKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,266:1\n98#2:267\n110#2:268\n49#3,4:269\n215#4,2:273\n215#4,2:275\n*S KotlinDebug\n*F\n+ 1 ReplayCoordinator.kt\nkd/bos/olapServer2/replication/ReplayCoordinator\n*L\n86#1:267\n86#1:268\n104#1:269,4\n163#1:273,2\n231#1:275,2\n*E\n"})
public final class ReplayCoordinator
implements Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final OlapWorkspace olap;
    @NotNull
    private final SlaveLSNContext LSNContext;
    @NotNull
    private final String redoPath;
    @Nullable
    private final OlapLogger logger;
    @NotNull
    private final ReplayContext context;
    @Nullable
    private Throwable errorThrowable;
    @NotNull
    private final AtomicBoolean isFinished;
    private boolean isInterupted;
    @NotNull
    private final SeqRedoLogger redoLogger;
    @Nullable
    private final SeqRedoLogger incrementRedoLogger;
    @NotNull
    private final AbstractRedoReader innerReader;
    @NotNull
    private final IReferenceIterator<RedoRecordWithPage> redoRecordReader;
    private int activeTransactionCount;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final CoroutineExceptionHandler exceptionHandler;
    @NotNull
    private final Job mainReplayJob;
    @NotNull
    private final ConcurrentHashMap<Integer, CubeReplayContext> contextMap;
    private static final int maxRedoQueueSize = 4096;

    public ReplayCoordinator(@NotNull OlapWorkspace olap, @NotNull SlaveLSNContext LSNContext2, @NotNull String redoPath, @NotNull String backupPath, @Nullable OlapLogger logger2, @NotNull ReplayContext context) {
        IReferenceIterator iReferenceIterator;
        Intrinsics.checkNotNullParameter((Object)olap, (String)"olap");
        Intrinsics.checkNotNullParameter((Object)LSNContext2, (String)"LSNContext");
        Intrinsics.checkNotNullParameter((Object)redoPath, (String)"redoPath");
        Intrinsics.checkNotNullParameter((Object)backupPath, (String)"backupPath");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.olap = olap;
        this.LSNContext = LSNContext2;
        this.redoPath = redoPath;
        this.logger = logger2;
        this.context = context;
        this.isFinished = new AtomicBoolean();
        this.redoLogger = new SeqRedoLogger(this.redoPath, 16, new SeqRedoLogNameStrategy(".redo", ".redoz"), null, false, 8, null);
        this.incrementRedoLogger = !Intrinsics.areEqual((Object)backupPath, (Object)"") ? new SeqRedoLogger(RedoUtil.INSTANCE.getOrCreateIncrementPath(backupPath), 16, new SeqRedoLogNameStrategy(".redo", ".redoz"), null, false, 8, null) : null;
        AbstractRedoReader abstractRedoReader = this.innerReader = this.context.isSlaveRedoReplay() ? (AbstractRedoReader)new RedoRecordReader(this.redoPath, this.LSNContext) : (AbstractRedoReader)new RedoRecordCombineReader(this.redoLogger, this.incrementRedoLogger, this.LSNContext, null, false, 24, null);
        if (this.context.getReplayItems() == null) {
            iReferenceIterator = this.innerReader;
        } else {
            IReferenceIterator $this$filter$iv = this.innerReader;
            boolean $i$f$filter = false;
            iReferenceIterator = new IReferenceIterator<RedoRecordWithPage>($this$filter$iv, this){
                final /* synthetic */ IReferenceIterator $this_filter;
                final /* synthetic */ ReplayCoordinator this$0;
                {
                    this.$this_filter = $receiver;
                    this.this$0 = replayCoordinator;
                }

                public RedoRecordWithPage getCurrent() {
                    return this.$this_filter.getCurrent();
                }

                public boolean next() {
                    while (this.$this_filter.next()) {
                        RedoRecordWithPage it = (RedoRecordWithPage)this.$this_filter.getCurrent();
                        boolean bl = false;
                        IRedoRecord record = it.getRecord();
                        long l = record.getTid();
                        Long l2 = ReplayCoordinator.access$getContext$p(this.this$0).getReplayItems().getLastMetadataTid(record.getCubeId());
                        Intrinsics.checkNotNull((Object)l2);
                        boolean bl2 = l > l2 && !ReplayCoordinator.access$getContext$p(this.this$0).getReplayItems().isDropCube(record.getCubeId());
                        if (!bl2) continue;
                        return true;
                    }
                    return false;
                }
            };
        }
        this.redoRecordReader = iReferenceIterator;
        this.scope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getDefault()));
        this.contextMap = new ConcurrentHashMap();
        boolean $i$f$CoroutineExceptionHandler = false;
        this.exceptionHandler = new CoroutineExceptionHandler((CoroutineContext.Key)CoroutineExceptionHandler.Key, this){
            final /* synthetic */ ReplayCoordinator this$0;
            {
                this.this$0 = replayCoordinator;
                super($super_call_param$1);
            }

            public void handleException(@NotNull CoroutineContext context, @NotNull Throwable exception) {
                Throwable throwable = exception;
                boolean bl = false;
                OlapLogger olapLogger = ReplayCoordinator.access$getLogger$p(this.this$0);
                if (olapLogger != null) {
                    OlapLogger this_$iv = olapLogger;
                    boolean $i$f$error = false;
                    String reportId$iv = this_$iv.getStatus().get().name() + "-ReplicationError-" + CubeToolKt.getCurrentTime();
                    OlapLogger this_$iv$iv = this_$iv;
                    boolean $i$f$error2 = false;
                    if (this_$iv$iv.isErrorEnabled()) {
                        boolean bl2 = false;
                        String message$iv$iv = "\u91cd\u505a\u534f\u7a0b \u5f02\u5e38\u9000\u51fa\u3002";
                        HealthReport report$iv$iv = new HealthReport(reportId$iv, null, this_$iv$iv.getStatus().get().name() + "-ReplicationError: " + message$iv$iv, HealthReportLevel.Error, PrivilegeType.None.getCode());
                        this_$iv$iv.getOlapWorkspace().getHealthReports().commit(report$iv$iv);
                        if (throwable == null) {
                            OlapLogger.access$getLogger$cp().error(message$iv$iv);
                        } else {
                            OlapLogger.access$getLogger$cp().error("{}", (Object)message$iv$iv, (Object)throwable);
                        }
                    }
                }
                CoroutineScopeKt.cancel$default((CoroutineScope)ReplayCoordinator.access$getScope$p(this.this$0), null, (int)1, null);
                ReplayCoordinator.access$getContextMap$p(this.this$0).clear();
                this.this$0.setErrorThrowable(throwable);
            }
        };
        this.mainReplayJob = BuildersKt.launch((CoroutineScope)this.scope, (CoroutineContext)((CoroutineContext)this.exceptionHandler), (CoroutineStart)CoroutineStart.LAZY, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ ReplayCoordinator this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object2) {
                Object object3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object2);
                        this.label = 1;
                        Object object4 = this.this$0.startReplay((Continuation<? super Unit>)((Continuation)this));
                        if (object4 != object3) return Unit.INSTANCE;
                        return object3;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object4 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    public /* synthetic */ ReplayCoordinator(OlapWorkspace olapWorkspace, SlaveLSNContext slaveLSNContext, String string2, String string3, OlapLogger olapLogger, ReplayContext replayContext, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            olapLogger = null;
        }
        this(olapWorkspace, slaveLSNContext, string2, string3, olapLogger, replayContext);
    }

    public final boolean isError() {
        return this.errorThrowable != null;
    }

    @Nullable
    public final Throwable getErrorThrowable() {
        return this.errorThrowable;
    }

    public final void setErrorThrowable(@Nullable Throwable throwable) {
        this.errorThrowable = throwable;
    }

    @NotNull
    public final AtomicBoolean isFinished() {
        return this.isFinished;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    private final Object startReplay(Continuation<? super Unit> var1_1) {
        block24: {
            if (!(var1_1 instanceof startReplay.1)) ** GOTO lbl-1000
            var9_2 = var1_1;
            if ((var9_2.label & -2147483648) != 0) {
                var9_2.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var1_1){
                    Object L$0;
                    Object L$1;
                    long J$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ ReplayCoordinator this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return ReplayCoordinator.access$startReplay(this.this$0, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var10_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    this.isFinished.set(false);
                    ** GOTO lbl38
                }
                case 1: {
                    currentPageLsn = $continuation.J$0;
                    this = (ReplayCoordinator)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
                    while (true) {
                        this.flushCheckpoint();
                        ** GOTO lbl107
                        break;
                    }
                }
                case 2: {
                    currentPageLsn = $continuation.J$0;
                    this = (ReplayCoordinator)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
                    ** GOTO lbl107
                }
                case 3: {
                    currentPageLsn = $continuation.J$0;
                    this = (ReplayCoordinator)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
                    ** GOTO lbl107
                }
                case 4: {
                    this = (ReplayCoordinator)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v3 = $result;
lbl38:
                    // 3 sources

                    while (true) {
                        if (!this.isInterupted || this.getExistUnCompleteRecord()) {
                            currentPageLsn = -1L;
                            break block24;
                        }
                        $this$forEach$iv = this.contextMap;
                        $i$f$forEach = false;
                        var4_7 = $this$forEach$iv.entrySet().iterator();
                        ** GOTO lbl53
                        break;
                    }
                }
                case 5: {
                    $i$f$forEach = false;
                    $i$a$-forEach-ReplayCoordinator$startReplay$2 = false;
                    var4_7 = (Iterator<Map.Entry<K, V>>)$continuation.L$1;
                    this = (ReplayCoordinator)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v4 = $result;
lbl53:
                    // 2 sources

                    do {
                        if (!var4_7.hasNext()) {
                            this.contextMap.clear();
                            return Unit.INSTANCE;
                        }
                        it = element$iv = var4_7.next();
                        $i$a$-forEach-ReplayCoordinator$startReplay$2 = false;
                        SendChannel.DefaultImpls.close$default((SendChannel)((SendChannel)((CubeReplayContext)it.getValue()).getRecordChannel()), null, (int)1, null);
                        $continuation.L$0 = this;
                        $continuation.L$1 = var4_7;
                        $continuation.label = 5;
                    } while ((v4 = ((CubeReplayContext)it.getValue()).getCubeReplayJob().join((Continuation)$continuation)) != var10_4);
                    return var10_4;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }
        while (this.redoRecordReader.next()) {
            this.isFinished.set(false);
            current = this.redoRecordReader.getCurrent();
            page = current.getStartPage();
            if (currentPageLsn == -1L || currentPageLsn < page.getPageLSN()) {
                currentPageLsn = page.getPageLSN();
                v5 = this.context.getDelayTimeStat();
                if (v5 != null) {
                    v5.setEnd(page.getPageLSN());
                }
            }
            record = current.getRecord();
            switch (WhenMappings.$EnumSwitchMapping$0[record.getRedoType().ordinal()]) {
                case 1: {
                    Intrinsics.checkNotNull((Object)record, (String)"null cannot be cast to non-null type kd.bos.olapServer2.replication.IDDLRecord");
                    $continuation.L$0 = this;
                    $continuation.J$0 = currentPageLsn;
                    $continuation.label = 1;
                    if ((v0 = this.dealDDLRecord((IDDLRecord)record, (Continuation<? super Unit>)$continuation)) != var10_4) ** continue;
                    return var10_4;
                }
                case 2: 
                case 3: 
                case 4: {
                    $continuation.L$0 = this;
                    $continuation.J$0 = currentPageLsn;
                    $continuation.label = 2;
                    v1 = this.dispatch(record, (Continuation<? super Unit>)$continuation);
                    if (v1 != var10_4) break;
                    return var10_4;
                }
                case 5: {
                    Intrinsics.checkNotNull((Object)record, (String)"null cannot be cast to non-null type kd.bos.olapServer2.replication.ITranStatusRecord");
                    this.tryCheckPoint((ITranStatusRecord)record);
                    $continuation.L$0 = this;
                    $continuation.J$0 = currentPageLsn;
                    $continuation.label = 3;
                    v2 = this.dispatch(record, (Continuation<? super Unit>)$continuation);
                    if (v2 != var10_4) break;
                    return var10_4;
                }
                case 6: {
                    Intrinsics.checkNotNull((Object)record, (String)"null cannot be cast to non-null type kd.bos.olapServer2.replication.ICubeRecoverRecord");
                    this.dealCubeRecoverRecord((ICubeRecoverRecord)record, page.getPageLSN(), this.context.isIncrement());
                    this.flushCheckpoint();
                    break;
                }
            }
lbl107:
            // 7 sources

        }
        this.isFinished.set(true);
        $continuation.L$0 = this;
        $continuation.label = 4;
        ** while ((v3 = DelayKt.delay((long)10L, (Continuation)$continuation)) != var10_4)
lbl113:
        // 1 sources

        return var10_4;
    }

    private final boolean getExistUnCompleteRecord() {
        boolean bl;
        AbstractRedoReader abstractRedoReader = this.innerReader;
        if (abstractRedoReader instanceof RedoRecordReader) {
            bl = this.innerReader.getExistUnCompleteRecord();
        } else if (abstractRedoReader instanceof RedoRecordCombineReader) {
            bl = this.innerReader.getExistUnCompleteRecord();
        } else {
            throw new RuntimeException("type error");
        }
        return bl;
    }

    private final void tryCheckPoint(ITranStatusRecord record) {
        switch (WhenMappings.$EnumSwitchMapping$1[record.getTranStatus().ordinal()]) {
            case 1: {
                int n = this.activeTransactionCount;
                this.activeTransactionCount = n + 1;
                break;
            }
            case 2: 
            case 3: {
                int n = this.activeTransactionCount;
                this.activeTransactionCount = n + -1;
                this.flushCheckpoint();
            }
        }
    }

    private final void flushCheckpoint() {
        if (this.activeTransactionCount == 0) {
            this.LSNContext.setCheckPoint(this.LSNContext.getNextReadPage());
        }
    }

    private final void dealCubeRecoverRecord(ICubeRecoverRecord record, long lsn, boolean isIncrement) {
        record.recoveryCube(this.olap, this.redoPath, "backupPath", lsn, isIncrement);
    }

    private final Object dealDDLRecord(IDDLRecord record, Continuation<? super Unit> $completion) {
        if (record.isOlapLevel()) {
            Object object2 = this.execOlapDDL(record, $completion);
            if (object2 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object2;
            }
            return Unit.INSTANCE;
        }
        Object object3 = this.dispatch(record, $completion);
        if (object3 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object3;
        }
        return Unit.INSTANCE;
    }

    /*
     * Unable to fully structure code
     */
    private final Object dispatch(IRedoRecord var1_1, Continuation<? super Unit> var2_2) {
        if (!(var2_2 instanceof dispatch.1)) ** GOTO lbl-1000
        var8_3 = var2_2;
        if ((var8_3.label & -2147483648) != 0) {
            var8_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ ReplayCoordinator this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return ReplayCoordinator.access$dispatch(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var9_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                cubeContext = this.contextMap.get(Boxing.boxInt((int)record.getCubeId()));
                if (cubeContext == null) break;
                $continuation.label = 1;
                v0 = cubeContext.getRecordChannel().send((Object)record, (Continuation)$continuation);
                if (v0 == var9_5) {
                    return var9_5;
                }
                ** GOTO lbl22
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        cubeRecordChannel = ChannelKt.Channel$default((int)4096, null, null, (int)6, null);
        $continuation.L$0 = this;
        $continuation.L$1 = record;
        $continuation.L$2 = cubeRecordChannel;
        $continuation.label = 2;
        v1 = cubeRecordChannel.send((Object)record, (Continuation)$continuation);
        if (v1 == var9_5) {
            return var9_5;
        }
        ** GOTO lbl38
        {
            case 2: {
                cubeRecordChannel = (Channel)$continuation.L$2;
                record = (IRedoRecord)$continuation.L$1;
                this = (ReplayCoordinator)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl38:
                // 2 sources

                cubeReplayJob = BuildersKt.launch$default((CoroutineScope)this.scope, (CoroutineContext)((CoroutineContext)this.exceptionHandler), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(record, this, (Channel<IRedoRecord>)cubeRecordChannel, null){
                    int label;
                    final /* synthetic */ IRedoRecord $record;
                    final /* synthetic */ ReplayCoordinator this$0;
                    final /* synthetic */ Channel<IRedoRecord> $cubeRecordChannel;
                    {
                        this.$record = $record;
                        this.this$0 = $receiver;
                        this.$cubeRecordChannel = $cubeRecordChannel;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object2) {
                        Object object3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object2);
                                RedoReplayer replayer = new RedoReplayer(this.$record.getCubeId(), ReplayCoordinator.access$getOlap$p(this.this$0), this.$cubeRecordChannel, ReplayCoordinator.access$getContext$p(this.this$0));
                                this.label = 1;
                                Object object4 = replayer.executeJob((Continuation<? super Unit>)((Continuation)this));
                                if (object4 != object3) return Unit.INSTANCE;
                                return object3;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object4 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)2, null);
                newCubeContext = new CubeReplayContext((Channel<IRedoRecord>)cubeRecordChannel, cubeReplayJob);
                ((Map)this.contextMap).put(Boxing.boxInt((int)record.getCubeId()), newCubeContext);
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object execOlapDDL(IDDLRecord var1_1, Continuation<? super Unit> var2_2) {
        if (!(var2_2 instanceof execOlapDDL.1)) ** GOTO lbl-1000
        var10_3 = var2_2;
        if ((var10_3.label & -2147483648) != 0) {
            var10_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ ReplayCoordinator this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return ReplayCoordinator.access$execOlapDDL(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var11_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$forEach$iv = this.contextMap;
                $i$f$forEach = false;
                var5_8 = $this$forEach$iv.entrySet().iterator();
lbl15:
                // 3 sources

                while (var5_8.hasNext()) {
                    it = element$iv = var5_8.next();
                    $i$a$-forEach-ReplayCoordinator$execOlapDDL$2 = false;
                    SendChannel.DefaultImpls.close$default((SendChannel)((SendChannel)((CubeReplayContext)it.getValue()).getRecordChannel()), null, (int)1, null);
                    $continuation.L$0 = this;
                    $continuation.L$1 = record;
                    $continuation.L$2 = var5_8;
                    $continuation.label = 1;
                    v0 = ((CubeReplayContext)it.getValue()).getCubeReplayJob().join((Continuation)$continuation);
                    if (v0 != var11_5) continue;
                    return var11_5;
                }
                break;
            }
            case 1: {
                $i$f$forEach = false;
                $i$a$-forEach-ReplayCoordinator$execOlapDDL$2 = false;
                var5_8 = (Iterator<Map.Entry<K, V>>)$continuation.L$2;
                record = (IDDLRecord)$continuation.L$1;
                this = (ReplayCoordinator)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
                ** GOTO lbl15
            }
        }
        this.contextMap.clear();
        record.replayDDL(this.olap);
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public final void start() {
        this.mainReplayJob.start();
    }

    public final boolean isActive() {
        return this.mainReplayJob.isActive();
    }

    @Override
    public void close() {
        block2: {
            this.isInterupted = true;
            long startClose = System.nanoTime();
            while (this.mainReplayJob.isActive() || !((Map)this.contextMap).isEmpty()) {
                long waitTime = System.nanoTime() - startClose;
                if (waitTime > 600000000000L) {
                    CoroutineScopeKt.cancel((CoroutineScope)this.scope, (CancellationException)new CancellationException("replay scope is cancelled"));
                }
                Thread.sleep(10L);
            }
            this.redoLogger.close();
            AbstractRedoReader abstractRedoReader = this.innerReader;
            Closeable closeable = abstractRedoReader instanceof Closeable ? (Closeable)abstractRedoReader : null;
            if (closeable == null) break block2;
            closeable.close();
        }
    }

    public static final /* synthetic */ Object access$dealDDLRecord(ReplayCoordinator $this, IDDLRecord record, Continuation $completion) {
        return $this.dealDDLRecord(record, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$dispatch(ReplayCoordinator $this, IRedoRecord record, Continuation $completion) {
        return $this.dispatch(record, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ OlapWorkspace access$getOlap$p(ReplayCoordinator $this) {
        return $this.olap;
    }

    public static final /* synthetic */ ReplayContext access$getContext$p(ReplayCoordinator $this) {
        return $this.context;
    }

    public static final /* synthetic */ Object access$execOlapDDL(ReplayCoordinator $this, IDDLRecord record, Continuation $completion) {
        return $this.execOlapDDL(record, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ OlapLogger access$getLogger$p(ReplayCoordinator $this) {
        return $this.logger;
    }

    public static final /* synthetic */ CoroutineScope access$getScope$p(ReplayCoordinator $this) {
        return $this.scope;
    }

    public static final /* synthetic */ ConcurrentHashMap access$getContextMap$p(ReplayCoordinator $this) {
        return $this.contextMap;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lkd/bos/olapServer2/replication/ReplayCoordinator$Companion;", "", "()V", "maxRedoQueueSize", "", "bos-olap-core2"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0004\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lkd/bos/olapServer2/replication/ReplayCoordinator$CubeReplayContext;", "", "recordChannel", "Lkotlinx/coroutines/channels/Channel;", "Lkd/bos/olapServer2/replication/IRedoRecord;", "cubeReplayJob", "Lkotlinx/coroutines/Job;", "(Lkd/bos/olapServer2/replication/ReplayCoordinator;Lkotlinx/coroutines/channels/Channel;Lkotlinx/coroutines/Job;)V", "getCubeReplayJob", "()Lkotlinx/coroutines/Job;", "getRecordChannel", "()Lkotlinx/coroutines/channels/Channel;", "bos-olap-core2"})
    public final class CubeReplayContext {
        @NotNull
        private final Channel<IRedoRecord> recordChannel;
        @NotNull
        private final Job cubeReplayJob;

        public CubeReplayContext(@NotNull Channel<IRedoRecord> recordChannel, Job cubeReplayJob2) {
            Intrinsics.checkNotNullParameter(recordChannel, (String)"recordChannel");
            Intrinsics.checkNotNullParameter((Object)cubeReplayJob2, (String)"cubeReplayJob");
            this.recordChannel = recordChannel;
            this.cubeReplayJob = cubeReplayJob2;
        }

        @NotNull
        public final Channel<IRedoRecord> getRecordChannel() {
            return this.recordChannel;
        }

        @NotNull
        public final Job getCubeReplayJob() {
            return this.cubeReplayJob;
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[RedoType.values().length];
            try {
                nArray[RedoType.METADATA.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RedoType.INSERT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RedoType.UPDATE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RedoType.Compensation.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RedoType.TranStatus.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RedoType.CubeRecover.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[TransactionStatus.values().length];
            try {
                nArray[TransactionStatus.Active.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TransactionStatus.Committed.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TransactionStatus.Aborted.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

