/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.replication;

import java.io.Closeable;
import java.util.HashSet;
import kd.bos.olapServer2.backup.sequenceLog.SeqRedoLogger;
import kd.bos.olapServer2.dataEntities.InputRow;
import kd.bos.olapServer2.replication.IDDLRecord;
import kd.bos.olapServer2.replication.IDMLRecord;
import kd.bos.olapServer2.replication.IRedoRecord;
import kd.bos.olapServer2.replication.ITranStatusRecord;
import kd.bos.olapServer2.replication.RedoPageInfo;
import kd.bos.olapServer2.replication.RedoRecordCombineReader;
import kd.bos.olapServer2.replication.RedoRecordWithPage;
import kd.bos.olapServer2.replication.RedoType;
import kd.bos.olapServer2.replication.SlaveLSNContext;
import kd.bos.olapServer2.replication.TimeUtil;
import kd.bos.olapServer2.storages.CubeWorkspace;
import kd.bos.olapServer2.storages.IInputRowWriter;
import kd.bos.olapServer2.storages.OlapWorkspace;
import kd.bos.olapServer2.tools.Res;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0085\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\n\u0010\t\u001a\u00060\nj\u0002`\u000b\u0012\n\u0010\f\u001a\u00060\rj\u0002`\u000e\u0012\n\u0010\u000f\u001a\u00060\u0010j\u0002`\u0011\u0012 \b\u0002\u0010\u0012\u001a\u001a\u0012\b\u0012\u00060\u0010j\u0002`\u00110\u0013j\f\u0012\b\u0012\u00060\u0010j\u0002`\u0011`\u0014\u0012\n\u0010\u0015\u001a\u00060\u0010j\u0002`\u0011\u0012\f\b\u0002\u0010\u0016\u001a\u00060\u0010j\u0002`\u0011\u00a2\u0006\u0002\u0010\u0017J\b\u0010#\u001a\u00020$H\u0002J\u0018\u0010%\u001a\u00060\u001bj\u0002`&2\n\u0010'\u001a\u00060\u0010j\u0002`\u0011H\u0002J\b\u0010(\u001a\u00020$H\u0002J\u0006\u0010)\u001a\u00020$J\u0010\u0010*\u001a\u00020$2\u0006\u0010+\u001a\u00020,H\u0002J\u0010\u0010-\u001a\u00020$2\u0006\u0010+\u001a\u00020,H\u0002R\u0012\u0010\u0015\u001a\u00060\u0010j\u0002`\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00060\nj\u0002`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0012\u001a\u001a\u0012\b\u0012\u00060\u0010j\u0002`\u00110\u0013j\f\u0012\b\u0012\u00060\u0010j\u0002`\u0011`\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0016\u001a\u00060\u0010j\u0002`\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u0004\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000f\u001a\u00060\u0010j\u0002`\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010!\u001a\u0004\u0018\u00010\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lkd/bos/olapServer2/replication/ReplayCube;", "", "olapWorkspace", "Lkd/bos/olapServer2/storages/OlapWorkspace;", "LSNContext", "Lkd/bos/olapServer2/replication/SlaveLSNContext;", "redoLogger", "Lkd/bos/olapServer2/backup/sequenceLog/SeqRedoLogger;", "incrementLogger", "expectCubeId", "", "Lkd/bos/olapServer2/common/int;", "expectCubeName", "", "Lkd/bos/olapServer2/common/string;", "time", "", "Lkd/bos/olapServer2/common/long;", "ignoreTidSet", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "createTime", "maxTid", "(Lkd/bos/olapServer2/storages/OlapWorkspace;Lkd/bos/olapServer2/replication/SlaveLSNContext;Lkd/bos/olapServer2/backup/sequenceLog/SeqRedoLogger;Lkd/bos/olapServer2/backup/sequenceLog/SeqRedoLogger;ILjava/lang/String;JLjava/util/HashSet;JJ)V", "cubeWorkspace", "Lkd/bos/olapServer2/storages/CubeWorkspace;", "isClose", "", "isDirty", "recordItr", "Lkd/bos/olapServer2/replication/RedoRecordCombineReader;", "row", "Lkd/bos/olapServer2/dataEntities/InputRow;", "writer", "Lkd/bos/olapServer2/storages/IInputRowWriter;", "checkFlushOrClose", "", "isInvalid", "Lkd/bos/olapServer2/common/bool;", "tid", "refreshRowAndWriter", "replay", "replayRecord", "record", "Lkd/bos/olapServer2/replication/IRedoRecord;", "replaySkipTidRecord", "bos-olap-core2"})
public final class ReplayCube {
    @NotNull
    private final OlapWorkspace olapWorkspace;
    private final int expectCubeId;
    private final long time;
    @NotNull
    private final HashSet<Long> ignoreTidSet;
    private final long createTime;
    private final long maxTid;
    @NotNull
    private final CubeWorkspace cubeWorkspace;
    @Nullable
    private InputRow row;
    @Nullable
    private IInputRowWriter writer;
    @NotNull
    private final RedoRecordCombineReader recordItr;
    private boolean isDirty;
    private boolean isClose;

    public ReplayCube(@NotNull OlapWorkspace olapWorkspace, @NotNull SlaveLSNContext LSNContext2, @NotNull SeqRedoLogger redoLogger, @NotNull SeqRedoLogger incrementLogger, int expectCubeId, @NotNull String expectCubeName, long time2, @NotNull HashSet<Long> ignoreTidSet, long createTime, long maxTid) {
        Intrinsics.checkNotNullParameter((Object)olapWorkspace, (String)"olapWorkspace");
        Intrinsics.checkNotNullParameter((Object)LSNContext2, (String)"LSNContext");
        Intrinsics.checkNotNullParameter((Object)redoLogger, (String)"redoLogger");
        Intrinsics.checkNotNullParameter((Object)incrementLogger, (String)"incrementLogger");
        Intrinsics.checkNotNullParameter((Object)expectCubeName, (String)"expectCubeName");
        Intrinsics.checkNotNullParameter(ignoreTidSet, (String)"ignoreTidSet");
        this.olapWorkspace = olapWorkspace;
        this.expectCubeId = expectCubeId;
        this.time = time2;
        this.ignoreTidSet = ignoreTidSet;
        this.createTime = createTime;
        this.maxTid = maxTid;
        CubeWorkspace cubeWorkspace = this.olapWorkspace.tryGet(expectCubeName);
        if (cubeWorkspace == null) {
            String string2 = Res.INSTANCE.getReplayCubeException_1();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-ReplayCubeException_1>(...)");
            Object[] objectArray = new Object[]{TimeUtil.Companion.toDateString(this.time), expectCubeName};
            throw Res.INSTANCE.getRuntimeException(string2, objectArray);
        }
        this.cubeWorkspace = cubeWorkspace;
        this.recordItr = new RedoRecordCombineReader(redoLogger, incrementLogger, LSNContext2, null, false, 24, null);
    }

    public /* synthetic */ ReplayCube(OlapWorkspace olapWorkspace, SlaveLSNContext slaveLSNContext, SeqRedoLogger seqRedoLogger, SeqRedoLogger seqRedoLogger2, int n, String string2, long l, HashSet hashSet, long l2, long l3, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x80) != 0) {
            hashSet = new HashSet<Long>();
        }
        if ((n2 & 0x200) != 0) {
            l3 = Long.MAX_VALUE;
        }
        this(olapWorkspace, slaveLSNContext, seqRedoLogger, seqRedoLogger2, n, string2, l, hashSet, l2, l3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void replay() {
        Closeable closeable = this.recordItr;
        Throwable throwable = null;
        try {
            RedoRecordCombineReader it = (RedoRecordCombineReader)closeable;
            boolean bl = false;
            try {
                while (this.recordItr.next()) {
                    IRedoRecord record;
                    RedoRecordWithPage recordWithPage = this.recordItr.getCurrent();
                    RedoPageInfo page = recordWithPage.getStartPage();
                    int n = page.getVersion();
                    if (!(0 <= n ? n < 4 : false)) {
                        throw Res.INSTANCE.getNotSupportedException("replay error,not support new page version.", new Object[0]);
                    }
                    if (page.getTimestamp() > this.time) {
                        break;
                    }
                    if (this.createTime != -1L && page.getTimestamp() <= this.createTime || (record = recordWithPage.getRecord()).getCubeId() != this.expectCubeId) continue;
                    if (this.isInvalid(record.getTid())) {
                        this.replaySkipTidRecord(record);
                        continue;
                    }
                    this.replayRecord(record);
                }
            }
            finally {
                this.checkFlushOrClose();
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final boolean isInvalid(long tid) {
        if (tid > this.maxTid) {
            return true;
        }
        return this.ignoreTidSet.contains(tid);
    }

    private final void replayRecord(IRedoRecord record) {
        IRedoRecord iRedoRecord = record;
        if (iRedoRecord instanceof IDDLRecord) {
            this.checkFlushOrClose();
            ((IDDLRecord)record).replayDDL(this.olapWorkspace);
        } else if (iRedoRecord instanceof IDMLRecord) {
            if (this.row == null || this.writer == null) {
                this.refreshRowAndWriter();
            }
            IDMLRecord iDMLRecord = (IDMLRecord)record;
            IInputRowWriter iInputRowWriter = this.writer;
            Intrinsics.checkNotNull((Object)iInputRowWriter);
            InputRow inputRow = this.row;
            Intrinsics.checkNotNull((Object)inputRow);
            IDMLRecord.DefaultImpls.replayDML$default(iDMLRecord, this.cubeWorkspace, iInputRowWriter, inputRow, false, false, 16, null);
            this.isDirty = true;
        } else if (!(iRedoRecord instanceof ITranStatusRecord)) {
            throw Res.INSTANCE.getNotSupportedException("impossible Redo Type " + (Object)((Object)record.getRedoType()) + " for cube:" + record.getCubeId(), new Object[0]);
        }
    }

    private final void checkFlushOrClose() {
        IInputRowWriter w = this.writer;
        if (this.isDirty && w != null) {
            w.force();
            this.isDirty = false;
        }
        if (!this.isClose && w != null) {
            w.close();
            this.writer = null;
            this.isClose = true;
        }
    }

    private final void refreshRowAndWriter() {
        this.row = new InputRow(this.cubeWorkspace.getMetadata());
        this.writer = CubeWorkspace.createWriter$default(this.cubeWorkspace, null, null, null, 7, null);
        this.isDirty = false;
        this.isClose = false;
    }

    private final void replaySkipTidRecord(IRedoRecord record) {
        if (record instanceof ITranStatusRecord) {
            return;
        }
        if (!(record instanceof IDMLRecord)) {
            throw Res.INSTANCE.getRuntimeException("skip tid can't be ddl, tid is " + record.getTid() + ", cubeid is " + record.getCubeId(), new Object[0]);
        }
        if (record.getRedoType() != RedoType.INSERT) {
            return;
        }
        IDMLRecord iDMLRecord = (IDMLRecord)record;
        IInputRowWriter iInputRowWriter = this.writer;
        Intrinsics.checkNotNull((Object)iInputRowWriter);
        InputRow inputRow = this.row;
        Intrinsics.checkNotNull((Object)inputRow);
        IDMLRecord.DefaultImpls.replayDML$default(iDMLRecord, this.cubeWorkspace, iInputRowWriter, inputRow, true, false, 16, null);
    }
}

