/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.replication;

import java.io.Closeable;
import java.util.Collection;
import java.util.HashSet;
import kd.bos.olapServer2.backup.sequenceLog.SeqRedoLogger;
import kd.bos.olapServer2.common.CommandTypes;
import kd.bos.olapServer2.dataSources.MetadataCommandInfo;
import kd.bos.olapServer2.metadata.MetadataTypes;
import kd.bos.olapServer2.replication.CubeRecoverRecord;
import kd.bos.olapServer2.replication.CubeRecoverRecordV0;
import kd.bos.olapServer2.replication.IDDLRecord;
import kd.bos.olapServer2.replication.IRedoRecord;
import kd.bos.olapServer2.replication.ITranStatusRecord;
import kd.bos.olapServer2.replication.RedoPageInfo;
import kd.bos.olapServer2.replication.RedoRecordCombineReader;
import kd.bos.olapServer2.replication.RedoRecordWithPage;
import kd.bos.olapServer2.replication.RedoType;
import kd.bos.olapServer2.replication.ReplayCube;
import kd.bos.olapServer2.replication.SlaveLSNContext;
import kd.bos.olapServer2.storages.OlapWorkspace;
import kd.bos.olapServer2.tools.JsonHelper;
import kd.bos.olapServer2.tools.Res;
import kd.bos.olapServer2.transactions.TransactionStatus;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001Bw\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\n\u0010\t\u001a\u00060\nj\u0002`\u000b\u0012\n\u0010\f\u001a\u00060\rj\u0002`\u000e\u0012\n\u0010\u000f\u001a\u00060\u0010j\u0002`\u0011\u0012\u001e\u0010\u0012\u001a\u001a\u0012\b\u0012\u00060\u0010j\u0002`\u00110\u0013j\f\u0012\b\u0012\u00060\u0010j\u0002`\u0011`\u0014\u0012\f\b\u0002\u0010\u0015\u001a\u00060\u0010j\u0002`\u0011\u00a2\u0006\u0002\u0010\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020 H\u0002J\u0006\u0010\"\u001a\u00020 R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\u0019\u001a\u001a\u0012\b\u0012\u00060\nj\u0002`\u000b0\u0013j\f\u0012\b\u0012\u00060\nj\u0002`\u000b`\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00060\nj\u0002`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u00060\rj\u0002`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0012\u001a\u001a\u0012\b\u0012\u00060\u0010j\u0002`\u00110\u0013j\f\u0012\b\u0012\u00060\u0010j\u0002`\u0011`\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0015\u001a\u00060\u0010j\u0002`\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000f\u001a\u00060\u0010j\u0002`\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u001e\u001a\u001a\u0012\b\u0012\u00060\u0010j\u0002`\u00110\u0013j\f\u0012\b\u0012\u00060\u0010j\u0002`\u0011`\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lkd/bos/olapServer2/replication/ReplayCubeCommitted;", "Ljava/io/Closeable;", "olapWorkspace", "Lkd/bos/olapServer2/storages/OlapWorkspace;", "LSNContext", "Lkd/bos/olapServer2/replication/SlaveLSNContext;", "redoLogger", "Lkd/bos/olapServer2/backup/sequenceLog/SeqRedoLogger;", "incrementLogger", "currentCubeId", "", "Lkd/bos/olapServer2/common/int;", "expectCubeName", "", "Lkd/bos/olapServer2/common/string;", "time", "", "Lkd/bos/olapServer2/common/long;", "ignoreTidSet", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "maxTid", "(Lkd/bos/olapServer2/storages/OlapWorkspace;Lkd/bos/olapServer2/replication/SlaveLSNContext;Lkd/bos/olapServer2/backup/sequenceLog/SeqRedoLogger;Lkd/bos/olapServer2/backup/sequenceLog/SeqRedoLogger;ILjava/lang/String;JLjava/util/HashSet;J)V", "createTime", "cubeId", "cubeIds", "isDropped", "", "recordItr", "Lkd/bos/olapServer2/replication/RedoRecordCombineReader;", "unCommitedTidSet", "close", "", "getUnCommitedTids", "replay", "bos-olap-core2"})
@SourceDebugExtension(value={"SMAP\nReplayCubeCommitted.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReplayCubeCommitted.kt\nkd/bos/olapServer2/replication/ReplayCubeCommitted\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,170:1\n1#2:171\n*E\n"})
public final class ReplayCubeCommitted
implements Closeable {
    @NotNull
    private final OlapWorkspace olapWorkspace;
    @NotNull
    private final SlaveLSNContext LSNContext;
    @NotNull
    private final SeqRedoLogger redoLogger;
    @NotNull
    private final SeqRedoLogger incrementLogger;
    private final int currentCubeId;
    @NotNull
    private final String expectCubeName;
    private final long time;
    @NotNull
    private final HashSet<Long> ignoreTidSet;
    private final long maxTid;
    @NotNull
    private final RedoRecordCombineReader recordItr;
    @NotNull
    private final HashSet<Long> unCommitedTidSet;
    private long createTime;
    private int cubeId;
    private boolean isDropped;
    @NotNull
    private HashSet<Integer> cubeIds;

    /*
     * WARNING - void declaration
     */
    public ReplayCubeCommitted(@NotNull OlapWorkspace olapWorkspace, @NotNull SlaveLSNContext LSNContext2, @NotNull SeqRedoLogger redoLogger, @NotNull SeqRedoLogger incrementLogger, int currentCubeId, @NotNull String expectCubeName, long time2, @NotNull HashSet<Long> ignoreTidSet, long maxTid) {
        void it;
        HashSet hashSet;
        Intrinsics.checkNotNullParameter((Object)olapWorkspace, (String)"olapWorkspace");
        Intrinsics.checkNotNullParameter((Object)LSNContext2, (String)"LSNContext");
        Intrinsics.checkNotNullParameter((Object)redoLogger, (String)"redoLogger");
        Intrinsics.checkNotNullParameter((Object)incrementLogger, (String)"incrementLogger");
        Intrinsics.checkNotNullParameter((Object)expectCubeName, (String)"expectCubeName");
        Intrinsics.checkNotNullParameter(ignoreTidSet, (String)"ignoreTidSet");
        this.olapWorkspace = olapWorkspace;
        this.LSNContext = LSNContext2;
        this.redoLogger = redoLogger;
        this.incrementLogger = incrementLogger;
        this.currentCubeId = currentCubeId;
        this.expectCubeName = expectCubeName;
        this.time = time2;
        this.ignoreTidSet = ignoreTidSet;
        this.maxTid = maxTid;
        this.recordItr = new RedoRecordCombineReader(this.redoLogger, this.incrementLogger, new SlaveLSNContext(this.LSNContext.getNextReadPage(), this.LSNContext.getNextWritePage(), this.LSNContext.getCheckPoint()), null, false, 24, null);
        this.unCommitedTidSet = new HashSet();
        this.createTime = -1L;
        this.cubeId = -1;
        HashSet hashSet2 = hashSet = new HashSet();
        ReplayCubeCommitted replayCubeCommitted = this;
        boolean bl = false;
        it.add(this.currentCubeId);
        replayCubeCommitted.cubeIds = hashSet;
    }

    public /* synthetic */ ReplayCubeCommitted(OlapWorkspace olapWorkspace, SlaveLSNContext slaveLSNContext, SeqRedoLogger seqRedoLogger, SeqRedoLogger seqRedoLogger2, int n, String string2, long l, HashSet hashSet, long l2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x100) != 0) {
            l2 = Long.MAX_VALUE;
        }
        this(olapWorkspace, slaveLSNContext, seqRedoLogger, seqRedoLogger2, n, string2, l, hashSet, l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void getUnCommitedTids() {
        Closeable closeable = this.recordItr;
        Throwable throwable = null;
        try {
            RedoRecordCombineReader it = (RedoRecordCombineReader)closeable;
            boolean bl = false;
            while (this.recordItr.next()) {
                RedoRecordWithPage recordWithPage = this.recordItr.getCurrent();
                RedoPageInfo page = recordWithPage.getStartPage();
                int n = page.getVersion();
                if (!(0 <= n ? n < 4 : false)) {
                    throw Res.INSTANCE.getNotSupportedException("replay error,not support new page version.", new Object[0]);
                }
                if (page.getTimestamp() > this.time) break;
                IRedoRecord record = recordWithPage.getRecord();
                if (record.isOlapLevel()) {
                    if (record.getRedoType() == RedoType.METADATA) {
                        if (!(record instanceof IDDLRecord)) {
                            String string2 = "Failed requirement.";
                            throw new IllegalArgumentException(string2.toString());
                        }
                        String commandStr = ((IDDLRecord)record).getDDLCommand();
                        MetadataCommandInfo command = (MetadataCommandInfo)JsonHelper.INSTANCE.getMapper().readValue(commandStr, MetadataCommandInfo.class);
                        if (!StringsKt.equals((String)command.getName(), (String)this.expectCubeName, (boolean)true) || command.getMetadataType() != MetadataTypes.Cube) continue;
                        if (command.getAction() == CommandTypes.create) {
                            ((IDDLRecord)record).replayDDL(this.olapWorkspace);
                            this.createTime = page.getTimestamp();
                            this.cubeId = page.getVersion() == 0 ? Integer.parseInt((String)command.getProperties().get((Object)"id")) : record.getCubeId();
                            this.cubeIds.add(this.cubeId);
                            continue;
                        }
                        if (command.getAction() != CommandTypes.drop) continue;
                        ((IDDLRecord)record).replayDDL(this.olapWorkspace);
                        this.isDropped = true;
                        continue;
                    }
                    if (record.getRedoType() != RedoType.CubeRecover) continue;
                    if (record instanceof CubeRecoverRecord) {
                        if (!StringsKt.equals((String)this.expectCubeName, (String)((CubeRecoverRecord)record).getCubeName(), (boolean)true)) continue;
                        ((CubeRecoverRecord)record).recoveryCube(this.olapWorkspace, this.redoLogger.getRootPath(), this.incrementLogger.getRootPath(), page.getPageLSN(), false);
                        this.createTime = page.getTimestamp();
                        this.cubeId = record.getCubeId();
                        this.cubeIds.add(this.cubeId);
                        continue;
                    }
                    if (!(record instanceof CubeRecoverRecordV0) || !this.cubeIds.contains(record.getCubeId()) && !this.isDropped) continue;
                    throw Res.INSTANCE.getNotSupportedException("replay error,not support old version recovery record.", new Object[0]);
                }
                if ((page.getVersion() == 0 || page.getVersion() == 1) && !this.cubeIds.contains(record.getCubeId()) || !(record instanceof ITranStatusRecord)) continue;
                if (((ITranStatusRecord)record).getTranStatus() == TransactionStatus.Active) {
                    this.unCommitedTidSet.add(record.getTid());
                    continue;
                }
                if (((ITranStatusRecord)record).getTranStatus() != TransactionStatus.Committed) continue;
                this.unCommitedTidSet.remove(record.getTid());
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public final void replay() {
        this.getUnCommitedTids();
        this.ignoreTidSet.addAll((Collection<Long>)this.unCommitedTidSet);
        int realCubeId = this.cubeId != -1 ? this.cubeId : this.currentCubeId;
        new ReplayCube(this.olapWorkspace, this.LSNContext, this.redoLogger, this.incrementLogger, realCubeId, this.expectCubeName, this.time, this.ignoreTidSet, this.createTime, this.maxTid).replay();
    }

    @Override
    public void close() {
        this.recordItr.close();
    }
}

