/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.replication;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import kd.bos.olapServer2.common.Paths;
import kd.bos.olapServer2.common.PathsKt;
import kd.bos.olapServer2.tools.FileTools;
import kd.bos.olapServer2.tools.Res;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.helpers.DefaultHandler;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u0000 \u001d2\u00020\u0001:\u0005\u001d\u001e\u001f !B#\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013J\f\u0010\u0014\u001a\u00020\u0010*\u00020\u0015H\u0002J$\u0010\u0016\u001a\u00020\u0010*\u00020\u00152\n\u0010\u0017\u001a\u00060\u0018j\u0002`\u00192\n\u0010\u001a\u001a\u00060\u0018j\u0002`\u0019H\u0002J\f\u0010\u001b\u001a\u00020\u0010*\u00020\u0015H\u0002J\f\u0010\u001c\u001a\u00020\u0010*\u00020\u0015H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\""}, d2={"Lkd/bos/olapServer2/replication/ReplicationConf;", "", "_node", "Lkd/bos/olapServer2/replication/ReplicationConf$NodeConfig;", "_master", "Lkd/bos/olapServer2/replication/ReplicationConf$MasterConfig;", "_slave", "Lkd/bos/olapServer2/replication/ReplicationConf$SlaveConfig;", "(Lkd/bos/olapServer2/replication/ReplicationConf$NodeConfig;Lkd/bos/olapServer2/replication/ReplicationConf$MasterConfig;Lkd/bos/olapServer2/replication/ReplicationConf$SlaveConfig;)V", "get_master", "()Lkd/bos/olapServer2/replication/ReplicationConf$MasterConfig;", "get_node", "()Lkd/bos/olapServer2/replication/ReplicationConf$NodeConfig;", "get_slave", "()Lkd/bos/olapServer2/replication/ReplicationConf$SlaveConfig;", "checkValid", "", "save", "file", "Ljava/io/File;", "writeMasterConfig", "Ljavax/xml/transform/sax/TransformerHandler;", "writeNode", "nodeName", "", "Lkd/bos/olapServer2/common/string;", "content", "writeNodeConfig", "writeSlaveConfig", "Companion", "MasterConfig", "NodeConfig", "SAXParserHandler", "SlaveConfig", "bos-olap-core2"})
@SourceDebugExtension(value={"SMAP\nReplicationConf.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReplicationConf.kt\nkd/bos/olapServer2/replication/ReplicationConf\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,276:1\n1855#2,2:277\n*S KotlinDebug\n*F\n+ 1 ReplicationConf.kt\nkd/bos/olapServer2/replication/ReplicationConf\n*L\n122#1:277,2\n*E\n"})
public final class ReplicationConf {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final NodeConfig _node;
    @NotNull
    private final MasterConfig _master;
    @NotNull
    private final SlaveConfig _slave;
    @NotNull
    public static final String BACKUP = "backup";
    @NotNull
    public static final String BACKUP_PATH = "backupPath";
    @NotNull
    public static final String BACKUP_DIR = "backupDir";
    @NotNull
    public static final String REDO_DIR = "redoDir";

    public ReplicationConf(@NotNull NodeConfig _node, @NotNull MasterConfig _master, @NotNull SlaveConfig _slave) {
        Intrinsics.checkNotNullParameter((Object)_node, (String)"_node");
        Intrinsics.checkNotNullParameter((Object)_master, (String)"_master");
        Intrinsics.checkNotNullParameter((Object)_slave, (String)"_slave");
        this._node = _node;
        this._master = _master;
        this._slave = _slave;
    }

    public /* synthetic */ ReplicationConf(NodeConfig nodeConfig, MasterConfig masterConfig, SlaveConfig slaveConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            nodeConfig = new NodeConfig(0, null, 0, false, null, null, 63, null);
        }
        if ((n & 2) != 0) {
            masterConfig = new MasterConfig(false, 0, null, false, 15, null);
        }
        if ((n & 4) != 0) {
            slaveConfig = new SlaveConfig(false, null, 0, 7, null);
        }
        this(nodeConfig, masterConfig, slaveConfig);
    }

    @NotNull
    public final NodeConfig get_node() {
        return this._node;
    }

    @NotNull
    public final MasterConfig get_master() {
        return this._master;
    }

    @NotNull
    public final SlaveConfig get_slave() {
        return this._slave;
    }

    public final void checkValid() {
        if (!Paths.INSTANCE.toFile(this._node.getRedoPath()).exists()) {
            throw Res.INSTANCE.getRuntimeException("redoPath " + this._node.getRedoPath() + " is not exists", new Object[0]);
        }
        if (!Paths.INSTANCE.toFile(this._node.getBackupPath()).exists()) {
            throw Res.INSTANCE.getRuntimeException("backupPath " + this._node.getBackupPath() + " path is not exists", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void save(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        TransformerFactory transformerFactory = SAXTransformerFactory.newInstance();
        Intrinsics.checkNotNull((Object)transformerFactory, (String)"null cannot be cast to non-null type javax.xml.transform.sax.SAXTransformerFactory");
        SAXTransformerFactory transformerFactory2 = (SAXTransformerFactory)transformerFactory;
        TransformerHandler transformerHandler = transformerFactory2.newTransformerHandler();
        Transformer transformer = transformerHandler.getTransformer();
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("indent", "yes");
        Closeable closeable = PathsKt.safeOutputStream(file);
        Throwable throwable = null;
        try {
            FileOutputStream fos = (FileOutputStream)closeable;
            boolean bl = false;
            StreamResult result2 = new StreamResult(fos);
            transformerHandler.setResult(result2);
            transformerHandler.startDocument();
            transformerHandler.startElement("", "", "config", null);
            Intrinsics.checkNotNull((Object)transformerHandler);
            this.writeNodeConfig(transformerHandler);
            this.writeMasterConfig(transformerHandler);
            this.writeSlaveConfig(transformerHandler);
            transformerHandler.endElement("", "", "config");
            transformerHandler.endDocument();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final void writeNodeConfig(TransformerHandler $this$writeNodeConfig) {
        $this$writeNodeConfig.startElement("", "", "node", null);
        String content = String.valueOf(this._node.getServerID());
        this.writeNode($this$writeNodeConfig, "serverId", content);
        content = this._node.getRedoPath();
        this.writeNode($this$writeNodeConfig, "redoPath", content);
        content = String.valueOf(this._node.getRedoKeepSegments());
        this.writeNode($this$writeNodeConfig, "redoKeepSegments", content);
        content = String.valueOf(this._node.getEnableStat());
        this.writeNode($this$writeNodeConfig, "enableStat", content);
        content = this._node.getVip();
        this.writeNode($this$writeNodeConfig, "vip", content);
        $this$writeNodeConfig.endElement("", "", "node");
    }

    private final void writeMasterConfig(TransformerHandler $this$writeMasterConfig) {
        $this$writeMasterConfig.startElement("", "", "master", null);
        String content = null;
        content = String.valueOf(this._master.getBindPort());
        this.writeNode($this$writeMasterConfig, "bindPort", content);
        content = String.valueOf(this._master.getEnableWriteDisk());
        this.writeNode($this$writeMasterConfig, "enableWriteDisk", content);
        Iterable $this$forEach$iv = this._master.getSynSlavesID();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            byte it = ((Number)element$iv).byteValue();
            boolean bl = false;
            content = String.valueOf(it);
            this.writeNode($this$writeMasterConfig, "synSlavesID", content);
        }
        content = String.valueOf(this._master.getMasterReplication());
        this.writeNode($this$writeMasterConfig, "masterReplication", content);
        $this$writeMasterConfig.endElement("", "", "master");
    }

    private final void writeSlaveConfig(TransformerHandler $this$writeSlaveConfig) {
        $this$writeSlaveConfig.startElement("", "", "slave", null);
        String content = String.valueOf(this._slave.getSlaveReplication());
        this.writeNode($this$writeSlaveConfig, "slaveReplication", content);
        content = this._slave.getHost();
        this.writeNode($this$writeSlaveConfig, "host", content);
        content = String.valueOf(this._slave.getPort());
        this.writeNode($this$writeSlaveConfig, "port", content);
        content = this._node.getBackupPath();
        this.writeNode($this$writeSlaveConfig, BACKUP_PATH, content);
        $this$writeSlaveConfig.endElement("", "", "slave");
    }

    private final void writeNode(TransformerHandler $this$writeNode, String nodeName, String content) {
        $this$writeNode.startElement("", "", nodeName, null);
        char[] cArray = content.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
        char[] cArray2 = content.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray2, (String)"this as java.lang.String).toCharArray()");
        $this$writeNode.characters(cArray, 0, cArray2.length);
        $this$writeNode.endElement("", "", nodeName);
    }

    public ReplicationConf() {
        this(null, null, null, 7, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\b\u001a\u00020\t2\n\u0010\n\u001a\u00060\u0004j\u0002`\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002JD\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u000122\u0010\u0010\u001a.\u0012\b\u0012\u00060\u0004j\u0002`\u000b\u0012\b\u0012\u00060\u0004j\u0002`\u000b0\u0011j\u0016\u0012\b\u0012\u00060\u0004j\u0002`\u000b\u0012\b\u0012\u00060\u0004j\u0002`\u000b`\u0012H\u0002J$\u0010\u0013\u001a\u0016\u0012\b\u0012\u00060\u0004j\u0002`\u000b\u0012\b\u0012\u00060\u0004j\u0002`\u000b0\u00142\u0006\u0010\f\u001a\u00020\rH\u0002J&\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00172\n\u0010\u0018\u001a\u00060\u0019j\u0002`\u001a2\n\u0010\n\u001a\u00060\u0004j\u0002`\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lkd/bos/olapServer2/replication/ReplicationConf$Companion;", "", "()V", "BACKUP", "", "BACKUP_DIR", "BACKUP_PATH", "REDO_DIR", "buildDefaultMaster", "", "rootPath", "Lkd/bos/olapServer2/common/string;", "config", "Lkd/bos/olapServer2/replication/ReplicationConf;", "initObjectFieldsMap", "obj", "configMap", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "parseInitNodeConfig", "", "read", "file", "Ljava/io/File;", "isAutoMaster", "", "Lkd/bos/olapServer2/common/bool;", "bos-olap-core2"})
    @SourceDebugExtension(value={"SMAP\nReplicationConf.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReplicationConf.kt\nkd/bos/olapServer2/replication/ReplicationConf$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,276:1\n1#2:277\n13309#3,2:278\n*S KotlinDebug\n*F\n+ 1 ReplicationConf.kt\nkd/bos/olapServer2/replication/ReplicationConf$Companion\n*L\n232#1:278,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ReplicationConf read(@NotNull File file, boolean isAutoMaster, @NotNull String rootPath) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)rootPath, (String)"rootPath");
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            sAXParserFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            ReplicationConf config = new ReplicationConf(null, null, null, 7, null);
            sAXParser.parse(file, (DefaultHandler)new SAXParserHandler(config));
            if (isAutoMaster) {
                String preMsg = "The service enabled auto masterNode";
                if (!config.get_slave().getSlaveReplication() && !config.get_master().getMasterReplication()) {
                    this.buildDefaultMaster(rootPath, config);
                    System.out.println((Object)(preMsg + ",config master node success"));
                } else {
                    System.out.println((Object)(preMsg + ",keep original config"));
                }
            } else {
                System.out.println((Object)"The service disabled auto masterNode,keep original config");
            }
            return config;
        }

        /*
         * WARNING - void declaration
         */
        private final void buildDefaultMaster(String rootPath, ReplicationConf config) {
            String bindPortValue;
            CharSequence charSequence;
            Object object2;
            CharSequence it;
            NodeConfig nodeConfig;
            CharSequence charSequence2;
            Map<String, String> nodeConfigMap = this.parseInitNodeConfig(config);
            String vipValue = nodeConfigMap.get("vip");
            config.get_node().setVip((charSequence2 = (CharSequence)vipValue) == null || charSequence2.length() == 0 ? "127.0.0.1" : vipValue);
            Object redoDirValue = nodeConfigMap.get("redoPath");
            NodeConfig nodeConfig2 = config.get_node();
            Object object3 = redoDirValue;
            if (object3 == null || object3.length() == 0) {
                object3 = new String[]{ReplicationConf.REDO_DIR};
                Object object4 = object3 = ((Object)Paths.INSTANCE.get(rootPath, (String)object3)).toString();
                nodeConfig = nodeConfig2;
                boolean bl = false;
                FileTools.INSTANCE.autoMakeDir((String)it);
                nodeConfig2 = nodeConfig;
                object2 = object3;
            } else {
                object2 = redoDirValue;
            }
            nodeConfig2.setRedoPath((String)object2);
            String backupDirValue = nodeConfigMap.get(ReplicationConf.BACKUP_PATH);
            NodeConfig nodeConfig3 = config.get_node();
            it = backupDirValue;
            if (it == null || StringsKt.isBlank((CharSequence)it)) {
                void backupFolder;
                File bl;
                File file = bl = Paths.INSTANCE.toFile(rootPath, ReplicationConf.BACKUP);
                nodeConfig = nodeConfig3;
                boolean bl2 = false;
                if (!backupFolder.exists()) {
                    backupFolder.mkdirs();
                }
                nodeConfig3 = nodeConfig;
                it = bl.getAbsolutePath();
                Intrinsics.checkNotNull((Object)it);
                charSequence = it;
            } else {
                charSequence = backupDirValue;
            }
            nodeConfig3.setBackupPath((String)charSequence);
            String string2 = bindPortValue = nodeConfigMap.get("bindPort");
            Integer bindPort = string2 != null ? StringsKt.toIntOrNull((String)string2) : null;
            config.get_master().setBindPort(bindPort == null || bindPort < 0 ? 0 : bindPort);
            config.get_master().setMasterReplication(true);
            config.get_slave().setSlaveReplication(false);
        }

        private final Map<String, String> parseInitNodeConfig(ReplicationConf config) {
            HashMap<String, String> configMap = new HashMap<String, String>();
            this.initObjectFieldsMap(config.get_node(), configMap);
            this.initObjectFieldsMap(config.get_master(), configMap);
            return configMap;
        }

        private final void initObjectFieldsMap(Object obj, HashMap<String, String> configMap) {
            Field[] fields2 = obj.getClass().getDeclaredFields();
            Intrinsics.checkNotNull((Object)fields2);
            Field[] $this$forEach$iv = fields2;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                Field element$iv;
                Field field = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                String key2 = field.getName();
                char c = key2.charAt(0);
                if (!('a' <= c ? c < '{' : false)) {
                    boolean bl2 = 'A' <= c ? c < '[' : false;
                    if (!bl2) continue;
                }
                Intrinsics.checkNotNull((Object)key2);
                String methodName = StringsKt.replaceFirst$default((String)key2, (char)c, (char)Character.toUpperCase(c), (boolean)false, (int)4, null);
                Method method = obj.getClass().getDeclaredMethod("get" + methodName, new Class[0]);
                Object value2 = method.invoke(obj, new Object[0]);
                if (value2 == null) continue;
                ((Map)configMap).put(key2, value2.toString());
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\u0018\u00002\u00020\u0001BQ\u0012\f\b\u0002\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\f\b\u0002\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u0012 \b\u0002\u0010\b\u001a\u001a\u0012\b\u0012\u00060\nj\u0002`\u000b0\tj\f\u0012\b\u0012\u00060\nj\u0002`\u000b`\f\u0012\f\b\u0002\u0010\r\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\u000eR\u001e\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001e\u0010\r\u001a\u00060\u0003j\u0002`\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001e\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0014\"\u0004\b\u0018\u0010\u0016R2\u0010\b\u001a\u001a\u0012\b\u0012\u00060\nj\u0002`\u000b0\tj\f\u0012\b\u0012\u00060\nj\u0002`\u000b`\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001d"}, d2={"Lkd/bos/olapServer2/replication/ReplicationConf$MasterConfig;", "", "masterReplication", "", "Lkd/bos/olapServer2/common/bool;", "bindPort", "", "Lkd/bos/olapServer2/common/int;", "synSlavesID", "Ljava/util/ArrayList;", "", "Lkd/bos/olapServer2/common/byte;", "Lkotlin/collections/ArrayList;", "enableWriteDisk", "(ZILjava/util/ArrayList;Z)V", "getBindPort", "()I", "setBindPort", "(I)V", "getEnableWriteDisk", "()Z", "setEnableWriteDisk", "(Z)V", "getMasterReplication", "setMasterReplication", "getSynSlavesID", "()Ljava/util/ArrayList;", "setSynSlavesID", "(Ljava/util/ArrayList;)V", "bos-olap-core2"})
    public static final class MasterConfig {
        private boolean masterReplication;
        private int bindPort;
        @NotNull
        private ArrayList<Byte> synSlavesID;
        private boolean enableWriteDisk;

        public MasterConfig(boolean masterReplication, int bindPort, @NotNull ArrayList<Byte> synSlavesID, boolean enableWriteDisk) {
            Intrinsics.checkNotNullParameter(synSlavesID, (String)"synSlavesID");
            this.masterReplication = masterReplication;
            this.bindPort = bindPort;
            this.synSlavesID = synSlavesID;
            this.enableWriteDisk = enableWriteDisk;
        }

        public /* synthetic */ MasterConfig(boolean bl, int n, ArrayList arrayList, boolean bl2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                bl = true;
            }
            if ((n2 & 2) != 0) {
                n = 16060;
            }
            if ((n2 & 4) != 0) {
                arrayList = new ArrayList<Byte>();
            }
            if ((n2 & 8) != 0) {
                bl2 = true;
            }
            this(bl, n, arrayList, bl2);
        }

        public final boolean getMasterReplication() {
            return this.masterReplication;
        }

        public final void setMasterReplication(boolean bl) {
            this.masterReplication = bl;
        }

        public final int getBindPort() {
            return this.bindPort;
        }

        public final void setBindPort(int n) {
            this.bindPort = n;
        }

        @NotNull
        public final ArrayList<Byte> getSynSlavesID() {
            return this.synSlavesID;
        }

        public final void setSynSlavesID(@NotNull ArrayList<Byte> arrayList) {
            Intrinsics.checkNotNullParameter(arrayList, (String)"<set-?>");
            this.synSlavesID = arrayList;
        }

        public final boolean getEnableWriteDisk() {
            return this.enableWriteDisk;
        }

        public final void setEnableWriteDisk(boolean bl) {
            this.enableWriteDisk = bl;
        }

        public MasterConfig() {
            this(false, 0, null, false, 15, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0016\u0018\u00002\u00020\u0001BY\u0012\f\b\u0002\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\f\b\u0002\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u0012\f\b\u0002\u0010\b\u001a\u00060\u0003j\u0002`\u0004\u0012\f\b\u0002\u0010\t\u001a\u00060\nj\u0002`\u000b\u0012\f\b\u0002\u0010\f\u001a\u00060\u0006j\u0002`\u0007\u0012\f\b\u0002\u0010\r\u001a\u00060\u0006j\u0002`\u0007\u00a2\u0006\u0002\u0010\u000eR\u001e\u0010\r\u001a\u00060\u0006j\u0002`\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001e\u0010\t\u001a\u00060\nj\u0002`\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001e\u0010\b\u001a\u00060\u0003j\u0002`\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001e\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0010\"\u0004\b\u001c\u0010\u0012R\u001e\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0018\"\u0004\b\u001e\u0010\u001aR\u001e\u0010\f\u001a\u00060\u0006j\u0002`\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0010\"\u0004\b \u0010\u0012\u00a8\u0006!"}, d2={"Lkd/bos/olapServer2/replication/ReplicationConf$NodeConfig;", "", "serverID", "", "Lkd/bos/olapServer2/common/int;", "redoPath", "", "Lkd/bos/olapServer2/common/string;", "redoKeepSegments", "enableStat", "", "Lkd/bos/olapServer2/common/bool;", "vip", "backupPath", "(ILjava/lang/String;IZLjava/lang/String;Ljava/lang/String;)V", "getBackupPath", "()Ljava/lang/String;", "setBackupPath", "(Ljava/lang/String;)V", "getEnableStat", "()Z", "setEnableStat", "(Z)V", "getRedoKeepSegments", "()I", "setRedoKeepSegments", "(I)V", "getRedoPath", "setRedoPath", "getServerID", "setServerID", "getVip", "setVip", "bos-olap-core2"})
    public static final class NodeConfig {
        private int serverID;
        @NotNull
        private String redoPath;
        private int redoKeepSegments;
        private boolean enableStat;
        @NotNull
        private String vip;
        @NotNull
        private String backupPath;

        public NodeConfig(int serverID, @NotNull String redoPath, int redoKeepSegments, boolean enableStat, @NotNull String vip, @NotNull String backupPath) {
            Intrinsics.checkNotNullParameter((Object)redoPath, (String)"redoPath");
            Intrinsics.checkNotNullParameter((Object)vip, (String)"vip");
            Intrinsics.checkNotNullParameter((Object)backupPath, (String)ReplicationConf.BACKUP_PATH);
            this.serverID = serverID;
            this.redoPath = redoPath;
            this.redoKeepSegments = redoKeepSegments;
            this.enableStat = enableStat;
            this.vip = vip;
            this.backupPath = backupPath;
        }

        public /* synthetic */ NodeConfig(int n, String string2, int n2, boolean bl, String string3, String string4, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 1) != 0) {
                n = 1;
            }
            if ((n3 & 2) != 0) {
                String string5 = System.getProperty("user.dir");
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getProperty(...)");
                string2 = string5;
            }
            if ((n3 & 4) != 0) {
                n2 = 1024;
            }
            if ((n3 & 8) != 0) {
                bl = true;
            }
            if ((n3 & 0x10) != 0) {
                string3 = "127.0.0.1";
            }
            if ((n3 & 0x20) != 0) {
                string4 = "";
            }
            this(n, string2, n2, bl, string3, string4);
        }

        public final int getServerID() {
            return this.serverID;
        }

        public final void setServerID(int n) {
            this.serverID = n;
        }

        @NotNull
        public final String getRedoPath() {
            return this.redoPath;
        }

        public final void setRedoPath(@NotNull String string2) {
            Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
            this.redoPath = string2;
        }

        public final int getRedoKeepSegments() {
            return this.redoKeepSegments;
        }

        public final void setRedoKeepSegments(int n) {
            this.redoKeepSegments = n;
        }

        public final boolean getEnableStat() {
            return this.enableStat;
        }

        public final void setEnableStat(boolean bl) {
            this.enableStat = bl;
        }

        @NotNull
        public final String getVip() {
            return this.vip;
        }

        public final void setVip(@NotNull String string2) {
            Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
            this.vip = string2;
        }

        @NotNull
        public final String getBackupPath() {
            return this.backupPath;
        }

        public final void setBackupPath(@NotNull String string2) {
            Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
            this.backupPath = string2;
        }

        public NodeConfig() {
            this(0, null, 0, false, null, null, 63, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J&\u0010\u0012\u001a\u00020\f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00062\b\u0010\u0014\u001a\u0004\u0018\u00010\u00062\b\u0010\u0015\u001a\u0004\u0018\u00010\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lkd/bos/olapServer2/replication/ReplicationConf$SAXParserHandler;", "Lorg/xml/sax/helpers/DefaultHandler;", "config", "Lkd/bos/olapServer2/replication/ReplicationConf;", "(Lkd/bos/olapServer2/replication/ReplicationConf;)V", "trim", "", "getTrim", "()Ljava/lang/String;", "setTrim", "(Ljava/lang/String;)V", "characters", "", "ch", "", "start", "", "length", "endElement", "uri", "localName", "qName", "bos-olap-core2"})
    public static final class SAXParserHandler
    extends DefaultHandler {
        @NotNull
        private final ReplicationConf config;
        @NotNull
        private String trim;

        public SAXParserHandler(@NotNull ReplicationConf config) {
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            this.config = config;
            this.trim = "";
        }

        @NotNull
        public final String getTrim() {
            return this.trim;
        }

        public final void setTrim(@NotNull String string2) {
            Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
            this.trim = string2;
        }

        @Override
        public void characters(@Nullable char[] ch, int start, int length) {
            super.characters(ch, start, length);
            Intrinsics.checkNotNull((Object)ch);
            String content = new String(ch, start, length);
            this.trim = ((Object)StringsKt.trim((CharSequence)content)).toString();
        }

        @Override
        public void endElement(@Nullable String uri, @Nullable String localName, @Nullable String qName) {
            block43: {
                super.endElement(uri, localName, qName);
                String string2 = qName;
                if (string2 == null) break block43;
                int n = -1;
                switch (string2.hashCode()) {
                    case -771620029: {
                        if (string2.equals("redoPath")) {
                            n = 1;
                        }
                        break;
                    }
                    case 831230986: {
                        if (string2.equals("masterReplication")) {
                            n = 2;
                        }
                        break;
                    }
                    case 939379294: {
                        if (string2.equals("bindPort")) {
                            n = 3;
                        }
                        break;
                    }
                    case -273559179: {
                        if (string2.equals("slaveReplication")) {
                            n = 4;
                        }
                        break;
                    }
                    case 663834585: {
                        if (string2.equals("enableWriteDisk")) {
                            n = 5;
                        }
                        break;
                    }
                    case 1379103678: {
                        if (string2.equals("serverId")) {
                            n = 6;
                        }
                        break;
                    }
                    case -1171157377: {
                        if (string2.equals("synSlavesID")) {
                            n = 7;
                        }
                        break;
                    }
                    case 1893213815: {
                        if (string2.equals("enableStat")) {
                            n = 8;
                        }
                        break;
                    }
                    case 217195363: {
                        if (string2.equals("redoKeepSegments")) {
                            n = 9;
                        }
                        break;
                    }
                    case 3446913: {
                        if (string2.equals("port")) {
                            n = 10;
                        }
                        break;
                    }
                    case -934175481: {
                        if (string2.equals(ReplicationConf.BACKUP_PATH)) {
                            n = 11;
                        }
                        break;
                    }
                    case 3208616: {
                        if (string2.equals("host")) {
                            n = 12;
                        }
                        break;
                    }
                    case 116765: {
                        if (string2.equals("vip")) {
                            n = 13;
                        }
                        break;
                    }
                }
                switch (n) {
                    case 6: {
                        Integer n2 = StringsKt.toIntOrNull((String)this.trim);
                        this.config.get_node().setServerID(n2 != null ? n2 : 0);
                        break;
                    }
                    case 1: {
                        this.config.get_node().setRedoPath(this.trim);
                        break;
                    }
                    case 9: {
                        Integer n3 = StringsKt.toIntOrNull((String)this.trim);
                        this.config.get_node().setRedoKeepSegments(n3 != null ? n3 : 1024);
                        break;
                    }
                    case 8: {
                        this.config.get_node().setEnableStat(Boolean.parseBoolean(this.trim));
                        break;
                    }
                    case 13: {
                        this.config.get_node().setVip(this.trim);
                        break;
                    }
                    case 3: {
                        Integer n4 = StringsKt.toIntOrNull((String)this.trim);
                        this.config.get_master().setBindPort(n4 != null ? n4 : 0);
                        break;
                    }
                    case 5: {
                        this.config.get_master().setEnableWriteDisk(Boolean.parseBoolean(this.trim));
                        break;
                    }
                    case 7: {
                        Byte by = StringsKt.toByteOrNull((String)this.trim);
                        this.config.get_master().getSynSlavesID().add(by != null ? by : (byte)0);
                        break;
                    }
                    case 2: {
                        this.config.get_master().setMasterReplication(Boolean.parseBoolean(this.trim));
                        break;
                    }
                    case 4: {
                        this.config.get_slave().setSlaveReplication(Boolean.parseBoolean(this.trim));
                        break;
                    }
                    case 12: {
                        this.config.get_slave().setHost(this.trim);
                        break;
                    }
                    case 10: {
                        Integer n5 = StringsKt.toIntOrNull((String)this.trim);
                        this.config.get_slave().setPort(n5 != null ? n5 : 0);
                        break;
                    }
                    case 11: {
                        this.config.get_node().setBackupPath(this.trim);
                    }
                }
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u00002\u00020\u0001B/\u0012\f\b\u0002\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\f\b\u0002\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u0012\f\b\u0002\u0010\b\u001a\u00060\tj\u0002`\n\u00a2\u0006\u0002\u0010\u000bR\u001e\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001e\u0010\b\u001a\u00060\tj\u0002`\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001e\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lkd/bos/olapServer2/replication/ReplicationConf$SlaveConfig;", "", "slaveReplication", "", "Lkd/bos/olapServer2/common/bool;", "host", "", "Lkd/bos/olapServer2/common/string;", "port", "", "Lkd/bos/olapServer2/common/int;", "(ZLjava/lang/String;I)V", "getHost", "()Ljava/lang/String;", "setHost", "(Ljava/lang/String;)V", "getPort", "()I", "setPort", "(I)V", "getSlaveReplication", "()Z", "setSlaveReplication", "(Z)V", "bos-olap-core2"})
    public static final class SlaveConfig {
        private boolean slaveReplication;
        @NotNull
        private String host;
        private int port;

        public SlaveConfig(boolean slaveReplication, @NotNull String host, int port) {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            this.slaveReplication = slaveReplication;
            this.host = host;
            this.port = port;
        }

        public /* synthetic */ SlaveConfig(boolean bl, String string2, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                bl = false;
            }
            if ((n2 & 2) != 0) {
                string2 = "127.0.0.1";
            }
            if ((n2 & 4) != 0) {
                n = 16060;
            }
            this(bl, string2, n);
        }

        public final boolean getSlaveReplication() {
            return this.slaveReplication;
        }

        public final void setSlaveReplication(boolean bl) {
            this.slaveReplication = bl;
        }

        @NotNull
        public final String getHost() {
            return this.host;
        }

        public final void setHost(@NotNull String string2) {
            Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
            this.host = string2;
        }

        public final int getPort() {
            return this.port;
        }

        public final void setPort(int n) {
            this.port = n;
        }

        public SlaveConfig() {
            this(false, null, 0, 7, null);
        }
    }
}

