/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.replication;

import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.concurrent.atomic.AtomicReference;
import kd.bos.olapServer2.common.Paths;
import kd.bos.olapServer2.replication.RecoveryFiles;
import kd.bos.olapServer2.replication.ReplicationContext;
import kd.bos.olapServer2.server.ReplicationWorkspace;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001b\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0005\n\u0002\b\u0003\u0018\u0000 82\u00020\u0001:\u000289B?\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u0012\u0012\b\u0002\u0010\b\u001a\f\u0012\b\u0012\u00060\u0006j\u0002`\u00070\t\u0012\f\b\u0002\u0010\n\u001a\u00060\u000bj\u0002`\f\u00a2\u0006\u0002\u0010\rJ\u0006\u0010.\u001a\u00020\u000fJ\u0012\u0010/\u001a\u00020\u000f2\n\u00100\u001a\u00060\u0006j\u0002`\u0007J\u0015\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b4J\u000e\u00105\u001a\u0002022\u0006\u00106\u001a\u000207J\u000e\u00105\u001a\u0002022\u0006\u00106\u001a\u00020\u000fR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0018\u00010\u0011R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0015\u001a\u00020\u00168BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u0017\u0010\u0018R\u0015\u0010\u001b\u001a\u00060\u0006j\u0002`\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0018\u0010!\u001a\u00060\u0011R\u00020\u00008BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0018\u0010\b\u001a\f\u0012\b\u0012\u00060\u0006j\u0002`\u00070\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\n\u001a\u00060\u000bj\u0002`\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010$R\u000e\u0010%\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0015\u0010&\u001a\u00060\u0006j\u0002`\u00078F\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u001dR\u0015\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u001dR\u0015\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0014\u0010+\u001a\u00020\u00148@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010-\u00a8\u0006:"}, d2={"Lkd/bos/olapServer2/replication/ReplicationContext;", "", "webPort", "", "Lkd/bos/olapServer2/common/int;", "rootPath", "", "Lkd/bos/olapServer2/common/string;", "getProxyTokenFun", "Lkotlin/Function0;", "isAutoMasterNode", "", "Lkd/bos/olapServer2/common/bool;", "(ILjava/lang/String;Lkotlin/jvm/functions/Function0;Z)V", "_configMd5", "", "_fixConfigMd5", "Lkd/bos/olapServer2/replication/ReplicationContext$FixedConfigMd5;", "_workspace", "Ljava/util/concurrent/atomic/AtomicReference;", "Lkd/bos/olapServer2/server/ReplicationWorkspace;", "bytes", "Ljava/nio/ByteBuffer;", "getBytes", "()Ljava/nio/ByteBuffer;", "bytes$delegate", "Lkotlin/Lazy;", "confPath", "getConfPath", "()Ljava/lang/String;", "configMd5", "getConfigMd5", "()[B", "fixConfigMd5", "getFixConfigMd5", "()Lkd/bos/olapServer2/replication/ReplicationContext$FixedConfigMd5;", "()Z", "isFixed", "proxyToken", "getProxyToken", "getRootPath", "getWebPort", "()I", "workspace", "getWorkspace$bos_olap_core2", "()Lkd/bos/olapServer2/server/ReplicationWorkspace;", "md5fixed", "refreshMd5", "redoPath", "setWorkspace", "", "value", "setWorkspace$bos_olap_core2", "update", "input", "", "Companion", "FixedConfigMd5", "bos-olap-core2"})
@SourceDebugExtension(value={"SMAP\nReplicationContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReplicationContext.kt\nkd/bos/olapServer2/replication/ReplicationContext\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,118:1\n1#2:119\n*E\n"})
public final class ReplicationContext {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int webPort;
    @NotNull
    private final String rootPath;
    @NotNull
    private final Function0<String> getProxyTokenFun;
    private final boolean isAutoMasterNode;
    @NotNull
    private final AtomicReference<ReplicationWorkspace> _workspace;
    @NotNull
    private final Lazy bytes$delegate;
    private boolean isFixed;
    @Nullable
    private FixedConfigMd5 _fixConfigMd5;
    @Nullable
    private byte[] _configMd5;
    @NotNull
    private static final ReplicationContext emptyContext = new ReplicationContext(0, "", (Function0<String>)((Function0)Companion.emptyContext.1.INSTANCE), false);

    public ReplicationContext(int webPort, @NotNull String rootPath, @NotNull Function0<String> getProxyTokenFun, boolean isAutoMasterNode) {
        Intrinsics.checkNotNullParameter((Object)rootPath, (String)"rootPath");
        Intrinsics.checkNotNullParameter(getProxyTokenFun, (String)"getProxyTokenFun");
        this.webPort = webPort;
        this.rootPath = rootPath;
        this.getProxyTokenFun = getProxyTokenFun;
        this.isAutoMasterNode = isAutoMasterNode;
        this._workspace = new AtomicReference();
        this.bytes$delegate = LazyKt.lazy((Function0)bytes.2.INSTANCE);
    }

    public /* synthetic */ ReplicationContext(int n, String string2, Function0 function0, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            function0 = 1.INSTANCE;
        }
        if ((n2 & 8) != 0) {
            bl = false;
        }
        this(n, string2, (Function0<String>)function0, bl);
    }

    public final int getWebPort() {
        return this.webPort;
    }

    @NotNull
    public final String getRootPath() {
        return this.rootPath;
    }

    public final boolean isAutoMasterNode() {
        return this.isAutoMasterNode;
    }

    @NotNull
    public final String getProxyToken() {
        return (String)this.getProxyTokenFun.invoke();
    }

    @NotNull
    public final String getConfPath() {
        String[] stringArray = new String[]{"conf"};
        return ((Object)Paths.INSTANCE.get(this.rootPath, stringArray)).toString();
    }

    public final void setWorkspace$bos_olap_core2(@NotNull ReplicationWorkspace value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this._workspace.set(value2);
    }

    @NotNull
    public final ReplicationWorkspace getWorkspace$bos_olap_core2() {
        ReplicationWorkspace replicationWorkspace = this._workspace.get();
        Intrinsics.checkNotNullExpressionValue((Object)replicationWorkspace, (String)"get(...)");
        return replicationWorkspace;
    }

    private final ByteBuffer getBytes() {
        Lazy lazy = this.bytes$delegate;
        Object object2 = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getValue(...)");
        return (ByteBuffer)object2;
    }

    /*
     * WARNING - void declaration
     */
    private final FixedConfigMd5 getFixConfigMd5() {
        FixedConfigMd5 fixedConfigMd5;
        FixedConfigMd5 fixMd5 = this._fixConfigMd5;
        if (fixMd5 == null) {
            void var2_2;
            FixedConfigMd5 result2;
            byte[] byArray = this.getBytes().array();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"array(...)");
            this._fixConfigMd5 = result2 = new FixedConfigMd5(byArray);
            this.isFixed = true;
            fixedConfigMd5 = var2_2;
        } else {
            fixedConfigMd5 = fixMd5;
        }
        return fixedConfigMd5;
    }

    public final void update(@NotNull byte[] input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        if (!(!this.isFixed)) {
            boolean bl = false;
            String string2 = "error,replicationContext md5 is fixed.";
            throw new IllegalArgumentException(string2.toString());
        }
        this.getBytes().put(input);
    }

    public final void update(byte input) {
        if (!(!this.isFixed)) {
            boolean bl = false;
            String string2 = "error,replicationContext md5 is fixed.";
            throw new IllegalArgumentException(string2.toString());
        }
        this.getBytes().put(input);
    }

    @NotNull
    public final byte[] md5fixed() {
        return this.getConfigMd5();
    }

    @NotNull
    public final byte[] refreshMd5(@NotNull String redoPath) {
        Intrinsics.checkNotNullParameter((Object)redoPath, (String)"redoPath");
        byte[] recoveryFilesMd5 = RecoveryFiles.INSTANCE.getMd5Info(redoPath);
        return recoveryFilesMd5 != null ? this.getFixConfigMd5().build(recoveryFilesMd5) : this.getConfigMd5();
    }

    /*
     * WARNING - void declaration
     */
    private final byte[] getConfigMd5() {
        byte[] byArray;
        byte[] md5 = this._configMd5;
        if (md5 == null) {
            void var2_2;
            byte[] fixMd5 = this.getFixConfigMd5().fixBuild();
            this._configMd5 = fixMd5;
            byArray = var2_2;
        } else {
            byArray = md5;
        }
        return byArray;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lkd/bos/olapServer2/replication/ReplicationContext$Companion;", "", "()V", "emptyContext", "Lkd/bos/olapServer2/replication/ReplicationContext;", "getEmptyContext", "()Lkd/bos/olapServer2/replication/ReplicationContext;", "bos-olap-core2"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ReplicationContext getEmptyContext() {
            return emptyContext;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003J\u0006\u0010\n\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lkd/bos/olapServer2/replication/ReplicationContext$FixedConfigMd5;", "", "byteArray", "", "(Lkd/bos/olapServer2/replication/ReplicationContext;[B)V", "messageDigest", "Ljava/security/MessageDigest;", "kotlin.jvm.PlatformType", "build", "otherBytes", "fixBuild", "bos-olap-core2"})
    public final class FixedConfigMd5 {
        @NotNull
        private final byte[] byteArray;
        private final MessageDigest messageDigest;

        public FixedConfigMd5(byte[] byteArray) {
            Intrinsics.checkNotNullParameter((Object)byteArray, (String)"byteArray");
            this.byteArray = byteArray;
            this.messageDigest = MessageDigest.getInstance("MD5");
        }

        @NotNull
        public final byte[] build(@NotNull byte[] otherBytes) {
            Intrinsics.checkNotNullParameter((Object)otherBytes, (String)"otherBytes");
            this.messageDigest.update(this.byteArray);
            this.messageDigest.update(otherBytes);
            byte[] byArray = this.messageDigest.digest();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"digest(...)");
            return byArray;
        }

        @NotNull
        public final byte[] fixBuild() {
            this.messageDigest.update(this.byteArray);
            byte[] byArray = this.messageDigest.digest();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"digest(...)");
            return byArray;
        }
    }
}

