/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.replication;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.olapServer2.monitorReports.HealthReport;
import kd.bos.olapServer2.monitorReports.HealthReportLevel;
import kd.bos.olapServer2.replication.BackupRecord;
import kd.bos.olapServer2.replication.BackupRecordWorkspace;
import kd.bos.olapServer2.replication.BackupType;
import kd.bos.olapServer2.replication.ControlConfig;
import kd.bos.olapServer2.replication.ControlHead;
import kd.bos.olapServer2.replication.IReplicationMaster;
import kd.bos.olapServer2.replication.LSNUtil;
import kd.bos.olapServer2.replication.MasterLSNContext;
import kd.bos.olapServer2.replication.OlapBackup;
import kd.bos.olapServer2.replication.OlapBackupCommandExecutor;
import kd.bos.olapServer2.replication.OlapControlFile;
import kd.bos.olapServer2.replication.OlapHotBackup;
import kd.bos.olapServer2.replication.OlapLogger;
import kd.bos.olapServer2.replication.OlapRecovery;
import kd.bos.olapServer2.replication.RedoArchiver;
import kd.bos.olapServer2.replication.RedoBuffer;
import kd.bos.olapServer2.replication.RedoPage;
import kd.bos.olapServer2.replication.RedoSender;
import kd.bos.olapServer2.replication.ReplicationConf;
import kd.bos.olapServer2.replication.ReplicationContext;
import kd.bos.olapServer2.replication.ReplicationStatus;
import kd.bos.olapServer2.replication.SlaveLSNContext;
import kd.bos.olapServer2.replication.TimeStatQueue;
import kd.bos.olapServer2.replication.WritedRedoFile;
import kd.bos.olapServer2.security.PrivilegeType;
import kd.bos.olapServer2.tools.CubeToolKt;
import kd.bos.olapServer2.transactions.MasterTransactionContext;
import kd.bos.olapServer2.transactions.OlapRollbackExecutor;
import kd.bos.olapServer2.transactions.TidReplayer;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B!\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u00102\u001a\u000203H\u0016J\u0014\u00104\u001a\u00060\u0011j\u0002`52\u0006\u00106\u001a\u000207H\u0016J$\u00108\u001a\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020:09j\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020:`;H\u0016J\u0006\u0010<\u001a\u000203J\r\u0010=\u001a\u000203H\u0000\u00a2\u0006\u0002\b>J\u0018\u0010?\u001a\u00060@j\u0002`A2\n\u0010B\u001a\u00060\u0011j\u0002`5H\u0016J\u0006\u0010C\u001a\u000203J\b\u0010D\u001a\u000203H\u0016J\u0014\u0010E\u001a\u0002032\n\u0010F\u001a\u00060\u0011j\u0002`5H\u0016J\b\u0010G\u001a\u000203H\u0016R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0010\u001a\u00060\u0011j\u0002`\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u001b\u001a\u00020\u001c8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010 \u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010!\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\"\u001a\u0004\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010&\u001a\u0004\u0018\u00010'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0011\u0010*\u001a\u00020+8F\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R\u0014\u0010.\u001a\u00020/X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101\u00a8\u0006H"}, d2={"Lkd/bos/olapServer2/replication/ReplicationMaster;", "Lkd/bos/olapServer2/replication/IReplicationMaster;", "rootPath", "", "Lkd/bos/olapServer2/common/string;", "conf", "Lkd/bos/olapServer2/replication/ReplicationConf;", "replicationContext", "Lkd/bos/olapServer2/replication/ReplicationContext;", "(Ljava/lang/String;Lkd/bos/olapServer2/replication/ReplicationConf;Lkd/bos/olapServer2/replication/ReplicationContext;)V", "ackTimeStat", "Lkd/bos/olapServer2/replication/TimeStatQueue;", "getConf", "()Lkd/bos/olapServer2/replication/ReplicationConf;", "controlConfig", "Lkd/bos/olapServer2/replication/ControlConfig;", "currentLSN", "", "Lkd/bos/olapServer2/common/long;", "getCurrentLSN", "()J", "currentLSNContext", "Lkd/bos/olapServer2/replication/MasterLSNContext;", "getCurrentLSNContext", "()Lkd/bos/olapServer2/replication/MasterLSNContext;", "file", "Lkd/bos/olapServer2/replication/WritedRedoFile;", "logger", "Lkd/bos/olapServer2/replication/OlapLogger;", "getLogger", "()Lkd/bos/olapServer2/replication/OlapLogger;", "logger$delegate", "Lkotlin/Lazy;", "masterLSNContext", "redoArchiver", "Lkd/bos/olapServer2/replication/RedoArchiver;", "redoBuffer", "Lkd/bos/olapServer2/replication/RedoBuffer;", "redoSender", "Lkd/bos/olapServer2/replication/RedoSender;", "getRootPath", "()Ljava/lang/String;", "status", "Lkd/bos/olapServer2/replication/ReplicationStatus;", "getStatus", "()Lkd/bos/olapServer2/replication/ReplicationStatus;", "transactionContext", "Lkd/bos/olapServer2/transactions/MasterTransactionContext;", "getTransactionContext$bos_olap_core2", "()Lkd/bos/olapServer2/transactions/MasterTransactionContext;", "close", "", "forceMerge", "Lkd/bos/olapServer2/common/LSN;", "buffer", "Ljava/nio/ByteBuffer;", "getDisplayInfo", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "hotTotalBackup", "initLockTotalBackup", "initLockTotalBackup$bos_olap_core2", "isDirty", "", "Lkd/bos/olapServer2/common/bool;", "preLSN", "lockTotalBackup", "start", "syncSlaves", "syncPoint", "totalBackup", "bos-olap-core2"})
@SourceDebugExtension(value={"SMAP\nReplicationMaster.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReplicationMaster.kt\nkd/bos/olapServer2/replication/ReplicationMaster\n+ 2 OlapLogger.kt\nkd/bos/olapServer2/replication/OlapLogger\n+ 3 Timing.kt\nkotlin/system/TimingKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,253:1\n112#2,2:254\n91#2,24:256\n112#2,2:286\n91#2,24:288\n17#3,6:280\n1#4:312\n*S KotlinDebug\n*F\n+ 1 ReplicationMaster.kt\nkd/bos/olapServer2/replication/ReplicationMaster\n*L\n146#1:254,2\n146#1:256,24\n188#1:286,2\n188#1:288,24\n169#1:280,6\n*E\n"})
public final class ReplicationMaster
implements IReplicationMaster {
    @NotNull
    private final String rootPath;
    @NotNull
    private final ReplicationConf conf;
    @NotNull
    private final ReplicationContext replicationContext;
    @NotNull
    private final Lazy logger$delegate;
    @NotNull
    private final MasterTransactionContext transactionContext;
    @NotNull
    private final ControlConfig controlConfig;
    @NotNull
    private final MasterLSNContext masterLSNContext;
    @Nullable
    private final TimeStatQueue ackTimeStat;
    @Nullable
    private final RedoSender redoSender;
    @Nullable
    private RedoArchiver redoArchiver;
    @NotNull
    private final RedoBuffer redoBuffer;
    @Nullable
    private WritedRedoFile file;

    public ReplicationMaster(@NotNull String rootPath, @NotNull ReplicationConf conf, @NotNull ReplicationContext replicationContext) {
        Intrinsics.checkNotNullParameter((Object)rootPath, (String)"rootPath");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        Intrinsics.checkNotNullParameter((Object)replicationContext, (String)"replicationContext");
        this.rootPath = rootPath;
        this.conf = conf;
        this.replicationContext = replicationContext;
        this.logger$delegate = LazyKt.lazy((Function0)((Function0)new Function0<OlapLogger>(this){
            final /* synthetic */ ReplicationMaster this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final OlapLogger invoke() {
                return ReplicationMaster.access$getReplicationContext$p(this.this$0).getWorkspace$bos_olap_core2().getLogger$bos_olap_core2();
            }
        }));
        this.transactionContext = new MasterTransactionContext(this);
        this.controlConfig = OlapControlFile.Companion.readControlConfig(this.rootPath).getControlConfig();
        this.masterLSNContext = new MasterLSNContext(this.controlConfig.getRecoveryEndLSN(), this.controlConfig.getCheckPointLSN());
        this.ackTimeStat = this.conf.get_node().getEnableStat() ? new TimeStatQueue(this.masterLSNContext.getCurrentPage()) : null;
        this.redoSender = this.conf.get_master().getBindPort() <= 0 || this.conf.get_master().getBindPort() > 65535 ? null : new RedoSender(this.conf, this.masterLSNContext, this.replicationContext, this.ackTimeStat);
        this.redoBuffer = new RedoBuffer(this.masterLSNContext, (Function1<? super RedoPage, Unit>)((Function1)new Function1<RedoPage, Unit>(this){
            final /* synthetic */ ReplicationMaster this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull RedoPage it) {
                block4: {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    if (ReplicationMaster.access$getRedoSender$p(this.this$0) == null) {
                        ReplicationMaster.access$getMasterLSNContext$p(this.this$0).setLastACKLSN(Long.MAX_VALUE);
                    } else {
                        ReplicationMaster.access$getRedoSender$p(this.this$0).sync(it);
                    }
                    if (!this.this$0.getConf().get_master().getEnableWriteDisk()) break block4;
                    WritedRedoFile writedRedoFile = ReplicationMaster.access$getFile$p(this.this$0);
                    Intrinsics.checkNotNull((Object)writedRedoFile);
                    writedRedoFile.writePage(it);
                    ReplicationMaster.access$getMasterLSNContext$p(this.this$0).setNextWritePage(LSNUtil.INSTANCE.nextPageLSN(ReplicationMaster.access$getMasterLSNContext$p(this.this$0).getNextWritePage()));
                    if (LSNUtil.INSTANCE.isFileLSN$bos_olap_core2(ReplicationMaster.access$getMasterLSNContext$p(this.this$0).getNextWritePage())) {
                        RedoArchiver redoArchiver = ReplicationMaster.access$getRedoArchiver$p(this.this$0);
                        if (redoArchiver != null) {
                            redoArchiver.wakeup();
                        }
                    }
                }
            }
        }));
    }

    @NotNull
    public final String getRootPath() {
        return this.rootPath;
    }

    @NotNull
    public final ReplicationConf getConf() {
        return this.conf;
    }

    private final OlapLogger getLogger() {
        Lazy lazy = this.logger$delegate;
        return (OlapLogger)lazy.getValue();
    }

    @NotNull
    public final MasterTransactionContext getTransactionContext$bos_olap_core2() {
        return this.transactionContext;
    }

    @NotNull
    public final ReplicationStatus getStatus() {
        return this.replicationContext.getWorkspace$bos_olap_core2().getStatus();
    }

    @NotNull
    public final MasterLSNContext getCurrentLSNContext() {
        return this.masterLSNContext;
    }

    @Override
    public long getCurrentLSN() {
        return this.masterLSNContext.getCurrentPage();
    }

    @Override
    public boolean isDirty(long preLSN) {
        return this.transactionContext.getActiveWriteTranCount().get() != 0 || this.masterLSNContext.getCurrentPage() != preLSN;
    }

    @Override
    public long forceMerge(@NotNull ByteBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        return this.redoBuffer.forceMerge$bos_olap_core2(buffer);
    }

    @Override
    public void syncSlaves(long syncPoint) {
        this.redoBuffer.forceSync$bos_olap_core2(syncPoint);
        int count = 0;
        int maxCount = 1000;
        while (this.masterLSNContext.getLastACKLSN() < syncPoint) {
            Thread.sleep(10L);
            if (++count <= maxCount) continue;
            OlapLogger.Companion.info("slave ACK\u8fd4\u56de\u8d85\u65f6,masterLSNContext.lastACKLSN=" + this.masterLSNContext.getLastACKLSN() + ", syncPoint= " + syncPoint);
        }
    }

    @Override
    public void start() {
        block7: {
            try {
                this.redoArchiver = new RedoArchiver(this.masterLSNContext, this.replicationContext, this.conf.get_node().getRedoPath(), this.conf.get_node().getBackupPath());
                WritedRedoFile writedRedoFile = this.file = this.conf.get_master().getEnableWriteDisk() ? new WritedRedoFile(this.conf.get_node().getRedoPath(), this.masterLSNContext) : null;
                if (this.controlConfig.getCheckPointLSN() == -1L) {
                    System.out.println((Object)"controlConfig.checkPointLSN -1");
                }
                this.masterLSNContext.setCheckPoint(OlapRecovery.Companion.replayRedo(this.replicationContext.getWorkspace$bos_olap_core2(), this.controlConfig, this.conf.get_node().getRedoPath(), this.conf.get_node().getBackupPath(), true));
                long startLsn = this.masterLSNContext.getCheckPoint();
                long endLsn = this.masterLSNContext.getCurrentPage();
                boolean bl = 0L <= startLsn ? startLsn < endLsn : false;
                if (bl && this.conf.get_master().getEnableWriteDisk()) {
                    SlaveLSNContext tidReplayLSN = new SlaveLSNContext(startLsn, endLsn, -1L);
                    new TidReplayer(this.replicationContext.getWorkspace$bos_olap_core2().getOlapWorkspace$bos_olap_core2(), tidReplayLSN, this.conf.get_node().getRedoPath()).replay();
                    new OlapRollbackExecutor(this.replicationContext.getWorkspace$bos_olap_core2().getOlapWorkspace$bos_olap_core2(), this).execute();
                }
                this.replicationContext.getWorkspace$bos_olap_core2().switchStatus(ReplicationStatus.Master);
            }
            catch (Exception e) {
                OlapLogger this_$iv = this.getLogger();
                boolean $i$f$error = false;
                String reportId$iv = this_$iv.getStatus().get().name() + "-ReplicationError-" + CubeToolKt.getCurrentTime();
                OlapLogger this_$iv$iv = this_$iv;
                boolean $i$f$error2 = false;
                if (this_$iv$iv.isErrorEnabled()) {
                    boolean bl = false;
                    String message$iv$iv = "ReplicationMaster start failed.";
                    HealthReport report$iv$iv = new HealthReport(reportId$iv, null, this_$iv$iv.getStatus().get().name() + "-ReplicationError: " + message$iv$iv, HealthReportLevel.Error, PrivilegeType.None.getCode());
                    this_$iv$iv.getOlapWorkspace().getHealthReports().commit(report$iv$iv);
                    if ((Throwable)e == null) {
                        OlapLogger.access$getLogger$cp().error(message$iv$iv);
                    } else {
                        OlapLogger.access$getLogger$cp().error("{}", (Object)message$iv$iv, (Object)e);
                    }
                }
                this.replicationContext.getWorkspace$bos_olap_core2().switchStatus(ReplicationStatus.Unavailable);
                this.close();
                throw e;
            }
            RedoSender redoSender = this.redoSender;
            if (redoSender == null) break block7;
            redoSender.start();
        }
    }

    public final void initLockTotalBackup$bos_olap_core2() {
        block7: {
            try {
                BackupRecordWorkspace backupRecordWorkspace = this.replicationContext.getWorkspace$bos_olap_core2().getBackupRecordWorkspace();
                BackupRecord lastTotalBackup = backupRecordWorkspace.getLastTotalBackupWithZero();
                if (lastTotalBackup == null) {
                    if (this.replicationContext.getWorkspace$bos_olap_core2().getOlapWorkspace$bos_olap_core2().getMetadata().getCubes().getCount() > 0) {
                        String tipMsg = "server is executing initLockTotalBackup,please waiting...";
                        System.out.println((Object)tipMsg);
                        OlapLogger.Companion.info(tipMsg);
                        boolean $i$f$measureTimeMillis = false;
                        long start$iv = System.currentTimeMillis();
                        boolean bl = false;
                        OlapBackupCommandExecutor.Companion.lockTotalBackup(this.replicationContext.getWorkspace$bos_olap_core2(), ReplicationStatus.Master);
                        long spendTime = System.currentTimeMillis() - start$iv;
                        String successMsg = "server initLockTotalBackup success,spend " + spendTime + " ms";
                        System.out.println((Object)successMsg);
                        OlapLogger.Companion.info(successMsg);
                    } else {
                        File totalDir = backupRecordWorkspace.getBackupDir(BackupType.Total);
                        String string2 = totalDir.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                        backupRecordWorkspace.writeBackupRecord(string2, 0L, 0L);
                        OlapLogger.Companion.info("initLockTotalBackup write zeroTotal:{}.", totalDir.getName());
                    }
                }
            }
            catch (Throwable t2) {
                OlapLogger this_$iv = this.getLogger();
                boolean $i$f$error = false;
                String reportId$iv = this_$iv.getStatus().get().name() + "-ReplicationError-" + CubeToolKt.getCurrentTime();
                OlapLogger this_$iv$iv = this_$iv;
                boolean $i$f$error2 = false;
                if (!this_$iv$iv.isErrorEnabled()) break block7;
                boolean bl = false;
                StringBuilder stringBuilder = new StringBuilder().append("initLockTotalBackup error:");
                String string3 = t2.getMessage();
                if (string3 == null) {
                    string3 = "";
                }
                String message$iv$iv = stringBuilder.append(string3).toString();
                HealthReport report$iv$iv = new HealthReport(reportId$iv, null, this_$iv$iv.getStatus().get().name() + "-ReplicationError: " + message$iv$iv, HealthReportLevel.Error, PrivilegeType.None.getCode());
                this_$iv$iv.getOlapWorkspace().getHealthReports().commit(report$iv$iv);
                if (t2 == null) {
                    OlapLogger.access$getLogger$cp().error(message$iv$iv);
                }
                OlapLogger.access$getLogger$cp().error("{}", (Object)message$iv$iv, (Object)t2);
            }
        }
    }

    public final void lockTotalBackup() {
        new OlapBackup(this.replicationContext.getWorkspace$bos_olap_core2(), this.masterLSNContext).lockTotalBackup(this.replicationContext.getWorkspace$bos_olap_core2().getOlapWorkspace$bos_olap_core2(), this.masterLSNContext.getCurrentPage());
    }

    @Override
    public void totalBackup() {
        new OlapBackup(this.replicationContext.getWorkspace$bos_olap_core2(), this.masterLSNContext).totalBackup(this.masterLSNContext.getCurrentPage());
    }

    public final void hotTotalBackup() {
        OlapHotBackup olapHotBackup;
        OlapHotBackup it = olapHotBackup = new OlapHotBackup(this.replicationContext.getWorkspace$bos_olap_core2().getBackupRecordWorkspace());
        boolean bl = false;
        it.totalBackup(this.masterLSNContext.getCheckPoint());
    }

    @Override
    public void close() {
        this.redoBuffer.close();
        RedoSender redoSender = this.redoSender;
        if (redoSender != null) {
            redoSender.close();
        }
        WritedRedoFile writedRedoFile = this.file;
        if (writedRedoFile != null) {
            writedRedoFile.close();
        }
        RedoArchiver redoArchiver = this.redoArchiver;
        if (redoArchiver != null) {
            redoArchiver.close();
        }
        long currentPageLsn = this.masterLSNContext.getCurrentPage();
        long flushLsn = LSNUtil.INSTANCE.nextPageLSN(this.masterLSNContext.getFlushLSN());
        if (!(currentPageLsn == flushLsn)) {
            boolean bl = false;
            String string2 = "error,currentPageLsn[" + currentPageLsn + "] must equal flushLSN[" + flushLsn + ']';
            throw new IllegalArgumentException(string2.toString());
        }
        OlapControlFile.save$default(new OlapControlFile(new ControlConfig(currentPageLsn, currentPageLsn, currentPageLsn), new ControlHead(0, 0, 0, 0L, 15, null)), this.rootPath, false, 2, null);
    }

    @Override
    @NotNull
    public HashMap<String, Object> getDisplayInfo() {
        long editPage = this.masterLSNContext.getCurrentPage();
        long writedLsn = LSNUtil.INSTANCE.prePageLSN(this.masterLSNContext.getNextWritePage());
        long lastAck = this.masterLSNContext.getLastACKLSN();
        long lackedLsn = lastAck == Long.MAX_VALUE ? -1L : lastAck;
        TimeStatQueue timeStatQueue = this.ackTimeStat;
        ArrayList<Pair<Long, Long>> timeStat = timeStatQueue != null ? timeStatQueue.getTimeStat() : null;
        LinkedHashMap data = new LinkedHashMap();
        ((Map)data).put("editPage", new Pair((Object)"\u5f53\u524d\u7f16\u8f91\u9875LSN", (Object)editPage));
        ((Map)data).put("writedLsn", new Pair((Object)"\u5df2\u5199\u76d8\u9875LSN", (Object)writedLsn));
        ((Map)data).put("checkPoint", new Pair((Object)"CheckPointLSN", (Object)this.masterLSNContext.getCheckPoint()));
        ((Map)data).put("ackedLsn", new Pair((Object)"Slave\u5df2\u786e\u8ba4\u63a5\u6536LSN", (Object)lackedLsn));
        Map map2 = data;
        String string2 = "slaveNum";
        Object object2 = this.redoSender;
        if (object2 == null || (object2 = ((RedoSender)object2).getReadySlaves()) == null) {
            object2 = new ArrayList();
        }
        Pair pair = new Pair((Object)"\u5df2\u63a5\u5165Slave\u7ed3\u70b9", object2);
        map2.put(string2, pair);
        ((Map)data).put("timeStat", new Pair((Object)"RTT\u4f20\u8f93\u5ef6\u8fdf\u8ddf\u8e2a\u66f2\u7ebf", timeStat));
        return data;
    }

    public static final /* synthetic */ ReplicationContext access$getReplicationContext$p(ReplicationMaster $this) {
        return $this.replicationContext;
    }

    public static final /* synthetic */ RedoSender access$getRedoSender$p(ReplicationMaster $this) {
        return $this.redoSender;
    }

    public static final /* synthetic */ MasterLSNContext access$getMasterLSNContext$p(ReplicationMaster $this) {
        return $this.masterLSNContext;
    }

    public static final /* synthetic */ WritedRedoFile access$getFile$p(ReplicationMaster $this) {
        return $this.file;
    }

    public static final /* synthetic */ RedoArchiver access$getRedoArchiver$p(ReplicationMaster $this) {
        return $this.redoArchiver;
    }
}

