/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.replication;

import java.io.File;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.olapServer2.monitorReports.HealthReport;
import kd.bos.olapServer2.monitorReports.HealthReportLevel;
import kd.bos.olapServer2.replication.ControlConfig;
import kd.bos.olapServer2.replication.ControlHead;
import kd.bos.olapServer2.replication.IReplicationSlave;
import kd.bos.olapServer2.replication.LSNUtil;
import kd.bos.olapServer2.replication.OlapBackup;
import kd.bos.olapServer2.replication.OlapControlFile;
import kd.bos.olapServer2.replication.OlapLogger;
import kd.bos.olapServer2.replication.RecoveryFiles;
import kd.bos.olapServer2.replication.RedoArchiver;
import kd.bos.olapServer2.replication.RedoReceiver;
import kd.bos.olapServer2.replication.ReplayContext;
import kd.bos.olapServer2.replication.ReplayCoordinator;
import kd.bos.olapServer2.replication.ReplicationConf;
import kd.bos.olapServer2.replication.ReplicationContext;
import kd.bos.olapServer2.replication.ReplicationStatus;
import kd.bos.olapServer2.replication.SlaveLSNContext;
import kd.bos.olapServer2.replication.TimeStatQueue;
import kd.bos.olapServer2.security.PrivilegeType;
import kd.bos.olapServer2.server.ReplicationWorkspace;
import kd.bos.olapServer2.storages.OlapWorkspace;
import kd.bos.olapServer2.tools.CubeToolKt;
import kd.bos.olapServer2.tools.FileTools;
import kd.bos.olapServer2.tools.HttpTools;
import kd.bos.olapServer2.tools.RecoveryFilesParser;
import kd.bos.olapServer2.tools.Res;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010$\u001a\u00020%H\u0016J$\u0010&\u001a\u001e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020)0'j\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020)`*H\u0016J\f\u0010+\u001a\u00060(j\u0002`,H\u0002J\u0018\u0010-\u001a\u00060.j\u0002`/2\n\u00100\u001a\u00060\u0012j\u0002`\u0013H\u0016J\u0014\u00101\u001a\u00020%2\n\u00102\u001a\u00060\u0012j\u0002`\u0013H\u0002J\b\u00103\u001a\u00020%H\u0016J\b\u00104\u001a\u00020%H\u0002J\b\u00105\u001a\u00020%H\u0002J\b\u00106\u001a\u00020%H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0018\u0010\u0011\u001a\u00060\u0012j\u0002`\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010 \u001a\u00020!8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#\u00a8\u00067"}, d2={"Lkd/bos/olapServer2/replication/ReplicationSlave;", "Lkd/bos/olapServer2/replication/IReplicationSlave;", "olapWorkspace", "Lkd/bos/olapServer2/storages/OlapWorkspace;", "conf", "Lkd/bos/olapServer2/replication/ReplicationConf;", "replicationContext", "Lkd/bos/olapServer2/replication/ReplicationContext;", "(Lkd/bos/olapServer2/storages/OlapWorkspace;Lkd/bos/olapServer2/replication/ReplicationConf;Lkd/bos/olapServer2/replication/ReplicationContext;)V", "controlConfig", "Lkd/bos/olapServer2/replication/ControlConfig;", "coordinator", "Lkd/bos/olapServer2/replication/ReplayCoordinator;", "current", "Lkd/bos/olapServer2/server/ReplicationWorkspace;", "getCurrent", "()Lkd/bos/olapServer2/server/ReplicationWorkspace;", "currentLSN", "", "Lkd/bos/olapServer2/common/LSN;", "getCurrentLSN", "()J", "delayTimeStat", "Lkd/bos/olapServer2/replication/TimeStatQueue;", "receiver", "Lkd/bos/olapServer2/replication/RedoReceiver;", "redoArchiver", "Lkd/bos/olapServer2/replication/RedoArchiver;", "getReplicationContext", "()Lkd/bos/olapServer2/replication/ReplicationContext;", "slaveContext", "Lkd/bos/olapServer2/replication/SlaveLSNContext;", "status", "Lkd/bos/olapServer2/replication/ReplicationStatus;", "getStatus", "()Lkd/bos/olapServer2/replication/ReplicationStatus;", "close", "", "getDisplayInfo", "Ljava/util/HashMap;", "", "", "Lkotlin/collections/HashMap;", "getSetPasswordScriptPath", "Lkd/bos/olapServer2/common/string;", "isDirty", "", "Lkd/bos/olapServer2/common/bool;", "preLSN", "remoteGetRecoveryFiles", "startLsn", "start", "startReplay", "stopReplay", "totalBackup", "bos-olap-core2"})
@SourceDebugExtension(value={"SMAP\nReplicationSlave.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReplicationSlave.kt\nkd/bos/olapServer2/replication/ReplicationSlave\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 OlapLogger.kt\nkd/bos/olapServer2/replication/OlapLogger\n*L\n1#1,169:1\n1#2:170\n112#3,2:171\n91#3,24:173\n*S KotlinDebug\n*F\n+ 1 ReplicationSlave.kt\nkd/bos/olapServer2/replication/ReplicationSlave\n*L\n152#1:171,2\n152#1:173,24\n*E\n"})
public final class ReplicationSlave
implements IReplicationSlave {
    @NotNull
    private final OlapWorkspace olapWorkspace;
    @NotNull
    private final ReplicationConf conf;
    @NotNull
    private final ReplicationContext replicationContext;
    @NotNull
    private final ControlConfig controlConfig;
    @NotNull
    private final SlaveLSNContext slaveContext;
    @Nullable
    private final TimeStatQueue delayTimeStat;
    @Nullable
    private RedoArchiver redoArchiver;
    @NotNull
    private final RedoReceiver receiver;
    @Nullable
    private ReplayCoordinator coordinator;

    public ReplicationSlave(@NotNull OlapWorkspace olapWorkspace, @NotNull ReplicationConf conf, @NotNull ReplicationContext replicationContext) {
        Intrinsics.checkNotNullParameter((Object)olapWorkspace, (String)"olapWorkspace");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        Intrinsics.checkNotNullParameter((Object)replicationContext, (String)"replicationContext");
        this.olapWorkspace = olapWorkspace;
        this.conf = conf;
        this.replicationContext = replicationContext;
        this.controlConfig = OlapControlFile.Companion.readControlConfig(this.olapWorkspace.getRootPath()).getControlConfig();
        this.slaveContext = new SlaveLSNContext(this.controlConfig.getRecoveryStartLSN(), this.controlConfig.getRecoveryEndLSN(), this.controlConfig.getCheckPointLSN());
        this.delayTimeStat = this.conf.get_node().getEnableStat() ? new TimeStatQueue(this.slaveContext.getNextWritePage()) : null;
        this.receiver = new RedoReceiver(this.redoArchiver, this.conf, this.slaveContext, this.replicationContext, this.delayTimeStat);
    }

    @NotNull
    public final ReplicationContext getReplicationContext() {
        return this.replicationContext;
    }

    @NotNull
    public final ReplicationWorkspace getCurrent() {
        return this.replicationContext.getWorkspace$bos_olap_core2();
    }

    @NotNull
    public final ReplicationStatus getStatus() {
        return this.replicationContext.getWorkspace$bos_olap_core2().getStatus();
    }

    @Override
    public long getCurrentLSN() {
        return this.coordinator == null ? this.slaveContext.getNextReadPage() : -1L;
    }

    @Override
    public boolean isDirty(long preLSN) {
        if (this.coordinator == null) {
            return preLSN != this.slaveContext.getNextReadPage();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void totalBackup() {
        this.stopReplay();
        try {
            OlapBackup olapBackup;
            OlapBackup it = olapBackup = new OlapBackup(this.getCurrent(), this.slaveContext);
            boolean bl = false;
            it.lockTotalBackup(this.olapWorkspace, this.slaveContext.getNextReadPage());
        }
        finally {
            this.startReplay();
        }
    }

    private final void startReplay() {
        block0: {
            ReplayCoordinator replayCoordinator = this.coordinator = new ReplayCoordinator(this.olapWorkspace, this.slaveContext, this.conf.get_node().getRedoPath(), this.conf.get_node().getBackupPath(), this.replicationContext.getWorkspace$bos_olap_core2().getLogger$bos_olap_core2(), new ReplayContext(this.delayTimeStat, false, true, false, null, 26, null));
            if (replayCoordinator == null) break block0;
            replayCoordinator.start();
        }
    }

    private final void stopReplay() {
        Object object2;
        ReplayCoordinator replayCoordinator = this.coordinator;
        if (replayCoordinator != null) {
            replayCoordinator.close();
        }
        OlapLogger.Companion.info("\u5173\u95ed{}\u6210\u529f", (object2 = this.coordinator) != null && (object2 = object2.getClass()) != null ? ((Class)object2).getSimpleName() : null);
        this.coordinator = null;
    }

    @Override
    public void start() {
        this.remoteGetRecoveryFiles(this.slaveContext.getNextReadPage());
        try {
            this.redoArchiver = new RedoArchiver(this.slaveContext, this.replicationContext, this.conf.get_node().getRedoPath(), this.conf.get_node().getBackupPath());
            this.receiver.start();
        }
        catch (Exception e) {
            this.close();
            throw e;
        }
        if (!this.receiver.isAlive()) {
            OlapLogger.Companion.info("receiver not alive");
            return;
        }
        this.startReplay();
    }

    @Override
    public void close() {
        this.stopReplay();
        this.receiver.close();
        RedoArchiver redoArchiver = this.redoArchiver;
        if (redoArchiver != null) {
            redoArchiver.close();
        }
        OlapLogger.Companion.info("\u5173\u95ed{}\u6210\u529f", this.receiver.getClass().getSimpleName());
        OlapControlFile.save$default(new OlapControlFile(new ControlConfig(this.slaveContext.getNextReadPage(), this.slaveContext.getNextWritePage(), this.slaveContext.getCheckPoint()), new ControlHead(0, 0, 0, 0L, 15, null)), this.olapWorkspace.getRootPath(), false, 2, null);
    }

    @Override
    @NotNull
    public HashMap<String, Object> getDisplayInfo() {
        long recvedLsn = LSNUtil.INSTANCE.prePageLSN(this.slaveContext.getNextWritePage());
        long replyPage = LSNUtil.INSTANCE.prePageLSN(this.slaveContext.getNextReadPage());
        TimeStatQueue timeStatQueue = this.delayTimeStat;
        ArrayList<Pair<Long, Long>> timeStat = timeStatQueue != null ? timeStatQueue.getTimeStat() : null;
        LinkedHashMap data = new LinkedHashMap();
        ((Map)data).put("recvedLsn", new Pair((Object)"\u5df2\u63a5\u6536\u9875LSN", (Object)recvedLsn));
        ((Map)data).put("replyPage", new Pair((Object)"\u5f53\u524d\u91cd\u505a\u9875LSN", (Object)replyPage));
        ((Map)data).put("checkPoint", new Pair((Object)"CheckPointLSN", (Object)this.slaveContext.getCheckPoint()));
        ((Map)data).put("timeStat", new Pair((Object)"Redo\u91cd\u505a\u5ef6\u8fdf\u8ddf\u8e2a\u66f2\u7ebf", timeStat));
        return data;
    }

    private final void remoteGetRecoveryFiles(long startLsn) {
        if (StringsKt.isBlank((CharSequence)this.replicationContext.getProxyToken())) {
            String string2 = Res.INSTANCE.getReplicationSlaveException_2();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-ReplicationSlaveException_2>(...)");
            Object[] objectArray = new Object[]{this.getSetPasswordScriptPath()};
            throw Res.INSTANCE.getRuntimeException(string2, objectArray);
        }
        try {
            String standardIpAddress = HttpTools.Companion.getStandardIpAddress(this.conf.get_slave().getHost());
            String socketAddress = standardIpAddress + ':' + this.replicationContext.getWebPort();
            HttpTools.Companion.remoteGetRecoveryFiles(socketAddress, startLsn, this.replicationContext.getProxyToken(), (Function1<? super HttpURLConnection, Unit>)((Function1)new Function1<HttpURLConnection, Unit>(this){
                final /* synthetic */ ReplicationSlave this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull HttpURLConnection it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    String recoveryFilePath = RecoveryFiles.INSTANCE.getOrCreatePath(ReplicationSlave.access$getConf$p(this.this$0).get_node().getRedoPath(), true);
                    InputStream inputStream = it.getInputStream();
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
                    new RecoveryFilesParser(inputStream, recoveryFilePath).parseAndSave();
                }
            }));
        }
        catch (Exception ex) {
            String string3 = ex.getMessage();
            boolean bl = string3 != null ? StringsKt.contains$default((CharSequence)string3, (CharSequence)"#HttpCommandExecutor200", (boolean)false, (int)2, null) : false;
            if (bl) {
                throw new RuntimeException(Res.INSTANCE.getReplicationSlaveException_3(), ex);
            }
            OlapLogger this_$iv = this.replicationContext.getWorkspace$bos_olap_core2().getLogger$bos_olap_core2();
            boolean $i$f$error = false;
            String reportId$iv = this_$iv.getStatus().get().name() + "-ReplicationError-" + CubeToolKt.getCurrentTime();
            OlapLogger this_$iv$iv = this_$iv;
            boolean $i$f$error2 = false;
            if (this_$iv$iv.isErrorEnabled()) {
                boolean bl2 = false;
                String message$iv$iv = "remoteGetRecoveryFiles error.";
                HealthReport report$iv$iv = new HealthReport(reportId$iv, null, this_$iv$iv.getStatus().get().name() + "-ReplicationError: " + message$iv$iv, HealthReportLevel.Error, PrivilegeType.None.getCode());
                this_$iv$iv.getOlapWorkspace().getHealthReports().commit(report$iv$iv);
                if ((Throwable)ex == null) {
                    OlapLogger.access$getLogger$cp().error(message$iv$iv);
                } else {
                    OlapLogger.access$getLogger$cp().error("{}", (Object)message$iv$iv, (Object)ex);
                }
            }
            throw ex;
        }
    }

    private final String getSetPasswordScriptPath() {
        String separator = File.pathSeparator;
        String string2 = FileTools.INSTANCE.getServerRootFolderPath();
        if (string2 == null) {
            string2 = "";
        }
        String serverRootFolderPath = string2;
        return FileTools.INSTANCE.isWin() ? serverRootFolderPath + separator + "bin" + separator + "resetAdminPW.bat" : serverRootFolderPath + separator + "bin" + separator + "resetAdminPW.sh";
    }

    public static final /* synthetic */ ReplicationConf access$getConf$p(ReplicationSlave $this) {
        return $this.conf;
    }
}

