/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.replication;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashSet;
import kd.bos.olapServer2.backup.CubeBackup;
import kd.bos.olapServer2.backup.CubeRecovery;
import kd.bos.olapServer2.common.ITempFolder;
import kd.bos.olapServer2.common.Paths;
import kd.bos.olapServer2.common.PathsKt;
import kd.bos.olapServer2.metadata.OlapMetadata;
import kd.bos.olapServer2.metadata.builds.CubeEntry;
import kd.bos.olapServer2.replication.BackupRecord;
import kd.bos.olapServer2.replication.BackupRecordWorkspace;
import kd.bos.olapServer2.replication.CubeMapFileContainer;
import kd.bos.olapServer2.replication.CubeMapValue;
import kd.bos.olapServer2.replication.LSNUtil;
import kd.bos.olapServer2.replication.RedoUtil;
import kd.bos.olapServer2.replication.ReplayCubeCommitted;
import kd.bos.olapServer2.replication.SlaveLSNContext;
import kd.bos.olapServer2.replication.TimeUtil;
import kd.bos.olapServer2.replication.TotalBackupBuilderV1;
import kd.bos.olapServer2.server.ReplicationWorkspace;
import kd.bos.olapServer2.storages.CubeWorkspace;
import kd.bos.olapServer2.storages.OlapWorkspace;
import kd.bos.olapServer2.tools.FileTools;
import kd.bos.olapServer2.tools.Res;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.LongRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001Be\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u0012\n\u0010\u0007\u001a\u00060\u0005j\u0002`\u0006\u0012\n\u0010\b\u001a\u00060\u0005j\u0002`\u0006\u0012\n\u0010\t\u001a\u00060\nj\u0002`\u000b\u0012\u001e\u0010\f\u001a\u001a\u0012\b\u0012\u00060\nj\u0002`\u000b0\rj\f\u0012\b\u0012\u00060\nj\u0002`\u000b`\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J \u0010\u001b\u001a\u00020\u00172\n\u0010\u001c\u001a\u00060\nj\u0002`\u001d2\n\u0010\u001e\u001a\u00060\nj\u0002`\u001dH\u0002J\b\u0010\u001f\u001a\u00020\u0017H\u0016J\u0014\u0010 \u001a\u0004\u0018\u00010\u001a2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0002J \u0010#\u001a\u00060\nj\u0002`\u001d2\u0006\u0010$\u001a\u00020%2\n\u0010\u001c\u001a\u00060\nj\u0002`\u001dH\u0002R\u0012\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00060\u0005j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\f\u001a\u001a\u0012\b\u0012\u00060\nj\u0002`\u000b0\rj\f\u0012\b\u0012\u00060\nj\u0002`\u000b`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00060\u0005j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00060\nj\u0002`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\n \u0015*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lkd/bos/olapServer2/replication/TimeCubeBackup;", "Ljava/io/Closeable;", "replicationWorkspace", "Lkd/bos/olapServer2/server/ReplicationWorkspace;", "backupPath", "", "Lkd/bos/olapServer2/common/string;", "redoPath", "cubeName", "time", "", "Lkd/bos/olapServer2/common/long;", "ignoreTidSet", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "outputStream", "Ljava/io/OutputStream;", "(Lkd/bos/olapServer2/server/ReplicationWorkspace;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;JLjava/util/HashSet;Ljava/io/OutputStream;)V", "cubeEntry", "Lkd/bos/olapServer2/metadata/builds/CubeEntry;", "tmpDir", "kotlin.jvm.PlatformType", "backup", "", "checkBackupFileTransactionVersion", "backupFile", "Ljava/io/File;", "checkStartAndEndLSN", "replayStartLsn", "Lkd/bos/olapServer2/common/LSN;", "replayEndLsn", "close", "getCubeBackupFileByTotalRecord", "totalRecord", "Lkd/bos/olapServer2/replication/BackupRecord;", "getReplayEndLSN", "backupRecordWorkspace", "Lkd/bos/olapServer2/replication/BackupRecordWorkspace;", "bos-olap-core2"})
@SourceDebugExtension(value={"SMAP\nTimeCubeBackup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TimeCubeBackup.kt\nkd/bos/olapServer2/replication/TimeCubeBackup\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,191:1\n1#2:192\n1747#3,3:193\n*S KotlinDebug\n*F\n+ 1 TimeCubeBackup.kt\nkd/bos/olapServer2/replication/TimeCubeBackup\n*L\n179#1:193,3\n*E\n"})
public final class TimeCubeBackup
implements Closeable {
    @NotNull
    private final ReplicationWorkspace replicationWorkspace;
    @NotNull
    private final String backupPath;
    @NotNull
    private final String redoPath;
    @NotNull
    private final String cubeName;
    private final long time;
    @NotNull
    private final HashSet<Long> ignoreTidSet;
    @NotNull
    private final OutputStream outputStream;
    @NotNull
    private final CubeEntry cubeEntry;
    private final String tmpDir;

    public TimeCubeBackup(@NotNull ReplicationWorkspace replicationWorkspace, @NotNull String backupPath, @NotNull String redoPath, @NotNull String cubeName, long time2, @NotNull HashSet<Long> ignoreTidSet, @NotNull OutputStream outputStream) {
        Intrinsics.checkNotNullParameter((Object)replicationWorkspace, (String)"replicationWorkspace");
        Intrinsics.checkNotNullParameter((Object)backupPath, (String)"backupPath");
        Intrinsics.checkNotNullParameter((Object)redoPath, (String)"redoPath");
        Intrinsics.checkNotNullParameter((Object)cubeName, (String)"cubeName");
        Intrinsics.checkNotNullParameter(ignoreTidSet, (String)"ignoreTidSet");
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        this.replicationWorkspace = replicationWorkspace;
        this.backupPath = backupPath;
        this.redoPath = redoPath;
        this.cubeName = cubeName;
        this.time = time2;
        this.ignoreTidSet = ignoreTidSet;
        this.outputStream = outputStream;
        this.cubeEntry = (CubeEntry)this.replicationWorkspace.getOlapWorkspace$bos_olap_core2().getMetadata().getCubes().get(this.cubeName);
        this.tmpDir = ITempFolder.Companion.createTempDirectory$default(ITempFolder.Companion, null, 1, null).getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void backup() {
        String string2 = this.tmpDir;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"tmpDir");
        OlapMetadata olapMetadata = OlapMetadata.Companion.ReadFrom(string2);
        String string3 = this.tmpDir;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"tmpDir");
        Closeable closeable = new OlapWorkspace(olapMetadata, string3);
        Throwable throwable = null;
        try {
            long replayEndLsn;
            Closeable closeable2;
            BackupRecord lastTotalRecord;
            OlapWorkspace tmpOlapWorkspace = (OlapWorkspace)closeable;
            boolean bl = false;
            BackupRecordWorkspace backupRecordWorkspace = this.replicationWorkspace.getBackupRecordWorkspace();
            BackupRecord backupRecord = lastTotalRecord = backupRecordWorkspace.getLastTotalBackupBefore(this.time);
            long replayStartLsn = backupRecord != null ? backupRecord.getStart() : 0L;
            File cubeBackupFile = this.getCubeBackupFileByTotalRecord(lastTotalRecord);
            if (cubeBackupFile != null && cubeBackupFile.exists()) {
                this.checkBackupFileTransactionVersion(cubeBackupFile);
                Closeable closeable3 = new DataInputStream(new BufferedInputStream(new FileInputStream(cubeBackupFile)));
                Throwable throwable2 = null;
                try {
                    DataInputStream it = (DataInputStream)closeable3;
                    boolean bl2 = false;
                    new CubeRecovery(tmpOlapWorkspace, this.cubeName, tmpOlapWorkspace.getRootPath(), it, this.cubeEntry.getId()).recovery();
                    closeable2 = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable3, (Throwable)throwable2);
                }
            }
            if ((replayEndLsn = this.getReplayEndLSN(backupRecordWorkspace, replayStartLsn)) > replayStartLsn) {
                closeable2 = new ReplayCubeCommitted(tmpOlapWorkspace, new SlaveLSNContext(replayStartLsn, replayEndLsn, -1L), this.replicationWorkspace.getRedoSeqLogger$bos_olap_core2(), this.replicationWorkspace.getIncrementRedoSeqLogger$bos_olap_core2(), this.cubeEntry.getId(), this.cubeEntry.getName(), this.time, this.ignoreTidSet, 0L, 256, null);
                Throwable throwable4 = null;
                try {
                    ReplayCubeCommitted it = (ReplayCubeCommitted)closeable2;
                    boolean bl3 = false;
                    it.replay();
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable5) {
                    throwable4 = throwable5;
                    throw throwable5;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable4);
                }
            }
            if (tmpOlapWorkspace.tryGet(this.cubeName) == null) {
                String string4 = Res.INSTANCE.getReplayCubeException_1();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"<get-ReplayCubeException_1>(...)");
                Object[] objectArray = new Object[]{TimeUtil.Companion.toDateString(this.time), this.cubeName};
                throw Res.INSTANCE.getRuntimeException(string4, objectArray);
            }
            long l = ((Number)tmpOlapWorkspace.enterReadForBackup(this.cubeName, (Function2)new Function2<CubeWorkspace, Closeable, Long>(this, tmpOlapWorkspace){
                final /* synthetic */ TimeCubeBackup this$0;
                final /* synthetic */ OlapWorkspace $tmpOlapWorkspace;
                {
                    this.this$0 = $receiver;
                    this.$tmpOlapWorkspace = $tmpOlapWorkspace;
                    super(2);
                }

                @NotNull
                public final Long invoke(@NotNull CubeWorkspace cubeWorkspace, @NotNull Closeable lock) {
                    Intrinsics.checkNotNullParameter((Object)cubeWorkspace, (String)"cubeWorkspace");
                    Intrinsics.checkNotNullParameter((Object)lock, (String)"lock");
                    return new CubeBackup(cubeWorkspace, TimeCubeBackup.access$getOutputStream$p(this.this$0), lock, this.$tmpOlapWorkspace.getRootPath()).backup();
                }
            })).longValue();
        }
        catch (Throwable throwable6) {
            throwable = throwable6;
            throw throwable6;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final File getCubeBackupFileByTotalRecord(BackupRecord totalRecord) {
        File file;
        if (totalRecord == null) {
            file = null;
        } else {
            String totalRecordPath = RedoUtil.getTotalRecordFolder$default(RedoUtil.INSTANCE, this.backupPath, totalRecord.getName(), false, 4, null).getAbsolutePath();
            Intrinsics.checkNotNull((Object)totalRecordPath);
            TotalBackupBuilderV1 cubeMapValue = new CubeMapFileContainer(totalRecordPath).read();
            CubeMapValue value2 = cubeMapValue.tryGet(this.cubeName);
            file = value2 == null ? null : RedoUtil.INSTANCE.getBackupFile(this.backupPath, this.cubeName, value2.getFileName());
        }
        return file;
    }

    private final long getReplayEndLSN(BackupRecordWorkspace backupRecordWorkspace, long replayStartLsn) {
        long replayEndLsn;
        long l;
        BackupRecord afterTimeFirstRecord = backupRecordWorkspace.getFirstRecordAfterWithZero(this.time);
        if (afterTimeFirstRecord != null) {
            l = afterTimeFirstRecord.getEnd();
        } else {
            LongRange redoDirRange = LSNUtil.INSTANCE.getRealLsnRangeByFolderPath(this.redoPath);
            LongRange incrementDirRange = LSNUtil.INSTANCE.getRealLsnRangeByFolderPath(RedoUtil.INSTANCE.getOrCreateIncrementPath(this.backupPath));
            l = replayEndLsn = Math.max(redoDirRange.getLast(), incrementDirRange.getLast());
        }
        if (!(replayEndLsn >= replayStartLsn)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        this.checkStartAndEndLSN(replayStartLsn, replayEndLsn);
        return replayEndLsn;
    }

    private final void checkStartAndEndLSN(long replayStartLsn, long replayEndLsn) {
        File[] fileArray = Paths.INSTANCE.toFile(this.redoPath).listFiles(TimeCubeBackup::checkStartAndEndLSN$lambda$3);
        if (fileArray == null || fileArray.length == 0) {
            throw new RuntimeException("redo path is empty, no redoFile exists: " + this.redoPath);
        }
        LongRange redoLSNRange = LSNUtil.INSTANCE.getRealLsnRangeByFolderPath(this.redoPath);
        long redoStartLSN = redoLSNRange.getFirst();
        long redoEndLSN = redoLSNRange.getLast();
        String incrementPath = RedoUtil.INSTANCE.getOrCreateIncrementPath(this.backupPath);
        long incrementStartLSN = LSNUtil.INSTANCE.getRealLsnRangeByFolderPath(incrementPath).getFirst();
        if (incrementStartLSN == -1L && replayStartLsn < redoStartLSN || replayStartLsn < redoStartLSN && replayStartLsn < incrementStartLSN) {
            String string2 = Res.INSTANCE.getTimeCubeBackupException_1();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-TimeCubeBackupException_1>(...)");
            Object[] objectArray = new Object[]{replayStartLsn};
            throw Res.INSTANCE.getRuntimeException(string2, objectArray);
        }
        if (incrementStartLSN == -1L && replayEndLsn < redoStartLSN || replayEndLsn < redoStartLSN && replayEndLsn < incrementStartLSN) {
            String string3 = Res.INSTANCE.getTimeCubeBackupException_1();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"<get-TimeCubeBackupException_1>(...)");
            Object[] objectArray = new Object[]{replayStartLsn};
            throw Res.INSTANCE.getRuntimeException(string3, objectArray);
        }
        if (replayEndLsn > redoEndLSN) {
            String string4 = Res.INSTANCE.getTimeCubeBackupException_3();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"<get-TimeCubeBackupException_3>(...)");
            Object[] objectArray = new Object[]{replayEndLsn, redoEndLSN};
            throw Res.INSTANCE.getRuntimeException(string4, objectArray);
        }
    }

    private final void checkBackupFileTransactionVersion(File backupFile) {
        boolean bl;
        long transactionVersion;
        block5: {
            transactionVersion = BackupRecordWorkspace.Companion.getBackupFileTransactionVersion(backupFile);
            if (!(transactionVersion >= 0L)) {
                boolean $i$a$-require-TimeCubeBackup$checkBackupFileTransactionVersion$22 = false;
                String $i$a$-require-TimeCubeBackup$checkBackupFileTransactionVersion$22 = "transactionVersion[" + transactionVersion + "] is illegal";
                throw new IllegalArgumentException($i$a$-require-TimeCubeBackup$checkBackupFileTransactionVersion$22.toString());
            }
            Iterable $this$any$iv = this.ignoreTidSet;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    long it = ((Number)element$iv).longValue();
                    boolean bl2 = false;
                    if (!(it <= transactionVersion)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        if (bl) {
            String string2 = Res.INSTANCE.getTimeCubeBackupException_2();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-TimeCubeBackupException_2>(...)");
            Object[] objectArray = new Object[]{CollectionsKt.joinToString$default((Iterable)this.ignoreTidSet, (CharSequence)",", null, null, (int)0, null, null, (int)62, null), transactionVersion};
            throw Res.INSTANCE.getIllegalArgumentException(string2, objectArray);
        }
    }

    @Override
    public void close() {
        String string2 = this.tmpDir;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"tmpDir");
        FileTools.INSTANCE.deleteDir(PathsKt.fileSafeConstructor(string2));
    }

    private static final boolean checkStartAndEndLSN$lambda$3(File file) {
        Intrinsics.checkNotNull((Object)file);
        return Intrinsics.areEqual((Object)FilesKt.getExtension((File)file), (Object)"redo") || Intrinsics.areEqual((Object)FilesKt.getExtension((File)file), (Object)"redoz");
    }

    public static final /* synthetic */ OutputStream access$getOutputStream$p(TimeCubeBackup $this) {
        return $this.outputStream;
    }
}

