/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.replication;

import java.io.Closeable;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kd.bos.olapServer2.common.OlapRuntimeException;
import kd.bos.olapServer2.dataSources.TimeBackupCommandInfo;
import kd.bos.olapServer2.replication.ReplicationConf;
import kd.bos.olapServer2.replication.TimeCubeBackup;
import kd.bos.olapServer2.replication.TimeUtil;
import kd.bos.olapServer2.server.ReplicationWorkspace;
import kd.bos.olapServer2.tools.Res;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0002J\u0006\u0010\u000e\u001a\u00020\rR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lkd/bos/olapServer2/replication/TimeCubeBackupCommandExecutor;", "", "replicationWorkspace", "Lkd/bos/olapServer2/server/ReplicationWorkspace;", "cubeName", "", "Lkd/bos/olapServer2/common/string;", "commandInfo", "Lkd/bos/olapServer2/dataSources/TimeBackupCommandInfo;", "outputStream", "Ljava/io/OutputStream;", "(Lkd/bos/olapServer2/server/ReplicationWorkspace;Ljava/lang/String;Lkd/bos/olapServer2/dataSources/TimeBackupCommandInfo;Ljava/io/OutputStream;)V", "checkTime", "", "run", "bos-olap-core2"})
@SourceDebugExtension(value={"SMAP\nTimeCubeBackupCommandExecutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TimeCubeBackupCommandExecutor.kt\nkd/bos/olapServer2/replication/TimeCubeBackupCommandExecutor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,56:1\n1549#2:57\n1620#2,3:58\n1#3:61\n*S KotlinDebug\n*F\n+ 1 TimeCubeBackupCommandExecutor.kt\nkd/bos/olapServer2/replication/TimeCubeBackupCommandExecutor\n*L\n28#1:57\n28#1:58,3\n*E\n"})
public final class TimeCubeBackupCommandExecutor {
    @NotNull
    private final ReplicationWorkspace replicationWorkspace;
    @NotNull
    private final String cubeName;
    @NotNull
    private final TimeBackupCommandInfo commandInfo;
    @NotNull
    private final OutputStream outputStream;

    public TimeCubeBackupCommandExecutor(@NotNull ReplicationWorkspace replicationWorkspace, @NotNull String cubeName, @NotNull TimeBackupCommandInfo commandInfo, @NotNull OutputStream outputStream) {
        Intrinsics.checkNotNullParameter((Object)replicationWorkspace, (String)"replicationWorkspace");
        Intrinsics.checkNotNullParameter((Object)cubeName, (String)"cubeName");
        Intrinsics.checkNotNullParameter((Object)commandInfo, (String)"commandInfo");
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        this.replicationWorkspace = replicationWorkspace;
        this.cubeName = cubeName;
        this.commandInfo = commandInfo;
        this.outputStream = outputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void run() {
        Iterable iterable;
        Object object2;
        this.checkTime();
        ReplicationConf.NodeConfig nodeConf = this.replicationWorkspace.getCurrentNode().getConf().get_node();
        String backupPath = nodeConf.getBackupPath();
        String redoPath = nodeConf.getRedoPath();
        try {
            Object object3;
            if (((CharSequence)this.commandInfo.getIgnoreIds()).length() > 0) {
                void $this$mapTo$iv$iv;
                object2 = new String[]{","};
                Iterable $this$map$iv = StringsKt.split$default((CharSequence)this.commandInfo.getIgnoreIds(), (String[])object2, (boolean)false, (int)0, (int)6, null);
                boolean $i$f$map = false;
                iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string2 = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(Long.parseLong((String)it));
                }
                object3 = CollectionsKt.toHashSet((Iterable)((List)destination$iv$iv));
            } else {
                object3 = new HashSet();
            }
            object2 = object3;
        }
        catch (Exception ex) {
            throw new OlapRuntimeException("time backup error,ignoreIds[" + this.commandInfo.getIgnoreIds() + "] parse failed.", null, null, 6, null);
        }
        String[] ignoreTidSet = object2;
        object2 = new TimeCubeBackup(this.replicationWorkspace, backupPath, redoPath, this.cubeName, this.commandInfo.getTime(), (HashSet<Long>)ignoreTidSet, this.outputStream);
        Throwable throwable = null;
        try {
            TimeCubeBackup it = (TimeCubeBackup)object2;
            boolean bl = false;
            it.backup();
            iterable = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
        }
    }

    private final void checkTime() {
        long currentTime = System.currentTimeMillis();
        if (this.commandInfo.getTime() > currentTime) {
            String string2 = Res.INSTANCE.getTimeCubeBackupCommandExecutorException_1();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-TimeCubeBackupComma\u2026ExecutorException_1>(...)");
            Object[] objectArray = new Object[]{TimeUtil.Companion.toDateString(this.commandInfo.getTime(), TimeUtil.Companion.getTimeSdf()), TimeUtil.Companion.toDateString(currentTime, TimeUtil.Companion.getTimeSdf())};
            throw Res.INSTANCE.getRuntimeException(string2, objectArray);
        }
    }
}

