/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.replication;

import java.nio.ByteBuffer;
import kd.bos.olapServer2.replication.IRedoRecordHead;
import kd.bos.olapServer2.replication.ITranStatusRecord;
import kd.bos.olapServer2.replication.RedoType;
import kd.bos.olapServer2.transactions.TransactionStatus;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u001e\u001a\u00020\bH\u0016J\b\u0010\u001f\u001a\u00020\bH\u0002J\b\u0010 \u001a\u00020!H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0018\u0010\u000b\u001a\u00060\fj\u0002`\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0013X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0018\u0010\u0019\u001a\u00060\u001aj\u0002`\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006\""}, d2={"Lkd/bos/olapServer2/replication/TranStatusRecord;", "Lkd/bos/olapServer2/replication/ITranStatusRecord;", "head", "Lkd/bos/olapServer2/replication/IRedoRecordHead;", "body", "Ljava/nio/ByteBuffer;", "(Lkd/bos/olapServer2/replication/IRedoRecordHead;Ljava/nio/ByteBuffer;)V", "_transactionStatus", "Lkd/bos/olapServer2/transactions/TransactionStatus;", "getBody", "()Ljava/nio/ByteBuffer;", "cubeId", "", "Lkd/bos/olapServer2/common/int;", "getCubeId", "()I", "getHead", "()Lkd/bos/olapServer2/replication/IRedoRecordHead;", "isOlapLevel", "", "()Z", "redoType", "Lkd/bos/olapServer2/replication/RedoType;", "getRedoType", "()Lkd/bos/olapServer2/replication/RedoType;", "tid", "", "Lkd/bos/olapServer2/common/long;", "getTid", "()J", "getTranStatus", "readTranStatus", "toString", "", "bos-olap-core2"})
public final class TranStatusRecord
implements ITranStatusRecord {
    @NotNull
    private final IRedoRecordHead head;
    @NotNull
    private final ByteBuffer body;
    private final boolean isOlapLevel;
    @NotNull
    private final TransactionStatus _transactionStatus;

    public TranStatusRecord(@NotNull IRedoRecordHead head, @NotNull ByteBuffer body) {
        Intrinsics.checkNotNullParameter((Object)head, (String)"head");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        this.head = head;
        this.body = body;
        this._transactionStatus = this.readTranStatus();
    }

    @NotNull
    public final IRedoRecordHead getHead() {
        return this.head;
    }

    @NotNull
    public final ByteBuffer getBody() {
        return this.body;
    }

    @Override
    @NotNull
    public RedoType getRedoType() {
        return this.head.getType();
    }

    @Override
    public int getCubeId() {
        return this.head.getCubeId();
    }

    @Override
    public boolean isOlapLevel() {
        return this.isOlapLevel;
    }

    @Override
    public long getTid() {
        return this.head.getTid();
    }

    private final TransactionStatus readTranStatus() {
        if (!(this.head.getType() == RedoType.TranStatus)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        return TransactionStatus.Companion.byteToTranStatus(this.body.get());
    }

    @Override
    @NotNull
    public TransactionStatus getTranStatus() {
        return this._transactionStatus;
    }

    @NotNull
    public String toString() {
        return "cubeID: " + this.head.getCubeId() + ", tid: " + this.head.getTid() + ", " + (Object)((Object)this.getTranStatus()) + '\n';
    }
}

