/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.replication;

import java.nio.channels.SocketChannel;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import kd.bos.olapServer2.replication.LSNUtil;
import kd.bos.olapServer2.replication.MasterLSNContext;
import kd.bos.olapServer2.replication.RedoFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B%\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0019\u0010\f\u001a\u00060\rj\u0002`\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u0011J(\u0010\u0012\u001a\u00020\u00132\n\u0010\u0014\u001a\u00060\u0003j\u0002`\u00152\n\u0010\u0016\u001a\u00060\u0003j\u0002`\u00152\u0006\u0010\u0017\u001a\u00020\u0010H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u00060\u0003j\u0002`\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lkd/bos/olapServer2/replication/TransferredRedoFile;", "Lkd/bos/olapServer2/replication/RedoFile;", "fileLSN", "", "Lkd/bos/olapServer2/common/LSN;", "path", "", "Lkd/bos/olapServer2/common/string;", "masterLSNContext", "Lkd/bos/olapServer2/replication/MasterLSNContext;", "(JLjava/lang/String;Lkd/bos/olapServer2/replication/MasterLSNContext;)V", "nextTransferPoint", "transferTo", "", "Lkd/bos/olapServer2/common/bool;", "socket", "Ljava/nio/channels/SocketChannel;", "transferTo$bos_olap_core2", "transferToSafe", "", "position", "Lkd/bos/olapServer2/common/long;", "count", "target", "bos-olap-core2"})
public final class TransferredRedoFile
extends RedoFile {
    @NotNull
    private final MasterLSNContext masterLSNContext;
    private long nextTransferPoint;

    public TransferredRedoFile(long fileLSN, @NotNull String path, @NotNull MasterLSNContext masterLSNContext) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)masterLSNContext, (String)"masterLSNContext");
        OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.READ};
        super(fileLSN, path, openOptionArray);
        this.masterLSNContext = masterLSNContext;
        this.nextTransferPoint = fileLSN;
    }

    public final boolean transferTo$bos_olap_core2(@NotNull SocketChannel socket) {
        Intrinsics.checkNotNullParameter((Object)socket, (String)"socket");
        if (this.masterLSNContext.getNextWritePage() <= this.nextTransferPoint) {
            return false;
        }
        if (this.nextTransferPoint == this.getNextFileLsn()) {
            this.switchFile();
        }
        long position = LSNUtil.INSTANCE.getLsnPositionInFile(this.nextTransferPoint);
        long lastWritePage = LSNUtil.INSTANCE.prePageLSN(this.masterLSNContext.getNextWritePage());
        long count = LSNUtil.INSTANCE.fileLSN(lastWritePage) == LSNUtil.INSTANCE.fileLSN(this.nextTransferPoint) ? this.masterLSNContext.getNextWritePage() - this.nextTransferPoint : 0x1000000L - position;
        this.transferToSafe(position, count, socket);
        this.nextTransferPoint += count;
        return true;
    }

    private final void transferToSafe(long position, long count, SocketChannel target) {
        long sendByte = 0L;
        long startPos = position;
        while (sendByte < count) {
            long oneTimeByte = this.getFd().transferTo(startPos, count - sendByte, target);
            sendByte += oneTimeByte;
            startPos += oneTimeByte;
        }
    }
}

