/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.replication;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import kd.bos.olapServer2.common.Paths;
import kd.bos.olapServer2.common.PathsKt;
import kd.bos.olapServer2.replication.LSNContext;
import kd.bos.olapServer2.replication.LSNUtil;
import kd.bos.olapServer2.replication.RedoFile;
import kd.bos.olapServer2.replication.RedoPage;
import kd.bos.olapServer2.replication.WritedRedoFile;
import kd.bos.olapServer2.tools.FileTools;
import kd.bos.olapServer2.tools.Res;
import kotlin.Metadata;
import kotlin.io.FileTreeWalk;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010\n\u001a\u00060\u0003j\u0002`\u00042\n\u0010\u000b\u001a\u00060\fj\u0002`\rH\u0002J\u0012\u0010\u000e\u001a\u00060\u000fj\u0002`\u00102\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lkd/bos/olapServer2/replication/WritedRedoFile;", "Lkd/bos/olapServer2/replication/RedoFile;", "path", "", "Lkd/bos/olapServer2/common/string;", "context", "Lkd/bos/olapServer2/replication/LSNContext;", "(Ljava/lang/String;Lkd/bos/olapServer2/replication/LSNContext;)V", "checkInitLSN", "", "getFixLsnCommand", "redoFileLastLSN", "", "Lkd/bos/olapServer2/common/LSN;", "writePage", "", "Lkd/bos/olapServer2/common/bool;", "page", "Lkd/bos/olapServer2/replication/RedoPage;", "bos-olap-core2"})
@SourceDebugExtension(value={"SMAP\nWritedRedoFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WritedRedoFile.kt\nkd/bos/olapServer2/replication/WritedRedoFile\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,99:1\n1313#2,2:100\n*S KotlinDebug\n*F\n+ 1 WritedRedoFile.kt\nkd/bos/olapServer2/replication/WritedRedoFile\n*L\n55#1:100,2\n*E\n"})
public final class WritedRedoFile
extends RedoFile {
    @NotNull
    private final String path;
    @NotNull
    private final LSNContext context;

    public WritedRedoFile(@NotNull String path, @NotNull LSNContext context) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.APPEND};
        super(context.getNextWritePage(), path, openOptionArray);
        this.path = path;
        this.context = context;
        this.checkInitLSN();
    }

    public final boolean writePage(@NotNull RedoPage page) {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        int dataSize = page.getBuffer().position();
        page.getBuffer().flip();
        while (this.getFd().size() < LSNUtil.INSTANCE.getPageStartPosition(this.context.getNextWritePage())) {
            ByteBuffer tmpBuffer = ByteBuffer.wrap((byte[])page.getBuffer().array().clone());
            tmpBuffer.putLong(0, -1L);
            this.getFd().write(tmpBuffer, this.getFd().size());
        }
        int writeSize = this.getFd().write(page.getBuffer(), LSNUtil.INSTANCE.getPageStartPosition(this.context.getNextWritePage()));
        if (!(writeSize == dataSize)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        long nextWritePage = LSNUtil.INSTANCE.nextPageLSN(this.context.getNextWritePage());
        if (nextWritePage == this.getNextFileLsn()) {
            this.switchFile();
        }
        return true;
    }

    public final void checkInitLSN() {
        long lastFileSize;
        String maxFileName = null;
        maxFileName = "00_0000_0000.redo";
        FileTreeWalk redoPathWalk = FilesKt.walk$default((File)PathsKt.fileSafeConstructor(this.path), null, (int)1, null);
        Sequence $this$forEach$iv = SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)((Sequence)redoPathWalk.maxDepth(1)), (Function1)checkInitLSN.1.INSTANCE), (Function1)checkInitLSN.2.INSTANCE);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            if (it.getName().compareTo(maxFileName) <= 0) continue;
            Intrinsics.checkNotNullExpressionValue((Object)it.getName(), (String)"getName(...)");
        }
        String lastFileName = StringsKt.substringBefore$default((String)maxFileName, (char)'.', null, (int)2, null);
        long redoFileLastLSN = LSNUtil.INSTANCE.getLsnByFileName(lastFileName, lastFileSize = Paths.INSTANCE.toFile(this.path, maxFileName).length());
        if (redoFileLastLSN > this.context.getNextWritePage()) {
            String string2 = Res.INSTANCE.getWritedRedoFileException_1();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-WritedRedoFileException_1>(...)");
            Object[] objectArray = new Object[]{redoFileLastLSN, this.context.getNextWritePage(), this.getFixLsnCommand(redoFileLastLSN)};
            throw Res.INSTANCE.getRuntimeException(string2, objectArray);
        }
    }

    private final String getFixLsnCommand(long redoFileLastLSN) {
        String string2;
        String controlFilePath;
        String string3;
        String string4 = FileTools.INSTANCE.getServerRootFolderPath();
        if (string4 == null) {
            return FileTools.INSTANCE.isWin() ? "bin\\updateLSN.bat olap.control " + redoFileLastLSN : "sh bin/updateLSN olap.control " + redoFileLastLSN;
        }
        String serverFolderPath = string4;
        File binFolder = Paths.INSTANCE.toFile(serverFolderPath, "bin");
        if (!binFolder.exists()) {
            String string5 = "Failed requirement.";
            throw new IllegalArgumentException(string5.toString());
        }
        String[] stringArray = new String[]{"database", "olap.control"};
        File olapControlFile = Paths.INSTANCE.joinToFile(serverFolderPath, stringArray);
        String[] stringArray2 = new String[]{"database", "lsn.control"};
        File lsnControlFile = Paths.INSTANCE.joinToFile(serverFolderPath, stringArray2);
        if (olapControlFile.exists()) {
            string3 = olapControlFile.getAbsolutePath();
        } else {
            if (!lsnControlFile.exists()) {
                String string6 = "Failed requirement.";
                throw new IllegalArgumentException(string6.toString());
            }
            string3 = controlFilePath = lsnControlFile.getAbsolutePath();
        }
        if (FileTools.INSTANCE.isWin()) {
            StringBuilder stringBuilder = new StringBuilder().append(".\\");
            String string7 = binFolder.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"getAbsolutePath(...)");
            String[] stringArray3 = new String[]{"tools", "updateLSN.bat"};
            string2 = stringBuilder.append(Paths.INSTANCE.joinToFile(string7, stringArray3).getAbsolutePath()).append(' ').append(controlFilePath).append(' ').append(redoFileLastLSN).toString();
        } else {
            StringBuilder stringBuilder = new StringBuilder().append("sh ");
            String string8 = binFolder.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"getAbsolutePath(...)");
            String[] stringArray4 = new String[]{"tools", "updateLSN"};
            string2 = stringBuilder.append(Paths.INSTANCE.joinToFile(string8, stringArray4).getAbsolutePath()).append(' ').append(controlFilePath).append(' ').append(redoFileLastLSN).toString();
        }
        return string2;
    }
}

