/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.security;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kd.bos.olapServer2.security.AccessStrategyCollection;
import kd.bos.olapServer2.security.IAccessStrategy;
import kd.bos.olapServer2.security.OlapActions;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005J\b\u0010\r\u001a\u00020\u000bH\u0002J\u000e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005J\u000e\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0012\u0010\u0007\u001a\u00060\bj\u0002`\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lkd/bos/olapServer2/security/AccessStrategyCollection;", "", "()V", "_accessStrategies", "", "Lkd/bos/olapServer2/security/IAccessStrategy;", "[Lkd/bos/olapServer2/security/IAccessStrategy;", "_privilegeValue", "", "Lkd/bos/olapServer2/common/int;", "add", "", "accessStrategy", "refreshAccessStrategy", "remove", "verify", "action", "Lkd/bos/olapServer2/security/OlapActions;", "bos-olap-core2"})
@SourceDebugExtension(value={"SMAP\nAccessStrategyCollection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AccessStrategyCollection.kt\nkd/bos/olapServer2/security/AccessStrategyCollection\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,85:1\n3792#2:86\n4307#2,2:87\n*S KotlinDebug\n*F\n+ 1 AccessStrategyCollection.kt\nkd/bos/olapServer2/security/AccessStrategyCollection\n*L\n77#1:86\n77#1:87,2\n*E\n"})
public final class AccessStrategyCollection {
    private int _privilegeValue = -1;
    @NotNull
    private IAccessStrategy[] _accessStrategies = new IAccessStrategy[0];

    public final synchronized void add(@NotNull IAccessStrategy accessStrategy) {
        Intrinsics.checkNotNullParameter((Object)accessStrategy, (String)"accessStrategy");
        if (accessStrategy.getForbidPrivilege() != 0) {
            Object[] objectArray = Arrays.copyOf(this._accessStrategies, this._accessStrategies.length + 1);
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"copyOf(this, newSize)");
            Object[] newArray = objectArray;
            newArray[ArraysKt.getLastIndex((Object[])newArray)] = accessStrategy;
            this._accessStrategies = (IAccessStrategy[])ArraysKt.requireNoNulls((Object[])newArray);
            this.refreshAccessStrategy();
        }
    }

    public final synchronized void remove(@NotNull IAccessStrategy accessStrategy) {
        int n;
        Intrinsics.checkNotNullParameter((Object)accessStrategy, (String)"accessStrategy");
        int index2 = -1;
        IAccessStrategy[] iAccessStrategyArray = this._accessStrategies;
        int n2 = iAccessStrategyArray.length;
        for (n = 0; n < n2; ++n) {
            int i = n;
            IAccessStrategy strategy = iAccessStrategyArray[n];
            if (strategy != accessStrategy) continue;
            index2 = i;
            break;
        }
        if (index2 >= 0) {
            IAccessStrategy[] accessStrategies = this._accessStrategies;
            n2 = accessStrategies.length - 1;
            IAccessStrategy[] iAccessStrategyArray2 = new IAccessStrategy[n2];
            AccessStrategyCollection accessStrategyCollection = this;
            for (n = 0; n < n2; ++n) {
                int n3 = n;
                iAccessStrategyArray2[n3] = n3 >= index2 ? accessStrategies[n3 + 1] : accessStrategies[n3];
            }
            accessStrategyCollection._accessStrategies = iAccessStrategyArray2;
            this.refreshAccessStrategy();
        }
    }

    private final void refreshAccessStrategy() {
        int privilegeValue = -1;
        for (IAccessStrategy strategy : this._accessStrategies) {
            privilegeValue &= ~strategy.getForbidPrivilege();
        }
        this._privilegeValue = privilegeValue;
    }

    /*
     * WARNING - void declaration
     */
    public final void verify(@NotNull OlapActions action) {
        Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
        int actionCode = action.getCode();
        if ((this._privilegeValue & actionCode) != actionCode) {
            void $this$filterTo$iv$iv;
            IAccessStrategy[] $this$filter$iv = this._accessStrategies;
            boolean $i$f$filter = false;
            IAccessStrategy[] iAccessStrategyArray = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            int n = ((void)$this$filterTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void element$iv$iv;
                void item = element$iv$iv = $this$filterTo$iv$iv[i];
                boolean bl = false;
                if (!((item.getForbidPrivilege() & actionCode) != 0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable iterable = (List)destination$iv$iv;
            String string2 = System.lineSeparator();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"lineSeparator(...)");
            String message2 = CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string2, null, null, (int)0, null, (Function1)verify.message.2.INSTANCE, (int)30, null);
            if (((CharSequence)message2).length() > 0) {
                throw new RuntimeException(message2);
            }
        }
    }
}

