/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.selects;

import java.util.concurrent.CancellationException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import kd.bos.olapServer2.common.CancellableToken;
import kd.bos.olapServer2.common.CommonTypesKt;
import kd.bos.olapServer2.common.ICancellable;
import kd.bos.olapServer2.common.IContinueToken;
import kd.bos.olapServer2.common.NotSupportedException;
import kd.bos.olapServer2.common.OlapContext;
import kd.bos.olapServer2.metadata.DirectPointer;
import kd.bos.olapServer2.query.SelectFieldCollectionRowCreator;
import kd.bos.olapServer2.selects.IQueryReader;
import kd.bos.olapServer2.selects.IQuerySession;
import kd.bos.olapServer2.selects.ISelectField;
import kd.bos.olapServer2.selects.ISelectFieldCollection;
import kd.bos.olapServer2.selects.ParallelQueryReader;
import kd.bos.olapServer2.selects.SelectWorkerStater;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001:\u0001(B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\b\u0002\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\n\u0012\u0004\u0012\u00020 \u0018\u00010\"H\u0002J\f\u0010#\u001a\u00060\fj\u0002`$H\u0002J\f\u0010%\u001a\u00060\fj\u0002`$H\u0016J\f\u0010&\u001a\u00060\fj\u0002`$H\u0002J\b\u0010'\u001a\u00020 H\u0002R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000e\u001a\u0012\u0012\u000e\u0012\f\u0012\u0006\u0012\u0004\u0018\u00010\u0011\u0018\u00010\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0019\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006)"}, d2={"Lkd/bos/olapServer2/selects/ParallelQueryReader;", "Lkd/bos/olapServer2/selects/IQueryReader;", "querySession", "Lkd/bos/olapServer2/selects/IQuerySession;", "maxWorkerCount", "", "Lkd/bos/olapServer2/common/int;", "(Lkd/bos/olapServer2/selects/IQuerySession;I)V", "_endWorkerCount", "_fields", "Lkd/bos/olapServer2/selects/ISelectFieldCollection;", "_isMainReaderEnd", "", "_mainReader", "_queueValues", "Lkd/bos/olapServer2/metadata/DirectPointer;", "", "", "_valuesQueue", "Ljava/util/concurrent/LinkedBlockingQueue;", "_workerCount", "_workerStater", "Lkd/bos/olapServer2/selects/SelectWorkerStater;", "mainOlapContext", "Lkd/bos/olapServer2/common/OlapContext;", "otherWorkerCount", "getOtherWorkerCount", "()I", "selectFields", "getSelectFields", "()Lkd/bos/olapServer2/selects/ISelectFieldCollection;", "close", "", "createWorker", "Lkotlin/Function0;", "isEOF", "Lkd/bos/olapServer2/common/bool;", "next", "nextForParallel", "readerJob", "EndFlag", "bos-olap-core2"})
public final class ParallelQueryReader
implements IQueryReader {
    @NotNull
    private final IQuerySession querySession;
    private final int maxWorkerCount;
    @NotNull
    private final IQueryReader _mainReader;
    @NotNull
    private final ISelectFieldCollection _fields;
    @NotNull
    private final DirectPointer<Object[]> _queueValues;
    @NotNull
    private final SelectWorkerStater _workerStater;
    @NotNull
    private final LinkedBlockingQueue<Object> _valuesQueue;
    private int _workerCount;
    private volatile int _endWorkerCount;
    private boolean _isMainReaderEnd;
    @Nullable
    private final OlapContext mainOlapContext;

    public ParallelQueryReader(@NotNull IQuerySession querySession, int maxWorkerCount) {
        Intrinsics.checkNotNullParameter((Object)querySession, (String)"querySession");
        this.querySession = querySession;
        this.maxWorkerCount = maxWorkerCount;
        this._queueValues = new DirectPointer<Object>(null);
        this.mainOlapContext = OlapContext.Companion.getCurrentContext();
        if (!(this.maxWorkerCount >= 0)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        this._workerStater = new SelectWorkerStater((Function0<? extends Function0<Unit>>)((Function0)new Function0<Function0<? extends Unit>>((Object)this){

            @Nullable
            public final Function0<Unit> invoke() {
                return ((ParallelQueryReader)this.receiver).createWorker();
            }
        }));
        OlapContext.Companion.push(this._workerStater);
        try {
            this._mainReader = this.querySession.createReader();
            this._fields = SelectFieldCollectionRowCreator.INSTANCE.create(this._mainReader.getSelectFields(), this._queueValues);
            this._valuesQueue = new LinkedBlockingQueue(Math.max(this.maxWorkerCount, 2) * 4096);
        }
        catch (Throwable ex) {
            OlapContext.Companion.pop(this._workerStater);
            throw ex;
        }
    }

    public /* synthetic */ ParallelQueryReader(IQuerySession iQuerySession, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = CommonTypesKt.getDefaultWorkerCount() - 1;
        }
        this(iQuerySession, n);
    }

    private final Function0<Unit> createWorker() {
        Function0 function0;
        if (this._workerCount < this.maxWorkerCount && this._endWorkerCount == 0 && !this._isMainReaderEnd) {
            int n = this._workerCount;
            this._workerCount = n + 1;
            function0 = (Function0)new Function0<Unit>((Object)this){

                public final void invoke() {
                    ParallelQueryReader.access$readerJob((ParallelQueryReader)this.receiver);
                }
            };
        } else {
            function0 = null;
        }
        return function0;
    }

    private final void readerJob() {
        if (this._isMainReaderEnd || this._endWorkerCount > 0) {
            this._valuesQueue.put(EndFlag.INSTANCE);
            return;
        }
        IQueryReader reader = this.querySession.createReader();
        OlapContext.Companion.newContext(this.mainOlapContext, (Function0)new Function0<Unit>(reader, this){
            final /* synthetic */ IQueryReader $reader;
            final /* synthetic */ ParallelQueryReader this$0;
            {
                this.$reader = $reader;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                ISelectFieldCollection fields2 = this.$reader.getSelectFields();
                IContinueToken cancelToken = CancellableToken.INSTANCE.getContinueToken();
                while (cancelToken.canContinue() && this.$reader.next()) {
                    int n = 0;
                    int n2 = fields2.getCount();
                    Object[] objectArray = new Object[n2];
                    while (n < n2) {
                        int n3 = n++;
                        objectArray[n3] = ((ISelectField)fields2.get(n3)).getCurrentValue();
                    }
                    Object[] values = objectArray;
                    ParallelQueryReader.access$get_valuesQueue$p(this.this$0).put(values);
                }
            }
        }, readerJob.2.INSTANCE, (Function0<Unit>)((Function0)new Function0<Unit>(this, reader){
            final /* synthetic */ ParallelQueryReader this$0;
            final /* synthetic */ IQueryReader $reader;
            {
                this.this$0 = $receiver;
                this.$reader = $reader;
                super(0);
            }

            public final void invoke() {
                ParallelQueryReader.access$get_valuesQueue$p(this.this$0).put(EndFlag.INSTANCE);
                this.$reader.close();
            }
        }));
    }

    @Override
    @NotNull
    public ISelectFieldCollection getSelectFields() {
        return this._fields;
    }

    @Override
    public boolean next() {
        boolean bl;
        if (this._workerCount == 0) {
            if (this._mainReader.next()) {
                bl = true;
            } else {
                this._isMainReaderEnd = true;
                bl = this.nextForParallel();
            }
        } else {
            bl = this.nextForParallel();
        }
        return bl;
    }

    private final boolean nextForParallel() {
        while (!this.isEOF()) {
            Object values = this._isMainReaderEnd ? this._valuesQueue.poll(1L, TimeUnit.MILLISECONDS) : this._valuesQueue.poll();
            if (values instanceof Object[]) {
                this._queueValues.setCurrent((Object[])values);
                return true;
            }
            if (values == EndFlag.INSTANCE) {
                int n = this._endWorkerCount;
                this._endWorkerCount = n + 1;
                continue;
            }
            if (values == null) {
                if (this._isMainReaderEnd) continue;
                if (this._mainReader.next()) {
                    this._queueValues.setCurrent(null);
                    return true;
                }
                this._isMainReaderEnd = true;
                continue;
            }
            throw new NotSupportedException("not support data " + values);
        }
        return false;
    }

    private final boolean isEOF() {
        return this._isMainReaderEnd && this._endWorkerCount >= this._workerCount;
    }

    @Override
    public void close() {
        OlapContext.Companion.pop(this._workerStater);
        this._mainReader.close();
        if (this._endWorkerCount < this._workerCount) {
            ICancellable iCancellable = OlapContext.Companion.tryGetContext(ICancellable.class);
            if (iCancellable != null) {
                iCancellable.cancel(new CancellationException("LockedQueryReader.close"));
            }
            this._valuesQueue.clear();
        }
        this._workerStater.waitWorkers();
    }

    public final int getOtherWorkerCount() {
        return this._workerCount;
    }

    public static final /* synthetic */ void access$readerJob(ParallelQueryReader $this) {
        $this.readerJob();
    }

    public static final /* synthetic */ LinkedBlockingQueue access$get_valuesQueue$p(ParallelQueryReader $this) {
        return $this._valuesQueue;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lkd/bos/olapServer2/selects/ParallelQueryReader$EndFlag;", "", "()V", "bos-olap-core2"})
    private static final class EndFlag {
        @NotNull
        public static final EndFlag INSTANCE = new EndFlag();

        private EndFlag() {
        }
    }
}

