/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.selects;

import kd.bos.olapServer2.collections.IIterator;
import kd.bos.olapServer2.performanceStatistics.CommandStatisticsItem;
import kd.bos.olapServer2.performanceStatistics.StandardCommandStatistics;
import kd.bos.olapServer2.query.IRowIndexIterator;
import kd.bos.olapServer2.selects.ConcurrentQueryJob;
import kd.bos.olapServer2.selects.IQueryReader;
import kd.bos.olapServer2.selects.ISelectFieldCollection;
import kd.bos.olapServer2.selects.PartitionConcurrentQueryTask;
import kd.bos.olapServer2.selects.PartitionQuerySession;
import kd.bos.olapServer2.selects.PartitionSelectFieldCollection;
import kd.bos.olapServer2.selects.QueryReader;
import kd.bos.olapServer2.selects.SelectFieldCollection;
import kd.bos.olapServer2.storages.PartitionCubeWorkspace;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\f\u0010\u0016\u001a\u00060\fj\u0002`\u0017H\u0002J\f\u0010\u0018\u001a\u00060\fj\u0002`\u0017H\u0016J\b\u0010\u0019\u001a\u00020\fH\u0002R\u001c\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lkd/bos/olapServer2/selects/PartitionQueryReader;", "Lkd/bos/olapServer2/selects/IQueryReader;", "session", "Lkd/bos/olapServer2/selects/PartitionQuerySession;", "(Lkd/bos/olapServer2/selects/PartitionQuerySession;)V", "_currentPartitionJob", "Lkd/bos/olapServer2/selects/ConcurrentQueryJob;", "Lkd/bos/olapServer2/storages/PartitionCubeWorkspace;", "Lkd/bos/olapServer2/selects/PartitionConcurrentQueryTask;", "_currentQueryIterator", "Lkd/bos/olapServer2/collections/IIterator;", "_isFirstLoopPartition", "", "_selectCount", "", "_selectFields", "Lkd/bos/olapServer2/selects/ISelectFieldCollection;", "selectFields", "getSelectFields", "()Lkd/bos/olapServer2/selects/ISelectFieldCollection;", "close", "", "incSelectCount", "Lkd/bos/olapServer2/common/bool;", "next", "nextPartitionCubeWorkspace", "bos-olap-core2"})
public final class PartitionQueryReader
implements IQueryReader {
    @NotNull
    private final PartitionQuerySession session;
    @Nullable
    private ConcurrentQueryJob<PartitionCubeWorkspace, PartitionConcurrentQueryTask> _currentPartitionJob;
    @NotNull
    private IIterator _currentQueryIterator;
    @NotNull
    private final ISelectFieldCollection _selectFields;
    private boolean _isFirstLoopPartition;
    private long _selectCount;

    public PartitionQueryReader(@NotNull PartitionQuerySession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.session = session;
        this._currentQueryIterator = IRowIndexIterator.Empty.INSTANCE;
        this._selectFields = SelectFieldCollection.Companion.createPartitionProxySelectFields(this.session.getQuery());
        this._isFirstLoopPartition = true;
    }

    @Override
    @NotNull
    public ISelectFieldCollection getSelectFields() {
        return this._selectFields;
    }

    @Override
    public boolean next() {
        return this._currentQueryIterator.next() && this.incSelectCount() || this.nextPartitionCubeWorkspace();
    }

    private final boolean incSelectCount() {
        long l = this._selectCount;
        this._selectCount = l + 1L;
        return true;
    }

    private final boolean nextPartitionCubeWorkspace() {
        ConcurrentQueryJob nextJob;
        PartitionConcurrentQueryTask nextCubePartition;
        QueryReader currentReader;
        IIterator currentItr;
        do {
            int n;
            ConcurrentQueryJob<PartitionCubeWorkspace, PartitionConcurrentQueryTask> currentJob;
            if ((currentJob = this._currentPartitionJob) != null) {
                currentJob.exit();
                n = currentJob.getTask().getIndex();
            } else {
                n = -1;
            }
            int currentPartitionIndex = n;
            nextCubePartition = null;
            if (this._isFirstLoopPartition && (nextCubePartition = this.session.getNextCubeQueryPartitionOnFirstLoop$bos_olap_core2(currentPartitionIndex)) == null) {
                this._isFirstLoopPartition = false;
                this._currentPartitionJob = null;
                currentPartitionIndex = -1;
            }
            if (nextCubePartition == null) {
                PartitionConcurrentQueryTask partitionConcurrentQueryTask = this.session.getNextCubeQueryPartition$bos_olap_core2(currentPartitionIndex);
                if (partitionConcurrentQueryTask == null) {
                    return false;
                }
                nextCubePartition = partitionConcurrentQueryTask;
            }
            nextJob = new ConcurrentQueryJob(nextCubePartition);
            this._currentPartitionJob = nextJob;
        } while (!(currentItr = (currentReader = nextCubePartition.getQuerySession().createReader(nextJob)).createIterator(this.session.getQuery())).next());
        PartitionSelectFieldCollection.INSTANCE.updateProxyField(this._selectFields, (PartitionCubeWorkspace)nextCubePartition.getCubeWorkspace(), currentReader, nextCubePartition.getQuerySession());
        this._currentQueryIterator = currentItr;
        return this.incSelectCount();
    }

    @Override
    public void close() {
        ConcurrentQueryJob<PartitionCubeWorkspace, PartitionConcurrentQueryTask> concurrentQueryJob = this._currentPartitionJob;
        if (concurrentQueryJob != null) {
            concurrentQueryJob.close();
        }
        if (this._selectCount > 0L) {
            StandardCommandStatistics.INSTANCE.inc(CommandStatisticsItem.Companion.getSelectCount(), this._selectCount);
            this._selectCount = 0L;
        }
    }
}

