/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.server;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.olapServer2.asyncTasks.CubeTask;
import kd.bos.olapServer2.asyncTasks.CubeTaskChartData;
import kd.bos.olapServer2.backup.BackupCommandExecutor;
import kd.bos.olapServer2.backup.RecoveryCommandExecutor;
import kd.bos.olapServer2.backup.RedoTraceIterableWrapper;
import kd.bos.olapServer2.backup.TransactionTraceQueryExecutor;
import kd.bos.olapServer2.common.CommandTypes;
import kd.bos.olapServer2.common.CommonTypesKt;
import kd.bos.olapServer2.common.ImmutablePropertyBag;
import kd.bos.olapServer2.common.NotSupportedException;
import kd.bos.olapServer2.common.OlapContext;
import kd.bos.olapServer2.common.Paths;
import kd.bos.olapServer2.computingEngine.ComputingCommandExecutor;
import kd.bos.olapServer2.dataSources.BackupCommandInfo;
import kd.bos.olapServer2.dataSources.ComputingCommandInfo;
import kd.bos.olapServer2.dataSources.FunctionCommandInfo;
import kd.bos.olapServer2.dataSources.MemberMetadataItem;
import kd.bos.olapServer2.dataSources.MetadataCommandInfo;
import kd.bos.olapServer2.dataSources.MetadataItem;
import kd.bos.olapServer2.dataSources.RecoveryCommandInfo;
import kd.bos.olapServer2.dataSources.SaveCommandInfo;
import kd.bos.olapServer2.dataSources.SelectCommandInfo;
import kd.bos.olapServer2.dataSources.TimeBackupCommandInfo;
import kd.bos.olapServer2.function.FunctionCommandExecutor;
import kd.bos.olapServer2.function.FunctionDefine;
import kd.bos.olapServer2.function.FunctionInfo;
import kd.bos.olapServer2.metadata.Cube;
import kd.bos.olapServer2.metadata.Dimension;
import kd.bos.olapServer2.metadata.Measure;
import kd.bos.olapServer2.metadata.Member;
import kd.bos.olapServer2.metadata.MemberCollection;
import kd.bos.olapServer2.metadata.MemberStorageTypes;
import kd.bos.olapServer2.metadata.MetadataCommandExecutor;
import kd.bos.olapServer2.metadata.MetadataTypes;
import kd.bos.olapServer2.metadata.OlapMetadata;
import kd.bos.olapServer2.metadata.builds.CubeEntry;
import kd.bos.olapServer2.metadata.partitions.CachePartitionItem;
import kd.bos.olapServer2.metadata.partitions.EmptyPartitionItemCollection;
import kd.bos.olapServer2.metadata.partitions.IPartitionItemCollection;
import kd.bos.olapServer2.metadata.sandboxs.MetadataSandboxCommandExecutor;
import kd.bos.olapServer2.monitorReports.OlapHealthReportContainer;
import kd.bos.olapServer2.performanceStatistics.BenchmarkTaskBuilder;
import kd.bos.olapServer2.query.SelectCommandExecutor;
import kd.bos.olapServer2.replication.BackupRecordWorkspace;
import kd.bos.olapServer2.replication.BackupType;
import kd.bos.olapServer2.replication.IReplicationNode;
import kd.bos.olapServer2.replication.OlapBackupCommandExecutor;
import kd.bos.olapServer2.replication.OlapLogger;
import kd.bos.olapServer2.replication.OlapRecoveryCommandExecutor;
import kd.bos.olapServer2.replication.RecoveryFiles;
import kd.bos.olapServer2.replication.ReplicationContext;
import kd.bos.olapServer2.replication.ReplicationMaster;
import kd.bos.olapServer2.replication.ReplicationNone;
import kd.bos.olapServer2.replication.ReplicationStatus;
import kd.bos.olapServer2.replication.TimeCubeBackupCommandExecutor;
import kd.bos.olapServer2.security.AccessStrategyCollection;
import kd.bos.olapServer2.security.OlapActions;
import kd.bos.olapServer2.server.IOlapLogger;
import kd.bos.olapServer2.server.OlapServer;
import kd.bos.olapServer2.server.OlapSession;
import kd.bos.olapServer2.server.ReplicationNodeProxy;
import kd.bos.olapServer2.server.ReplicationWorkspace;
import kd.bos.olapServer2.storages.CubeWorkspace;
import kd.bos.olapServer2.storages.CubeWorkspaceUtils;
import kd.bos.olapServer2.storages.OlapWorkspace;
import kd.bos.olapServer2.storages.SaveCommandExecutor;
import kd.bos.olapServer2.storages.plugins.OlapWorkspacePlugin;
import kd.bos.olapServer2.storages.plugins.OlapWorkspacePluginContext;
import kd.bos.olapServer2.storages.plugins.PluginCollection;
import kd.bos.olapServer2.tools.FileTools;
import kd.bos.olapServer2.tools.JsonHelper;
import kd.bos.olapServer2.tools.Res;
import kd.bos.olapServer2.transactions.ITransaction;
import kd.bos.olapServer2.transactions.TransactionTypes;
import kd.bos.olapServer2.transactions.WriteTransaction;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00de\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010(\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0002\u00a3\u0001B+\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\b\u0002\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u0012\f\b\u0002\u0010\u0007\u001a\u00060\bj\u0002`\t\u00a2\u0006\u0002\u0010\nB1\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u0012\f\b\u0002\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u0012\f\b\u0002\u0010\u0007\u001a\u00060\bj\u0002`\t\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\"\u0010/\u001a\u00060\bj\u0002`\t2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u000205J\"\u00106\u001a\u0002072\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;2\n\u0010<\u001a\u00060\u0005j\u0002`\u0006J\u001a\u0010=\u001a\u00020>2\n\u0010?\u001a\u00060\u0003j\u0002`\u00102\u0006\u0010@\u001a\u00020AJ\u0012\u0010B\u001a\u0002072\n\u0010?\u001a\u00060\u0003j\u0002`\u0010J*\u0010C\u001a\u0002072\n\u0010?\u001a\u00060\u0003j\u0002`\u00102\n\u0010D\u001a\u00060Ej\u0002`F2\n\u0010G\u001a\u00060\bj\u0002`\tJ\u0006\u0010H\u001a\u000207J\u000e\u0010I\u001a\u0002072\u0006\u0010:\u001a\u00020;J\u0006\u0010J\u001a\u000207J\u0006\u0010K\u001a\u000207J\b\u0010L\u001a\u000207H\u0016J\u0016\u0010M\u001a\u0002072\u0006\u0010N\u001a\u00020O2\u0006\u00102\u001a\u000203J\u0006\u0010P\u001a\u00020QJ6\u0010R\u001a\u0002072\u0006\u00102\u001a\u0002032\n\u0010?\u001a\u00060\u0003j\u0002`\u00102\f\u0010S\u001a\b\u0012\u0004\u0012\u00020\u00030T2\f\u0010U\u001a\b\u0012\u0004\u0012\u00020\u00030TJ\u0006\u0010V\u001a\u000207J7\u0010W\u001a\u0002HX\"\u0004\b\u0000\u0010X2\u0006\u00102\u001a\u0002032\u0006\u0010Y\u001a\u00020Z2\u0012\u0010[\u001a\u000e\u0012\u0004\u0012\u00020]\u0012\u0004\u0012\u0002HX0\\H\u0002\u00a2\u0006\u0002\u0010^J\u0016\u0010_\u001a\u00020`2\u0006\u0010a\u001a\u00020b2\u0006\u00102\u001a\u000203J\f\u0010c\u001a\b\u0012\u0004\u0012\u00020\u00030TJ!\u0010d\u001a\f\u0012\b\u0012\u00060\u0003j\u0002`\u00100e2\n\u0010?\u001a\u00060\u0003j\u0002`\u0010\u00a2\u0006\u0002\u0010fJ\u0016\u0010g\u001a\u00060\u0003j\u0002`\u00102\n\u0010?\u001a\u00060\u0003j\u0002`\u0010J&\u0010h\u001a\u0016\u0012\b\u0012\u00060\u0003j\u0002`\u0010\u0012\b\u0012\u00060\u0003j\u0002`\u00100i2\n\u0010?\u001a\u00060\u0003j\u0002`\u0010J\u0016\u0010j\u001a\u00060\u0003j\u0002`\u00102\n\u0010?\u001a\u00060\u0003j\u0002`\u0010J\u0010\u0010k\u001a\f\u0012\b\u0012\u00060\u0003j\u0002`\u00100TJ\u0016\u0010l\u001a\u00060\u0003j\u0002`\u00102\n\u0010?\u001a\u00060\u0003j\u0002`\u0010J\f\u0010m\u001a\b\u0012\u0004\u0012\u00020o0nJ\u0012\u0010p\u001a\u00020q2\n\u0010r\u001a\u00060\u0003j\u0002`\u0010J8\u0010s\u001a\u001c\u0012\u0018\u0012\u0016\u0012\b\u0012\u00060\u0003j\u0002`\u0010\u0012\b\u0012\u00060\u0003j\u0002`\u00100i0t2\n\u0010?\u001a\u00060\u0003j\u0002`\u00102\n\u0010u\u001a\u00060\u0003j\u0002`\u0010JW\u0010v\u001a\u00020w2\n\u0010?\u001a\u00060\u0003j\u0002`\u00102\u001a\u0010x\u001a\u0016\u0012\b\u0012\u00060\u0003j\u0002`\u0010\u0012\b\u0012\u00060\u0003j\u0002`\u00100i2\n\u0010y\u001a\u00060\u0003j\u0002`\u00102\u000e\u0010z\u001a\n\u0018\u00010\bj\u0004\u0018\u0001`\t2\u0006\u0010{\u001a\u00020|\u00a2\u0006\u0002\u0010}J\u0017\u0010~\u001a\u0013\u0012\b\u0012\u00060\u0003j\u0002`\u0010\u0012\u0005\u0012\u00030\u0080\u00010\u007fJ\u0017\u0010\u0081\u0001\u001a\u00060\bj\u0002`\t2\n\u0010?\u001a\u00060\u0003j\u0002`\u0010J\u0017\u0010\u0082\u0001\u001a\u00060\bj\u0002`\t2\n\u0010?\u001a\u00060\u0003j\u0002`\u0010J\u000b\u0010\u0083\u0001\u001a\u00060\u0005j\u0002`\u0006J\u0019\u0010\u0084\u0001\u001a\u00020\u00032\b\u0010\u0085\u0001\u001a\u00030\u0086\u00012\u0006\u00102\u001a\u000203J7\u0010\u0084\u0001\u001a\u0002072\b\u0010\u0085\u0001\u001a\u00030\u0086\u00012\u0006\u00102\u001a\u0002032\u001c\u0010\u0087\u0001\u001a\u0017\u0012\r\u0012\u000b\u0012\u0007\u0012\u0005\u0018\u00010\u0080\u00010e\u0012\u0004\u0012\u0002070\\J\u000b\u0010\u0088\u0001\u001a\u00060\u0003j\u0002`\u0010J\"\u0010\u0089\u0001\u001a\u0002072\b\u0010\u0085\u0001\u001a\u00030\u0086\u00012\u0006\u00102\u001a\u0002032\u0007\u0010\u008a\u0001\u001a\u000205J6\u0010\u008b\u0001\u001a\u0002072\b\u0010\u008c\u0001\u001a\u00030\u008d\u00012\u0006\u00102\u001a\u0002032\b\u0010\u008e\u0001\u001a\u00030\u008f\u00012\u0011\b\u0002\u0010\u0090\u0001\u001a\n\u0018\u00010\u0003j\u0004\u0018\u0001`\u0010J \u0010\u0091\u0001\u001a\u0002072\n\u0010%\u001a\u00060\u0003j\u0002`\u00102\u000b\u0010\u0092\u0001\u001a\u00060\u0003j\u0002`\u0010J\u0007\u0010\u0093\u0001\u001a\u000207J\u0007\u0010\u0094\u0001\u001a\u000207J \u0010\u0095\u0001\u001a\u0002072\u0007\u00100\u001a\u00030\u0096\u00012\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u000205J\u0019\u0010\u0097\u0001\u001a\u0002072\b\u0010\u0098\u0001\u001a\u00030\u0099\u00012\u0006\u00102\u001a\u000203J\u001c\u0010\u009a\u0001\u001a\u0002072\t\u0010\u009b\u0001\u001a\u0004\u0018\u00010]2\u0006\u0010[\u001a\u00020ZH\u0002J#\u0010\u009c\u0001\u001a\u0002072\b\u0010\u009d\u0001\u001a\u00030\u009e\u00012\b\u0010\u009f\u0001\u001a\u00030\u00a0\u00012\u0006\u00102\u001a\u000203J2\u0010\u009c\u0001\u001a\u0002072\b\u0010\u009d\u0001\u001a\u00030\u009e\u00012\u0017\u0010\u00a1\u0001\u001a\u0012\u0012\r\u0012\u000b\u0012\u0007\u0012\u0005\u0018\u00010\u0080\u00010e0\u00a2\u00012\u0006\u00102\u001a\u000203R\u0015\u0010\u000f\u001a\u00060\u0003j\u0002`\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u000b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001aX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001d\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020 0\u001e8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0015\u0010#\u001a\u00060\u0003j\u0002`\u00108F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u0012R\u0015\u0010%\u001a\u00060\u0003j\u0002`\u00108F\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u0012R\u0014\u0010'\u001a\u00020(X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0011\u0010+\u001a\u00020,8F\u00a2\u0006\u0006\u001a\u0004\b-\u0010.\u00a8\u0006\u00a4\u0001"}, d2={"Lkd/bos/olapServer2/server/OlapServer;", "Ljava/io/Closeable;", "rootPath", "", "startGC", "", "Lkd/bos/olapServer2/common/bool;", "gcTimePeriod", "", "Lkd/bos/olapServer2/common/long;", "(Ljava/lang/String;ZJ)V", "databasePath", "replicationContext", "Lkd/bos/olapServer2/replication/ReplicationContext;", "(Ljava/lang/String;ZJLkd/bos/olapServer2/replication/ReplicationContext;)V", "backupPath", "Lkd/bos/olapServer2/common/string;", "getBackupPath", "()Ljava/lang/String;", "healthReports", "Lkd/bos/olapServer2/monitorReports/OlapHealthReportContainer;", "getHealthReports", "()Lkd/bos/olapServer2/monitorReports/OlapHealthReportContainer;", "isMaster", "()Z", "olapWorkspace", "Lkd/bos/olapServer2/storages/OlapWorkspace;", "getOlapWorkspace$bos_olap_core2", "()Lkd/bos/olapServer2/storages/OlapWorkspace;", "plugins", "Lkd/bos/olapServer2/storages/plugins/PluginCollection;", "Lkd/bos/olapServer2/storages/plugins/OlapWorkspacePlugin;", "Lkd/bos/olapServer2/storages/plugins/OlapWorkspacePluginContext;", "getPlugins", "()Lkd/bos/olapServer2/storages/plugins/PluginCollection;", "proxyToken", "getProxyToken", "redoPath", "getRedoPath", "replicationWorkspace", "Lkd/bos/olapServer2/server/ReplicationWorkspace;", "getReplicationWorkspace$bos_olap_core2", "()Lkd/bos/olapServer2/server/ReplicationWorkspace;", "status", "Lkd/bos/olapServer2/replication/ReplicationStatus;", "getStatus", "()Lkd/bos/olapServer2/replication/ReplicationStatus;", "backup", "backupCommandInfo", "Lkd/bos/olapServer2/dataSources/BackupCommandInfo;", "session", "Lkd/bos/olapServer2/server/OlapSession;", "outputStream", "Ljava/io/OutputStream;", "backupOlap", "", "backupType", "Lkd/bos/olapServer2/replication/BackupType;", "logger", "Lkd/bos/olapServer2/server/IOlapLogger;", "isReport", "beginTransaction", "Lkd/bos/olapServer2/transactions/ITransaction;", "cubeName", "type", "Lkd/bos/olapServer2/transactions/TransactionTypes;", "cancelCubeTasks", "cancelSingleTask", "partitionId", "", "Lkd/bos/olapServer2/common/int;", "taskId", "checkExecuteByFreeSpace", "cleanBackupFiles", "cleanDSCacheFolder", "cleanRecoveryTmpFiles", "close", "computing", "computingCommand", "Lkd/bos/olapServer2/dataSources/ComputingCommandInfo;", "currentNode", "Lkd/bos/olapServer2/replication/IReplicationNode;", "exchangeDCAndDCS", "dynamicCalcDims", "", "dynamicCalcAndStoreDims", "executeBenchmarkTask", "executeCommand", "R", "actionCode", "Lkd/bos/olapServer2/security/OlapActions;", "action", "Lkotlin/Function1;", "Lkd/bos/olapServer2/storages/CubeWorkspace;", "(Lkd/bos/olapServer2/server/OlapSession;Lkd/bos/olapServer2/security/OlapActions;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "executeFunction", "Lkd/bos/olapServer2/common/ImmutablePropertyBag;", "functionCommandInfo", "Lkd/bos/olapServer2/dataSources/FunctionCommandInfo;", "getBackupRecords", "getCubeMeasures", "", "(Ljava/lang/String;)[Ljava/lang/String;", "getCubeMetadata", "getCubeProperties", "", "getCubeTasks", "getCubes", "getDynamicCalcDimensions", "getFunctionDefines", "", "Lkd/bos/olapServer2/function/FunctionDefine;", "getFunctionInfo", "Lkd/bos/olapServer2/function/FunctionInfo;", "name", "getMembers", "Lkotlin/sequences/Sequence;", "dimName", "getRedoTraceInfo", "Lkd/bos/olapServer2/backup/RedoTraceIterableWrapper;", "cellKey", "measureName", "token", "deadlineTime", "Ljava/time/LocalDateTime;", "(Ljava/lang/String;Ljava/util/Map;Ljava/lang/String;Ljava/lang/Long;Ljava/time/LocalDateTime;)Lkd/bos/olapServer2/backup/RedoTraceIterableWrapper;", "getReplicationDisplayInfo", "Ljava/util/HashMap;", "", "getRowCount", "getTransactionVersion", "isNoneNode", "query", "selectCommand", "Lkd/bos/olapServer2/dataSources/SelectCommandInfo;", "consumer", "queryConcatMeInfo", "queryStream", "outStream", "recovery", "command", "Lkd/bos/olapServer2/dataSources/RecoveryCommandInfo;", "webInputStream", "Ljava/io/InputStream;", "fileName", "recoveryOlap", "backupFileDirPath", "slaveToMaster", "start", "timeBackup", "Lkd/bos/olapServer2/dataSources/TimeBackupCommandInfo;", "updateMetadata", "metadataCommand", "Lkd/bos/olapServer2/dataSources/MetadataCommandInfo;", "verify", "cubeWorkspace", "write", "saveInfo", "Lkd/bos/olapServer2/dataSources/SaveCommandInfo;", "reader", "Ljava/io/BufferedReader;", "dataValuesList", "", "DimensionsVO", "bos-olap-core2"})
@SourceDebugExtension(value={"SMAP\nOlapServer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OlapServer.kt\nkd/bos/olapServer2/server/OlapServer\n+ 2 OlapContext.kt\nkd/bos/olapServer2/common/OlapContext$Companion\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 6 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,667:1\n120#2,6:668\n1549#3:674\n1620#3,3:675\n1549#3:679\n1620#3,3:680\n1855#3:687\n1856#3:690\n1855#3,2:691\n1855#3,2:693\n1855#3,2:695\n1855#3,2:697\n26#4:678\n37#5,2:683\n13309#6,2:685\n13309#6,2:688\n*S KotlinDebug\n*F\n+ 1 OlapServer.kt\nkd/bos/olapServer2/server/OlapServer\n*L\n94#1:668,6\n385#1:674\n385#1:675,3\n405#1:679\n405#1:680,3\n500#1:687\n500#1:690\n586#1:691,2\n655#1:693,2\n656#1:695,2\n644#1:697,2\n404#1:678\n405#1:683,2\n479#1:685,2\n503#1:688,2\n*E\n"})
public final class OlapServer
implements Closeable {
    @NotNull
    private final String databasePath;
    @NotNull
    private final OlapWorkspace olapWorkspace;
    @NotNull
    private final ReplicationWorkspace replicationWorkspace;
    @NotNull
    private final OlapHealthReportContainer healthReports;

    /*
     * WARNING - void declaration
     */
    public OlapServer(@NotNull String databasePath, boolean startGC, long gcTimePeriod, @NotNull ReplicationContext replicationContext) {
        OlapWorkspace olapWorkspace;
        Intrinsics.checkNotNullParameter((Object)databasePath, (String)"databasePath");
        Intrinsics.checkNotNullParameter((Object)replicationContext, (String)"replicationContext");
        this.databasePath = databasePath;
        OlapWorkspace olapWorkspace2 = olapWorkspace = new OlapWorkspace(OlapMetadata.Companion.ReadFrom(this.databasePath), this.databasePath);
        OlapServer olapServer = this;
        boolean bl = false;
        if (startGC) {
            void $this$olapWorkspace_u24lambda_u240;
            $this$olapWorkspace_u24lambda_u240.startGC(gcTimePeriod);
        }
        olapServer.olapWorkspace = olapWorkspace;
        this.replicationWorkspace = new ReplicationWorkspace(this.olapWorkspace, replicationContext);
        this.healthReports = new OlapHealthReportContainer(this.olapWorkspace);
    }

    public /* synthetic */ OlapServer(String string2, boolean bl, long l, ReplicationContext replicationContext, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            l = -1L;
        }
        this(string2, bl, l, replicationContext);
    }

    public OlapServer(@NotNull String rootPath, boolean startGC, long gcTimePeriod) {
        Intrinsics.checkNotNullParameter((Object)rootPath, (String)"rootPath");
        this(rootPath, startGC, gcTimePeriod, ReplicationContext.Companion.getEmptyContext());
    }

    public /* synthetic */ OlapServer(String string2, boolean bl, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            l = -1L;
        }
        this(string2, bl, l);
    }

    @NotNull
    public final OlapWorkspace getOlapWorkspace$bos_olap_core2() {
        return this.olapWorkspace;
    }

    @NotNull
    public final ReplicationWorkspace getReplicationWorkspace$bos_olap_core2() {
        return this.replicationWorkspace;
    }

    @NotNull
    public final String getProxyToken() {
        return this.replicationWorkspace.getCurrentNode().getContext().getProxyToken();
    }

    public final boolean isNoneNode() {
        return this.replicationWorkspace.getCurrentNode().getValue() instanceof ReplicationNone;
    }

    public final boolean isMaster() {
        return this.replicationWorkspace.isMaster();
    }

    @NotNull
    public final IReplicationNode currentNode() {
        return this.replicationWorkspace.getCurrentNode().getValue();
    }

    public final void start() {
        this.replicationWorkspace.getCurrentNode().getValue().start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void backupOlap(@NotNull BackupType backupType, @NotNull IOlapLogger logger2, boolean isReport) {
        Intrinsics.checkNotNullParameter((Object)((Object)backupType), (String)"backupType");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        try {
            OlapContext.Companion this_$iv = OlapContext.Companion;
            boolean $i$f$withContext = false;
            try {
                this_$iv.push(logger2);
                boolean bl = false;
                logger2.info("start total backup, backupPoint: " + this.replicationWorkspace.getCurrentNode().getValue().getCurrentLSN() + "...");
                new OlapBackupCommandExecutor(this.replicationWorkspace, backupType).run();
                logger2.info("total backup finish. endPoint: " + this.replicationWorkspace.getCurrentNode().getValue().getCurrentLSN());
                this.cleanBackupFiles(logger2);
                Unit unit = Unit.INSTANCE;
            }
            finally {
                this_$iv.pop(logger2);
            }
        }
        catch (Throwable t2) {
            String reportMessage = "TotalBackupFailed: " + t2.getMessage();
            if (isReport) {
                logger2.reportAndError("TotalBackupFailed-" + new Date(), null, reportMessage, t2);
            }
            throw t2;
        }
    }

    public final void recoveryOlap(@NotNull String redoPath, @NotNull String backupFileDirPath) {
        Intrinsics.checkNotNullParameter((Object)redoPath, (String)"redoPath");
        Intrinsics.checkNotNullParameter((Object)backupFileDirPath, (String)"backupFileDirPath");
        new OlapRecoveryCommandExecutor(this.replicationWorkspace, redoPath, backupFileDirPath).run();
    }

    @NotNull
    public final List<String> getBackupRecords() {
        String backupPath = this.replicationWorkspace.getCurrentNode().getConf().get_node().getBackupPath();
        String[] stringArray = new String[]{"backup.record"};
        String backupRecordPath = ((Object)Paths.INSTANCE.get(backupPath, stringArray)).toString();
        if (((CharSequence)backupPath).length() == 0 || !FileTools.INSTANCE.isExist(backupRecordPath)) {
            return CollectionsKt.emptyList();
        }
        return BackupRecordWorkspace.getBackupRecords$default(this.replicationWorkspace.getBackupRecordWorkspace(), 0, false, 3, null);
    }

    @NotNull
    public final HashMap<String, Object> getReplicationDisplayInfo() {
        return this.replicationWorkspace.getCurrentNode().getValue().getDisplayInfo();
    }

    public final void slaveToMaster() {
        this.replicationWorkspace.slaveToMaster();
    }

    @NotNull
    public final String getRedoPath() {
        ReplicationNodeProxy currentNode = this.replicationWorkspace.getCurrentNode();
        if (currentNode.getValue() instanceof ReplicationNone) {
            throw new NotSupportedException("None node can't get redoPath");
        }
        return this.replicationWorkspace.getCurrentNode().getConf().get_node().getRedoPath();
    }

    @NotNull
    public final String getBackupPath() {
        return this.replicationWorkspace.getCurrentNode().getConf().get_node().getBackupPath();
    }

    @NotNull
    public final OlapHealthReportContainer getHealthReports() {
        return this.healthReports;
    }

    private final void verify(CubeWorkspace cubeWorkspace, OlapActions action) {
        block0: {
            this.olapWorkspace.getAccessStrategies().verify(action);
            Object object2 = cubeWorkspace;
            if (object2 == null || (object2 = ((CubeWorkspace)object2).getAccessStrategies()) == null) break block0;
            ((AccessStrategyCollection)object2).verify(action);
        }
    }

    @NotNull
    public final ITransaction beginTransaction(@NotNull String cubeName, @NotNull TransactionTypes type) {
        Intrinsics.checkNotNullParameter((Object)cubeName, (String)"cubeName");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        CubeWorkspace cubeWorkspace = this.olapWorkspace.getCubeWorkspace(cubeName);
        IReplicationNode node = this.replicationWorkspace.getCurrentNode().getValue();
        return cubeWorkspace.getTransactionManager().beginTransaction(type, node);
    }

    public final long backup(@NotNull BackupCommandInfo backupCommandInfo, @NotNull OlapSession session, @NotNull OutputStream outputStream) {
        Intrinsics.checkNotNullParameter((Object)backupCommandInfo, (String)"backupCommandInfo");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        if (!(session.getSandBoxIdentity() == null)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        String cubeName = session.getCubeName();
        return ((Number)this.olapWorkspace.enterReadForBackup(cubeName, (Function2)new Function2<CubeWorkspace, Closeable, Long>(this, backupCommandInfo, outputStream){
            final /* synthetic */ OlapServer this$0;
            final /* synthetic */ BackupCommandInfo $backupCommandInfo;
            final /* synthetic */ OutputStream $outputStream;
            {
                this.this$0 = $receiver;
                this.$backupCommandInfo = $backupCommandInfo;
                this.$outputStream = $outputStream;
                super(2);
            }

            @NotNull
            public final Long invoke(@NotNull CubeWorkspace cubeWorkspace, @NotNull Closeable lock) {
                Intrinsics.checkNotNullParameter((Object)cubeWorkspace, (String)"cubeWorkspace");
                Intrinsics.checkNotNullParameter((Object)lock, (String)"lock");
                OlapServer.access$verify(this.this$0, cubeWorkspace, OlapActions.ActionCubeBackup);
                BackupCommandExecutor executor = new BackupCommandExecutor(this.$backupCommandInfo, cubeWorkspace, this.$outputStream, lock, OlapServer.access$getDatabasePath$p(this.this$0));
                return executor.run();
            }
        })).longValue();
    }

    public final void timeBackup(@NotNull TimeBackupCommandInfo backupCommandInfo, @NotNull OlapSession session, @NotNull OutputStream outputStream) {
        Intrinsics.checkNotNullParameter((Object)backupCommandInfo, (String)"backupCommandInfo");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        String cubeName = session.getCubeName();
        TimeCubeBackupCommandExecutor executor = new TimeCubeBackupCommandExecutor(this.replicationWorkspace, cubeName, backupCommandInfo, outputStream);
        executor.run();
    }

    public final void recovery(@NotNull RecoveryCommandInfo command, @NotNull OlapSession session, @NotNull InputStream webInputStream, @Nullable String fileName) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)webInputStream, (String)"webInputStream");
        if (!(session.getSandBoxIdentity() == null)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        String cubeName = command.getCubeName();
        this.verify(null, OlapActions.ActionCubeRecovery);
        new RecoveryCommandExecutor(this.olapWorkspace, command, cubeName, this.databasePath, webInputStream, this.olapWorkspace.assignNextId(), fileName, this.replicationWorkspace).run();
    }

    public static /* synthetic */ void recovery$default(OlapServer olapServer, RecoveryCommandInfo recoveryCommandInfo, OlapSession olapSession, InputStream inputStream, String string2, int n, Object object2) {
        if ((n & 8) != 0) {
            string2 = null;
        }
        olapServer.recovery(recoveryCommandInfo, olapSession, inputStream, string2);
    }

    @NotNull
    public final String query(@NotNull SelectCommandInfo selectCommand, @NotNull OlapSession session) {
        Intrinsics.checkNotNullParameter((Object)selectCommand, (String)"selectCommand");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Object r = this.executeCommand(session, OlapActions.ActionQuery, (Function1)new Function1<CubeWorkspace, String>(selectCommand, this){
            final /* synthetic */ SelectCommandInfo $selectCommand;
            final /* synthetic */ OlapServer this$0;
            {
                this.$selectCommand = $selectCommand;
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @NotNull
            public final String invoke(@NotNull CubeWorkspace cubeWorkspace) {
                String string2;
                Intrinsics.checkNotNullParameter((Object)cubeWorkspace, (String)"cubeWorkspace");
                SelectCommandExecutor executor = new SelectCommandExecutor(this.$selectCommand, this.this$0.getOlapWorkspace$bos_olap_core2(), cubeWorkspace);
                ByteArrayOutputStream outputSteam = new ByteArrayOutputStream();
                Closeable closeable = outputSteam;
                Throwable throwable = null;
                try {
                    ByteArrayOutputStream it = (ByteArrayOutputStream)closeable;
                    boolean bl = false;
                    executor.buildResult(outputSteam);
                    String string3 = outputSteam.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
                    string2 = string3;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                return string2;
            }
        });
        Intrinsics.checkNotNullExpressionValue(r, (String)"executeCommand(...)");
        return (String)r;
    }

    public final void queryStream(@NotNull SelectCommandInfo selectCommand, @NotNull OlapSession session, @NotNull OutputStream outStream) {
        Intrinsics.checkNotNullParameter((Object)selectCommand, (String)"selectCommand");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)outStream, (String)"outStream");
        this.executeCommand(session, OlapActions.ActionQuery, (Function1)new Function1<CubeWorkspace, Unit>(selectCommand, this, outStream){
            final /* synthetic */ SelectCommandInfo $selectCommand;
            final /* synthetic */ OlapServer this$0;
            final /* synthetic */ OutputStream $outStream;
            {
                this.$selectCommand = $selectCommand;
                this.this$0 = $receiver;
                this.$outStream = $outStream;
                super(1);
            }

            public final void invoke(@NotNull CubeWorkspace cubeWorkspace) {
                Intrinsics.checkNotNullParameter((Object)cubeWorkspace, (String)"cubeWorkspace");
                SelectCommandExecutor executor = new SelectCommandExecutor(this.$selectCommand, this.this$0.getOlapWorkspace$bos_olap_core2(), cubeWorkspace);
                executor.buildResult(this.$outStream);
            }
        });
    }

    public final void query(@NotNull SelectCommandInfo selectCommand, @NotNull OlapSession session, @NotNull Function1<? super Object[], Unit> consumer) {
        Intrinsics.checkNotNullParameter((Object)selectCommand, (String)"selectCommand");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        this.executeCommand(session, OlapActions.ActionQuery, (Function1)new Function1<CubeWorkspace, Unit>(selectCommand, this, consumer){
            final /* synthetic */ SelectCommandInfo $selectCommand;
            final /* synthetic */ OlapServer this$0;
            final /* synthetic */ Function1<Object[], Unit> $consumer;
            {
                this.$selectCommand = $selectCommand;
                this.this$0 = $receiver;
                this.$consumer = $consumer;
                super(1);
            }

            public final void invoke(@NotNull CubeWorkspace cubeWorkspace) {
                Intrinsics.checkNotNullParameter((Object)cubeWorkspace, (String)"cubeWorkspace");
                SelectCommandExecutor executor = new SelectCommandExecutor(this.$selectCommand, this.this$0.getOlapWorkspace$bos_olap_core2(), cubeWorkspace);
                executor.buildResult(this.$consumer);
            }
        });
    }

    @NotNull
    public final ImmutablePropertyBag executeFunction(@NotNull FunctionCommandInfo functionCommandInfo, @NotNull OlapSession session) {
        Intrinsics.checkNotNullParameter((Object)functionCommandInfo, (String)"functionCommandInfo");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        String cubeName = session.getCubeName();
        CubeWorkspace cubeWorkspace = null;
        if (((CharSequence)cubeName).length() > 0) {
            cubeWorkspace = session.getSandBoxIdentity() == null ? this.olapWorkspace.getCubeWorkspace(cubeName) : this.olapWorkspace.getSandboxWorkspace(cubeName, session.getSandBoxIdentity());
        }
        FunctionCommandExecutor executor = new FunctionCommandExecutor(functionCommandInfo, this.olapWorkspace, cubeWorkspace);
        return executor.execute();
    }

    public final void write(@NotNull SaveCommandInfo saveInfo, @NotNull BufferedReader reader, @NotNull OlapSession session) {
        Intrinsics.checkNotNullParameter((Object)saveInfo, (String)"saveInfo");
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.executeCommand(session, OlapActions.ActionWrite, (Function1)new Function1<CubeWorkspace, Unit>(saveInfo, reader, session){
            final /* synthetic */ SaveCommandInfo $saveInfo;
            final /* synthetic */ BufferedReader $reader;
            final /* synthetic */ OlapSession $session;
            {
                this.$saveInfo = $saveInfo;
                this.$reader = $reader;
                this.$session = $session;
                super(1);
            }

            public final void invoke(@NotNull CubeWorkspace cubeWorkspace) {
                Intrinsics.checkNotNullParameter((Object)cubeWorkspace, (String)"cubeWorkspace");
                ITransaction iTransaction = this.$session.getTransaction();
                SaveCommandExecutor executor = new SaveCommandExecutor(cubeWorkspace, this.$saveInfo, this.$reader, iTransaction instanceof WriteTransaction ? (WriteTransaction)iTransaction : null);
                executor.write();
            }
        });
    }

    public final void write(@NotNull SaveCommandInfo saveInfo, @NotNull Iterator<Object[]> dataValuesList, @NotNull OlapSession session) {
        Intrinsics.checkNotNullParameter((Object)saveInfo, (String)"saveInfo");
        Intrinsics.checkNotNullParameter(dataValuesList, (String)"dataValuesList");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.executeCommand(session, OlapActions.ActionWrite, (Function1)new Function1<CubeWorkspace, Unit>(saveInfo, dataValuesList, session){
            final /* synthetic */ SaveCommandInfo $saveInfo;
            final /* synthetic */ Iterator<Object[]> $dataValuesList;
            final /* synthetic */ OlapSession $session;
            {
                this.$saveInfo = $saveInfo;
                this.$dataValuesList = $dataValuesList;
                this.$session = $session;
                super(1);
            }

            public final void invoke(@NotNull CubeWorkspace cubeWorkspace) {
                Intrinsics.checkNotNullParameter((Object)cubeWorkspace, (String)"cubeWorkspace");
                ITransaction iTransaction = this.$session.getTransaction();
                SaveCommandExecutor executor = new SaveCommandExecutor(cubeWorkspace, this.$saveInfo, this.$dataValuesList, iTransaction instanceof WriteTransaction ? (WriteTransaction)iTransaction : null);
                executor.write();
            }
        });
    }

    public final void computing(@NotNull ComputingCommandInfo computingCommand, @NotNull OlapSession session) {
        Intrinsics.checkNotNullParameter((Object)computingCommand, (String)"computingCommand");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.executeCommand(session, OlapActions.ActionCompute, (Function1)new Function1<CubeWorkspace, Unit>(computingCommand, this, session){
            final /* synthetic */ ComputingCommandInfo $computingCommand;
            final /* synthetic */ OlapServer this$0;
            final /* synthetic */ OlapSession $session;
            {
                this.$computingCommand = $computingCommand;
                this.this$0 = $receiver;
                this.$session = $session;
                super(1);
            }

            public final void invoke(@NotNull CubeWorkspace cubeWorkspace) {
                Intrinsics.checkNotNullParameter((Object)cubeWorkspace, (String)"cubeWorkspace");
                ITransaction iTransaction = this.$session.getTransaction();
                ComputingCommandExecutor executor = new ComputingCommandExecutor(this.$computingCommand, this.this$0.getOlapWorkspace$bos_olap_core2(), cubeWorkspace, iTransaction instanceof WriteTransaction ? (WriteTransaction)iTransaction : null);
                executor.run();
            }
        });
    }

    private final <R> R executeCommand(OlapSession session, OlapActions actionCode, Function1<? super CubeWorkspace, ? extends R> action) {
        return session.getSandBoxIdentity() == null ? this.olapWorkspace.execute(session.getCubeName(), (Function1)new Function1<CubeWorkspace, R>(this, actionCode, action){
            final /* synthetic */ OlapServer this$0;
            final /* synthetic */ OlapActions $actionCode;
            final /* synthetic */ Function1<CubeWorkspace, R> $action;
            {
                this.this$0 = $receiver;
                this.$actionCode = $actionCode;
                this.$action = $action;
                super(1);
            }

            public final R invoke(@NotNull CubeWorkspace cubeWorkspace) {
                Intrinsics.checkNotNullParameter((Object)cubeWorkspace, (String)"cubeWorkspace");
                OlapServer.access$verify(this.this$0, cubeWorkspace, this.$actionCode);
                return (R)this.$action.invoke((Object)cubeWorkspace);
            }
        }) : this.olapWorkspace.enterSandbox(session.getCubeName(), session.getSandBoxIdentity(), (Function1)new Function1<CubeWorkspace, R>(this, action){
            final /* synthetic */ OlapServer this$0;
            final /* synthetic */ Function1<CubeWorkspace, R> $action;
            {
                this.this$0 = $receiver;
                this.$action = $action;
                super(1);
            }

            public final R invoke(@NotNull CubeWorkspace sandboxWorkspace) {
                Intrinsics.checkNotNullParameter((Object)sandboxWorkspace, (String)"sandboxWorkspace");
                this.this$0.getOlapWorkspace$bos_olap_core2().getAccessStrategies().verify(OlapActions.ActionQuery);
                return (R)this.$action.invoke((Object)sandboxWorkspace);
            }
        });
    }

    public final void updateMetadata(@NotNull MetadataCommandInfo metadataCommand, @NotNull OlapSession session) {
        Intrinsics.checkNotNullParameter((Object)metadataCommand, (String)"metadataCommand");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        String cubeName = session.getCubeName();
        if (session.getSandBoxIdentity() == null) {
            IReplicationNode node;
            this.verify(this.olapWorkspace.tryGet(cubeName), OlapActions.ActionMetadataUpdate);
            new MetadataCommandExecutor(metadataCommand, this.olapWorkspace, cubeName, session.getTransaction()).execute();
            if (metadataCommand.getMetadataType() == MetadataTypes.Cube && metadataCommand.getAction() == CommandTypes.create && (node = this.currentNode()) instanceof ReplicationMaster) {
                ((ReplicationMaster)node).getTransactionContext$bos_olap_core2().tryCheckPoint();
            }
        } else {
            new MetadataSandboxCommandExecutor(metadataCommand, this.olapWorkspace, cubeName, session.getSandBoxIdentity()).run();
        }
    }

    @NotNull
    public final ReplicationStatus getStatus() {
        return this.replicationWorkspace.getStatus();
    }

    @NotNull
    public final PluginCollection<OlapWorkspacePlugin, OlapWorkspacePluginContext> getPlugins() {
        return this.olapWorkspace.getPlugins();
    }

    @Override
    public void close() {
        this.replicationWorkspace.close();
        this.olapWorkspace.close();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getCubes() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.olapWorkspace.getMetadata().getCubes();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            CubeEntry cubeEntry = (CubeEntry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final String getCubeMetadata(@NotNull String cubeName) {
        Intrinsics.checkNotNullParameter((Object)cubeName, (String)"cubeName");
        CubeWorkspace cubeWorkspace = this.olapWorkspace.tryGet(cubeName);
        if (cubeWorkspace == null) {
            return "";
        }
        CubeWorkspace cubeWorkspace2 = cubeWorkspace;
        return Cube.Companion.toJsonV1(cubeWorkspace2.getMetadata());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String[] getCubeMeasures(@NotNull String cubeName) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)cubeName, (String)"cubeName");
        CubeWorkspace cubeWorkspace = this.olapWorkspace.tryGet(cubeName);
        if (cubeWorkspace == null) {
            boolean $i$f$emptyArray = false;
            return new String[0];
        }
        CubeWorkspace cubeWorkspace2 = cubeWorkspace;
        Iterable $this$map$iv = cubeWorkspace2.getMetadata().getMeasures();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Measure measure = (Measure)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new String[0]);
    }

    @NotNull
    public final Sequence<Map<String, String>> getMembers(@NotNull String cubeName, @NotNull String dimName) {
        Intrinsics.checkNotNullParameter((Object)cubeName, (String)"cubeName");
        Intrinsics.checkNotNullParameter((Object)dimName, (String)"dimName");
        CubeWorkspace cubeWorkspace = this.olapWorkspace.tryGet(cubeName);
        if (cubeWorkspace == null) {
            return SequencesKt.sequenceOf((Object[])new Map[0]);
        }
        CubeWorkspace cubeWorkspace2 = cubeWorkspace;
        MemberCollection members2 = ((Dimension)cubeWorkspace2.getMetadata().getDimensions().get(dimName)).getMembers();
        return SequencesKt.map((Sequence)SequencesKt.asSequence(members2.getNames()), (Function1)getMembers.1.INSTANCE);
    }

    public final long getRowCount(@NotNull String cubeName) {
        Intrinsics.checkNotNullParameter((Object)cubeName, (String)"cubeName");
        return this.olapWorkspace.getCubeWorkspace(cubeName).getRowCount();
    }

    public final long getTransactionVersion(@NotNull String cubeName) {
        Intrinsics.checkNotNullParameter((Object)cubeName, (String)"cubeName");
        return this.olapWorkspace.getTransactionVersion(cubeName);
    }

    @NotNull
    public final Map<String, String> getCubeProperties(@NotNull String cubeName) {
        Intrinsics.checkNotNullParameter((Object)cubeName, (String)"cubeName");
        HashMap map2 = new HashMap();
        ((Map)map2).put("name", cubeName);
        CubeEntry cubeEntry = (CubeEntry)this.olapWorkspace.getMetadata().getCubes().tryGet(cubeName);
        if (cubeEntry != null) {
            for (Map.Entry entry : ((Map)cubeEntry.getProperties()).entrySet()) {
                String property = (String)entry.getKey();
                String value2 = (String)entry.getValue();
                ((Map)map2).put(property, value2);
            }
        }
        return map2;
    }

    @NotNull
    public final FunctionInfo getFunctionInfo(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return this.olapWorkspace.getFunctions().getFunctionInfo(name2);
    }

    @NotNull
    public final Iterable<FunctionDefine> getFunctionDefines() {
        return this.olapWorkspace.getFunctions().getFunctionDefines();
    }

    public final void checkExecuteByFreeSpace() {
        this.olapWorkspace.checkExecuteByFreeSpace();
    }

    public final void cleanRecoveryTmpFiles() {
        try {
            File[] files = Paths.INSTANCE.toFile(RecoveryFiles.getOrCreatePath$default(RecoveryFiles.INSTANCE, this.getRedoPath(), false, 2, null)).listFiles(OlapServer::cleanRecoveryTmpFiles$lambda$4);
            long currentTimestamp = System.currentTimeMillis();
            File[] fileArray = files;
            if (!(fileArray == null || fileArray.length == 0)) {
                Intrinsics.checkNotNull((Object)files);
                File[] $this$forEach$iv = files;
                boolean $i$f$forEach = false;
                int n = $this$forEach$iv.length;
                for (int i = 0; i < n; ++i) {
                    boolean isDelete;
                    File element$iv;
                    File file = element$iv = $this$forEach$iv[i];
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)file);
                    String fileName = FilesKt.getNameWithoutExtension((File)file);
                    String string2 = fileName.substring(StringsKt.lastIndexOf$default((CharSequence)fileName, (String)"_", (int)0, (boolean)false, (int)6, null) + 1, fileName.length());
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    long timestamp = Long.parseLong(string2);
                    if (currentTimestamp - timestamp <= 604800000L || (isDelete = file.delete())) continue;
                    String string3 = "Failed requirement.";
                    throw new IllegalArgumentException(string3.toString());
                }
            }
        }
        catch (Throwable t2) {
            StringBuilder stringBuilder = new StringBuilder().append("clean recovery tmp file failed:");
            String string4 = t2.getMessage();
            if (string4 == null) {
                string4 = "";
            }
            System.err.println(stringBuilder.append(string4).toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void cleanDSCacheFolder() {
        if (!CommonTypesKt.getDynamicCalcAndStored()) {
            List cleanCacheFolders = new ArrayList();
            Iterable $this$forEach$iv = this.olapWorkspace.getMetadata().getCubes();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void $this$forEach$iv2;
                CubeEntry it = (CubeEntry)element$iv;
                boolean bl = false;
                Object[] objectArray = new String[]{it.getName()};
                Path cubePath = Paths.INSTANCE.get(this.olapWorkspace.getRootPath(), (String[])objectArray);
                objectArray = cubePath.toFile().listFiles(OlapServer::cleanDSCacheFolder$lambda$8$lambda$6);
                if (objectArray == null) continue;
                Object[] objectArray2 = objectArray;
                boolean $i$f$forEach2 = false;
                int n = ((void)$this$forEach$iv2).length;
                for (int i = 0; i < n; ++i) {
                    void element$iv2;
                    void cacheFolder = element$iv2 = $this$forEach$iv2[i];
                    boolean bl2 = false;
                    Intrinsics.checkNotNull((Object)cacheFolder);
                    if (!FileTools.INSTANCE.deleteDir((File)cacheFolder)) continue;
                    String string2 = cacheFolder.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                    cleanCacheFolders.add(string2);
                }
            }
            if (!((Collection)cleanCacheFolders).isEmpty()) {
                OlapLogger.Companion.info("cleanDSCacheFolder success:[{}]", CollectionsKt.joinToString$default((Iterable)cleanCacheFolders, (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
            }
        }
    }

    public final void cleanBackupFiles(@NotNull IOlapLogger logger2) {
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        BackupRecordWorkspace.cleanBackupRecords$default(this.replicationWorkspace.getBackupRecordWorkspace(), logger2, 0L, 2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void executeBenchmarkTask() {
        Closeable closeable = new BenchmarkTaskBuilder(this.databasePath, false);
        Throwable throwable = null;
        try {
            BenchmarkTaskBuilder it = (BenchmarkTaskBuilder)closeable;
            boolean bl = false;
            it.run();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @NotNull
    public final RedoTraceIterableWrapper getRedoTraceInfo(@NotNull String cubeName, @NotNull Map<String, String> cellKey, @NotNull String measureName, @Nullable Long token, @NotNull LocalDateTime deadlineTime) {
        Intrinsics.checkNotNullParameter((Object)cubeName, (String)"cubeName");
        Intrinsics.checkNotNullParameter(cellKey, (String)"cellKey");
        Intrinsics.checkNotNullParameter((Object)measureName, (String)"measureName");
        Intrinsics.checkNotNullParameter((Object)deadlineTime, (String)"deadlineTime");
        CubeWorkspace cubeWorkspace = this.olapWorkspace.getCubeWorkspace(cubeName);
        IReplicationNode master = this.currentNode();
        if (master instanceof ReplicationMaster) {
            return new TransactionTraceQueryExecutor((ReplicationMaster)master, cubeWorkspace, cellKey, measureName, token, deadlineTime).run();
        }
        throw Res.INSTANCE.getNotSupportedException("only master node can get redoInfo", new Object[0]);
    }

    @NotNull
    public final String getCubeTasks(@NotNull String cubeName) {
        Intrinsics.checkNotNullParameter((Object)cubeName, (String)"cubeName");
        String string2 = JsonHelper.INSTANCE.getMapper().writeValueAsString((Object)new CubeTaskChartData(this.olapWorkspace.getCubeWorkspace(cubeName)));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"writeValueAsString(...)");
        return string2;
    }

    public final void cancelSingleTask(@NotNull String cubeName, int partitionId, long taskId) {
        Intrinsics.checkNotNullParameter((Object)cubeName, (String)"cubeName");
        this.olapWorkspace.getCubeWorkspace(cubeName).getTaskCenter().cancelTask(partitionId, (Function1<? super CubeTask, Boolean>)((Function1)new Function1<CubeTask, Boolean>(taskId){
            final /* synthetic */ long $taskId;
            {
                this.$taskId = $taskId;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull CubeTask cubeTask) {
                Intrinsics.checkNotNullParameter((Object)cubeTask, (String)"cubeTask");
                return cubeTask.getTaskId() == this.$taskId;
            }
        }));
    }

    public final void cancelCubeTasks(@NotNull String cubeName) {
        Intrinsics.checkNotNullParameter((Object)cubeName, (String)"cubeName");
        CubeWorkspaceUtils.INSTANCE.cancelAllDSTask(this.olapWorkspace.getCubeWorkspace(cubeName));
    }

    @NotNull
    public final String getDynamicCalcDimensions(@NotNull String cubeName) {
        Intrinsics.checkNotNullParameter((Object)cubeName, (String)"cubeName");
        List result2 = new ArrayList();
        Cube cube = this.olapWorkspace.getCubeWorkspace(cubeName).getMetadata();
        IPartitionItemCollection partitionItems = cube.getPartitionItems();
        Iterable $this$forEach$iv = cube.getDimensions();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Dimension dimension = (Dimension)element$iv;
            boolean bl = false;
            String dimensionName = dimension.getName();
            if (partitionItems instanceof EmptyPartitionItemCollection) {
                if (!dimension.getExistAnyCalculatedMember()) continue;
                result2.add(new DimensionsVO(dimensionName, dimension.getExistAnyDynamicCalcMember(), dimension.getExistAnyDStoredMember()));
                continue;
            }
            if (!dimension.getExistAnyCalculatedMember() || ArraysKt.contains((Object[])partitionItems.getAssociatedDimension(), (Object)cube.getDimensions().get(dimensionName))) continue;
            result2.add(new DimensionsVO(dimensionName, dimension.getExistAnyDynamicCalcMember(), dimension.getExistAnyDStoredMember()));
        }
        String string2 = JsonHelper.INSTANCE.getMapper().writeValueAsString((Object)result2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"writeValueAsString(...)");
        return string2;
    }

    public final void exchangeDCAndDCS(@NotNull OlapSession session, @NotNull String cubeName, @NotNull List<String> dynamicCalcDims, @NotNull List<String> dynamicCalcAndStoreDims) {
        String it;
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)cubeName, (String)"cubeName");
        Intrinsics.checkNotNullParameter(dynamicCalcDims, (String)"dynamicCalcDims");
        Intrinsics.checkNotNullParameter(dynamicCalcAndStoreDims, (String)"dynamicCalcAndStoreDims");
        Iterable $this$forEach$iv = dynamicCalcDims;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            boolean bl = false;
            OlapServer.exchangeDCAndDCS$exchangeCore(this, cubeName, session, it, MemberStorageTypes.DynamicCalc);
        }
        $this$forEach$iv = dynamicCalcAndStoreDims;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            boolean bl = false;
            OlapServer.exchangeDCAndDCS$exchangeCore(this, cubeName, session, it, MemberStorageTypes.DynamicCalcAndStored);
        }
    }

    @NotNull
    public final String queryConcatMeInfo() {
        String string2;
        String[] stringArray = new String[]{"ConcatMe.txt"};
        File file = Paths.INSTANCE.get(((Object)Paths.INSTANCE.get(this.databasePath, new String[0]).getParent()).toString(), stringArray).toFile();
        if (file.exists()) {
            Intrinsics.checkNotNull((Object)file);
            string2 = FilesKt.readText((File)file, (Charset)Charsets.UTF_8);
        } else {
            string2 = "";
        }
        return string2;
    }

    private static final boolean cleanRecoveryTmpFiles$lambda$4(File file, String name2) {
        Intrinsics.checkNotNull((Object)name2);
        return StringsKt.endsWith$default((String)name2, (String)".tmp", (boolean)false, (int)2, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean cleanDSCacheFolder$lambda$8$lambda$6(File file, String name2) {
        if (!file.isDirectory()) return false;
        Intrinsics.checkNotNull((Object)name2);
        if (!StringsKt.contains$default((CharSequence)name2, (CharSequence)CachePartitionItem.INSTANCE.getKey(), (boolean)false, (int)2, null)) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static final void exchangeDCAndDCS$exchangeCore(OlapServer this$0, String $cubeName, OlapSession $session, String dimensionName, MemberStorageTypes targetType) {
        MetadataCommandInfo metadataCommandInfo;
        MemberStorageTypes memberStorageTypes;
        Dimension dimension = (Dimension)this$0.olapWorkspace.getCubeWorkspace($cubeName).getMetadata().getDimensions().get(dimensionName);
        switch (WhenMappings.$EnumSwitchMapping$0[targetType.ordinal()]) {
            case 1: {
                if (!dimension.getExistAnyDStoredMember()) {
                    return;
                }
                memberStorageTypes = MemberStorageTypes.DynamicCalcAndStored;
                break;
            }
            case 2: {
                if (!dimension.getExistAnyDynamicCalcMember()) {
                    return;
                }
                memberStorageTypes = MemberStorageTypes.DynamicCalc;
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        MemberStorageTypes sourceType = memberStorageTypes;
        MetadataCommandInfo $this$exchangeDCAndDCS_u24exchangeCore_u24lambda_u2413 = metadataCommandInfo = new MetadataCommandInfo();
        boolean bl = false;
        $this$exchangeDCAndDCS_u24exchangeCore_u24lambda_u2413.setAction(CommandTypes.alter);
        $this$exchangeDCAndDCS_u24exchangeCore_u24lambda_u2413.setMetadataType(MetadataTypes.Member);
        $this$exchangeDCAndDCS_u24exchangeCore_u24lambda_u2413.setOwnerUniqueName($cubeName + '.' + dimensionName);
        Iterable $this$forEach$iv = dimension.getMembers();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$exchangeDCAndDCS_u24exchangeCore_u24lambda_u2413_u24lambda_u2412_u24lambda_u2411;
            MemberMetadataItem memberMetadataItem;
            Member member = (Member)element$iv;
            boolean bl2 = false;
            if (member.getStorageType() != sourceType) continue;
            MemberMetadataItem memberMetadataItem2 = memberMetadataItem = new MemberMetadataItem(member.getName());
            List<MetadataItem> list2 = $this$exchangeDCAndDCS_u24exchangeCore_u24lambda_u2413.getItems();
            boolean bl3 = false;
            $this$exchangeDCAndDCS_u24exchangeCore_u24lambda_u2413_u24lambda_u2412_u24lambda_u2411.setStorageType(targetType);
            list2.add(memberMetadataItem);
        }
        MetadataCommandInfo metadataCommandInfo2 = metadataCommandInfo;
        this$0.updateMetadata(metadataCommandInfo2, $session);
    }

    public static final /* synthetic */ void access$verify(OlapServer $this, CubeWorkspace cubeWorkspace, OlapActions action) {
        $this.verify(cubeWorkspace, action);
    }

    public static final /* synthetic */ String access$getDatabasePath$p(OlapServer $this) {
        return $this.databasePath;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\b\b\u0082\u0004\u0018\u00002\u00020\u0001B)\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u0012\n\u0010\b\u001a\u00060\u0006j\u0002`\u0007\u00a2\u0006\u0002\u0010\tR\u0015\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0015\u0010\b\u001a\u00060\u0006j\u0002`\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0015\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\r\u00a8\u0006\u000f"}, d2={"Lkd/bos/olapServer2/server/OlapServer$DimensionsVO;", "", "dimensionName", "", "Lkd/bos/olapServer2/common/string;", "existAnyDynamicCalcMember", "", "Lkd/bos/olapServer2/common/bool;", "existAnyDStoredMember", "(Lkd/bos/olapServer2/server/OlapServer;Ljava/lang/String;ZZ)V", "getDimensionName", "()Ljava/lang/String;", "getExistAnyDStoredMember", "()Z", "getExistAnyDynamicCalcMember", "bos-olap-core2"})
    private final class DimensionsVO {
        @NotNull
        private final String dimensionName;
        private final boolean existAnyDynamicCalcMember;
        private final boolean existAnyDStoredMember;

        public DimensionsVO(String dimensionName, boolean existAnyDynamicCalcMember, boolean existAnyDStoredMember) {
            Intrinsics.checkNotNullParameter((Object)dimensionName, (String)"dimensionName");
            this.dimensionName = dimensionName;
            this.existAnyDynamicCalcMember = existAnyDynamicCalcMember;
            this.existAnyDStoredMember = existAnyDStoredMember;
        }

        @NotNull
        public final String getDimensionName() {
            return this.dimensionName;
        }

        public final boolean getExistAnyDynamicCalcMember() {
            return this.existAnyDynamicCalcMember;
        }

        public final boolean getExistAnyDStoredMember() {
            return this.existAnyDStoredMember;
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MemberStorageTypes.values().length];
            try {
                nArray[MemberStorageTypes.DynamicCalc.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MemberStorageTypes.DynamicCalcAndStored.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

