/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.server;

import java.io.Closeable;
import java.io.File;
import java.io.OutputStream;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.concurrent.atomic.AtomicReference;
import kd.bos.olapServer2.backup.BackupCommandExecutor;
import kd.bos.olapServer2.backup.sequenceLog.SeqRedoLogNameStrategy;
import kd.bos.olapServer2.backup.sequenceLog.SeqRedoLogger;
import kd.bos.olapServer2.common.NotSupportedException;
import kd.bos.olapServer2.common.OlapConfigItems;
import kd.bos.olapServer2.common.Paths;
import kd.bos.olapServer2.common.PathsKt;
import kd.bos.olapServer2.dataSources.BackupCommandInfo;
import kd.bos.olapServer2.metadata.OlapMetadata;
import kd.bos.olapServer2.monitorReports.HealthReport;
import kd.bos.olapServer2.monitorReports.HealthReportLevel;
import kd.bos.olapServer2.replication.BackupRecordUpgrade;
import kd.bos.olapServer2.replication.BackupRecordWorkspace;
import kd.bos.olapServer2.replication.IReplicationNode;
import kd.bos.olapServer2.replication.OlapLogger;
import kd.bos.olapServer2.replication.OlapReplicationMasterPlugin;
import kd.bos.olapServer2.replication.RedoUtil;
import kd.bos.olapServer2.replication.ReplicationConf;
import kd.bos.olapServer2.replication.ReplicationContext;
import kd.bos.olapServer2.replication.ReplicationMaster;
import kd.bos.olapServer2.replication.ReplicationNone;
import kd.bos.olapServer2.replication.ReplicationSlave;
import kd.bos.olapServer2.replication.ReplicationStatus;
import kd.bos.olapServer2.security.AccessStrategyCollection;
import kd.bos.olapServer2.security.IAccessStrategy;
import kd.bos.olapServer2.security.OlapActions;
import kd.bos.olapServer2.security.PrivilegeType;
import kd.bos.olapServer2.security.StatusAccessStrategy;
import kd.bos.olapServer2.server.OlapSession;
import kd.bos.olapServer2.server.ReplicationNodeProxy;
import kd.bos.olapServer2.storages.CubeWorkspace;
import kd.bos.olapServer2.storages.OlapWorkspace;
import kd.bos.olapServer2.storages.plugins.OlapDynamicCalcAndStoredPlugin;
import kd.bos.olapServer2.storages.plugins.OlapWorkspacePluginContext;
import kd.bos.olapServer2.tools.CubeToolKt;
import kd.bos.olapServer2.tools.FileTools;
import kd.bos.olapServer2.tools.HttpTools;
import kd.bos.olapServer2.tools.Res;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.SetsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 S2\u00020\u0001:\u0001SB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u001d\b\u0002\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\nJ\n\u0010-\u001a\u00060 j\u0002`.J\b\u0010/\u001a\u000200H\u0016J\u001a\u00101\u001a\u00060 j\u0002`.2\u0006\u00102\u001a\u00020\f2\u0006\u00103\u001a\u00020\fJ\n\u00104\u001a\u00060 j\u0002`.J\u0006\u00105\u001a\u000200J\b\u00106\u001a\u000200H\u0002J \u00107\u001a\u0002002\n\u00108\u001a\u000609j\u0002`:2\n\u0010;\u001a\u000609j\u0002`:H\u0002J\u0010\u0010<\u001a\u0002002\u0006\u0010=\u001a\u000209H\u0002J\u0006\u0010>\u001a\u000200J\u000e\u0010?\u001a\u0002002\u0006\u0010@\u001a\u00020\fJ\u001e\u0010A\u001a\u0002002\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020GJ\u0010\u0010H\u001a\u0002002\u0006\u0010@\u001a\u00020\fH\u0002J\b\u0010I\u001a\u000200H\u0002J\u001f\u0010J\u001a\u0002002\b\u0010K\u001a\u0004\u0018\u00010L2\u0006\u0010M\u001a\u00020NH\u0000\u00a2\u0006\u0002\bOJ\u0012\u0010P\u001a\u00020\t*\u00020\t2\u0006\u0010Q\u001a\u00020RR\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u0010\u0012\f\u0012\n \r*\u0004\u0018\u00010\f0\f0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u001b\u0010\u0019\u001a\u00020\u001a8@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001f\u001a\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010!R\u0014\u0010\"\u001a\u00020#X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0014\u0010(\u001a\u00020\u001aX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u001cR\u0011\u0010*\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b+\u0010,\u00a8\u0006T"}, d2={"Lkd/bos/olapServer2/server/ReplicationWorkspace;", "Ljava/io/Closeable;", "olapWorkspace", "Lkd/bos/olapServer2/storages/OlapWorkspace;", "context", "Lkd/bos/olapServer2/replication/ReplicationContext;", "(Lkd/bos/olapServer2/storages/OlapWorkspace;Lkd/bos/olapServer2/replication/ReplicationContext;)V", "_currentNode", "Ljava/util/concurrent/atomic/AtomicReference;", "Lkd/bos/olapServer2/server/ReplicationNodeProxy;", "(Ljava/util/concurrent/atomic/AtomicReference;Lkd/bos/olapServer2/storages/OlapWorkspace;)V", "_status", "Lkd/bos/olapServer2/replication/ReplicationStatus;", "kotlin.jvm.PlatformType", "_statusStrategy", "Lkd/bos/olapServer2/security/IAccessStrategy;", "_switchThread", "Ljava/lang/Thread;", "backupRecordWorkspace", "Lkd/bos/olapServer2/replication/BackupRecordWorkspace;", "getBackupRecordWorkspace", "()Lkd/bos/olapServer2/replication/BackupRecordWorkspace;", "currentNode", "getCurrentNode", "()Lkd/bos/olapServer2/server/ReplicationNodeProxy;", "incrementRedoSeqLogger", "Lkd/bos/olapServer2/backup/sequenceLog/SeqRedoLogger;", "getIncrementRedoSeqLogger$bos_olap_core2", "()Lkd/bos/olapServer2/backup/sequenceLog/SeqRedoLogger;", "incrementRedoSeqLogger$delegate", "Lkotlin/Lazy;", "isMaster", "", "()Z", "logger", "Lkd/bos/olapServer2/replication/OlapLogger;", "getLogger$bos_olap_core2", "()Lkd/bos/olapServer2/replication/OlapLogger;", "getOlapWorkspace$bos_olap_core2", "()Lkd/bos/olapServer2/storages/OlapWorkspace;", "redoSeqLogger", "getRedoSeqLogger$bos_olap_core2", "status", "getStatus", "()Lkd/bos/olapServer2/replication/ReplicationStatus;", "canSwitch", "Lkd/bos/olapServer2/common/bool;", "close", "", "compareAndSetStatus", "expect", "update", "isVip", "masterToSlave", "migrateBackupFiles", "moveFolder", "sourceFolderPath", "", "Lkd/bos/olapServer2/common/string;", "targetFolderPath", "moveRootBackupFiles", "currentBackupPath", "slaveToMaster", "switchStatus", "value", "timeBackup", "backupCommandInfo", "Lkd/bos/olapServer2/dataSources/BackupCommandInfo;", "session", "Lkd/bos/olapServer2/server/OlapSession;", "outputStream", "Ljava/io/OutputStream;", "updateAccessStrategies", "upgrade", "verify", "cubeWorkspace", "Lkd/bos/olapServer2/storages/CubeWorkspace;", "action", "Lkd/bos/olapServer2/security/OlapActions;", "verify$bos_olap_core2", "switch", "newNode", "Lkd/bos/olapServer2/replication/IReplicationNode;", "Companion", "bos-olap-core2"})
@SourceDebugExtension(value={"SMAP\nReplicationWorkspace.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReplicationWorkspace.kt\nkd/bos/olapServer2/server/ReplicationWorkspace\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,469:1\n13309#2:470\n13309#2,2:471\n13310#2:473\n*S KotlinDebug\n*F\n+ 1 ReplicationWorkspace.kt\nkd/bos/olapServer2/server/ReplicationWorkspace\n*L\n355#1:470\n367#1:471,2\n355#1:473\n*E\n"})
public final class ReplicationWorkspace
implements Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AtomicReference<ReplicationNodeProxy> _currentNode;
    @NotNull
    private final OlapWorkspace olapWorkspace;
    @NotNull
    private final AtomicReference<ReplicationStatus> _status;
    @NotNull
    private final BackupRecordWorkspace backupRecordWorkspace;
    @NotNull
    private final SeqRedoLogger redoSeqLogger;
    @NotNull
    private final Lazy incrementRedoSeqLogger$delegate;
    @NotNull
    private final OlapLogger logger;
    @Nullable
    private IAccessStrategy _statusStrategy;
    @NotNull
    private final AtomicReference<Thread> _switchThread;
    public static final int redoCompressNum = 16;

    private ReplicationWorkspace(AtomicReference<ReplicationNodeProxy> _currentNode, OlapWorkspace olapWorkspace) {
        this._currentNode = _currentNode;
        this.olapWorkspace = olapWorkspace;
        this._status = new AtomicReference<ReplicationStatus>(ReplicationStatus.Unavailable);
        this.redoSeqLogger = new SeqRedoLogger(this._currentNode.get().getConf().get_node().getRedoPath(), 16, new SeqRedoLogNameStrategy(".redo", ".redoz"), null, false, 8, null);
        this.incrementRedoSeqLogger$delegate = LazyKt.lazy((Function0)((Function0)new Function0<SeqRedoLogger>(this){
            final /* synthetic */ ReplicationWorkspace this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final SeqRedoLogger invoke() {
                return new SeqRedoLogger(RedoUtil.INSTANCE.getOrCreateIncrementPath(((ReplicationNodeProxy)ReplicationWorkspace.access$get_currentNode$p(this.this$0).get()).getConf().get_node().getBackupPath()), 16, new SeqRedoLogNameStrategy(".redo", ".redoz"), null, true, 8, null);
            }
        }));
        this.getCurrentNode().getContext().setWorkspace$bos_olap_core2(this);
        this.olapWorkspace.getPlugins().getOrCreate(OlapReplicationMasterPlugin.Companion.getOlapReplicationPluginKey(), (Function1)new Function1<OlapWorkspacePluginContext, OlapReplicationMasterPlugin>(){

            @NotNull
            public final OlapReplicationMasterPlugin invoke(@NotNull OlapWorkspacePluginContext it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return new OlapReplicationMasterPlugin(it, this.getCurrentNode().getContext());
            }
        });
        this.olapWorkspace.getPlugins().getOrCreate(OlapDynamicCalcAndStoredPlugin.Companion.getOlapDynamicCalcAndStoredPluginKey(), (Function1)new Function1<OlapWorkspacePluginContext, OlapDynamicCalcAndStoredPlugin>(){

            @NotNull
            public final OlapDynamicCalcAndStoredPlugin invoke(@NotNull OlapWorkspacePluginContext it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return new OlapDynamicCalcAndStoredPlugin(it, this.getCurrentNode().getContext());
            }
        });
        this.upgrade();
        this.backupRecordWorkspace = BackupRecordWorkspace.Companion.create(this.getCurrentNode().getConf().get_node().getBackupPath());
        this.logger = new OlapLogger(this.olapWorkspace, this._status);
        this._switchThread = new AtomicReference();
    }

    @NotNull
    public final OlapWorkspace getOlapWorkspace$bos_olap_core2() {
        return this.olapWorkspace;
    }

    public ReplicationWorkspace(@NotNull OlapWorkspace olapWorkspace, @NotNull ReplicationContext context) {
        Intrinsics.checkNotNullParameter((Object)olapWorkspace, (String)"olapWorkspace");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(new AtomicReference<ReplicationNodeProxy>(ReplicationWorkspace.Companion.init(olapWorkspace, context)), olapWorkspace);
    }

    public /* synthetic */ ReplicationWorkspace(OlapWorkspace olapWorkspace, ReplicationContext replicationContext, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            replicationContext = ReplicationContext.Companion.getEmptyContext();
        }
        this(olapWorkspace, replicationContext);
    }

    @NotNull
    public final BackupRecordWorkspace getBackupRecordWorkspace() {
        return this.backupRecordWorkspace;
    }

    @NotNull
    public final SeqRedoLogger getRedoSeqLogger$bos_olap_core2() {
        return this.redoSeqLogger;
    }

    @NotNull
    public final SeqRedoLogger getIncrementRedoSeqLogger$bos_olap_core2() {
        Lazy lazy = this.incrementRedoSeqLogger$delegate;
        return (SeqRedoLogger)lazy.getValue();
    }

    @NotNull
    public final ReplicationNodeProxy getCurrentNode() {
        ReplicationNodeProxy replicationNodeProxy = this._currentNode.get();
        Intrinsics.checkNotNullExpressionValue((Object)replicationNodeProxy, (String)"get(...)");
        return replicationNodeProxy;
    }

    @NotNull
    public final OlapLogger getLogger$bos_olap_core2() {
        return this.logger;
    }

    @NotNull
    public final ReplicationStatus getStatus() {
        ReplicationStatus replicationStatus = this._status.get();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)replicationStatus), (String)"get(...)");
        return replicationStatus;
    }

    public final boolean isMaster() {
        return this.getCurrentNode().getValue() instanceof ReplicationMaster;
    }

    public final void switchStatus(@NotNull ReplicationStatus value2) {
        Intrinsics.checkNotNullParameter((Object)((Object)value2), (String)"value");
        this._status.set(value2);
        this.updateAccessStrategies(value2);
    }

    @NotNull
    public final ReplicationNodeProxy switch(@NotNull ReplicationNodeProxy $this$switch, @NotNull IReplicationNode newNode) {
        Intrinsics.checkNotNullParameter((Object)$this$switch, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)newNode, (String)"newNode");
        return new ReplicationNodeProxy($this$switch.getConf(), newNode, $this$switch.getContext());
    }

    public final boolean canSwitch() {
        return this.olapWorkspace.isFree();
    }

    private final void updateAccessStrategies(ReplicationStatus value2) {
        IAccessStrategy currentStatusStrategy = this._statusStrategy;
        if (currentStatusStrategy != null) {
            this.olapWorkspace.getAccessStrategies().remove(currentStatusStrategy);
        }
        StatusAccessStrategy newStatusStrategy = new StatusAccessStrategy(value2);
        this._statusStrategy = newStatusStrategy;
        this.olapWorkspace.getAccessStrategies().add(newStatusStrategy);
    }

    public final boolean compareAndSetStatus(@NotNull ReplicationStatus expect, @NotNull ReplicationStatus update) {
        Intrinsics.checkNotNullParameter((Object)((Object)expect), (String)"expect");
        Intrinsics.checkNotNullParameter((Object)((Object)update), (String)"update");
        boolean ret = this._status.compareAndSet(expect, update);
        if (ret) {
            this.updateAccessStrategies(update);
        }
        return ret;
    }

    public final void verify$bos_olap_core2(@Nullable CubeWorkspace cubeWorkspace, @NotNull OlapActions action) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
            this.olapWorkspace.getAccessStrategies().verify(action);
            Object object2 = cubeWorkspace;
            if (object2 == null || (object2 = ((CubeWorkspace)object2).getAccessStrategies()) == null) break block0;
            ((AccessStrategyCollection)object2).verify(action);
        }
    }

    public final boolean isVip() {
        String vip = this.getCurrentNode().getConf().get_node().getVip();
        Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
        while (e.hasMoreElements()) {
            NetworkInterface item = e.nextElement();
            for (InterfaceAddress address : item.getInterfaceAddresses()) {
                if (!Intrinsics.areEqual((Object)address.getAddress(), (Object)HttpTools.Companion.getInetAddressByString(vip))) continue;
                if (this.getStatus() == ReplicationStatus.Slave) {
                    OlapLogger.Companion.info("VIP: {}, \u72b6\u6001\uff1a{}", address.getAddress().getHostAddress(), (Object)this.getStatus());
                }
                return true;
            }
        }
        return false;
    }

    public final void timeBackup(@NotNull BackupCommandInfo backupCommandInfo, @NotNull OlapSession session, @NotNull OutputStream outputStream) {
        Intrinsics.checkNotNullParameter((Object)backupCommandInfo, (String)"backupCommandInfo");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        String cubeName = session.getCubeName();
        CubeWorkspace cubeWorkspace = this.olapWorkspace.getCubeWorkspace(cubeName);
        this.olapWorkspace.enterReadForBackup(cubeName, (Function2)new Function2<CubeWorkspace, Closeable, Long>(this, cubeWorkspace, backupCommandInfo, outputStream){
            final /* synthetic */ ReplicationWorkspace this$0;
            final /* synthetic */ CubeWorkspace $cubeWorkspace;
            final /* synthetic */ BackupCommandInfo $backupCommandInfo;
            final /* synthetic */ OutputStream $outputStream;
            {
                this.this$0 = $receiver;
                this.$cubeWorkspace = $cubeWorkspace;
                this.$backupCommandInfo = $backupCommandInfo;
                this.$outputStream = $outputStream;
                super(2);
            }

            @NotNull
            public final Long invoke(@NotNull CubeWorkspace cubeWorkspace, @NotNull Closeable lock) {
                Intrinsics.checkNotNullParameter((Object)cubeWorkspace, (String)"<anonymous parameter 0>");
                Intrinsics.checkNotNullParameter((Object)lock, (String)"lock");
                this.this$0.verify$bos_olap_core2(this.$cubeWorkspace, OlapActions.ActionCubeBackup);
                BackupCommandExecutor executor = new BackupCommandExecutor(this.$backupCommandInfo, this.$cubeWorkspace, this.$outputStream, lock, this.this$0.getOlapWorkspace$bos_olap_core2().getRootPath());
                return executor.run();
            }
        });
    }

    public final void slaveToMaster() {
        IReplicationNode slave = this.getCurrentNode().getValue();
        if (slave instanceof ReplicationSlave) {
            if (this.olapWorkspace.isFree()) {
                ThreadsKt.thread$default((boolean)false, (boolean)false, null, (String)"SlaveToMasterThread", (int)0, (Function0)((Function0)new Function0<Unit>(this, slave){
                    final /* synthetic */ ReplicationWorkspace this$0;
                    final /* synthetic */ IReplicationNode $slave;
                    {
                        this.this$0 = $receiver;
                        this.$slave = $slave;
                        super(0);
                    }

                    public final void invoke() {
                        ReplicationWorkspace.access$get_switchThread$p(this.this$0).set(Thread.currentThread());
                        this.$slave.close();
                        this.this$0.getOlapWorkspace$bos_olap_core2().unloadWorkspaces$bos_olap_core2();
                        ReplicationMaster newMaster = new ReplicationMaster(this.this$0.getOlapWorkspace$bos_olap_core2().getRootPath(), this.this$0.getCurrentNode().getConf(), this.this$0.getCurrentNode().getContext());
                        try {
                            newMaster.start();
                            ReplicationWorkspace.access$get_currentNode$p(this.this$0).set(this.this$0.switch(this.this$0.getCurrentNode(), newMaster));
                            OlapLogger.Companion.info("Status switch Slave->Master success");
                        }
                        catch (Throwable t2) {
                            ReplicationWorkspace workspace = this.this$0.getCurrentNode().getContext().getWorkspace$bos_olap_core2();
                            OlapLogger this_$iv = workspace.getLogger$bos_olap_core2();
                            boolean $i$f$error = false;
                            String reportId$iv = this_$iv.getStatus().get().name() + "-ReplicationError-" + CubeToolKt.getCurrentTime();
                            OlapLogger this_$iv$iv = this_$iv;
                            boolean $i$f$error2 = false;
                            if (this_$iv$iv.isErrorEnabled()) {
                                boolean bl = false;
                                String message$iv$iv = "\u4ece\u81ea\u52a8\u5207\u6362\u4e3a\u4e3b\uff0c\u5931\u8d25";
                                HealthReport report$iv$iv = new HealthReport(reportId$iv, null, this_$iv$iv.getStatus().get().name() + "-ReplicationError: " + message$iv$iv, HealthReportLevel.Error, PrivilegeType.None.getCode());
                                this_$iv$iv.getOlapWorkspace().getHealthReports().commit(report$iv$iv);
                                if (t2 == null) {
                                    OlapLogger.access$getLogger$cp().error(message$iv$iv);
                                } else {
                                    OlapLogger.access$getLogger$cp().error("{}", (Object)message$iv$iv, (Object)t2);
                                }
                            }
                            newMaster.close();
                            workspace.switchStatus(ReplicationStatus.Unavailable);
                            OlapLogger.Companion.info("Status switch Slave->Master failed");
                        }
                    }
                }), (int)23, null);
            }
        } else {
            throw new NotSupportedException("not support slaveToMaster,currentNode server is " + (Object)((Object)this.getStatus()));
        }
    }

    public final void masterToSlave() {
        IReplicationNode master = this._currentNode.get().getValue();
        if (master instanceof ReplicationMaster) {
            if (this.olapWorkspace.isFree()) {
                ThreadsKt.thread$default((boolean)false, (boolean)false, null, (String)"MaterToSlaveThread", (int)0, (Function0)((Function0)new Function0<Unit>(this, master){
                    final /* synthetic */ ReplicationWorkspace this$0;
                    final /* synthetic */ IReplicationNode $master;
                    {
                        this.this$0 = $receiver;
                        this.$master = $master;
                        super(0);
                    }

                    public final void invoke() {
                        ReplicationWorkspace.access$get_switchThread$p(this.this$0).set(Thread.currentThread());
                        this.$master.close();
                        this.this$0.getOlapWorkspace$bos_olap_core2().unloadWorkspaces$bos_olap_core2();
                        ReplicationSlave newSlave = new ReplicationSlave(this.this$0.getOlapWorkspace$bos_olap_core2(), this.this$0.getCurrentNode().getConf(), this.this$0.getCurrentNode().getContext());
                        for (int i = 1; i < 11; ++i) {
                            try {
                                newSlave.start();
                                ReplicationWorkspace.access$get_currentNode$p(this.this$0).set(this.this$0.switch(this.this$0.getCurrentNode(), newSlave));
                                OlapLogger.Companion.info("Status switch Master->Slave success");
                                break;
                            }
                            catch (Exception ex) {
                                Thread.sleep(1000L);
                                ReplicationWorkspace workspace = this.this$0.getCurrentNode().getContext().getWorkspace$bos_olap_core2();
                                OlapLogger.Companion.info("" + '\u7b2c' + i + "\u6b21\u5c1d\u8bd5\u8fde\u63a5\u65b0MASTER\uff0c\u5931\u8d25");
                                if (i != 10) continue;
                                OlapLogger.Companion.info("\u4e3b\u81ea\u52a8\u5207\u6362\u4e3a\u4ece\uff0c\u5931\u8d25");
                                newSlave.close();
                                workspace.switchStatus(ReplicationStatus.Unavailable);
                                OlapLogger.Companion.info("Status switch Master->Slave failed");
                                continue;
                            }
                        }
                    }
                }), (int)23, null);
            }
        } else {
            throw new NotSupportedException("not support masterToSlave,currentNode server is " + (Object)((Object)this.getStatus()));
        }
    }

    private final void moveFolder(String sourceFolderPath, String targetFolderPath) {
        if (!(!StringsKt.isBlank((CharSequence)sourceFolderPath))) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        if (!(!StringsKt.isBlank((CharSequence)targetFolderPath))) {
            String string3 = "Failed requirement.";
            throw new IllegalArgumentException(string3.toString());
        }
        File sourceFolder = Paths.INSTANCE.toFile(sourceFolderPath);
        File targetFolder = Paths.INSTANCE.toFile(targetFolderPath);
        if (!sourceFolder.exists()) {
            return;
        }
        if (!targetFolder.exists()) {
            FileTools.INSTANCE.autoMakeDir(targetFolderPath);
        }
        if (!Intrinsics.areEqual((Object)sourceFolder.getCanonicalPath(), (Object)targetFolder.getCanonicalPath())) {
            System.out.println((Object)("The service is upgrading, move '" + sourceFolderPath + "' to '" + targetFolderPath + '\''));
            try {
                FileTools.moveDir$default(FileTools.INSTANCE, sourceFolder, targetFolder, SetsKt.emptySet(), false, true, 8, null);
            }
            catch (Throwable t2) {
                throw new RuntimeException("Upgrade failed, please contact administrator.", t2);
            }
            if (sourceFolder.exists()) {
                FileUtils.deleteDirectory((File)sourceFolder);
            }
            System.out.println((Object)"The current service upgrade has been completed.");
        }
    }

    private final void upgrade() {
        if (this.getCurrentNode().getValue() instanceof ReplicationNone) {
            return;
        }
        if (BackupRecordUpgrade.Companion.tryGetVersion$bos_olap_core2(this.getCurrentNode().getConf().get_node().getBackupPath()) == 4) {
            return;
        }
        this.migrateBackupFiles();
        new BackupRecordUpgrade(this.getCurrentNode().getConf().get_node().getBackupPath(), this.getIncrementRedoSeqLogger$bos_olap_core2()).tryUpgrade();
    }

    private final void migrateBackupFiles() {
        System.out.println((Object)"The service is migrating backup data, please waiting...");
        try {
            String currentBackupPath;
            String olapServerRootPath = Paths.INSTANCE.toFile(this.getCurrentNode().getContext().getRootPath()).getAbsolutePath();
            Intrinsics.checkNotNull((Object)olapServerRootPath);
            String defaultBackupPath = Paths.INSTANCE.toFile(olapServerRootPath, "backup").getAbsolutePath();
            String defaultBackupDirPath = Paths.INSTANCE.toFile(olapServerRootPath, "backupDir").getAbsolutePath();
            String tmpPath = OlapConfigItems.INSTANCE.getBackupPathConfigItem$bos_olap_core2().getValue();
            boolean bl = false;
            String previousWebBackupPath = StringsKt.isBlank((CharSequence)tmpPath) ? defaultBackupPath : Paths.INSTANCE.toFile(tmpPath).getAbsolutePath();
            if (!Intrinsics.areEqual((Object)previousWebBackupPath, (Object)(currentBackupPath = PathsKt.toFile(this.getCurrentNode().getConf().get_node().getBackupPath()).getAbsolutePath()))) {
                Intrinsics.checkNotNull((Object)previousWebBackupPath);
                if (PathsKt.toFile(previousWebBackupPath).exists()) {
                    Intrinsics.checkNotNull((Object)currentBackupPath);
                    this.moveFolder(previousWebBackupPath, currentBackupPath);
                }
            }
            if (!Intrinsics.areEqual((Object)defaultBackupDirPath, (Object)currentBackupPath)) {
                Intrinsics.checkNotNull((Object)defaultBackupDirPath);
                if (PathsKt.toFile(defaultBackupDirPath).exists()) {
                    Intrinsics.checkNotNull((Object)currentBackupPath);
                    this.moveFolder(defaultBackupDirPath, currentBackupPath);
                }
            }
            Intrinsics.checkNotNull((Object)currentBackupPath);
            this.moveRootBackupFiles(currentBackupPath);
            System.out.println((Object)"Successfully migrated backup data");
        }
        catch (Throwable e) {
            System.out.println((Object)("Migrated backup data failed, error message: " + e.getMessage()));
            e.printStackTrace();
        }
    }

    private final void moveRootBackupFiles(String currentBackupPath) {
        block11: {
            File[] fileArray = PathsKt.toFile(this.getCurrentNode().getContext().getRootPath()).listFiles();
            if (fileArray == null) break block11;
            File[] $this$forEach$iv = fileArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                File targetFolder;
                Object targetFile;
                File element$iv;
                File file = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                if (file.isFile()) {
                    Object[] objectArray = new String[]{"backupOld.record", "backup.record", "version.dat"};
                    if (ArraysKt.contains((Object[])objectArray, (Object)file.getName())) {
                        String string2 = file.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                        targetFile = Paths.INSTANCE.toFile(currentBackupPath, string2);
                        if (!((File)targetFile).exists()) {
                            FileUtils.moveFile((File)file, (File)targetFile);
                        }
                    }
                }
                if (file.isDirectory()) {
                    targetFile = new String[]{"increment", "total", "recoveryFiles"};
                    if (ArraysKt.contains((Object[])targetFile, (Object)file.getName())) {
                        File[] fileArray2;
                        String string3 = file.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
                        targetFolder = Paths.INSTANCE.toFile(currentBackupPath, string3);
                        if (!targetFolder.exists()) {
                            FileUtils.moveDirectory((File)file, (File)targetFolder);
                        } else if (fileArray2 != null) {
                            fileArray2 = file.listFiles();
                            Intrinsics.checkNotNull((Object)fileArray2);
                            File[] $this$forEach$iv2 = fileArray2;
                            boolean $i$f$forEach2 = false;
                            int n2 = $this$forEach$iv2.length;
                            for (int j = 0; j < n2; ++j) {
                                File element$iv2;
                                File fooFile = element$iv2 = $this$forEach$iv2[j];
                                boolean bl2 = false;
                                String[] stringArray = new String[2];
                                Intrinsics.checkNotNullExpressionValue((Object)file.getName(), (String)"getName(...)");
                                Intrinsics.checkNotNullExpressionValue((Object)fooFile.getName(), (String)"getName(...)");
                                File targetFile2 = Paths.INSTANCE.joinToFile(currentBackupPath, stringArray);
                                if (targetFile2.exists()) continue;
                                FileUtils.moveDirectory((File)fooFile, (File)targetFile2);
                            }
                        }
                    }
                }
                if (!file.isDirectory()) continue;
                String string4 = file.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getName(...)");
                if (!StringsKt.endsWith$default((String)string4, (String)"-total", (boolean)false, (int)2, null)) {
                    String string5 = file.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getName(...)");
                    if (!StringsKt.endsWith$default((String)string5, (String)"-increment", (boolean)false, (int)2, null)) continue;
                }
                String string6 = file.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getName(...)");
                targetFolder = Paths.INSTANCE.toFile(currentBackupPath, string6);
                if (targetFolder.exists()) continue;
                FileUtils.moveDirectory((File)file, (File)targetFolder);
            }
        }
    }

    @Override
    public void close() {
        this.redoSeqLogger.close();
        this.getIncrementRedoSeqLogger$bos_olap_core2().close();
        Thread thread = this._switchThread.get();
        if (thread != null) {
            thread.join();
        }
        ReplicationNodeProxy replicationNodeProxy = this._currentNode.get();
        if (replicationNodeProxy != null) {
            replicationNodeProxy.close();
        }
        this.switchStatus(ReplicationStatus.Unavailable);
        this._switchThread.set(null);
        this._currentNode.set(null);
    }

    public static final /* synthetic */ AtomicReference access$get_switchThread$p(ReplicationWorkspace $this) {
        return $this._switchThread;
    }

    public static final /* synthetic */ AtomicReference access$get_currentNode$p(ReplicationWorkspace $this) {
        return $this._currentNode;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u00060\bj\u0002`\tJ\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lkd/bos/olapServer2/server/ReplicationWorkspace$Companion;", "", "()V", "redoCompressNum", "", "createNoneWorkspace", "Lkd/bos/olapServer2/server/ReplicationWorkspace;", "tmpDatabase", "", "Lkd/bos/olapServer2/common/string;", "init", "Lkd/bos/olapServer2/server/ReplicationNodeProxy;", "olapWorkspace", "Lkd/bos/olapServer2/storages/OlapWorkspace;", "context", "Lkd/bos/olapServer2/replication/ReplicationContext;", "bos-olap-core2"})
    @SourceDebugExtension(value={"SMAP\nReplicationWorkspace.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReplicationWorkspace.kt\nkd/bos/olapServer2/server/ReplicationWorkspace$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,469:1\n1#2:470\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final ReplicationNodeProxy init(OlapWorkspace olapWorkspace, ReplicationContext context) {
            ReplicationNodeProxy replicationNodeProxy;
            File confFile = Paths.INSTANCE.toFile(context.getConfPath(), "replication.xml");
            File defaultBackupFolder = Paths.INSTANCE.toFile(context.getRootPath(), "backup");
            if (context != ReplicationContext.Companion.getEmptyContext() && ((CharSequence)context.getConfPath()).length() > 0 && confFile.exists()) {
                ReplicationConf conf = ReplicationConf.Companion.read(confFile, context.isAutoMasterNode(), context.getRootPath());
                if (StringsKt.isBlank((CharSequence)conf.get_node().getBackupPath())) {
                    ReplicationConf.NodeConfig nodeConfig = conf.get_node();
                    String string2 = defaultBackupFolder.getAbsolutePath();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAbsolutePath(...)");
                    nodeConfig.setBackupPath(string2);
                }
                if (!PathsKt.toFile(conf.get_node().getBackupPath()).exists()) {
                    FileTools.INSTANCE.autoMakeDir(conf.get_node().getBackupPath());
                }
                if (conf.get_master().getMasterReplication() && conf.get_slave().getSlaveReplication()) {
                    conf.checkValid();
                    String string3 = Res.INSTANCE.getReplicationManagerException_2();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"<get-ReplicationManagerException_2>(...)");
                    throw Res.INSTANCE.getRuntimeException(string3, new Object[0]);
                }
                if (conf.get_master().getMasterReplication()) {
                    conf.checkValid();
                    context.md5fixed();
                    replicationNodeProxy = new ReplicationNodeProxy(conf, new ReplicationMaster(olapWorkspace.getRootPath(), conf, context), context);
                } else if (conf.get_slave().getSlaveReplication()) {
                    conf.checkValid();
                    context.md5fixed();
                    replicationNodeProxy = new ReplicationNodeProxy(conf, new ReplicationSlave(olapWorkspace, conf, context), context);
                } else {
                    replicationNodeProxy = new ReplicationNodeProxy(conf, new ReplicationNone(context), context);
                }
            } else {
                if (!defaultBackupFolder.exists()) {
                    String string4 = defaultBackupFolder.getAbsolutePath();
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getAbsolutePath(...)");
                    FileTools.INSTANCE.autoMakeDir(string4);
                }
                String string5 = defaultBackupFolder.getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getAbsolutePath(...)");
                replicationNodeProxy = new ReplicationNodeProxy(new ReplicationConf(new ReplicationConf.NodeConfig(0, null, 0, false, null, string5, 31, null), null, null, 6, null), new ReplicationNone(context), context);
            }
            return replicationNodeProxy;
        }

        @NotNull
        public final ReplicationWorkspace createNoneWorkspace(@NotNull String tmpDatabase) {
            ReplicationWorkspace replicationWorkspace;
            Intrinsics.checkNotNullParameter((Object)tmpDatabase, (String)"tmpDatabase");
            ReplicationWorkspace it = replicationWorkspace = new ReplicationWorkspace(new OlapWorkspace(OlapMetadata.Companion.ReadFrom(tmpDatabase), tmpDatabase), null, 2, null);
            boolean bl = false;
            it.getCurrentNode().getValue().start();
            return replicationWorkspace;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

