/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.storages;

import java.io.Closeable;
import kd.bos.olapServer.dataAdapter.IPartitionWriteAdapter;
import kd.bos.olapServer2.backup.BackupConstant;
import kd.bos.olapServer2.collections.IMutableMapLong2Long;
import kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders.DefaultByteBufferProvider;
import kd.bos.olapServer2.metadata.Cube;
import kd.bos.olapServer2.monitorReports.HealthReportContainer;
import kd.bos.olapServer2.storages.ChangeVersionManager;
import kd.bos.olapServer2.storages.CubeDataLock;
import kd.bos.olapServer2.storages.CubeDataStorage;
import kd.bos.olapServer2.storages.CubeMetadataStorage;
import kd.bos.olapServer2.storages.CubeResourcePool;
import kd.bos.olapServer2.storages.ICubeDataLock;
import kd.bos.olapServer2.storages.ICubeMetadataLock;
import kd.bos.olapServer2.storages.InputRowList;
import kd.bos.olapServer2.storages.writers.PartitionWriteAdapter;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\b \u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010%\u001a\u00020&J\u0006\u0010'\u001a\u00020&J\u0006\u0010(\u001a\u00020)J\u0016\u0010*\u001a\u00020&2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.J\u0006\u0010/\u001a\u000200J\n\u00101\u001a\u000602j\u0002`3J\u000e\u00104\u001a\u00020&2\u0006\u00105\u001a\u00020\u0003R\u0011\u0010\b\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0012\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001c\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0014R\u0011\u0010!\u001a\u00020\"8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010$\u00a8\u00066"}, d2={"Lkd/bos/olapServer2/storages/AbstractCubeWorkspace;", "", "_metadata", "Lkd/bos/olapServer2/metadata/Cube;", "path", "", "Lkd/bos/olapServer2/common/string;", "(Lkd/bos/olapServer2/metadata/Cube;Ljava/lang/String;)V", "Metadata", "getMetadata", "()Lkd/bos/olapServer2/metadata/Cube;", "_changeVersionManager", "Lkd/bos/olapServer2/storages/ChangeVersionManager;", "_metadataStorage", "Lkd/bos/olapServer2/storages/CubeMetadataStorage;", "_resourcePool", "Lkd/bos/olapServer2/storages/CubeResourcePool;", "dataLock", "Lkd/bos/olapServer2/storages/ICubeDataLock;", "getDataLock", "()Lkd/bos/olapServer2/storages/ICubeDataLock;", "dataStorage", "Lkd/bos/olapServer2/storages/CubeDataStorage;", "getDataStorage", "()Lkd/bos/olapServer2/storages/CubeDataStorage;", "metadataStorage", "getMetadataStorage", "()Lkd/bos/olapServer2/storages/CubeMetadataStorage;", "resourcePool", "getResourcePool", "()Lkd/bos/olapServer2/storages/CubeResourcePool;", "rowValidBitmapLock", "getRowValidBitmapLock", "tidMap", "Lkd/bos/olapServer2/collections/IMutableMapLong2Long;", "getTidMap", "()Lkd/bos/olapServer2/collections/IMutableMapLong2Long;", "clearTidMap", "", "close", "createPartitionWriteAdapter", "Lkd/bos/olapServer/dataAdapter/IPartitionWriteAdapter;", "gc", "healthReports", "Lkd/bos/olapServer2/monitorReports/HealthReportContainer;", "metadataLock", "Lkd/bos/olapServer2/storages/ICubeMetadataLock;", "getInputRowList", "Lkd/bos/olapServer2/storages/InputRowList;", "getRowCount", "", "Lkd/bos/olapServer2/common/rowIdx;", "onMetadataUpdated", "newMetadata", "bos-olap-core2"})
public abstract class AbstractCubeWorkspace {
    @NotNull
    private volatile Cube _metadata;
    @NotNull
    private final String path;
    @NotNull
    private final ICubeDataLock dataLock;
    @NotNull
    private final ICubeDataLock rowValidBitmapLock;
    @NotNull
    private final ChangeVersionManager _changeVersionManager;
    @NotNull
    private volatile CubeResourcePool _resourcePool;
    @NotNull
    private volatile CubeMetadataStorage _metadataStorage;

    public AbstractCubeWorkspace(@NotNull Cube _metadata, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)_metadata, (String)"_metadata");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this._metadata = _metadata;
        this.path = path;
        this.dataLock = new CubeDataLock();
        this.rowValidBitmapLock = new CubeDataLock();
        this._changeVersionManager = new ChangeVersionManager(0L, 1, null);
        this._resourcePool = new CubeResourcePool(this._metadata, new DefaultByteBufferProvider(this.path), this._changeVersionManager);
        this._metadataStorage = new CubeMetadataStorage(this.getResourcePool(), this.path);
    }

    @NotNull
    public final ICubeDataLock getDataLock() {
        return this.dataLock;
    }

    @NotNull
    public final ICubeDataLock getRowValidBitmapLock() {
        return this.rowValidBitmapLock;
    }

    @NotNull
    public final CubeResourcePool getResourcePool() {
        return this._resourcePool;
    }

    @NotNull
    public final CubeDataStorage getDataStorage() {
        return this._resourcePool.getDataStorage();
    }

    @NotNull
    public final IPartitionWriteAdapter createPartitionWriteAdapter() {
        return new PartitionWriteAdapter(BackupConstant.INSTANCE.getPartitionKey(this), this._metadata, this._resourcePool);
    }

    @NotNull
    public final CubeMetadataStorage getMetadataStorage() {
        return this._metadataStorage;
    }

    @NotNull
    public final Cube getMetadata() {
        return this._metadata;
    }

    @NotNull
    public final InputRowList getInputRowList() {
        return this.getResourcePool().getInputRowList();
    }

    @NotNull
    public final IMutableMapLong2Long getTidMap() {
        return this.getResourcePool().getTidMap();
    }

    public final long getRowCount() {
        return this.getResourcePool().getRowCount();
    }

    public final void onMetadataUpdated(@NotNull Cube newMetadata) {
        Intrinsics.checkNotNullParameter((Object)newMetadata, (String)"newMetadata");
        if (!Intrinsics.areEqual((Object)newMetadata.getName(), (Object)this._metadata.getName())) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        this._metadata = newMetadata;
        CubeResourcePool resourcePool = new CubeResourcePool(newMetadata, new DefaultByteBufferProvider(this.path), this._changeVersionManager);
        CubeMetadataStorage metadataStorage = new CubeMetadataStorage(resourcePool, this.path);
        this._resourcePool.close();
        this._changeVersionManager.updateChangeVersion();
        this._resourcePool = resourcePool;
        this._metadataStorage = metadataStorage;
    }

    public final void clearTidMap() {
        this._resourcePool.clearTidMap();
    }

    public final void gc(@NotNull HealthReportContainer healthReports, @NotNull ICubeMetadataLock metadataLock) {
        Intrinsics.checkNotNullParameter((Object)healthReports, (String)"healthReports");
        Intrinsics.checkNotNullParameter((Object)metadataLock, (String)"metadataLock");
        this.getResourcePool().gc(healthReports, metadataLock, this.dataLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() {
        Closeable closeable = this.dataLock.getWriteLock();
        Throwable throwable = null;
        try {
            Closeable it = closeable;
            boolean bl = false;
            this.getResourcePool().close();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }
}

