/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.storages;

import java.io.Closeable;
import java.util.concurrent.TimeUnit;
import kd.bos.olapServer2.collections.IAddOrUpdateStrategy;
import kd.bos.olapServer2.collections.IMutableDictionaryObserver;
import kd.bos.olapServer2.collections.IMutableMapLong2Long;
import kd.bos.olapServer2.common.NotSupportedException;
import kd.bos.olapServer2.dataEntities.DimensionKeysBase;
import kd.bos.olapServer2.dataEntities.IDimensionKeys;
import kd.bos.olapServer2.dataEntities.IInputRow;
import kd.bos.olapServer2.dataEntities.IMeasureValues;
import kd.bos.olapServer2.dataEntities.IMeasureValuesKt;
import kd.bos.olapServer2.performanceStatistics.CommandStatisticsItem;
import kd.bos.olapServer2.performanceStatistics.StandardCommandStatistics;
import kd.bos.olapServer2.storages.AbstractCubeWorkspace;
import kd.bos.olapServer2.storages.CubeWorkspace;
import kd.bos.olapServer2.storages.EmptyDimensionKeys;
import kd.bos.olapServer2.storages.ICubeDataLock;
import kd.bos.olapServer2.storages.ICubeDataObserver;
import kd.bos.olapServer2.storages.ICubeDataObserverContext;
import kd.bos.olapServer2.storages.ICubeMetadataLock;
import kd.bos.olapServer2.storages.IInputRowWriter;
import kd.bos.olapServer2.storages.InputRowList;
import kd.bos.olapServer2.storages.InputRowWriterOption;
import kd.bos.olapServer2.storages.LoadOriginalValuesStrategy;
import kd.bos.olapServer2.storages.RowIndexUtil;
import kd.bos.olapServer2.storages.TransactionStrategy;
import kd.bos.olapServer2.storages.gc.RuntimeZipTaskExecutor;
import kd.bos.olapServer2.storages.plugins.InputRowWriterCreatingEventArgs;
import kd.bos.olapServer2.tools.Res;
import kd.bos.olapServer2.transactions.WriteTransaction;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0019\b\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003B7\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0018\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020\u00042\u0006\u0010H\u001a\u00020\u0005H\u0016J0\u0010I\u001a\u00020F2\n\u0010=\u001a\u00060'j\u0002`(2\u0006\u0010G\u001a\u00020\u00042\u0006\u0010H\u001a\u00020\u00052\n\u0010J\u001a\u00060\u0017j\u0002`!H\u0016J\u001c\u0010K\u001a\u00060Lj\u0002`M2\u0006\u0010G\u001a\u00020\u00042\u0006\u0010N\u001a\u00020\u0005H\u0016J\u0018\u0010O\u001a\u00020F2\u0006\u0010G\u001a\u00020\u00042\u0006\u0010N\u001a\u00020\u0005H\u0016J$\u0010P\u001a\u00020F2\n\u0010=\u001a\u00060'j\u0002`(2\u0006\u0010G\u001a\u00020\u00042\u0006\u0010H\u001a\u00020\u0005H\u0016J\u0014\u0010Q\u001a\u00020F2\n\u0010R\u001a\u00060\u0017j\u0002`\u0018H\u0016J\b\u0010S\u001a\u00020FH\u0016J\b\u0010T\u001a\u00020FH\u0016J\u0014\u0010U\u001a\u00060\u0017j\u0002`\u00182\u0006\u0010G\u001a\u00020\u0004H\u0016J\u0014\u0010V\u001a\u00060\u0017j\u0002`\u00182\u0006\u00103\u001a\u000204H\u0002J\b\u0010W\u001a\u00020FH\u0002J0\u0010X\u001a\u00060Lj\u0002`M2\n\u0010=\u001a\u00060'j\u0002`(2\n\u0010Y\u001a\u00060\u0017j\u0002`\u00182\n\u0010Z\u001a\u00060\u0017j\u0002`!H\u0016J$\u0010[\u001a\u00020F2\n\u0010\\\u001a\u00060\u0017j\u0002`\u00182\u0006\u0010G\u001a\u00020\u00042\u0006\u0010N\u001a\u00020\u0005H\u0016J$\u0010]\u001a\u00020F2\n\u0010R\u001a\u00060\u0017j\u0002`\u00182\u0006\u0010G\u001a\u00020\u00042\u0006\u0010N\u001a\u00020\u0005H\u0016J4\u0010^\u001a\u00020F2\n\u0010=\u001a\u00060'j\u0002`(2\n\u0010Y\u001a\u00060\u0017j\u0002`\u00182\n\u0010A\u001a\u00060\u0017j\u0002`!2\u0006\u0010_\u001a\u00020\u0005H\u0016J\u0014\u0010`\u001a\u00020F2\n\u00100\u001a\u00060\u0017j\u0002`!H\u0002J\b\u0010a\u001a\u00020FH\u0002J\u001c\u0010b\u001a\u00020F2\n\u0010Y\u001a\u00060\u0017j\u0002`!2\u0006\u0010H\u001a\u00020\u0005H\u0016J2\u0010c\u001a\u00020F2\n\u0010=\u001a\u00060'j\u0002`(2\n\u0010Y\u001a\u00060\u0017j\u0002`\u00182\u0006\u0010H\u001a\u00020\u00052\b\u0010d\u001a\u0004\u0018\u00010\u0005H\u0016J\b\u0010e\u001a\u00020FH\u0002R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\u0004\u0018\u00010\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0012\u0010\u0016\u001a\u00060\u0017j\u0002`\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\u00020\u001d8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0012\u0010 \u001a\u00060\u0017j\u0002`!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\"\u001a\u0004\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010&\u001a\u00060'j\u0002`(X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0018\u0010-\u001a\u00060\u0017j\u0002`!8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010/R\u0018\u00100\u001a\u00060\u0017j\u0002`\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u0010/R\u0012\u00102\u001a\u00060\u0017j\u0002`\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u000204X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u00105\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u00107R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u00109R\u0014\u0010:\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b;\u0010<R\u0018\u0010=\u001a\u00060'j\u0002`(8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b>\u0010*R\u0016\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b?\u0010@R\u0018\u0010A\u001a\u00060\u0017j\u0002`!8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bB\u0010/R\u000e\u0010C\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010D\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006f"}, d2={"Lkd/bos/olapServer2/storages/BasicInputRowWriter;", "Lkd/bos/olapServer2/storages/IInputRowWriter;", "Lkd/bos/olapServer2/storages/ICubeDataObserverContext;", "Lkd/bos/olapServer2/collections/IMutableDictionaryObserver;", "Lkd/bos/olapServer2/dataEntities/IDimensionKeys;", "Lkd/bos/olapServer2/dataEntities/IMeasureValues;", "cubeWorkspace", "Lkd/bos/olapServer2/storages/CubeWorkspace;", "currentCubeWorkspace", "Lkd/bos/olapServer2/storages/AbstractCubeWorkspace;", "transaction", "Lkd/bos/olapServer2/transactions/WriteTransaction;", "strategy", "Lkd/bos/olapServer2/collections/IAddOrUpdateStrategy;", "option", "Lkd/bos/olapServer2/storages/InputRowWriterOption;", "(Lkd/bos/olapServer2/storages/CubeWorkspace;Lkd/bos/olapServer2/storages/AbstractCubeWorkspace;Lkd/bos/olapServer2/transactions/WriteTransaction;Lkd/bos/olapServer2/collections/IAddOrUpdateStrategy;Lkd/bos/olapServer2/storages/InputRowWriterOption;)V", "_currentKey", "_dataLock", "Lkd/bos/olapServer2/storages/ICubeDataLock;", "get_dataLock", "()Lkd/bos/olapServer2/storages/ICubeDataLock;", "_index", "", "Lkd/bos/olapServer2/common/rowIdx;", "_observer", "Lkd/bos/olapServer2/storages/ICubeDataObserver;", "_strategy", "_tidMap", "Lkd/bos/olapServer2/collections/IMutableMapLong2Long;", "get_tidMap", "()Lkd/bos/olapServer2/collections/IMutableMapLong2Long;", "_undoTid", "Lkd/bos/olapServer2/common/long;", "_writeLock", "Ljava/io/Closeable;", "creatingEventArgs", "Lkd/bos/olapServer2/storages/plugins/InputRowWriterCreatingEventArgs;", "cubeId", "", "Lkd/bos/olapServer2/common/int;", "getCubeId", "()I", "getCurrentCubeWorkspace", "()Lkd/bos/olapServer2/storages/AbstractCubeWorkspace;", "globalIndex", "getGlobalIndex", "()J", "index", "getIndex", "initSegmentIndex", "inputRowList", "Lkd/bos/olapServer2/storages/InputRowList;", "keyInPartition", "getKeyInPartition", "()Lkd/bos/olapServer2/dataEntities/IDimensionKeys;", "getOption", "()Lkd/bos/olapServer2/storages/InputRowWriterOption;", "originalValues", "getOriginalValues", "()Lkd/bos/olapServer2/dataEntities/IMeasureValues;", "partitionId", "getPartitionId", "getTransaction", "()Lkd/bos/olapServer2/transactions/WriteTransaction;", "undoTid", "getUndoTid", "validWriteCount", "writeCount", "add4Calc", "", "key", "values", "add4Redo", "expectRowIndex", "addOrUpdate", "", "Lkd/bos/olapServer2/common/bool;", "value", "addOrUpdate4Calc", "addOrUpdate4Redo", "beforeUpdate", "updateIndex", "close", "force", "getKeyIndex", "getLastSegmentIndex", "incrementWriteCount", "isRowNeedRollback", "rowIndex", "rollbackTid", "onAdded", "addIndex", "onUpdated", "rollback", "undoValues", "setRowTid", "trySubmitDataZip", "update4Calc", "update4Redo", "expectOldValue", "yieldLock", "bos-olap-core2"})
@SourceDebugExtension(value={"SMAP\nBasicInputRowWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BasicInputRowWriter.kt\nkd/bos/olapServer2/storages/BasicInputRowWriter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,322:1\n1#2:323\n*E\n"})
public final class BasicInputRowWriter
implements IInputRowWriter,
ICubeDataObserverContext,
IMutableDictionaryObserver<IDimensionKeys, IMeasureValues> {
    @NotNull
    private final CubeWorkspace cubeWorkspace;
    @NotNull
    private final AbstractCubeWorkspace currentCubeWorkspace;
    @Nullable
    private final WriteTransaction transaction;
    @NotNull
    private final InputRowWriterOption option;
    @Nullable
    private Closeable _writeLock;
    @NotNull
    private InputRowList inputRowList;
    private long writeCount;
    private long validWriteCount;
    private long initSegmentIndex;
    @NotNull
    private final InputRowWriterCreatingEventArgs creatingEventArgs;
    @Nullable
    private final ICubeDataObserver _observer;
    @Nullable
    private final IAddOrUpdateStrategy<IMeasureValues> _strategy;
    private long _index;
    @NotNull
    private IDimensionKeys _currentKey;
    private final int cubeId;
    private long _undoTid;

    /*
     * WARNING - void declaration
     */
    public BasicInputRowWriter(@NotNull CubeWorkspace cubeWorkspace, @NotNull AbstractCubeWorkspace currentCubeWorkspace, @Nullable WriteTransaction transaction, @Nullable IAddOrUpdateStrategy<IMeasureValues> strategy, @NotNull InputRowWriterOption option) {
        Intrinsics.checkNotNullParameter((Object)cubeWorkspace, (String)"cubeWorkspace");
        Intrinsics.checkNotNullParameter((Object)currentCubeWorkspace, (String)"currentCubeWorkspace");
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        this.cubeWorkspace = cubeWorkspace;
        this.currentCubeWorkspace = currentCubeWorkspace;
        this.transaction = transaction;
        this.option = option;
        this.creatingEventArgs = new InputRowWriterCreatingEventArgs(this);
        ICubeDataLock iCubeDataLock = this.get_dataLock();
        this._writeLock = iCubeDataLock != null ? iCubeDataLock.getWriteLock(1800L, TimeUnit.SECONDS) : null;
        try {
            IAddOrUpdateStrategy<IMeasureValues> iAddOrUpdateStrategy;
            boolean enableLoadOriginalValues;
            void it;
            InputRowList inputRowList;
            InputRowList inputRowList2 = inputRowList = this.getCurrentCubeWorkspace().getInputRowList();
            BasicInputRowWriter basicInputRowWriter = this;
            boolean bl = false;
            this.initSegmentIndex = this.getLastSegmentIndex((InputRowList)it);
            basicInputRowWriter.inputRowList = inputRowList;
            boolean bl2 = enableLoadOriginalValues = this.getOption().getEnableLoadOriginalValues() || this.getTransaction() != null;
            if (enableLoadOriginalValues) {
                LoadOriginalValuesStrategy t2 = new LoadOriginalValuesStrategy(strategy, this.cubeWorkspace.getMetadata().getMeasures());
                iAddOrUpdateStrategy = this.getTransaction() != null ? (IAddOrUpdateStrategy)new TransactionStrategy(t2, this) : (IAddOrUpdateStrategy<IMeasureValues>)t2;
            } else {
                iAddOrUpdateStrategy = this._strategy = strategy;
            }
            if (this.getOption().getEnableCreatingEvent()) {
                this.cubeWorkspace.getInputRowWriterCreating().invoke(this.cubeWorkspace.getPlugins().getContext(), this.creatingEventArgs);
            }
            this._observer = this.creatingEventArgs.createCubeDataObserver$bos_olap_core2();
        }
        catch (Throwable ex) {
            Closeable closeable = this._writeLock;
            if (closeable != null) {
                closeable.close();
            }
            throw ex;
        }
        this._index = -1L;
        this._currentKey = EmptyDimensionKeys.INSTANCE;
        this.cubeId = this.cubeWorkspace.getCubeId();
        this._undoTid = -1L;
    }

    @Override
    @NotNull
    public AbstractCubeWorkspace getCurrentCubeWorkspace() {
        return this.currentCubeWorkspace;
    }

    @Override
    @Nullable
    public WriteTransaction getTransaction() {
        return this.transaction;
    }

    @Override
    @NotNull
    public InputRowWriterOption getOption() {
        return this.option;
    }

    private final ICubeDataLock get_dataLock() {
        return this.getOption().getEnableLock() ? this.getCurrentCubeWorkspace().getDataLock() : null;
    }

    private final IMutableMapLong2Long get_tidMap() {
        return this.getCurrentCubeWorkspace().getTidMap();
    }

    private final long getLastSegmentIndex(InputRowList inputRowList) {
        return inputRowList.getCount() >> 16;
    }

    private final void incrementWriteCount() {
        long l = this.writeCount;
        this.writeCount = l + 1L;
        if ((this.writeCount & 0x7FFFFL) == 0L) {
            this.yieldLock();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void yieldLock() {
        this.inputRowList.flush();
        this.trySubmitDataZip();
        ICubeDataLock dataLock = this.get_dataLock();
        if (dataLock != null && dataLock.getHasQueuedThreads()) {
            void it;
            InputRowList inputRowList;
            Closeable closeable = this._writeLock;
            if (closeable != null) {
                closeable.close();
            }
            this._writeLock = null;
            this._writeLock = dataLock.getWriteLock(1800L, TimeUnit.SECONDS);
            InputRowList inputRowList2 = inputRowList = this.getCurrentCubeWorkspace().getInputRowList();
            BasicInputRowWriter basicInputRowWriter = this;
            boolean bl = false;
            this.initSegmentIndex = this.getLastSegmentIndex((InputRowList)it);
            basicInputRowWriter.inputRowList = inputRowList;
            StandardCommandStatistics.INSTANCE.inc(CommandStatisticsItem.Companion.getWriteCount(), this.writeCount);
            this.writeCount = 0L;
        }
    }

    @Override
    public boolean addOrUpdate(@NotNull IDimensionKeys key2, @NotNull IMeasureValues value2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        BasicInputRowWriter observer = this._observer == null ? null : this;
        boolean it = bl = this.inputRowList.addOrUpdate(key2, value2, this._strategy, (IMutableDictionaryObserver<IDimensionKeys, IMeasureValues>)observer) < 0L;
        boolean bl2 = false;
        this.incrementWriteCount();
        return bl;
    }

    @Override
    public void addOrUpdate4Calc(@NotNull IDimensionKeys key2, @NotNull IMeasureValues value2) {
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.addOrUpdate(key2, value2);
    }

    @Override
    public void add4Calc(@NotNull IDimensionKeys key2, @NotNull IMeasureValues values) {
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        IAddOrUpdateStrategy<IMeasureValues> iAddOrUpdateStrategy = this._strategy;
        if (!(iAddOrUpdateStrategy != null ? !iAddOrUpdateStrategy.allowAdd() : false)) {
            long addIndex = this.inputRowList.add$bos_olap_core2(key2, values);
            this.onAdded(addIndex, key2, values);
            this.incrementWriteCount();
        }
    }

    @Override
    public void update4Calc(long rowIndex, @NotNull IMeasureValues values) {
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        long index2 = RowIndexUtil.INSTANCE.getPartitionRowIndex(rowIndex);
        IMeasureValues originValue = this.inputRowList.getMeasureValues(index2);
        IMeasureValues newValues = values;
        if (this._strategy != null) {
            newValues = this._strategy.modifiedValue(index2, originValue, values);
        }
        this.beforeUpdate(index2);
        IDimensionKeys key2 = this.inputRowList.update$bos_olap_core2(index2, newValues);
        this.onUpdated(index2, key2, newValues);
        this.incrementWriteCount();
    }

    @Override
    public void add4Redo(int partitionId, @NotNull IDimensionKeys key2, @NotNull IMeasureValues values, long expectRowIndex) {
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        long realIndex = this.inputRowList.add$bos_olap_core2(key2, values);
        if (expectRowIndex != -1L && realIndex != expectRowIndex) {
            String string2 = Res.INSTANCE.getInputRowWriterException_1();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-InputRowWriterException_1>(...)");
            Object[] objectArray = new Object[]{this.cubeWorkspace.getMetadata().getName(), key2.toString(), expectRowIndex, realIndex};
            throw Res.INSTANCE.getRuntimeException(string2, objectArray);
        }
    }

    @Override
    public void update4Redo(int partitionId, long rowIndex, @NotNull IMeasureValues values, @Nullable IMeasureValues expectOldValue) {
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        IMeasureValues originValue = this.inputRowList.getMeasureValues(rowIndex);
        if (expectOldValue != null && !IMeasureValuesKt.isEqual(expectOldValue, originValue)) {
            String string2 = Res.INSTANCE.getInputRowWriterException_2();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-InputRowWriterException_2>(...)");
            Object[] objectArray = new Object[]{this.cubeWorkspace.getMetadata().getName(), DimensionKeysBase.Companion.toString(this.inputRowList.get(rowIndex).getKey(), this.cubeWorkspace.getMetadata().getDimensions()), IMeasureValuesKt.asString(expectOldValue), IMeasureValuesKt.asString(originValue)};
            throw Res.INSTANCE.getRuntimeException(string2, objectArray);
        }
        this.inputRowList.update$bos_olap_core2(rowIndex, values);
    }

    @Override
    public void addOrUpdate4Redo(int partitionId, @NotNull IDimensionKeys key2, @NotNull IMeasureValues values) {
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        this.inputRowList.addOrUpdate(key2, values);
    }

    @Override
    public long getKeyIndex(@NotNull IDimensionKeys key2) {
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        this.incrementWriteCount();
        return this.inputRowList.getKeyIndex(key2);
    }

    @Override
    public void beforeUpdate(long updateIndex) {
        block0: {
            ICubeDataObserver iCubeDataObserver = this._observer;
            if (iCubeDataObserver == null) break block0;
            ICubeDataObserver $this$beforeUpdate_u24lambda_u243 = iCubeDataObserver;
            boolean bl = false;
            this._index = updateIndex;
            $this$beforeUpdate_u24lambda_u243.beforeUpdate();
        }
    }

    @Override
    public void onAdded(long addIndex, @NotNull IDimensionKeys key2, @NotNull IMeasureValues value2) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            ICubeDataObserver iCubeDataObserver = this._observer;
            if (iCubeDataObserver == null) break block0;
            ICubeDataObserver $this$onAdded_u24lambda_u244 = iCubeDataObserver;
            boolean bl = false;
            this.setRowTid(addIndex);
            this._index = addIndex;
            this._currentKey = key2;
            long l = this.validWriteCount;
            this.validWriteCount = l + 1L;
            $this$onAdded_u24lambda_u244.onAdded(key2, value2);
        }
    }

    @Override
    public void onUpdated(long updateIndex, @NotNull IDimensionKeys key2, @NotNull IMeasureValues value2) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            ICubeDataObserver iCubeDataObserver = this._observer;
            if (iCubeDataObserver == null) break block1;
            ICubeDataObserver $this$onUpdated_u24lambda_u245 = iCubeDataObserver;
            boolean bl = false;
            if (!IMeasureValuesKt.allValuesIsIgnoreValue(value2)) {
                this.setRowTid(updateIndex);
                this._currentKey = key2;
                long l = this.validWriteCount;
                this.validWriteCount = l + 1L;
                $this$onUpdated_u24lambda_u245.onUpdated(key2, value2);
            }
        }
    }

    @Override
    public int getCubeId() {
        return this.cubeId;
    }

    @Override
    public int getPartitionId() {
        return -1;
    }

    @Override
    public long getIndex() {
        return this._index;
    }

    @Override
    public long getGlobalIndex() {
        return this._index;
    }

    @Override
    @NotNull
    public IDimensionKeys getKeyInPartition() {
        return this._currentKey;
    }

    @Override
    @NotNull
    public IMeasureValues getOriginalValues() {
        IMeasureValues iMeasureValues;
        IAddOrUpdateStrategy<IMeasureValues> iAddOrUpdateStrategy = this._strategy;
        if (iAddOrUpdateStrategy instanceof LoadOriginalValuesStrategy) {
            iMeasureValues = ((LoadOriginalValuesStrategy)this._strategy).getOriginalValues();
        } else if (iAddOrUpdateStrategy instanceof TransactionStrategy) {
            iMeasureValues = ((TransactionStrategy)this._strategy).getOriginalValues();
        } else {
            throw new NotSupportedException("please set loadOriginalValuesEnabled = true");
        }
        return iMeasureValues;
    }

    /*
     * WARNING - void declaration
     */
    private final void trySubmitDataZip() {
        long lastSegmentIndex = this.getLastSegmentIndex(this.inputRowList);
        if (lastSegmentIndex > this.initSegmentIndex) {
            void it;
            InputRowList inputRowList;
            long taskCount = lastSegmentIndex - this.initSegmentIndex;
            ICubeMetadataLock metadataLock = this.cubeWorkspace.getMetadataLock();
            this.getCurrentCubeWorkspace().getResourcePool().getZipTaskExecutor().submit(new RuntimeZipTaskExecutor.ZipTaskContext(this.cubeWorkspace.getHealthReports(), this.getCurrentCubeWorkspace().getResourcePool(), metadataLock, this.getCurrentCubeWorkspace().getDataLock()), taskCount);
            this.initSegmentIndex = lastSegmentIndex;
            InputRowList inputRowList2 = inputRowList = this.getCurrentCubeWorkspace().getInputRowList();
            BasicInputRowWriter basicInputRowWriter = this;
            boolean bl = false;
            this.initSegmentIndex = this.getLastSegmentIndex((InputRowList)it);
            basicInputRowWriter.inputRowList = inputRowList;
        }
    }

    @Override
    public void force() {
        this.inputRowList.flush();
        this.trySubmitDataZip();
        if (this.validWriteCount > 0L) {
            ICubeDataObserver iCubeDataObserver = this._observer;
            if (iCubeDataObserver != null) {
                iCubeDataObserver.onForcePartition();
            }
            ICubeDataObserver iCubeDataObserver2 = this._observer;
            if (iCubeDataObserver2 != null) {
                iCubeDataObserver2.onFlush();
            }
            this.validWriteCount = 0L;
        }
        if (this.writeCount > 0L) {
            StandardCommandStatistics.INSTANCE.inc(CommandStatisticsItem.Companion.getWriteCount(), this.writeCount);
            this.writeCount = 0L;
        }
    }

    @Override
    public void close() {
        block0: {
            Closeable closeable = this._writeLock;
            if (closeable == null) break block0;
            closeable.close();
        }
    }

    private final void setRowTid(long index2) {
        if (this.getTransaction() == null) {
            return;
        }
        if (index2 != Long.MIN_VALUE) {
            long realIndex = index2 < 0L ? -index2 - 1L : index2;
            this._undoTid = this.get_tidMap().get(realIndex);
            this.get_tidMap().set(realIndex, this.getTransaction().getVersion());
        }
    }

    @Override
    public boolean isRowNeedRollback(int partitionId, long rowIndex, long rollbackTid) {
        return this.get_tidMap().get(rowIndex) == rollbackTid;
    }

    @Override
    public void rollback(int partitionId, long rowIndex, long undoTid, @NotNull IMeasureValues undoValues) {
        Intrinsics.checkNotNullParameter((Object)undoValues, (String)"undoValues");
        IMeasureValues newValues = null;
        newValues = undoValues;
        if (this._strategy != null) {
            newValues = this._strategy.modifiedValue(rowIndex, this.inputRowList.getMeasureValues(rowIndex), undoValues);
        }
        this.beforeUpdate(rowIndex);
        IDimensionKeys key2 = this.inputRowList.update$bos_olap_core2(rowIndex, newValues);
        this.get_tidMap().set(rowIndex, undoTid);
        this._undoTid = undoTid;
        ICubeDataObserver iCubeDataObserver = this._observer;
        if (iCubeDataObserver != null) {
            ICubeDataObserver $this$rollback_u24lambda_u247 = iCubeDataObserver;
            boolean bl = false;
            this._index = rowIndex;
            this._currentKey = key2;
            long l = this.validWriteCount;
            this.validWriteCount = l + 1L;
            $this$rollback_u24lambda_u247.onUpdated(key2, newValues);
        }
        this.incrementWriteCount();
    }

    @Override
    public long getUndoTid() {
        return this._undoTid;
    }

    @Override
    public boolean addOrUpdate(@NotNull IInputRow row) {
        return IInputRowWriter.DefaultImpls.addOrUpdate(this, row);
    }
}

