/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.storages;

import java.util.UUID;
import kd.bos.olapServer2.memoryMappedFiles.bigContainers.MutableBigFixedSegmentContainer;
import kd.bos.olapServer2.memoryMappedFiles.bigContainers.MutableBigFixedSegmentSequenceContainer;
import kd.bos.olapServer2.memoryMappedFiles.bigContainers.MutableBigFullSegmentContainer;
import kd.bos.olapServer2.memoryMappedFiles.bigContainers.MutableBigUnFixedSegmentContainer;
import kd.bos.olapServer2.memoryMappedFiles.byteBufferProviders.IByteBufferProvider;
import kd.bos.olapServer2.memoryMappedFiles.concurrentDynamicData.MutableBigHeapByteContainer;
import kd.bos.olapServer2.memoryMappedFiles.concurrentDynamicData.NullHeapByteContainer;
import kd.bos.olapServer2.memoryMappedFiles.containers.FixedMetadata;
import kd.bos.olapServer2.memoryMappedFiles.containers.IMutableFixedSegmentContainer;
import kd.bos.olapServer2.memoryMappedFiles.containers.IMutableFixedSegmentSequenceContainer;
import kd.bos.olapServer2.memoryMappedFiles.containers.IMutableFullSegmentContainer;
import kd.bos.olapServer2.memoryMappedFiles.containers.IMutableUnFixedSegmentContainer;
import kd.bos.olapServer2.storages.MeasureSource;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0005\u001a\u00020\u0006J\u0006\u0010\u0007\u001a\u00020\u0006J\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\n\u001a\u00020\u000bJ\u0012\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u00060\u000fj\u0002`\u0010J\u0012\u0010\u0011\u001a\u00020\u00062\n\u0010\u000e\u001a\u00060\u000fj\u0002`\u0010J\u0006\u0010\u0012\u001a\u00020\tJ\u0006\u0010\u0013\u001a\u00020\u000bJ\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u000e\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u0014\u0010\u001b\u001a\u00020\u00152\n\u0010\u001c\u001a\u00060\u001dj\u0002`\u001eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lkd/bos/olapServer2/storages/CubeBigContainerStorage;", "", "bufferProvider", "Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/IByteBufferProvider;", "(Lkd/bos/olapServer2/memoryMappedFiles/byteBufferProviders/IByteBufferProvider;)V", "createBucketsContainer", "Lkd/bos/olapServer2/memoryMappedFiles/containers/IMutableFullSegmentContainer;", "createEntitiesContainer", "createIndexDataContainer", "Lkd/bos/olapServer2/memoryMappedFiles/containers/IMutableUnFixedSegmentContainer;", "createIndexKeyContainer", "Lkd/bos/olapServer2/memoryMappedFiles/containers/IMutableFixedSegmentSequenceContainer;", "createMainUnzipDataContainer", "Lkd/bos/olapServer2/memoryMappedFiles/containers/IMutableFixedSegmentContainer;", "dimensionCount", "", "Lkd/bos/olapServer2/common/int;", "createMainUnzipKeyContainer", "createMainZipDataContainer", "createMainZipKeyContainer", "createNotHeapMeasureContainer", "Lkd/bos/olapServer2/storages/MeasureSource;", "uuid", "Ljava/util/UUID;", "createSparseMeasureContainer", "createSparseMeasureIndexContainer", "createSparseNotHeapMeasureContainer", "createStandardMeasureContainer", "measureRelativePath", "", "Lkd/bos/olapServer2/common/string;", "bos-olap-core2"})
public final class CubeBigContainerStorage {
    @NotNull
    private final IByteBufferProvider bufferProvider;

    public CubeBigContainerStorage(@NotNull IByteBufferProvider bufferProvider) {
        Intrinsics.checkNotNullParameter((Object)bufferProvider, (String)"bufferProvider");
        this.bufferProvider = bufferProvider;
        this.bufferProvider.createFolder("");
    }

    @NotNull
    public final IMutableFullSegmentContainer createMainUnzipKeyContainer(int dimensionCount) {
        return MutableBigFullSegmentContainer.Companion.createContainer(this.bufferProvider, "", "mainUnzip", "key" + dimensionCount);
    }

    @NotNull
    public final IMutableFixedSegmentContainer createMainUnzipDataContainer(int dimensionCount) {
        return MutableBigFixedSegmentContainer.Companion.createByDimensionCount(this.bufferProvider, "", "mainUnzip", "dat" + dimensionCount, dimensionCount);
    }

    @NotNull
    public final IMutableFixedSegmentSequenceContainer createMainZipKeyContainer() {
        return MutableBigFixedSegmentSequenceContainer.Companion.createContainer$default(MutableBigFixedSegmentSequenceContainer.Companion, this.bufferProvider, "", "main", "key", null, 16, null);
    }

    @NotNull
    public final IMutableUnFixedSegmentContainer createMainZipDataContainer() {
        return MutableBigUnFixedSegmentContainer.Companion.createMainZipDataContainer(this.bufferProvider, "", "main", "dat");
    }

    @NotNull
    public final IMutableFixedSegmentSequenceContainer createIndexKeyContainer() {
        return MutableBigFixedSegmentSequenceContainer.Companion.createContainer(this.bufferProvider, "", "index", "key", FixedMetadata.Companion.getMinSegmentInfoHeadItems());
    }

    @NotNull
    public final IMutableUnFixedSegmentContainer createIndexDataContainer() {
        return MutableBigUnFixedSegmentContainer.Companion.createIndexDataContainer(this.bufferProvider, "", "index", "dat");
    }

    @NotNull
    public final IMutableFullSegmentContainer createBucketsContainer() {
        return MutableBigFullSegmentContainer.Companion.createContainer(this.bufferProvider, "", "buckets", "dat");
    }

    @NotNull
    public final IMutableFullSegmentContainer createEntitiesContainer() {
        return MutableBigFullSegmentContainer.Companion.createContainer(this.bufferProvider, "", "entities", "dat");
    }

    @NotNull
    public final MeasureSource createStandardMeasureContainer(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        String string2 = uuid.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        String measureRelativePath = string2;
        return this.createStandardMeasureContainer(measureRelativePath);
    }

    private final MeasureSource createStandardMeasureContainer(String measureRelativePath) {
        this.bufferProvider.createFolder(measureRelativePath);
        MutableBigFullSegmentContainer indexContainer = MutableBigFullSegmentContainer.Companion.createContainer(this.bufferProvider, measureRelativePath, "measure", "key");
        MutableBigHeapByteContainer heapContainer = MutableBigHeapByteContainer.Companion.createContainer$default(MutableBigHeapByteContainer.Companion, this.bufferProvider, measureRelativePath, "measure", "dat", false, false, null, 64, null);
        return new MeasureSource(indexContainer, heapContainer, null);
    }

    private final IMutableFullSegmentContainer createSparseMeasureIndexContainer(UUID uuid) {
        String string2 = uuid.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        String measureRelativePath = string2;
        return MutableBigFullSegmentContainer.Companion.createContainer(this.bufferProvider, measureRelativePath, "index", "key");
    }

    @NotNull
    public final MeasureSource createSparseMeasureContainer(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        MeasureSource standardMeasureSource = this.createStandardMeasureContainer(uuid);
        return new MeasureSource(standardMeasureSource.getIndexContainer(), standardMeasureSource.getHeapContainer(), this.createSparseMeasureIndexContainer(uuid));
    }

    @NotNull
    public final MeasureSource createNotHeapMeasureContainer(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        String string2 = uuid.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        String measureRelativePath = string2;
        this.bufferProvider.createFolder(measureRelativePath);
        MutableBigFullSegmentContainer indexContainer = MutableBigFullSegmentContainer.Companion.createContainer(this.bufferProvider, measureRelativePath, "measure", "key");
        return new MeasureSource(indexContainer, NullHeapByteContainer.INSTANCE, null);
    }

    @NotNull
    public final MeasureSource createSparseNotHeapMeasureContainer(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        MeasureSource standardMeasureSource = this.createNotHeapMeasureContainer(uuid);
        return new MeasureSource(standardMeasureSource.getIndexContainer(), standardMeasureSource.getHeapContainer(), this.createSparseMeasureIndexContainer(uuid));
    }
}

